

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEntityAnomalousCount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  AppGetEntityAnomalousCount()
--  |
--  | Description:  Returns count for anomalous entity.
--  |
--  |       Input:  request XML
--  |
--  |      Output:  Count of anomalous entity.
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Mohammad Dilshad		Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetEntityAnomalousCount')
BEGIN
	print '>>> Drop Stored Procedure: AppGetEntityAnomalousCount <<<'
	drop procedure AppGetEntityAnomalousCount
END
IF EXISTS (select * from GxQscripts where name='AppGetEntityAnomalousCount')
	delete from GxQscripts where name = 'AppGetEntityAnomalousCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntityAnomalousCount')
	delete from GXDBVersions where aliasname = 'AppGetEntityAnomalousCount'
GO
print '... Creating Procedure: AppGetEntityAnomalousCount'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetEntityAnomalousCount
  @xml XML
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @userId INT = ISNULL((SELECT @xml.value('(//processinginstructioninfo/user/@userId)[1]', 'INT')), 0)
	DECLARE @time INT = DATEDIFF(SECOND, '1970-01-01 00:00:00', GETUTCDATE())
	DECLARE @secondsInhour INT = 60*60
	DECLARE @secondsInDay INT = @secondsInhour * 24
	DECLARE @MinimumRuntime INT = @secondsInhour
	DECLARE @filterFlag INT = ISNULL((SELECT @xml.value('(//@AnomalousEntityTypeFlag)[1]', 'INT')), 0)
	DECLARE @toTime INT = ISNULL((SELECT @xml.value('(//timeRange/@toTime)[1]', 'INT')), @time)
	DECLARE @fromTime INT = ISNULL((SELECT @xml.value('(//timeRange/@fromTime)[1]', 'INT')), @toTime - @secondsInDay)
	DECLARE @currentTime DATETIME = GETDATE()
	DECLARE @performanceCaptureTime DATETIME = DATEADD(MINUTE, -30, @currentTime)
	DECLARE @isAdmin INT = 0
EXEC DBO.sec_checkPermissionOnEntity @userId, 1, @isAdmin OUTPUT, 1, 2
	IF OBJECT_ID('tempdb.dbo.#userClients') IS NOT NULL DROP TABLE #userClients
	CREATE TABLE #userClients
	(
		   t_clientId INT,
		   t_appTypeId INT,
		   t_instanceId INT,
		   t_backupsetId INT,
		   t_subclientId INT
	)
	IF OBJECT_ID('tempdb.dbo.#storagePolicies') IS NOT NULL DROP TABLE #storagePolicies
	CREATE TABLE #storagePolicies
	(
		   t_archGrpId INT
	)
	DECLARE @dummyNodes TABLE(clientId INT)
	INSERT INTO @dummyNodes
	SELECT DISTINCT attrVal FROM APP_ClientProp WHERE attrName = 'Linked CS Client' AND modified = 0
	IF @isAdmin <> 1
	BEGIN
		EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#userClients'
EXEC sec_getNonIdaObjectsForThisUser @userId, 17 , 4, '#storagePolicies'
	END
	DELETE UC
	FROM #userClients UC
	INNER JOIN @dummyNodes DN ON UC.t_clientId = DN.clientId
	DECLARE @CountOfAnomalousEvents INT
	DECLARE @CountOfAnomalousJobs INT
	DECLARE @CountOfAnomalousServers INT
	DECLARE @CountOfAnomalousMediaAgents INT
IF @filterFlag = 0 OR @filterFlag & 4 = 4 -- Calculating anomalous count for Clients
	BEGIN
		IF @isAdmin = 1
		BEGIN
			SET @CountOfAnomalousServers = (
				SELECT COUNT(1) FROM
				(
					-- Failed Job based client
					SELECT CLCount.componentNameId AS clientId FROM APP_ClientProp CLThreshold
					INNER JOIN APP_ClientProp CLCount
						ON CLThreshold.componentNameId = CLCount.componentNameId
							AND CLThreshold.attrName = N'Client Failed Job Anomaly Threshold'
							AND CLThreshold.modified = 0
							AND CLCount.attrName = N'Client Failed Job Count For Today'
							AND CLCount.modified = 0
							AND CLCount.created > @fromTime
							AND CLCount.created > CLThreshold.created
					WHERE CAST(CLThreshold.attrVal AS FLOAT) < CAST(CLCount.attrVal AS FLOAT)
					UNION
					-- Not reachable clients
					SELECT Client.id FROM
					(
						SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
						UNION
						SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
					)UnreachbleClients
					INNER JOIN App_Client Client ON Client.id = UnreachbleClients.clientID
AND Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000) | 2 | 4) = 0
 					INNER JOIN (SELECT DISTINCT ClientId FROM simInstalledPackages) SIM ON Client.id = SIM.ClientId
 					LEFT OUTER JOIN MMhost MM ON MM.ClientID = Client.id
                	WHERE   MM.ClientId IS NULL
OR (NOT((MM.Attribute & 32768) = 32768
                    		AND (MM.offlineReason =7)))
					EXCEPT
					SELECT clientId FROM @dummyNodes
				) ANOMCLIENTS
			)
		END
		ELSE
		BEGIN
			SET @CountOfAnomalousServers = (
				SELECT COUNT(1) FROM
				(
					-- Failed Job based client
					SELECT CLCount.componentNameId AS clientId
					FROM APP_ClientProp CLThreshold
					INNER JOIN APP_ClientProp CLCount
						ON CLThreshold.componentNameId = CLCount.componentNameId
							AND CLThreshold.attrName = N'Client Failed Job Anomaly Threshold'
							AND CLThreshold.modified = 0
							AND CLCount.attrName = N'Client Failed Job Count For Today'
							AND CLCount.modified = 0
							AND CLCount.created > @fromTime
							AND CLCount.created > CLThreshold.created
					INNER JOIN #userClients CL ON CL.t_clientId = CLThreshold.componentNameId AND CL.t_clientId = CLCount.componentNameId
					WHERE CAST(CLThreshold.attrVal AS FLOAT) > 10 AND CAST(CLThreshold.attrVal AS FLOAT) < CAST(CLCount.attrVal AS FLOAT)
					UNION
					-- Not reachable clients
					SELECT Client.id FROM
					(
						SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
						UNION
						SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
					)UnreachbleClients INNER JOIN #userClients CL ON UnreachbleClients.clientId = CL.t_clientId
					INNER JOIN App_Client Client ON Client.id = UnreachbleClients.clientID
AND Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000) | 2 | 4) = 0
 					INNER JOIN (SELECT DISTINCT ClientId FROM simInstalledPackages) SIM ON Client.id = SIM.ClientId
 					LEFT OUTER JOIN MMhost MM ON MM.ClientID = Client.id
                	WHERE   MM.ClientId IS NULL
OR (NOT((MM.Attribute & 32768) = 32768
                    		AND (MM.offlineReason =7)))
				) ANOMCLIENTS
			)
		END
	END
IF @filterFlag = 0 OR @filterFlag & 8 = 8 -- Calculating anomalous count for Media Agents
	BEGIN
		IF @isAdmin = 1
		BEGIN
			SET @CountOfAnomalousMediaAgents = (
				SELECT COUNT(1) FROM
				(
					-- Failed Job based Media Agents
					SELECT MACount.componentNameId AS mediaAgentId FROM APP_ClientProp MAThreshold
					INNER JOIN APP_ClientProp MACount
						ON MAThreshold.componentNameId = MACount.componentNameId
							AND MAThreshold.attrName = N'Media Agent Failed Job Anomaly Threshold'
							AND MAThreshold.modified = 0
							AND MACount.attrName = N'Media Agent Failed Job Count For Today'
							AND MACount.modified = 0
							AND MACount.created > @fromTime
							AND MACount.created > MAThreshold.created
						WHERE CAST(MAThreshold.attrVal AS FLOAT) > 10 AND CAST(MAThreshold.attrVal AS FLOAT) < CAST(MACount.attrVal AS FLOAT)
					UNION
					-- Not reachable media agents
					SELECT MM.clientId FROM
					(
						SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
						UNION
						SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
					)UnreachbleClients INNER JOIN MMHost MM ON UnreachbleClients.clientId = MM.clientId
WHERE NOT((MM.Attribute & 32768) = 32768 AND (MM.offlineReason =7))
					UNION
					-- Not reachable web servers
					SELECT SIM.clientId FROM
					(
						SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
						UNION
						SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
					)UnreachbleClients INNER JOIN simInstalledPackages SIM ON UnreachbleClients.clientId = SIM.clientId AND SIM.simPackageID = 252
					LEFT OUTER JOIN MMhost MM ON MM.ClientID = UnreachbleClients.clientId
					WHERE   MM.ClientId IS NULL
OR (NOT((MM.Attribute & 32768) = 32768
                    		AND (MM.offlineReason =7)))
					EXCEPT
					SELECT clientId FROM @dummyNodes
				)ANOMINFRA
			)
		END
		ELSE
		BEGIN
			SET @CountOfAnomalousMediaAgents = (
				SELECT COUNT(1) FROM
				(
					-- Failed Job based Media Agents
					SELECT MACount.componentNameId AS mediaAgentId FROM APP_ClientProp MAThreshold
					INNER JOIN APP_ClientProp MACount
						ON MAThreshold.componentNameId = MACount.componentNameId
							AND MAThreshold.attrName = N'Media Agent Failed Job Anomaly Threshold'
							AND MAThreshold.modified = 0
							AND MACount.attrName = N'Media Agent Failed Job Count For Today'
							AND MACount.modified = 0
							AND MACount.created > @fromTime
							AND MACount.created > MAThreshold.created
						INNER JOIN #userClients CL ON CL.t_clientId = MAThreshold.componentNameId AND CL.t_clientId = MACount.componentNameId
						WHERE CAST(MAThreshold.attrVal AS FLOAT) > 10 AND CAST(MAThreshold.attrVal AS FLOAT) < CAST(MACount.attrVal AS FLOAT)
					UNION
					-- Not reachable media agents
					SELECT MM.clientId FROM
					(
						SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
						UNION
						SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
					)UnreachbleClients INNER JOIN MMHost MM ON UnreachbleClients.clientId = MM.ClientId
					INNER JOIN #userClients CL ON CL.t_clientId = MM.ClientId
WHERE NOT((MM.Attribute & 32768) = 32768 AND (MM.offlineReason =7))
					UNION
					-- Not reachable web servers
					SELECT SIM.clientId FROM
					(
						SELECT DISTINCT ToClientId AS clientId FROM CCRClientToClient WHERE (FromClientId = 2 AND ToClientId <> 2 AND errorCode > 0)
						UNION
						SELECT DISTINCT FromClientId AS clientId FROM CCRClientToClient WHERE (FromClientId <> 2 AND ToClientId = 2 AND errorCode > 0)
					)UnreachbleClients INNER JOIN simInstalledPackages SIM ON UnreachbleClients.clientId = SIM.ClientId AND SIM.simPackageID = 252
					INNER JOIN #userClients CL ON CL.t_clientId = SIM.ClientId
					LEFT OUTER JOIN MMhost MM ON MM.ClientID = UnreachbleClients.clientId
					WHERE   MM.ClientId IS NULL
OR (NOT((MM.Attribute & 32768) = 32768
                    		AND (MM.offlineReason =7)))
				)ANOMINFRA
			)
		END
	END
IF @filterFlag = 0 OR @filterFlag & 1 = 1-- Calculating anomalous count for Events
	BEGIN
		IF @isAdmin = 1
		BEGIN
			SET @CountOfAnomalousEvents = (
				SELECT  COUNT(1)
					FROM
					(
						SELECT  1 AS occur  FROM evMsg
							WHERE  timeSource BETWEEN @fromTime AND @toTime AND anomalous > 0
							GROUP BY messageId,clientId
					) ANOMEVENTS )
		END
		ELSE
		BEGIN
			SET @CountOfAnomalousEvents = (
				SELECT  COUNT(1)
					FROM
					(
						SELECT  1 AS occur  FROM evMsg EVNTS INNER JOIN #userClients CL ON EVNTS.clientID = CL.t_clientId
							WHERE  EVNTS.timeSource BETWEEN @fromTime AND @toTime AND EVNTS.anomalous > 0
							GROUP BY EVNTS.messageId, EVNTS.clientId
					) ANOMEVENTS )
		END
	END
IF @filterFlag = 0 OR @filterFlag & 2 = 2--Calculating anomalous count for Jobs
	BEGIN
		IF @isAdmin = 1
		BEGIN
			SET @CountOfAnomalousJobs = (
					SELECT COUNT(1)
					FROM
					(SELECT jobId FROM RunningBackups RB
					WHERE RB.guiAlertColorLevel >= 100000 -- (JMGUIAlertColorLevel::GUI_ALERT_COLOR_ANOMALOUS)
					UNION
					SELECT jobId FROM RunningAdminJobs RA
					WHERE RA.guiAlertColorLevel >= 100000 -- (JMGUIAlertColorLevel::GUI_ALERT_COLOR_ANOMALOUS)
					)A
			)
		END
		ELSE
		BEGIN
			SET @CountOfAnomalousJobs = (
					SELECT COUNT(1)
					FROM
					(SELECT jobId FROM RunningBackups RB
					INNER JOIN #userClients UCL ON UCL.t_clientId = RB.clientId
					WHERE RB.guiAlertColorLevel >= 100000 -- (JMGUIAlertColorLevel::GUI_ALERT_COLOR_ANOMALOUS)
					UNION
					SELECT jobId FROM RunningAdminJobs RA
					INNER JOIN #storagePolicies USP ON USP.t_archgrpId = RA.archGrpId
					WHERE RA.guiAlertColorLevel >= 100000 -- (JMGUIAlertColorLevel::GUI_ALERT_COLOR_ANOMALOUS)
					)A
				)
		END
	END
	-- Populating XML result
	SET @xml = (SELECT
		[@CountOfAnomalousServers] = @CountOfAnomalousServers,
		[@CountOfAnomalousInfrastructureServers] = @CountOfAnomalousMediaAgents,
		[@CountOfAnomalousJobs] = @CountOfAnomalousJobs,
		[@CountOfAnomalousEvents] = @CountOfAnomalousEvents
		FOR XML PATH('App_GetAnomalousEntityCountResp'),TYPE)
	SELECT @xml
	IF OBJECT_ID('tempdb.dbo.#userClients') IS NOT NULL
		DROP TABLE dbo.#userClients
	IF OBJECT_ID('tempdb.dbo.#storagePolicies') IS NOT NULL
		DROP TABLE #storagePolicies
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEntityAnomalousCount')
	delete from GxQscripts where name = 'AppGetEntityAnomalousCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntityAnomalousCount')
	delete from GXDBVersions where aliasname = 'AppGetEntityAnomalousCount'
GO

insert into GXDBVersions values(2, 'AppGetEntityAnomalousCount',  '00000000000000000000', 'AppGetEntityAnomalousCount', '00000000000000000000')
GO

