

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEntitiesWithBackupDisabled.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetEntitiesWithBackupDisabled')
BEGIN
	print '>>> Drop Stored Procedure: AppGetEntitiesWithBackupDisabled <<<'
	drop procedure AppGetEntitiesWithBackupDisabled
END
IF EXISTS (select * from GxQscripts where name='AppGetEntitiesWithBackupDisabled')
	delete from GxQscripts where name = 'AppGetEntitiesWithBackupDisabled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntitiesWithBackupDisabled')
	delete from GXDBVersions where aliasname = 'AppGetEntitiesWithBackupDisabled'
GO
print '... Creating Procedure: AppGetEntitiesWithBackupDisabled'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEntitiesWithBackupDisabled
  @i_xmlString XML
AS
  DECLARE @o_xmlString XML	
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
BEGIN TRY
	-- Error handlers.
	DECLARE	@errorCode	INT = 0
	DECLARE	@errorString	NVARCHAR(1024) = N''
	-- Reading from xml
	DECLARE	@clientId	INT = 0
	DECLARE @drInstanceID INTEGER
	SET @drInstanceID  =  ISNULL((select top 1 instance from APP_Application
where appTypeId= 1000),1)
	SELECT 	@clientId = ISNULL(ref.value('@clientId', 'INT'), 0)
		FROM @i_xmlString.nodes('App_GetEntitiesWithBackupDisabledReq') R (ref)
	if object_id('tempdb.dbo.#SubClientIdList') is not null
    		DROP TABLE #SubClientIdList
	CREATE TABLE #SubClientIdList (id INT PRIMARY KEY)
	if object_id('tempdb.dbo.#simGetPseudoClients_ExtTempTable') is not null
    		DROP TABLE #simGetPseudoClients_ExtTempTable
	CREATE TABLE #simGetPseudoClients_ExtTempTable (clientId INT PRIMARY KEY, type INT DEFAULT 0,name NVARCHAR(1024) DEFAULT NULL)
	INSERT INTO #simGetPseudoClients_ExtTempTable(clientId,type,name)
	VALUES(@clientId,0,'')
	--As the client being passed in the request is always from Physical client, we need to figure out pseudo clients
	--and also send their activity status if they belong to the physical client.
	EXEC simGetPseudoClients @clientId,0
	INSERT INTO #SubClientIdList
	-- disable at subclient level
	SELECT JMJA.appId FROM JMJobAction JMJA
		INNER JOIN APP_Application AP WITH(NOLOCK) ON JMJA.appId = AP.id
		INNER JOIN #simGetPseudoClients_ExtTempTable C ON AP.clientId = C.clientId
WHERE AP.appTypeId <> 1030
		AND JMJA.clientId = 1
		AND JMJA.mediaAgentID = 1
		AND JMJA.opType = 4  -- BACKUP
		AND JMJA.action = 1 -- DISABLEACTIVITY
		AND JMJA.clientGroupId = 0
		AND JMJA.instanceID = 1
	UNION
	--disable at instance level
	SELECT AP.id FROM JMJobAction JMJA
		INNER JOIN APP_InstanceName INS WITH(NOLOCK) ON JMJA.instanceID = INS.id
		INNER JOIN APP_Application AP WITH(NOLOCK) ON AP.instance = INS.id
		INNER JOIN #simGetPseudoClients_ExtTempTable C ON AP.clientId = C.clientId
WHERE AP.appTypeId <> 1030
		AND JMJA.clientId = 1
		AND JMJA.mediaAgentID = 1
		AND JMJA.opType = 4  -- BACKUP
		AND JMJA.action = 1 -- DISABLEACTIVITY
		AND JMJA.clientGroupId = 0
		AND JMJA.instanceID = AP.instance
	UNION
	-- disable at client level
	SELECT AP.id FROM APP_Application AP WITH(NOLOCK)
		INNER JOIN #simGetPseudoClients_ExtTempTable C ON AP.clientId = C.clientId
		INNER JOIN JMJobAction JMJA ON JMJA.clientId = C.clientId
		WHERE JMJA.clientId <> 1
		AND JMJA.mediaAgentID = 1
		AND JMJA.opType = 4  -- BACKUP
		AND JMJA.action = 1 -- DISABLEACTIVITY
		AND JMJA.clientGroupId = 0
		AND JMJA.instanceID = 1
	UNION
	-- disable at client computer group level
	SELECT AP.id FROM APP_Application AP WITH(NOLOCK)
		INNER JOIN #simGetPseudoClients_ExtTempTable C ON AP.clientId = C.clientId
		INNER JOIN APP_ClientGroupAssoc ACGA ON ACGA.clientId = C.clientId
			INNER JOIN JMJobAction JMJA ON JMJA.clientGroupId  = ACGA.clientGroupId
		WHERE JMJA.clientId = 1
			AND JMJA.clientGroupId <> 0
			AND JMJA.mediaAgentID = 1
			AND opType = 4  -- BACKUP
			AND action = 1 -- DISABLEACTIVITY
			AND instanceID = 1
	UNION
	--all activity or data management disabled at commcell level
	SELECT AP.id FROM APP_Application AP WITH(NOLOCK)
		INNER JOIN #simGetPseudoClients_ExtTempTable C ON AP.clientId = C.clientId
		WHERE EXISTS
	 (SELECT 1 FROM JMJobAction JMJA WHERE JMJA.clientId = 1 AND opType IN (1,4) AND action = 1 and appId = 1 and clientGroupId = 0 AND instanceID = @drInstanceID)
	-- Removing unnecessary subclients  with deleted flag and ones which are absent in Subclient mount path mapping
	DELETE scids
	FROM #SubClientIdList scids
	INNER JOIN APP_Application APP ON APP.id = scids.id
	WHERE (
			(( APP.subclientStatus & 2 ) = 2)   -- CV_STATUS_UNINSTALLED
            OR (( APP.subclientStatus & 4 ) = 4)   -- CV_STATUS_DELETED
		  )
	SET @o_xmlString=(SELECT (SELECT DISTINCT SCIL.id AS '@subclientId' FROM #SubClientIdList SCIL
			FOR XML PATH('entityList'), ROOT('App_GetEntitiesWithBackupDisabledResp'), TYPE))
		IF @o_xmlString IS NULL
			SET @o_xmlString = '<App_GetEntitiesWithBackupDisabledResp/>'
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_xmlString = '<App_GetEntitiesWithBackupDisabledResp/>'
END CATCH;
END
SELECT @o_xmlString
if object_id('tempdb.dbo.#SubClientIdList') is not null
    		DROP TABLE #SubClientIdList
if object_id('tempdb.dbo.#simGetPseudoClients_ExtTempTable') is not null
    		DROP TABLE #simGetPseudoClients_ExtTempTable
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEntitiesWithBackupDisabled')
	delete from GxQscripts where name = 'AppGetEntitiesWithBackupDisabled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEntitiesWithBackupDisabled')
	delete from GXDBVersions where aliasname = 'AppGetEntitiesWithBackupDisabled'
GO

insert into GXDBVersions values(2, 'AppGetEntitiesWithBackupDisabled',  '00000000000000000000', 'AppGetEntitiesWithBackupDisabled', '00000000000000000000')
GO

