

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEngineDetailsFromSubClientOrArray.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppGetEngineDetailsFromSubClientOrArray()
--  |
--  | Description:  Get Engine Id, Engine Name based on provided subclientId's or Array Id
--  |
--  |       Input:  Array ID , subclientId's
--  |      Output:  Engine ID and Engine Name if found, else empty strings
--  |
--  |
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetEngineDetailsFromSubClientOrArray <<<'

IF EXISTS (select * from sysobjects where name='AppGetEngineDetailsFromSubClientOrArray')
	drop procedure AppGetEngineDetailsFromSubClientOrArray
IF EXISTS (select * from GxQscripts where name='AppGetEngineDetailsFromSubClientOrArray')
	delete from GxQscripts where name = 'AppGetEngineDetailsFromSubClientOrArray'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEngineDetailsFromSubClientOrArray')
	delete from GXDBVersions where aliasname = 'AppGetEngineDetailsFromSubClientOrArray'
GO
print '... Creating Procedure: AppGetEngineDetailsFromSubClientOrArray'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEngineDetailsFromSubClientOrArray
  @arrayId INT,
  @subClientId NVARCHAR(1024)
AS
  DECLARE @engineID INT
  DECLARE @engineName NVARCHAR(1024)
DECLARE @errorCode INT
DECLARE @errorString NVARCHAR(1024)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
IF @arrayId > 0
BEGIN
-- will helpful while reading output of SP
SET @engineID = 0
SELECT TOP 1 @engineID=eng.SnapShotEngineId, @engineName=eng.SnapEngineName FROM SMControlHost ctrl (NOLOCK)
              INNER JOIN SMVendor ven (NOLOCK)
                          ON ctrl.SnapVendorName = ven.Name
              INNER JOIN SMSnapShotEngine eng (NOLOCK)
                          ON eng.SnapVendorName = ven.Name
              WHERE ctrl.ControlHostId = @arrayId
END
ELSE IF (@subClientId IS NOT NULL) AND LEN(@subClientId) > 0
BEGIN
	SELECT TOP 1 @engineID=eng.SnapShotEngineId, @engineName=eng.SnapEngineName FROM SMControlHost ctrl (NOLOCK)
				 INNER JOIN SMVendor ven (NOLOCK)
							 ON ctrl.SnapVendorName = ven.Name
				 INNER JOIN SMSnapShotEngine eng (NOLOCK)
							 ON eng.SnapVendorName = ven.Name
				 WHERE ctrl.ControlHostId = (SELECT top 1 _ID FROM dbo.SplitIDs((SELECT TOP 1 ACPA.attrVal FROM APP_ClientProp ACPA
			 INNER JOIN APP_ClientProp ACPI
				 ON ACPI.componentNameId=ACPA.componentNameId
			 INNER JOIN APP_Application AAP
				 ON AAP.clientId=ACPA.componentNameId
			 WHERE ACPA.attrName='Arrays' AND AAP.id IN (select _id from dbo.SplitIDs(@subClientId))
				 AND ACPI.attrName='Snap Backups Enabled' AND ACPI.attrVal=1)))
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
		SELECT @engineID, @engineName
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEngineDetailsFromSubClientOrArray')
	delete from GxQscripts where name = 'AppGetEngineDetailsFromSubClientOrArray'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEngineDetailsFromSubClientOrArray')
	delete from GXDBVersions where aliasname = 'AppGetEngineDetailsFromSubClientOrArray'
GO

insert into GXDBVersions values(2, 'AppGetEngineDetailsFromSubClientOrArray',  '00000000000000000000', 'AppGetEngineDetailsFromSubClientOrArray', '00000000000000000000')
GO

