

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEmailTemplates.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Divya Trivedi
-- Create date: 12/18/2017
-- Description:	To get the list of email templates or template details for IDs supplied as input.
-- Parameters : i_idList comma separated list of email template IDs. if null, all email templates will be returned.
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetEmailTemplates')
BEGIN
	print '>>> Drop Stored Procedure: AppGetEmailTemplates <<<'
	drop procedure AppGetEmailTemplates
END
IF EXISTS (select * from GxQscripts where name='AppGetEmailTemplates')
	delete from GxQscripts where name = 'AppGetEmailTemplates'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEmailTemplates')
	delete from GXDBVersions where aliasname = 'AppGetEmailTemplates'
GO
print '... Creating Procedure: AppGetEmailTemplates'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEmailTemplates
  @i_userId INT,
  @i_localeId INT,
  @i_idList NVARCHAR(MAX),
  @i_templateType INT,
  @i_ownerCompanyId INT,
  @i_listPropertyLevel INT = 1,
  @i_filterLocaleId INT,
  @o_xmlText XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @debug  AS INT = 0
DECLARE @o_errCode INTEGER
DECLARE @o_errString NVARCHAR(1024)
Declare @isMSPComcell int = isnull((select top 1 value from gxglobalparam where name = 'IsMSPCommcell' and modified = 0), 0)
IF OBJECT_ID('tempdb.dbo.#EmailTemplatesList') IS NOT null	DROP TABLE #EmailTemplatesList
create table #EmailTemplatesList
(
									id				int primary key,
									name						nvarchar(255),
									description					nvarchar(max),
									modifiedOn				int,
									type						int,
									ownerCompanyId					int,
									ownerCompanyName					nvarchar(255),
									localeId					int,
									localename					varchar(255),
									isDefault					tinyint,
									fromName					nvarchar(255),
									fromEmail					nvarchar(255),
									subject						nvarchar(max),
									emailBody					nvarchar(max),
									cc							nvarchar(255),
									bcc							nvarchar(255)
)
DECLARE @userRole   INTEGER
DECLARE @providerId INTEGER
DECLARE @isAllowedtoCreateCompanies INTEGER
DECLARE @xmlText XML
EXEC AppGetUserRole  @i_userId, @xmlText OUTPUT, @o_errCode OUTPUT, @o_errString OUTPUT
SET @userRole = (SELECT TOP 1 ref.value('@userRole', 'int') AS value FROM @xmlText.nodes('Api_GetUserMappings') R ( ref ))
SET @isAllowedtoCreateCompanies = (SELECT TOP 1 ref.value('@isAllowedtoCreateCompanies', 'int') AS value FROM @xmlText.nodes('Api_GetUserMappings') R ( ref ))
SET @providerId = (SELECT TOP 1 ref.value('@providerId', 'int') AS value FROM @xmlText.nodes('Api_GetUserMappings') R ( ref ))
IF @o_errCode = 0
BEGIN
	DECLARE @canManageProvider INT
	DECLARE @ownerCompany INT = 0
	SET @ownerCompany = dbo.AppgetOrganizationforuser(@i_userId) -- get company for logged in user
	--Check if user has admin rights
EXEC sec_checkPermissionOnEntity  @i_userId, 1, @canManageProvider OUTPUT, 61, @ownerCompany
	if @i_listPropertyLevel = 1
	BEGIN
		INSERT INTO #EmailTemplatesList(id, name, description, modifiedOn, type, ownerCompanyId, ownerCompanyName, localeId, isDefault, localename)
				(SELECT ET.[id]
					  ,ET.[name]
					  ,isnull( ET.[description]	, dbo.fn_EvFormatEventMsgText(0, @i_localeId, ETT.locDescriptionId, 0,2)  ) as description	-- if description is not set for template, get it from type table
					  ,ET.[modifiedOn]
					  ,ET.[type]
					  ,ET.[ownerCompanyId]
					  ,company.domainName
					  ,ET.[localeId]
					  ,ET.[isDefault]
					  ,loc.displayString
					  FROM APP_EmailTemplate ET
						join UMDSProviders company on et.ownerCompanyId = company.id
						join evlocales loc on ET.localeId = loc.id
						join App_EmailTemplateType ETT on ET.type = ETT.typeId	and ETT.flag&4 != 4 -- exclude disabled types
WHERE (@userRole=0 or @userRole=1)  -- check if current user is an admin (msp admin or tenant admin)
and (@userRole=0 or ((ET.ownerCompanyId = @providerId) and (@isAllowedtoCreateCompanies=1 or(ETT.flag&2 != 2)))) --if mspAdmin, return all templates. If tenant admin then return templates for that company only and exclude those that are for MSPAdminOnly
					and	((@isMSPComcell = 1) or (ETT.flag&1 = 0)) -- If CommCell is msp, no need to check for MSPOnly flag. If comcell is not msp, exclude MSPOnly types
					and ((@i_idList is null) or ((@i_idList is not null) and (ET.id in (SELECT idTbl._id FROM SplitIDs(@i_idList) idTbl))))
					and ((@i_templateType is null) or ((@i_templateType is not null) and (ET.type = @i_templateType))) -- type filter
					and ((@i_ownerCompanyId is null) or ((@i_ownerCompanyId is not null) and (ET.ownerCompanyId = @i_ownerCompanyId))) -- owner company filter. it is not related to security. it may be used for msp admins who may want to filter templates based on ownerCompany
					and ((@i_filterLocaleId is null) or ((@i_filterLocaleId is not null) and (ET.localeId = @i_filterLocaleId))) -- locale filter
				)
	END
	if @i_listPropertyLevel = 30
	BEGIN
		INSERT INTO #EmailTemplatesList(id, name, description, modifiedOn, type, ownerCompanyId, ownerCompanyName, localeId, isDefault, fromName, fromEmail, subject, emailBody, cc, bcc, localename)
				(SELECT ET.[id]
					  ,ET.[name]
					  ,isnull( ET.[description]	, dbo.fn_EvFormatEventMsgText(0, @i_localeId, ETT.locDescriptionId, 0,2)  ) as description	-- if description is not set for template, get it from type table
					  ,ET.[modifiedOn]
					  ,ET.[type]
					  ,ET.[ownerCompanyId]
					  ,company.domainName
					  ,ET.[localeId]
					  ,ET.[isDefault]
					  ,ET.[fromName]
					  ,ET.[fromEmail]
					  ,ET.[subject]
					  ,ET.[emailBody]
					  ,ET.[cc]
					  ,ET.[bcc]
					  ,loc.displayString
					  FROM APP_EmailTemplate ET
						join UMDSProviders company on et.ownerCompanyId = company.id
						join evlocales loc on ET.localeId = loc.id
						join App_EmailTemplateType ETT on ET.type = ETT.typeId	and ETT.flag&4 != 4 -- exclude disabled types
WHERE (@userRole=0 or @userRole=1)  -- check if current user is an admin (msp admin or tenant admin)
and (@userRole=0 or ((ET.ownerCompanyId = @providerId) and (@isAllowedtoCreateCompanies=1 or(ETT.flag&2 != 2)))) --if mspAdmin, return all templates. If tenant admin then return templates for that company only and exclude those that are for MSPAdminOnly
					and	((@isMSPComcell = 1) or (ETT.flag&1 = 0)) -- If CommCell is msp, no need to check for MSPOnly flag. If comcell is not msp, exclude MSPOnly types
					and ((@i_idList is null) or ((@i_idList is not null) and (ET.id in (SELECT idTbl._id FROM SplitIDs(@i_idList) idTbl))))
					and ((@i_templateType is null) or ((@i_templateType is not null) and (ET.type = @i_templateType))) -- type filter
					and ((@i_ownerCompanyId is null) or ((@i_ownerCompanyId is not null) and (ET.ownerCompanyId = @i_ownerCompanyId)))
					and ((@i_filterLocaleId is null) or ((@i_filterLocaleId is not null) and (ET.localeId = @i_filterLocaleId))) -- locale filter
				)
	END
	IF @debug = 1
	BEGIN
		SELECT 'emailTemplate', * FROM #EmailTemplatesList
	END
	SET @o_xmlText = (SELECT
						(SELECT
							ETEntities.id  AS '@emailTemplateId',
							ETEntities.name  AS '@name',
							ETEntities.description  AS '@description',
							ETEntities.type  AS '@emailTemplateTypeId',
							ETEntities.cc  AS '@cc',
							ETEntities.bcc  AS '@bcc',
							ETEntities.isDefault AS '@isDefault',
							ETEntities.modifiedOn  AS '@modifiedTime',
							ETEntities.subject  AS '@subject',
							ETEntities.emailBody  AS '@emailBody',
							(SELECT ETEntities.fromName                    AS '@fullName',
									ETEntities.fromEmail                   AS '@email'
								FOR XML PATH('from'), TYPE),
							(select ETEntities.ownerCompanyId                    AS '@providerId',
									ETEntities.ownerCompanyName                  AS '@providerDomainName'
							FOR XML PATH('ownerCompany'), TYPE),
							(select ETEntities.localeId as '@localeId',
									ETEntities.localename as '@displayString'
								for xml path('locale'), type)
						 FROM    #EmailTemplatesList ETEntities order by ETEntities.name
						 FOR XML PATH('emailTemplatesList'), TYPE)
					FOR XML PATH(''), ROOT('Api_GetEmailTemplatesResponse'))
END
ELSE
BEGIN
	SET @o_xmlText = (SELECT
							(SELECT @o_errCode AS '@errorCode',  @o_errString AS '@errorMessage'  FOR XML PATH('error'),TYPE)
						 FOR XML PATH('Api_GetEmailTemplatesResponse'),TYPE)
END
IF OBJECT_ID('tempdb.dbo.#EmailTemplatesList')                    IS NOT NULL DROP TABLE #EmailTemplatesList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEmailTemplates')
	delete from GxQscripts where name = 'AppGetEmailTemplates'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEmailTemplates')
	delete from GXDBVersions where aliasname = 'AppGetEmailTemplates'
GO

insert into GXDBVersions values(2, 'AppGetEmailTemplates',  '00000000000000000000', 'AppGetEmailTemplates', '00000000000000000000')
GO

