

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEmailTemplateTypes.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Divya Trivedi
-- Create date: 12/19/2017
-- Description:	To get the list of email template types
-- Parameters : i_idList comma separated list of email template type IDs. if null, all valid types will be returned.
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetEmailTemplateTypes')
BEGIN
	print '>>> Drop Stored Procedure: AppGetEmailTemplateTypes <<<'
	drop procedure AppGetEmailTemplateTypes
END
IF EXISTS (select * from GxQscripts where name='AppGetEmailTemplateTypes')
	delete from GxQscripts where name = 'AppGetEmailTemplateTypes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEmailTemplateTypes')
	delete from GXDBVersions where aliasname = 'AppGetEmailTemplateTypes'
GO
print '... Creating Procedure: AppGetEmailTemplateTypes'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEmailTemplateTypes
  @i_userId INT,
  @i_localeId INT,
  @i_idList NVARCHAR(MAX) =  null,
  @i_listPropertyLevel INT = 1,
  @i_defaultContentLocaleId INT = 0, -- if not passed return content in english. localeid 0 i.e. English is the default locale
  @o_xmlText XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @debug  AS INT = 0
DECLARE @o_errCode INTEGER
DECLARE @o_errString NVARCHAR(1024)
Declare @isMSPComcell int = isnull((select value from gxglobalparam where name = 'IsMSPCommcell'), 0)
IF OBJECT_ID('tempdb.dbo.#EmailTemplateTypesList') IS NOT null	DROP TABLE #EmailTemplateTypesList
create table #EmailTemplateTypesList
(
	typeId						int primary key,
	name						nvarchar(255),
	locNameId      				bigint,
	locDescriptionId 			bigint,
	isMSPAdminOnly				bit,
	locDefaultSubjectId 		bigint,
	emailBody 					nvarchar(max)
)
DECLARE @xmlText XML
DECLARE @userRole   INTEGER
DECLARE @providerId INTEGER
DECLARE @isAllowedtoCreateCompanies INTEGER
EXEC AppGetUserRole  @i_userId, @xmlText OUTPUT, @o_errCode OUTPUT, @o_errString OUTPUT
SET @userRole = (SELECT TOP 1 ref.value('@userRole', 'int') AS value FROM @xmlText.nodes('Api_GetUserMappings') R ( ref ))
SET @isAllowedtoCreateCompanies = (SELECT TOP 1 ref.value('@isAllowedtoCreateCompanies', 'int') AS value FROM @xmlText.nodes('Api_GetUserMappings') R ( ref ))
SET @providerId = (SELECT TOP 1 ref.value('@providerId', 'int') AS value FROM @xmlText.nodes('Api_GetUserMappings') R ( ref ))
IF @o_errCode = 0
BEGIN
	if @i_listPropertyLevel = 1
	BEGIN
		INSERT INTO #EmailTemplateTypesList(typeId, name,  locNameId, locDescriptionId, isMSPAdminOnly)
		(
			select ETT.typeId
					, ETT.name
					, ETT.locNameId
					, ETT.locDescriptionId
					, case when (ETT.flag&2 = 2) then 1 else 0 end as isMSPAdminOnly
			from APP_EmailTemplateType ETT
where (@userRole=0 or @userRole=1)  -- check if current user is an admin (msp admin or tenant admin)
			and ETT.flag&4 != 4 -- exclude disabled types
and (@userRole=0 or @isAllowedtoCreateCompanies=1  or (ETT.flag&2 != 2)) -- If user is MSPAdmin or can create companies, no need to check for MSPAdminOnly flag. If user is tenant admin, exclude MSPAdminOnly types
			and	((@isMSPComcell = 1) or (ETT.flag&1 = 0)) -- If CommCell is msp, no need to check for MSPOnly flag. If comcell is not msp, exclude MSPOnly types
			and ((@i_idList is null) or ((@i_idList is not null) and (ETT.typeId in (SELECT idTbl._id FROM SplitIDs(@i_idList) idTbl))))
		)
	END
	if @i_listPropertyLevel = 30
	BEGIN
		INSERT INTO #EmailTemplateTypesList(typeId, name,  locNameId, locDescriptionId, isMSPAdminOnly, locDefaultSubjectId, emailBody)
		(
			select ETT.typeId
					, ETT.name
					, ETT.locNameId
					, ETT.locDescriptionId
					, case when (ETT.flag&2 = 2) then 1 else 0 end as isMSPAdminOnly
					, ETT.locDefaultSubjectId
					, dbo.fn_EvFormatEventMsgText(0, @i_defaultContentLocaleId, ETT.locDefaultEmailBodyId, 0,2)
					--if no property record is found, append empty string
					+ isnull(
							--concat localized messages
							(SELECT '' + dbo.fn_EvFormatEventMsgText(0, @i_defaultContentLocaleId, _ID, 0,2)
								FROM dbo.SplitStringByDelimiter(
									  (
										--Get property for comma separated additional email body message IDs
										select top 1 ETTProp.attrVal
										from App_EmailTemplateTypeProp ETTProp
where ETTProp.componentNameId = ETT.typeId and ETTProp.modified = 0 and ETTProp.attrName = 'additionalLocDefaultEmailBodyIds'
										order by ETTProp.created desc
									  ),
									  -- message IDs are expected to be separated by comma in the property additionalLocDefaultEmailBodyIds
									 ','
								 )
						  FOR XML PATH (''), TYPE).value('.', 'nvarchar(max)')
						  , '')
			from APP_EmailTemplateType ETT
where (@userRole=0 or @userRole=1)  -- check if current user is an admin (msp admin or tenant admin)
			and ETT.flag&4 != 4 -- exclude disabled types
and (@userRole=0  or @isAllowedtoCreateCompanies=1  or (ETT.flag&2 != 2)) -- If user is MSPAdmin or can create companies, no need to check for MSPAdminOnly flag. If user is tenant admin, exclude MSPAdminOnly types
			and	((@isMSPComcell = 1) or (ETT.flag&1 = 0)) -- If CommCell is msp, no need to check for MSPOnly flag. If comcell is not msp, exclude MSPOnly types
			and ((@i_idList is null) or ((@i_idList is not null) and (ETT.typeId in (SELECT idTbl._id FROM SplitIDs(@i_idList) idTbl))))
		)
		--Update image data in emailBody from properties table, if present - START
		IF OBJECT_ID('tempdb.dbo.#EmailTemplateTypesWithImage') IS NOT null	DROP TABLE #EmailTemplateTypesWithImage
		create table #EmailTemplateTypesWithImage
		(
											rowId					int primary key identity(1,1),
											templateTypeId			int
		)
		Declare @totalTemplateTypes int, @currentTemplateTypeRecord int = 1, @templateTypeEmailBody nvarchar(max)
		INSERT INTO #EmailTemplateTypesWithImage(templateTypeId)
		select distinct componentNameId from App_EmailTemplateTypeProp where  modified = 0 and attrType = 138
		SET @totalTemplateTypes = @@ROWCOUNT
		declare @currentTemplateTypeId int
		WHILE @currentTemplateTypeRecord <= @totalTemplateTypes
		BEGIN
			SELECT @currentTemplateTypeId = templateTypeId
			FROM #EmailTemplateTypesWithImage
			where RowID = @currentTemplateTypeRecord
			select @templateTypeEmailBody = emailbody from #EmailTemplateTypesList where typeId = @currentTemplateTypeId
			update imagePropsKey
			set @templateTypeEmailBody = replace(@templateTypeEmailBody, '$'+imagePropsKey.attrName+'$', imagePropsKey.attrVal)
			from App_EmailTemplateTypeProp imagePropsKey
			where imagePropsKey.modified = 0
				and imagePropsKey.attrType = 138
				and imagePropsKey.componentNameId = @currentTemplateTypeId
			option (maxdop 1);
			update #EmailTemplateTypesList
			set emailBody = @templateTypeEmailBody
			where typeId = @currentTemplateTypeId
			SET @currentTemplateTypeRecord = @currentTemplateTypeRecord + 1
		END
		--Update image data in emailBody from properties table, if present - END
	END
IF @debug = 1
BEGIN
    SELECT 'emailTemplateType', * FROM #EmailTemplateTypesList
END
SET @o_xmlText = (SELECT
                    (SELECT
						ETT.typeId  AS '@typeId',
						ETT.name  AS '@name',
						dbo.fn_EvFormatEventMsgText(0, @i_localeId, ETT.locNameId, 0,2)  AS '@localizedName',
						dbo.fn_EvFormatEventMsgText(0, @i_localeId, ETT.locDescriptionId, 0,2)  AS '@description',
						ETT.isMSPAdminOnly  AS '@isMSPAdminOnly',
						(SELECT dbo.fn_EvFormatEventMsgText(0, @i_defaultContentLocaleId, ETT.locDefaultSubjectId, 0,2)                  AS '@subject',
							ETT.emailBody                 AS '@emailBody'
							FOR XML PATH('defaultTemplateContent'), TYPE)
                     FROM    #EmailTemplateTypesList ETT order by ETT.name
                     FOR XML PATH('emailTemplateTypesList'), TYPE)
                FOR XML PATH(''), ROOT('Api_GetEmailTemplateTypesResponse'))
END
ELSE
BEGIN
		SET @o_xmlText = (SELECT
							(SELECT @o_errCode AS '@errorCode',  @o_errString AS '@errorMessage'  FOR XML PATH('error'),TYPE)
						 FOR XML PATH('Api_GetEmailTemplateTypesResponse'),TYPE)
END
IF OBJECT_ID('tempdb.dbo.#EmailTemplateTypesWithImage') IS NOT NULL DROP TABLE #EmailTemplateTypesWithImage
IF OBJECT_ID('tempdb.dbo.#EmailTemplateTypesList')                    IS NOT NULL DROP TABLE #EmailTemplateTypesList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEmailTemplateTypes')
	delete from GxQscripts where name = 'AppGetEmailTemplateTypes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEmailTemplateTypes')
	delete from GXDBVersions where aliasname = 'AppGetEmailTemplateTypes'
GO

insert into GXDBVersions values(2, 'AppGetEmailTemplateTypes',  '00000000000000000000', 'AppGetEmailTemplateTypes', '00000000000000000000')
GO

