

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEmailTemplateTokens.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Divya Trivedi
-- Create date: 12/19/2017
-- Description:	To get the list of email template tokens for a template type
-- Parameters : i_templateType template type. it refers to enum EmailTemplateType in api.x
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetEmailTemplateTokens <<<'

IF EXISTS (select * from sysobjects where name='AppGetEmailTemplateTokens')
	drop procedure AppGetEmailTemplateTokens
IF EXISTS (select * from GxQscripts where name='AppGetEmailTemplateTokens')
	delete from GxQscripts where name = 'AppGetEmailTemplateTokens'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEmailTemplateTokens')
	delete from GXDBVersions where aliasname = 'AppGetEmailTemplateTokens'
GO
print '... Creating Procedure: AppGetEmailTemplateTokens'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEmailTemplateTokens
  @i_userId INT,
  @i_localeId INT,
  @i_templateType INT = null,
  @o_xmlText XML OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
if(@i_templateType is null)
SET @o_xmlText = (select
					(select
						etTok.tokenId  AS '@tokenId',
						etTok.name  AS '@name'
                     FROM    APP_EmailTemplateToken etTok order by etTok.name
                     FOR XML PATH('emailTemplateTokensList'), TYPE)
				FOR XML PATH(''), ROOT('Api_GetEmailTemplateTokensResponse'))
else
SET @o_xmlText = (select
					(select
						etTok.tokenId  AS '@tokenId',
						etTok.name  AS '@name'
                    from APP_EmailTemplateType_Token_Map mapTokType
					join APP_EmailTemplateToken etTok on mapTokType.tokenId = etTok.tokenId
					where  mapTokType.typeId = @i_templateType -- type filter
					order by etTok.name
                    FOR XML PATH('emailTemplateTokensList'), TYPE)
				FOR XML PATH(''), ROOT('Api_GetEmailTemplateTokensResponse'))
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEmailTemplateTokens')
	delete from GxQscripts where name = 'AppGetEmailTemplateTokens'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEmailTemplateTokens')
	delete from GXDBVersions where aliasname = 'AppGetEmailTemplateTokens'
GO

insert into GXDBVersions values(2, 'AppGetEmailTemplateTokens',  '00000000000000000000', 'AppGetEmailTemplateTokens', '00000000000000000000')
GO

