

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEmailConfigIncludingSecurity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEmailConfigIncludingSecurity.sp,v $ $Id: AppGetEmailConfigIncludingSecurity.sp,v 1.1.2.1 2018/10/16 17:47:30 dtrivedi Exp $";
-- =============================================
-- Author:		Divya Trivedi
-- Create date: 08/19/2013
-- Description:	To get the email configuration including smtpPassword
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetEmailConfigIncludingSecurity')
BEGIN
	print '>>> Drop Stored Procedure: AppGetEmailConfigIncludingSecurity <<<'
	drop procedure AppGetEmailConfigIncludingSecurity
END
IF EXISTS (select * from GxQscripts where name='AppGetEmailConfigIncludingSecurity')
	delete from GxQscripts where name = 'AppGetEmailConfigIncludingSecurity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEmailConfigIncludingSecurity')
	delete from GXDBVersions where aliasname = 'AppGetEmailConfigIncludingSecurity'
GO
print '... Creating Procedure: AppGetEmailConfigIncludingSecurity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEmailConfigIncludingSecurity
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
  DECLARE @o_xmlmsg xml
  DECLARE @smtpPassword nvarchar(max)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
--Code Below Here is From AppGetEmailConfig.spb
	DECLARE @smtpServer	nvarchar(256)
	DECLARE @smtpPort		int
	DECLARE @displayName	nvarchar(max)
	DECLARE @strFrom		nvarchar(max)
	DECLARE @smtpUserName	nvarchar(max)
	DECLARE @smtpSSL		int
	DECLARE @reqCred		int
	DECLARE @startTLS		INT
	DECLARE @timeout		INT
	DECLARE @filterInvalidEmails INT
	DECLARE @emailMaxMesgSize	bigint
	DECLARE @useEncryptedMailServer INT
	SET @smtpServer  = ISNULL((SELECT smtpServer from APP_CommCell where id = 2),'')
	SET @smtpPort     = ISNULL((SELECT TOP 1 CAST(value AS INT) FROM GXGlobalParam WHERE name = N'EVSMTPport' AND modified = 0 ORDER BY created DESC),0)
	SET @displayName = ISNULL((SELECT TOP 1 CAST(value AS  NVARCHAR(MAX)) FROM GXGlobalParam WHERE name = N'EVSMTPDisplayName' AND modified = 0 ORDER BY created DESC),'')
	SET @strFrom     = ISNULL((SELECT TOP 1 CAST(value AS  NVARCHAR(MAX)) FROM GXGlobalParam WHERE name = N'EVSMTPSender' AND modified = 0 ORDER BY created DESC),'')
	SET @smtpPassword = ISNULL((SELECT TOP 1 CAST(value AS  NVARCHAR(MAX)) FROM GXGlobalParam WHERE name = N'EVSMTPPassword' AND modified = 0 ORDER BY created DESC),'')
	SET @smtpUserName = ISNULL((SELECT TOP 1 CAST(value AS  NVARCHAR(MAX)) FROM GXGlobalParam WHERE name = N'EVSMTPUsername' AND modified = 0 ORDER BY created DESC),'')
	SET @startTLS     = ISNULL((SELECT TOP 1 CAST(value AS INT) FROM GXGlobalParam WHERE name = N'EVSMTPTLS' AND modified = 0 ORDER BY created DESC),0)
	SET @smtpSSL     = ISNULL((SELECT TOP 1 CAST(value AS INT) FROM GXGlobalParam WHERE name = N'EVSMTPSSL' AND modified = 0 ORDER BY created DESC),0)
	SET @reqCred     = ISNULL((SELECT TOP 1 CAST(value AS INT) FROM GXGlobalParam WHERE name = N'EVSMTPIsCredentialRequired' AND modified = 0 ORDER BY created DESC),0)
	SET @emailMaxMesgSize = ISNULL((SELECT TOP 1 CAST(value as int) FROM GXGlobalParam WHERE name = N'EVSMTPMaxMessKB' AND modified = 0 ORDER BY created DESC), 3*1024) --Default 3MB
	SET @timeout = ISNULL((SELECT TOP 1 CAST(value as int) FROM GXGlobalParam WHERE name = N'mailTimeOutValue' AND modified = 0 ORDER BY created DESC),30000)
	SET @filterInvalidEmails = ISNULL((SELECT TOP 1 CAST(value as int) FROM GXGlobalParam WHERE name = N'filterInvalidEmails' AND modified = 0 ORDER BY created DESC),0)
	SET @useEncryptedMailServer = ISNULL((SELECT TOP 1 1 FROM GXGlobalParam WHERE name = N'bUseEncryptedMailServer' AND modified = 0 AND value = N'TRUE'),0)
	Declare @smtpPassword4XML nvarchar(max)
	If @smtpPassword != ''
	Begin
		set @smtpPassword4XML = dbo.base64encode(@smtpPassword);
		set @smtpPassword4XML = dbo.EncodeInvalidXMLChar(@smtpPassword4XML);
		set @smtpPassword4XML = '||#5!' + @smtpPassword4XML;
	End
	SET @o_xmlmsg = (
		SELECT
		[@smtpServer] = @smtpServer,
		[@smtpPort] = @smtpPort,
		[@enableSSL] = @smtpSSL,
		[@startTLS] = @startTLS,
		[@useAuthentication] = @reqCred,
		[@maxMailServerSize] = @emailMaxMesgSize,
		[@timeout] = @timeout,
		[@filterInvalidEmails] = @filterInvalidEmails,
		[@useEncryptedMailServer] = @useEncryptedMailServer,
		[senderInfo/@senderName] = @displayName,
		[senderInfo/@senderAddress] = @strFrom,
		[userInfo/@userName] = CASE WHEN @reqCred = 1 THEN @smtpUserName END,
		[userInfo/@password] = CASE WHEN @reqCred = 1 THEN @smtpPassword4XML END
		FOR XML PATH('App_SMTPInfo'))
	SELECT @o_xmlmsg AS o_responseXML
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEmailConfigIncludingSecurity')
	delete from GxQscripts where name = 'AppGetEmailConfigIncludingSecurity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEmailConfigIncludingSecurity')
	delete from GXDBVersions where aliasname = 'AppGetEmailConfigIncludingSecurity'
GO

insert into GXDBVersions values(2, 'AppGetEmailConfigIncludingSecurity',  '00010001000200010000', 'AppGetEmailConfigIncludingSecurity', '00010001000200010000')
GO

