

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEligibleDCPlans.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetEligibleDCPlans"
--	|	This Procedure is used to get all DC plans that satisfies the input conditions
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetEligibleDCPlans')
BEGIN
	print '>>> Drop Stored Procedure: AppGetEligibleDCPlans <<<'
	drop procedure AppGetEligibleDCPlans
END
IF EXISTS (select * from GxQscripts where name='AppGetEligibleDCPlans')
	delete from GxQscripts where name = 'AppGetEligibleDCPlans'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEligibleDCPlans')
	delete from GXDBVersions where aliasname = 'AppGetEligibleDCPlans'
GO
print '... Creating Procedure: AppGetEligibleDCPlans'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetEligibleDCPlans
  @i_userId INT,
  @i_simPackageIds NVARCHAR(Max),
  @i_contentAnalyzerEnabled INT,
  @i_entityPolicyEnabled INT,
  @i_ciPolicyEnabled INT,
  @i_cloudType INT,
  @i_TargetApp INT = 0,
  @i_clientId INT = 0,
  @o_xmlText XML output
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @planActive INT = 0
DECLARE @getDCPlans TABLE
            (
				planId INT PRIMARY KEY,
				planName NVARCHAR(512),
				isValid BIT DEFAULT 1,
				reason NVARCHAR(256),
				indexServerClientId INT,
				caCloudId INT,
				eePolicyId INT,
				ciPolicyId INT,
				targetApp NVARCHAR(10)
            )
DECLARE @errorCode INT =0
DECLARE @errorMessage  NVARCHAR(1024)=''
IF (@i_clientId > 0)
BEGIN
	DECLARE @isCIEnabledOnAnySubclient INT  = 0
	SELECT @isCIEnabledOnAnySubclient=1 FROM APP_Application AAP WITH(NOLOCK)
	INNER JOIN APP_SubClientProp ASCP WITH(NOLOCK)
		ON ASCP.componentNameId=AAP.id AND AAP.clientId=@i_clientId
			AND ASCP.attrname='Enable content indexing' AND ASCP.cs_attrName=CHECKSUM(N'Enable content indexing')
			AND ASCP.attrval='1' AND ASCP.modified=0
	IF (@isCIEnabledOnAnySubclient = 1)
	BEGIN
SET @errorCode = (4717 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		--'Content Indexing is enabled for at least one of the subclient of client-[^1%s]. Disable it from Commcell console and try again.'
		SET @errorMessage=(SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = 0)
		SET @errorMessage = REPLACE(@errorMessage, '^1%s', (SELECT displayName FROM App_Client WITH(NOLOCK) WHERE id = @i_clientId))
		GOTO PROC_EXIT
	END
END
-- Get all appliable plans for this user
DECLARE @PlansList TABLE (planId INT PRIMARY KEY)
DECLARE   @plan_xmlText XML,
           @return_value INT
EXEC    @return_value = [dbo].[AppPlanGetSummaryListV2]
		 @i_planType = 0,
@i_planSubtype = 117506053,
         @i_userId = @i_userId,
		 @i_owner = 0,
		 @i_includeIncomplete = 0,
         @o_xmlText = @plan_xmlText OUTPUT
INSERT INTO @PlansList (planId)
 SELECT
     PlanInfo.N.value('@planId', 'INT')
     FROM @plan_xmlText.nodes('/Api_GetPlanSummaryResp/plans/plan') AS PlanInfo(N)
-- Get all the DC plans and initialize all as valid
INSERT INTO @getDCPlans
SELECT planInfo.id, planInfo.name, 1, '',dbo.AppPlanGetEntityValueV2(planInfo.id, 'Analytics Index Server Id',  default),
dbo.AppPlanGetEntityValueV2(planInfo.id, 'Content Analyzer Cloud Id',  default),
dbo.AppPlanGetEntityValueV2(planInfo.id, 'Data classification policy',  default),
dbo.AppPlanGetEntityValueV2(planInfo.id, 'Content Indexing Policy',  default),
PP.attrVal
FROM App_Plan planInfo (NOLOCK)
INNER JOIN @PlansList eligiblePlans ON planInfo.id = eligiblePlans.planId
-- Include target app filter to retrieve plans of a specific app
--
LEFT JOIN App_PlanProp PP (NOLOCK)
	ON planInfo.id = PP.componentNameId
AND PP.attrName = 'Target app'
		AND PP.modified = 0
WHERE subType=117506053
-- if valid target app is passed,
-- --if target app = FSO (1 - ContentIndexing_Target_App.CI_TARGET_FSO), return plans which has targetApp prop = FSO or prop = null and ee enabled = false
-- --if target app = SDG (2 - ContentIndexing_Target_App.CI_TARGET_SDG), return plans which has targetApp prop = SDG or prop = null end ee enabled = true
-- If target app = FS or VSA, then remove everything else. Since they are new ones targetApp will always be there
-- --else return plans which targetApp prop = input or prop = null
-- below is logic to DELETE, so it is a reversed logic to above explanation
IF (@i_TargetApp > 0)
BEGIN
	DELETE FROM @getDCPlans
	WHERE (targetApp IS NULL AND @i_TargetApp = 1 AND ISNULL(eePolicyId, 0) > 0) -- FSO
		OR (targetApp IS NULL AND @i_TargetApp = 2 AND ISNULL(eePolicyId, 0) = 0) -- SDG
		OR (targetApp IS NULL AND @i_TargetApp = 8)  -- FS
		OR (targetApp IS NULL AND @i_TargetApp = 16) -- VSA
		OR (targetApp IS NOT NULL AND CAST(targetApp AS INT) <> @i_TargetApp) -- valid target app
END
BEGIN
	-- Verifiying if the plan is created with the index server with appropriate packageid installed
	IF NULLIF(@i_simPackageIds, '') IS NOT NULL AND @i_simPackageIds <> '0'
	BEGIN
	-- Get the list of indexservers with simPackageType installed
		DECLARE @getCompliantServers TABLE
					(     serverName NVARCHAR(512),
						  clientId INT,
						  clientName NVARCHAR(256),
						  cloudId INT,
						  hostName NVARCHAR(256),
						  basePort INT,
						  engineName  NVARCHAR(256),
						  cloudType INT,
						  indexServerClientId INT,
						  internalCloudName NVARCHAR(256)
					)
		INSERT @getCompliantServers
		EXEC DM2GetAnalyticsEngineOfSimPackageType @i_simPackageIds
	-- Update DC plans that doesn't have the simPackageType compliant index servers
		UPDATE @getDCPlans SET reason = 'NOT_COMPLIANTSERVER',isValid=0
		FROM @getDCPlans A LEFT JOIN @getCompliantServers B on A.indexServerClientId = B.indexServerClientId
		-- fix for MR 251855: We should not show the Data classifications plans that are pointing to a multi node Index server while creating a project since Governance app does not support multi node index server or cloud
WHERE (B.indexServerClientId IS NULL) OR (B.cloudType != 1)
	END
END
IF @i_entityPolicyEnabled = 1
BEGIN
	UPDATE @getDCPlans SET reason = CASE
										WHEN reason='' THEN 'NO_EEPOLICY'
										ELSE CONCAT(reason,',','NO_EEPOLICY')
									END,
							isValid = 0
							WHERE eePolicyId IS NULL
END
IF @i_contentAnalyzerEnabled = 1
BEGIN
		UPDATE @getDCPlans SET reason = CASE
										WHEN reason='' THEN 'NO_CACLOUD'
										ELSE CONCAT(reason,',','NO_CACLOUD')
									END,
							isValid = 0
							WHERE caCloudId IS NULL
END
IF @i_ciPolicyEnabled = 1
BEGIN
		UPDATE @getDCPlans SET reason = CASE
										WHEN reason='' THEN 'NO_CIPOLICY'
										ELSE CONCAT(reason,',','NO_CIPOLICY')
									END,
							isValid = 0
							WHERE ciPolicyId IS NULL
END
/*Update the plan as invalid, if the cloud type is not matching the requested cloud type*/
UPDATE @getDCPlans SET reason = CASE
									WHEN reason='' THEN 'INVALID_INDEXSERVER'
									ELSE CONCAT(reason,',','INVALID_INDEXSERVER')
									END,
							isValid = 0
FROM @getDCPlans eligiblePlans INNER JOIN DM2Cloud dm2Cloud ON eligiblePlans.indexServerClientId = dm2Cloud.pseudoClientId
AND dm2Cloud.CloudType != @i_cloudType
SET @o_xmlText =(
SELECT planId '@planId', planName '@planName', isValid '@isValid', reason '@reason' FROM @getDCPlans FOR XML PATH('plans'))
PROC_EXIT:
SET @o_xmlText = ( SELECT
					@o_xmlText,
					( SELECT @errorCode AS '@errorCode', @errorMessage  AS '@errorMessage'
						  FOR XML PATH('error'), TYPE
					)
						FOR XML PATH(''),
					ROOT('App_GetEligibleDCPlansResponse'))
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEligibleDCPlans')
	delete from GxQscripts where name = 'AppGetEligibleDCPlans'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEligibleDCPlans')
	delete from GXDBVersions where aliasname = 'AppGetEligibleDCPlans'
GO

insert into GXDBVersions values(2, 'AppGetEligibleDCPlans',  '00000000000000000000', 'AppGetEligibleDCPlans', '00000000000000000000')
GO

