

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEligibleClientsForSubclientPolicy.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEligibleClientsForSubclientPolicy.sp,v $ $Id: AppGetEligibleClientsForSubclientPolicy.sp ";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetEligibleClientsForSubclientPolicy"
--	|	This Procedure is used to get all the file system clients which have atleast one backupset not associated to any subclient policy.
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetEligibleClientsForSubclientPolicy <<<'

IF EXISTS (select * from sysobjects where name='AppGetEligibleClientsForSubclientPolicy')
	drop procedure AppGetEligibleClientsForSubclientPolicy
IF EXISTS (select * from GxQscripts where name='AppGetEligibleClientsForSubclientPolicy')
	delete from GxQscripts where name = 'AppGetEligibleClientsForSubclientPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEligibleClientsForSubclientPolicy')
	delete from GXDBVersions where aliasname = 'AppGetEligibleClientsForSubclientPolicy'
GO
print '... Creating Procedure: AppGetEligibleClientsForSubclientPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEligibleClientsForSubclientPolicy
  @userId INT,
  @o_xml XML  OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
	DECLARE @clientList TABLE (id INT, name NVARCHAR(MAX))
	IF OBJECT_ID('tempdb.dbo.#ClientViewBackupSetsTbl') IS NOT NULL
    DROP TABLE #ClientViewBackupSetsTbl
	CREATE TABLE #ClientViewBackupSetsTbl (clientId INT, applicationId INT, instanceId INT, backupsetId INT )
	IF OBJECT_ID('tempdb.dbo.#UserClientsOrBackupsets') IS NOT NULL
	DROP TABLE #UserClientsOrBackupsets
	CREATE TABLE #UserClientsOrBackupsets (clientId INT, apptypeId INT, instanceId INT, backupsetId INT, subclientId	INT)
	IF OBJECT_ID('tempdb.dbo.#BackupSetsTbl') IS NOT NULL
	DROP TABLE #BackupSetsTbl
	CREATE TABLE #BackupSetsTbl   (clientId INT, apptypeId INT, instanceId INT, backupSet INT, backupSetName  NVARCHAR(256), subclientId INT,
        subclientStatus INT,  systemStateFlag INT, scpId INT )
    INSERT INTO #BackupSetsTbl
    SELECT  App.clientId, App.appTypeId, App.instance, App.backupSet, BackupSet.name, App.id, App.subclientStatus, systemStateFlag = ISNULL(SCProp.attrVal, 0), scpId   =   ISNULL(BSProp.attrVal, 0)
    FROM APP_Application App
        INNER JOIN APP_BackupsetName BackupSet
ON (App.subclientStatus & 0x00004) <> 0x00004 AND App.backupSet = BackupSet.id AND (BackupSet.status & 0x0080) <> 0x0080
        LEFT OUTER JOIN APP_SubClientProp SCProp
            ON App.id = SCProp.componentNameId
            AND SCProp.attrName = N'System State Subclient' AND SCProp.modified = 0
        LEFT OUTER JOIN APP_BackupSetProp BSProp
            ON App.backupSet = BSProp.componentNameId
            AND BSProp.attrName = N'Associated subclient Policy' AND BSProp.modified = 0
	--Only File System is allowed
	DELETE #BackupSetsTbl
	WHERE apptypeId  <> 33
	-- Remove Edge drive clients
	DELETE B
	FROM #BackupSetsTbl B
		INNER JOIN APP_Client C
                ON B.clientId = C.id
WHERE (C.status & 0x10000000) <>  0
    -- Remove Indexing backupsets
    DELETE #BackupSetsTbl WHERE backupSetName = N'Indexing BackupSet'
    -- Remove backupsets with user defined subclients
	DELETE A
	FROM #BackupSetsTbl A
		INNER JOIN #BackupSetsTbl B
			ON  A.backupSet = B.backupSet
	WHERE B.scpId = 0
		AND B.subclientStatus = 0
		AND B.systemStateFlag <> 1
    -- Remove backupsets already associated to a subclient policy
    DELETE #BackupSetsTbl WHERE scpId <> 0
    INSERT INTO #ClientViewBackupSetsTbl
    SELECT DISTINCT clientId, apptypeId, instanceId, backupSet FROM #BackupSetsTbl
EXEC sec_getIdaObjectsForUser @userId, 6, 2, 0, '#UserClientsOrBackupsets'
    DELETE tree
    FROM #ClientViewBackupSetsTbl tree LEFT OUTER JOIN #UserClientsOrBackupsets bkpSets
        ON tree.clientId = bkpSets.clientId AND tree.applicationId = bkpSets.apptypeId AND tree.instanceId = bkpSets.instanceId AND tree.backupsetId = bkpSets.backupsetId
        WHERE bkpSets.backupsetId IS NULL
	INSERT @clientList (id)
	SELECT DISTINCT clientId
	FROM  #ClientViewBackupSetsTbl
	UPDATE L
	SET L.name = AC.name
	FROM @clientList L
		INNER JOIN APP_Client AC
			ON  L.id = AC.id
	DECLARE @xmlquery XML
	SET @xmlquery = (SELECT
						(SELECT
							(SELECT 3 as '@_type_' , id AS '@clientId',
									name AS '@clientName'
									FOR XML PATH('clientEntity'), TYPE)
						FOR XML PATH('client'), TYPE)
						FROM @clientlist AS CL
					FOR XML PATH('clientProperties'), TYPE)
	SET @o_xml = (select @xmlQuery
	FOR XML PATH(''),ROOT('App_GetClientPropertiesResponse'))
	IF OBJECT_ID('tempdb.dbo.#ClientViewBackupSetsTbl') IS NOT NULL
    DROP TABLE #ClientViewBackupSetsTbl
	IF OBJECT_ID('tempdb.dbo.#UserClientsOrBackupsets') IS NOT NULL
	DROP TABLE #UserClientsOrBackupsets
	IF OBJECT_ID('tempdb.dbo.#BackupSetsTbl') IS NOT NULL
	DROP TABLE #BackupSetsTbl
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEligibleClientsForSubclientPolicy')
	delete from GxQscripts where name = 'AppGetEligibleClientsForSubclientPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEligibleClientsForSubclientPolicy')
	delete from GXDBVersions where aliasname = 'AppGetEligibleClientsForSubclientPolicy'
GO

insert into GXDBVersions values(2, 'AppGetEligibleClientsForSubclientPolicy',  '00000000000000000000', 'AppGetEligibleClientsForSubclientPolicy', '00000000000000000000')
GO

