

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEdgeSelectiveSyncContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEdgeSelectiveSyncContent.sp,v $ $Id: AppGetEdgeSelectiveSyncContent.sp,v 1.1.2.5 2019/10/24 02:26:20 nramalingam Exp $";
-- =================================================================================
-- Author:		Gokul Pattabiraman
-- Description:	Get the Edge drive Selective sync configuration for provided inputs.
-- =================================================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetEdgeSelectiveSyncContent')
BEGIN
	print '>>> Drop Stored Procedure: AppGetEdgeSelectiveSyncContent <<<'
	drop procedure AppGetEdgeSelectiveSyncContent
END
IF EXISTS (select * from GxQscripts where name='AppGetEdgeSelectiveSyncContent')
	delete from GxQscripts where name = 'AppGetEdgeSelectiveSyncContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeSelectiveSyncContent')
	delete from GXDBVersions where aliasname = 'AppGetEdgeSelectiveSyncContent'
GO
print '... Creating Procedure: AppGetEdgeSelectiveSyncContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEdgeSelectiveSyncContent
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inUserId INT,
  @inLocaleId INT,
  @inXml XML,
  @outXml XML OUTPUT
AS
-- Inputs
DECLARE @inSubclientId		INT
DECLARE @inLaptopClientId	INT
DECLARE @inMode				INT
-- Variables
DECLARE @errorCode					INT
DECLARE @errorMessage				NVARCHAR(MAX)
DECLARE @edgeSubclientPolicyAppId	INT
DECLARE @edgeClientId				INT
DECLARE @syncConfigOptions			XML
DECLARE @syncConfigFlag				INT
DECLARE @syncPath					NVARCHAR(MAX)
DECLARE @syncFolderId				INT
DECLARE @getPolicyContent			INT = 0
DECLARE @rootPath					NVARCHAR(MAX)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	IF OBJECT_ID('tempdb.dbo.#edgeSelectiveSyncContent') IS NOT NULL DROP TABLE #edgeSelectiveSyncContent
	CREATE TABLE #edgeSelectiveSyncContent(itemPath NVARCHAR(MAX), contentType INT)
	-- Read inputs
	SELECT
		@inUserId = ISNULL(ref.value('(//user/@userId)[1]', 'INT'), @inUserId),
		@inSubclientId = ISNULL(ref.value('(//edgeSubclient/@subclientId)[1]', 'INT'), 0),
		@inLaptopClientId = ISNULL(ref.value('(//laptopClient/@clientId)[1]', 'INT'), 0),
		@inMode = ISNULL(ref.value('(@mode)[1]', 'INT'), 0)
	FROM
	@inXml.nodes('/App_GetEdgeDriveSelectiveSyncContentReq') doc(ref)
	--Bad input. Fail it.
	IF @inLaptopClientId = 0
	BEGIN
		RAISERROR('LaptopClientID is mandatory.', 16, 1)
	END
	-- Validation
	IF @inSubclientId = 0
	BEGIN
		SELECT @inSubclientId = SC.subclientId
		FROM App_SyncCloudFolder SF
		INNER JOIN App_SyncCloudConfig SC ON SC.syncWebfolderId = SF.syncWebFolderId AND SC.clientId = @inLaptopClientId AND SC.syncType = 3
WHERE SF. flag & 0x10 = 0x10 -- SYNC_FOLDER_IS_EDGE_DRIVE
		AND SF.ownerId = @inUserId
	END
	-- Do the actual work
	 -- If no edge subclientid yet, get default filters from policy appid
	IF @inSubclientId = 0 OR @inSubclientId IS NULL
	BEGIN
		SET @getPolicyContent = 1
		DECLARE @edgeClientsWithCapabilities TABLE
		(clientId INT, clientStatus INT, capabilities BIGINT,userAssociationType INT)
		INSERT INTO @edgeClientsWithCapabilities
		EXEC AppGetEdgeCapabilties @inUserId, NULL
		SET @edgeClientId = ISNULL((SELECT TOP 1 EC.clientId
                            FROM @edgeClientsWithCapabilities  EC
                            INNER JOIN App_EdgeDriveAssociation EDA ON EDA.clientId = EC.clientId AND EDA.entityType = 3 AND EDA.entityId > 1
                            WHERE capabilities & 4112 = 4112 -- Client with upload and browse capability
ORDER BY (EC.clientStatus & 0x40000000) DESC, EC.userAssociationType DESC), 0)
		SET @edgeSubclientPolicyAppId  = ISNULL( (SELECT  APP.id
												  FROM   App_EdgeDriveAssociation EDA
INNER JOIN APP_Application APP ON APP.backupset = entityId AND APP.subclientStatus & 0x00008 = 0x00008 -- CV_STATUS_DEFAULT
												  WHERE  entityType = 65 AND EDA.clientId = @edgeClientId), 0)
	END
	ELSE
	BEGIN
		-- This is called during syncdown and filescan. mode 1&2 .
		-- We will get usercentric clients if any for the passed in laptopclientId
		IF OBJECT_ID('tempdb.dbo.#userCentricClients') IS NOT NULL DROP TABLE #userCentricClients
		CREATE TABLE #userCentricClients(id INT PRIMARY KEY)
		INSERT INTO #userCentricClients
		SELECT
			 UC.componentNameId
		FROM APP_ClientProp UC (NOLOCK)
		INNER JOIN APP_ClientProp PC (NOLOCK) ON UC.componentNameId = PC.componentNameId
		INNER JOIN UMOwners OW (NOLOCK) ON OW.entityId = UC.componentNameId
		WHERE UC.attrName = 'User Centric Client' AND UC.attrVal = '1' AND UC.modified = 0
		AND PC.modified = 0 AND PC.attrName = 'Physical Client Id' AND PC.attrVal = CAST(@inLaptopClientId AS NVARCHAR(32))
		SELECT @syncConfigOptions = SC.configOptions, @syncConfigFlag = SC.flag, @syncFolderId = SC.syncWebFolderId, @syncPath = SC.syncPath
		FROM App_SyncCloudConfig SC
		INNER JOIN App_SyncCloudFolder SF ON SC.syncWebFolderId = SF.syncWebFolderId
		WHERE subclientId = @inSubclientId
		AND (EXISTS(SELECT 1 FROM #userCentricClients UC WHERE UC.id = clientId) OR clientId = @inLaptopClientId) -- matches usercentric or physical
AND SF.flag & 0x10 = 0x10
		-- It means sync configuration not found for input. Fail it.
		IF @syncConfigFlag IS NULL
		BEGIN
			RAISERROR('Unable to find sync configuration for provided inputs.', 16, 2)
		END
		-- Only if selective sync is configured
IF @syncConfigFlag & 0x100 = 0x100
		BEGIN
			-- If it is decoupled, it means user has overridden admin defaults. So send the selective sync content from sync tables.
IF @syncConfigFlag & 0x200 = 0x200
			BEGIN
				INSERT INTO #edgeSelectiveSyncContent
				SELECT ref.value('@itemPath', 'NVARCHAR(MAX)'), 2 -- App::SelectiveSyncContentType_Client
				FROM
				@syncConfigOptions.nodes('/syncOptions/destinationOptions/selectiveItemsToSync') doc(ref)
			END
			ELSE
			-- If it is not decoupled, it means user is still using admin created defaults. Return from subclient policy
			BEGIN
				SET @getPolicyContent = 1
				SET @edgeSubclientPolicyAppId = (SELECT CAST(attrVal AS INT)
												 FROM APP_SubClientProp SP
												 WHERE SP.attrName = 'Associated subclient Policy' AND SP.cs_attrName = CHECKSUM(N'Associated subclient Policy')
												 AND SP.modified = 0 AND SP.componentNameId = @inSubclientId)
			END
		END
	END
	-- Return from subclient policy
	IF @getPolicyContent = 1 AND @edgeSubclientPolicyAppId > 0
	BEGIN
		INSERT INTO #edgeSelectiveSyncContent
		SELECT SFF.fileName, 1 -- App::SelectiveSyncContentType_Policy
		FROM APP_ScFilterFile SFF
		WHERE SFF.componentNameId = @edgeSubclientPolicyAppId AND SFF.type = 24 -- CV_EDGE_SELECTIVE_SYNC_FILTERS
		AND SFF.modified = 0
	END
	-- Do path replace based on mode
	IF @inMode > 0
	BEGIN
		IF @inMode = 1 -- SelectiveSyncPathMode_IndexPath
		  AND @syncFolderId > 0
		BEGIN
			SET @rootPath = CAST(@syncFolderId AS NVARCHAR(MAX))
		END
		ELSE IF @inMode = 2 -- SelectiveSyncPathMode_LocalPath
		  AND @syncPath IS NOT NULL
		BEGIN
			SET @rootPath = @syncPath
		END
		-- Remove trailing slashes in the path if any
		SET @rootPath = REVERSE(SUBSTRING(REVERSE(@rootPath), PATINDEX('%[^\/]%', REVERSE(@rootPath)), DATALENGTH(@rootPath)))
		UPDATE #edgeSelectiveSyncContent
		SET itemPath = REPLACE(itemPath, '\%EDGEDRIVE%', @rootPath)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorMessage = ERROR_MESSAGE()
END CATCH
SET @outXML = (SELECT
					(
						SELECT itemPath AS '@itemPath', contentType AS '@contentType'
						FROM #edgeSelectiveSyncContent
						FOR XML PATH('selectiveItemsToSync'), TYPE
					),
					(
						SELECT @errorCode AS '@errorCode', @errorMessage AS '@errorMessage'
						FOR XML PATH('error'), TYPE
					)
			    FOR XML PATH('App_GetEdgeDriveSelectiveSyncContentResp'),TYPE
			   )
SELECT @outXML
IF OBJECT_ID('tempdb.dbo.#edgeSelectiveSyncContent') IS NOT NULL DROP TABLE #edgeSelectiveSyncContent
IF OBJECT_ID('tempdb.dbo.#userCentricClients') IS NOT NULL DROP TABLE #userCentricClients
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEdgeSelectiveSyncContent')
	delete from GxQscripts where name = 'AppGetEdgeSelectiveSyncContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeSelectiveSyncContent')
	delete from GXDBVersions where aliasname = 'AppGetEdgeSelectiveSyncContent'
GO

insert into GXDBVersions values(2, 'AppGetEdgeSelectiveSyncContent',  '00010001000200050000', 'AppGetEdgeSelectiveSyncContent', '00010001000200050000')
GO

