

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEdgeDriveUserInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEdgeDriveUserInfo.sp,v $ $Id: AppGetEdgeDriveUserInfo.sp,v 1.1.2.4 2020/04/02 18:57:13 nramalingam Exp $";
--
--  +================================================================================================+
--  |   Procedure:  AppGetEdgeDriveUserInfo()
--  |
--  | Description:  SP to get minimal edge drive information based on the provided input
--  |
--  |       Input:  GetEdgeDriveUserInfoReq XML containing userid/subclientid/syncwebfolderid
--  |
--  |      Output:  GetEdgeDriveUserInfoResponse containing syncwebfolderid,clientid,rootguid and subclient id
--  |      Return:  errorCode
--  |
--  |   Revisions  Author           Description
--  |   ---------  nramalingam  	Get edge drive information
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetEdgeDriveUserInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetEdgeDriveUserInfo <<<'
	drop procedure AppGetEdgeDriveUserInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetEdgeDriveUserInfo')
	delete from GxQscripts where name = 'AppGetEdgeDriveUserInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeDriveUserInfo')
	delete from GXDBVersions where aliasname = 'AppGetEdgeDriveUserInfo'
GO
print '... Creating Procedure: AppGetEdgeDriveUserInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEdgeDriveUserInfo
  @i_xml XML	
AS
DECLARE @subclientId int = 0
DECLARE @userId int = 0
DECLARE @syncwebfolderId int = 0
BEGIN TRY
	SET @subclientId = (SELECT  ref.value('@subclientId', 'int') FROM    @i_xml.nodes('Api_GetEdgeDriveUserInfoRequest/subclient') R ( ref ))
	SET @userId = (SELECT  ref.value('@userId', 'int') FROM    @i_xml.nodes('Api_GetEdgeDriveUserInfoRequest/user') R ( ref ))
	SET @syncwebfolderId = (SELECT  ref.value('@syncWebFolderId', 'int') FROM    @i_xml.nodes('Api_GetEdgeDriveUserInfoRequest/syncwebfolder') R ( ref ))
    IF ( (@subclientId IS NULL OR @subclientId = 0 ) AND  (@userId IS NULL OR @userId = 0 ) AND  (@syncwebfolderId IS NULL OR @syncwebfolderId = 0 ))
    BEGIN
        RAISERROR ('UserId/SubclientId/SyncwebfolderId should be provided.', 16, 1 )
    END
	DECLARE @resp XML = ISNULL(
								(SELECT
									TMP.rootGUID AS '@rootGUID',
									TMP.systemDriveType AS '@driveType',
									(SELECT TMP.syncWebFolderId AS '@syncWebFolderId' FOR XML PATH('syncwebfolder'), TYPE),
									(SELECT TMP.clientId AS '@clientId',
											TMP.userId AS '@userId',
											TMP.subclientId AS '@subclientId' FOR XML PATH('entity'), TYPE)
								FROM
									(SELECT
										TOP 1 SF.syncWebFolderId AS syncWebFolderId,
										clientId AS clientId,
										subclientId AS subclientId,
										SF.ownerId  AS userId,
										SC.syncPath AS rootGUID,
										ISNULL(TRY_CAST(CP.attrVal AS int),0) as systemDriveType
									FROM App_SyncCloudFolder SF(NOLOCK)
									INNER JOIN App_SyncCloudConfig SC(NOLOCK) ON SF.syncWebFolderId = Sc.syncWebFolderId
									LEFT OUTER JOIN App_Clientprop CP (nolock) ON CP.componentNameId = clientid AND CP.attrname = N'System Drive Type' AND CP.modified = 0
									WHERE SF.flag & 0x10 <> 0 AND SC.syncType = 1 AND
									(@subclientId IS NULL OR @subclientId=0 OR SC.subclientId = @subclientId )
									AND (@syncwebfolderId IS NULL OR @syncwebfolderId=0 OR SC.syncWebFolderId = @syncwebfolderId)
									AND (@userId IS NULL OR @userId=0 OR SF.ownerId = @userId)
									) AS TMP
								FOR XML PATH('Api_GetEdgeDriveUserInfoResponse'), TYPE),
								'<Api_GetEdgeDriveUserInfoResponse/>'
								)
	SELECT @resp
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SELECT
	(
		SELECT
		ERROR_NUMBER() '@errorCode',
		'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE() '@errorMessage'
		FOR XML PATH('error'), TYPE
	)
	FOR XML PATH('Api_GetEdgeDriveUserInfoResponse'), TYPE
END  CATCH

IF EXISTS (select * from GxQscripts where name = 'AppGetEdgeDriveUserInfo')
	delete from GxQscripts where name = 'AppGetEdgeDriveUserInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeDriveUserInfo')
	delete from GXDBVersions where aliasname = 'AppGetEdgeDriveUserInfo'
GO

insert into GXDBVersions values(2, 'AppGetEdgeDriveUserInfo',  '00010001000200040000', 'AppGetEdgeDriveUserInfo', '00010001000200040000')
GO

