

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEdgeDriveRetentionReportInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEdgeDriveRetentionReportInfo.sp,v $ $Id: AppGetEdgeDriveRetentionReportInfo.sp,v 1.1.4.5 2018/03/22 01:46:27 jiechen Exp $";
-- =========================================================
-- Author:		Gokul Pattabiraman
-- Description:	Get the retention information for all edge drive subclients for generating report.
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetEdgeDriveRetentionReportInfo <<<'

IF EXISTS (select * from sysobjects where name='AppGetEdgeDriveRetentionReportInfo')
	drop procedure AppGetEdgeDriveRetentionReportInfo
IF EXISTS (select * from GxQscripts where name='AppGetEdgeDriveRetentionReportInfo')
	delete from GxQscripts where name = 'AppGetEdgeDriveRetentionReportInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeDriveRetentionReportInfo')
	delete from GXDBVersions where aliasname = 'AppGetEdgeDriveRetentionReportInfo'
GO
print '... Creating Procedure: AppGetEdgeDriveRetentionReportInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEdgeDriveRetentionReportInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inEdgeClientId INT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @edgeClientId INT = @inEdgeClientId
IF object_id('tempdb.dbo.#retentionInfo') IS NOT NULL
	DROP TABLE #retentionInfo
IF object_id('tempdb.dbo.#edgeSubclients') IS NOT NULL
	DROP TABLE #edgeSubclients
CREATE TABLE #retentionInfo
(
	subclientId	INT,
	trashCanRetentionInDays INT,
	maxNumberOfVersions INT,
	versionRetentionInDays INT,
	analyticsEngine NVARCHAR(255),
	analyticsEngineClientId INT
)
CREATE CLUSTERED INDEX RetentionInfo_subclientId_IDX on #retentionInfo(subclientId);
CREATE TABLE #edgeSubclients
(
	subclientId	INT,
	subclientName NVARCHAR(128),
	clientName NVARCHAR(255),
	userName NVARCHAR(255),
	associatedPolicySubclientId INT
)
CREATE CLUSTERED INDEX Output_policy_IDX on #edgeSubclients(associatedPolicySubclientId);
INSERT INTO #retentionInfo(subclientId, trashCanRetentionInDays, maxNumberOfVersions, versionRetentionInDays, analyticsEngine, analyticsEngineClientId)
SELECT	componentNameId,
		ISNULL([Trash Can Retention], 0),
		ISNULL([Versions in Drive], 0),
		ISNULL([Grace Period For Versions], 0),
		CL.name,
        CL.id
FROM	(
			SELECT componentNameId, attrName, attrVal
			FROM APP_SubClientProp
			WHERE attrName IN ('Trash Can Retention', 'Versions in Drive', 'Grace Period For Versions', 'Edge Web Server')
			AND modified = 0
		)RET
PIVOT
(
	MAX(attrVal)
	FOR attrName IN
	(
		[Trash Can Retention],
		[Versions in Drive],
		[Grace Period For Versions],
		[Edge Web Server]
	)
)PVT
INNER JOIN APP_Client CL ON PVT.[Edge Web Server] = CL.id
INSERT INTO #edgeSubclients(subclientId, subclientName, clientName, userName, associatedPolicySubclientId)
SELECT DISTINCT SUB.componentNameId, APP.subclientName, CL.name, U.login, SUB.associatedSubclient
FROM APP_Application APP
INNER JOIN (SELECT componentNameId, CAST(attrVal AS INT) AS associatedSubclient
			FROM APP_SubClientProp
			where attrName = 'Associated subclient Policy' --AND cs_attrName = checksum('Associated subclient Policy')
			AND modified = 0) SUB ON APP.id = SUB.componentNameId
INNER JOIN (SELECT componentNameId, CAST(attrVal AS INT) AS edgeUser
			FROM APP_SubClientProp
			where attrName = 'Edge Drive User Id' --AND cs_attrName = checksum('Associated subclient Policy')
			AND modified = 0) SUB2 ON APP.id = SUB2.componentNameId
INNER JOIN #retentionInfo RET ON SUB.associatedSubclient= RET.subclientId
INNER JOIN UMUsers U ON U.id = SUB2.edgeUser
INNER JOIN APP_Client CL ON APP.clientId = CL.id
WHERE APP.subclientstatus & 0x20000 <> 0 -- CV_STATUS_EDGEDRIVE_SUB
AND APP.clientId = @edgeClientId OR @edgeClientId = 0
SELECT S.userName, S.subclientName, S.subclientId, R.trashCanRetentionInDays, R.versionRetentionInDays, R.maxNumberOfVersions, S.clientName, R.analyticsEngine, R.analyticsEngineClientId
FROM #edgeSubclients S
INNER JOIN #retentionInfo R ON S.associatedPolicySubclientId = R.subclientId
IF object_id('tempdb.dbo.#retentionInfo') IS NOT NULL
	DROP TABLE #retentionInfo
IF object_id('tempdb.dbo.#edgeSubclients') IS NOT NULL
	DROP TABLE #edgeSubclients
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEdgeDriveRetentionReportInfo')
	delete from GxQscripts where name = 'AppGetEdgeDriveRetentionReportInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeDriveRetentionReportInfo')
	delete from GXDBVersions where aliasname = 'AppGetEdgeDriveRetentionReportInfo'
GO

insert into GXDBVersions values(2, 'AppGetEdgeDriveRetentionReportInfo',  '00010001000400050000', 'AppGetEdgeDriveRetentionReportInfo', '00010001000400050000')
GO

