

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEdgeDriveRetentionInfoAsTable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEdgeDriveRetentionInfoAsTable.sp,v $ $Id: AppGetEdgeDriveRetentionInfoAsTable.sp,v 1.1.2.2 2017/02/01 12:05:09 gpattabiraman Exp $";
-- =========================================================
-- Author:		Gokul Pattabiraman
-- Description:	Get the retention information for all edge drive subclients.
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetEdgeDriveRetentionInfoAsTable <<<'

IF EXISTS (select * from sysobjects where name='AppGetEdgeDriveRetentionInfoAsTable')
	drop procedure AppGetEdgeDriveRetentionInfoAsTable
IF EXISTS (select * from GxQscripts where name='AppGetEdgeDriveRetentionInfoAsTable')
	delete from GxQscripts where name = 'AppGetEdgeDriveRetentionInfoAsTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeDriveRetentionInfoAsTable')
	delete from GXDBVersions where aliasname = 'AppGetEdgeDriveRetentionInfoAsTable'
GO
print '... Creating Procedure: AppGetEdgeDriveRetentionInfoAsTable'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEdgeDriveRetentionInfoAsTable
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inIndexServerId INT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#retentionInfo') IS NOT NULL
	DROP TABLE #retentionInfo
IF object_id('tempdb.dbo.#edgeSubclients') IS NOT NULL
	DROP TABLE #edgeSubclients
CREATE TABLE #retentionInfo
(
	subclientId	INT,
	trashCanRetentionInDays INT,
	maxNumberOfVersions INT,
	versionRetentionInDays INT,
	webServerURL NVARCHAR(MAX),
	pruneExpiredItems INT,
	expiredItemsRetentionInDays INT
)
CREATE CLUSTERED INDEX RetentionInfo_subclientId_IDX on #retentionInfo(subclientId);
CREATE TABLE #edgeSubclients
(
	subclientId	INT,
	associatedPolicySubclientId INT,
	cloudId	INT
)
CREATE CLUSTERED INDEX Output_policy_IDX on #edgeSubclients(associatedPolicySubclientId);
-- Check if data aging is disabled at CC level. If yes, just return empty response
IF EXISTS(	SELECT 1
			FROM JMJobAction
			WHERE opType = 10 -- Data Aging
			AND clientId = 1 AND mediaAgentID = 1 AND appType = 0 AND appId = 1 AND clientGroupId = 0  -- Commcell level
			AND action = 1 -- Disabled
		 )
BEGIN
	GOTO PROC_END
END
INSERT INTO #retentionInfo(subclientId, trashCanRetentionInDays, maxNumberOfVersions, versionRetentionInDays, webServerURL)
SELECT	componentNameId,
		ISNULL([Trash Can Retention], 0),
		ISNULL([Versions in Drive], 0),
		ISNULL([Grace Period For Versions], 0),
		ISNULL([Edge Web Server URL], 0)
FROM	(
			SELECT componentNameId, attrName, attrVal
			FROM APP_SubClientProp
			WHERE attrName IN ('Trash Can Retention', 'Versions in Drive', 'Grace Period For Versions', 'Edge Web Server URL')
			AND modified = 0
		)RET
PIVOT
(
	MAX(attrVal)
	FOR attrName IN
	(
		[Trash Can Retention],
		[Versions in Drive],
		[Grace Period For Versions],
		[Edge Web Server URL]
	)
)PVT
--Prune expired Items for object store including edge drive
UPDATE RET
SET pruneExpiredItems = 1, expiredItemsRetentionInDays = 0
FROM #retentionInfo RET
INNER JOIN APP_Application APP ON APP.id = RET.subclientId
INNER JOIN App_EdgeDriveAssociation EDA ON EDA.entityType = 65 AND EDA.entityId = APP.backupSet
-- Get all subclients associated to these policies
-- which are part of specifiedi index server
-- and  who have data aging enabled.
INSERT INTO #edgeSubclients(subclientId, associatedPolicySubclientId)
SELECT DISTINCT SUB.componentNameId, SUB.associatedSubclient
FROM APP_Application APP
INNER JOIN (SELECT componentNameId, CAST(attrVal AS INT) AS associatedSubclient
			FROM APP_SubClientProp
			where attrName = 'Associated subclient Policy' --AND cs_attrName = checksum('Associated subclient Policy')
			AND modified = 0) SUB ON APP.id = SUB.componentNameId
INNER JOIN App_EdgeDriveAssociation EDA ON APP.clientId = EDA.clientId AND EDA.entityType = 11 AND EDA.entityId = @inIndexServerId
INNER JOIN #retentionInfo RET ON SUB.associatedSubclient= RET.subclientId
LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON APP.clientId = CGA.clientId
WHERE APP.subclientstatus & 0x20000 <> 0 -- CV_STATUS_EDGEDRIVE_SUB
AND NOT EXISTS(SELECT 1 FROM JMJobAction
			   WHERE opType = 10 -- Data Aging
			   AND clientId = APP.clientId AND mediaAgentID = 1 AND appType = 0 AND appId = 1 AND clientGroupId = 0  -- Client level
			   AND action = 1 -- Disabled
			   )
AND NOT EXISTS(SELECT 1 FROM JMJobAction
			   WHERE opType = 10 -- Data Aging
			   AND clientId = 1 AND mediaAgentID = 1 AND appType = 0 AND appId = 1 AND clientGroupId = CGA.clientGroupId -- Client group level
			   AND action = 1 -- Disabled
			   )
UPDATE #edgeSubclients
SET cloudId = (SELECT DM.CloudId
				FROM DM2SearchServerCoreInfo DM
				INNER JOIN DM2Cloud C ON DM.CloudId = C.cloudId
				INNER JOIN DM2CloudCoreRole R ON DM.CloudId = R.CloudId
				INNER JOIN DM2CloudRoleMaster RM ON RM.roleType = R.roleId AND RM.roleTypeName = 'EDGE Drive'
				WHERE DM.ClientId IN (SELECT entityId
									FROM App_EdgeDriveAssociation AE
									WHERE AE.entityType = 11 AND AE.clientId IN (SELECT ClientId
																					FROM APP_Application
																					WHERE id = subclientId)))
PROC_END:
SELECT S.subclientId, S.cloudId, R.trashCanRetentionInDays, R.maxNumberOfVersions, R.versionRetentionInDays, R.webServerURL, R.pruneExpiredItems, R.expiredItemsRetentionInDays
FROM #edgeSubclients S
INNER JOIN #retentionInfo R ON S.associatedPolicySubclientId = R.subclientId
IF object_id('tempdb.dbo.#retentionInfo') IS NOT NULL
	DROP TABLE #retentionInfo
IF object_id('tempdb.dbo.#edgeSubclients') IS NOT NULL
	DROP TABLE #edgeSubclients
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEdgeDriveRetentionInfoAsTable')
	delete from GxQscripts where name = 'AppGetEdgeDriveRetentionInfoAsTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeDriveRetentionInfoAsTable')
	delete from GXDBVersions where aliasname = 'AppGetEdgeDriveRetentionInfoAsTable'
GO

insert into GXDBVersions values(2, 'AppGetEdgeDriveRetentionInfoAsTable',  '00010001000200020000', 'AppGetEdgeDriveRetentionInfoAsTable', '00010001000200020000')
GO

