

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEdgeDriveRetentionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEdgeDriveRetentionInfo.sp,v $ $Id: AppGetEdgeDriveRetentionInfo.sp,v 1.1.2.7 2018/03/22 01:30:48 jiechen Exp $";
-- =========================================================
-- Author:		Gokul Pattabiraman
-- Description:	Get the retention information for all edge drive subclients.
-- =========================================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetEdgeDriveRetentionInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetEdgeDriveRetentionInfo <<<'
	drop procedure AppGetEdgeDriveRetentionInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetEdgeDriveRetentionInfo')
	delete from GxQscripts where name = 'AppGetEdgeDriveRetentionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeDriveRetentionInfo')
	delete from GXDBVersions where aliasname = 'AppGetEdgeDriveRetentionInfo'
GO
print '... Creating Procedure: AppGetEdgeDriveRetentionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEdgeDriveRetentionInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @o_xmlText XML
DECLARE @inIndexServerId INT
SET @inIndexServerId = ISNULL(( SELECT ref.value('@clientId', 'int')
									FROM   @i_xmlText . nodes('Api_GetEdgeDriveRetentionInfoReq/indexServer') R ( ref )
								), 0)
IF object_id('tempdb.dbo.#retentionInfo') IS NOT NULL
	DROP TABLE #retentionInfo
IF object_id('tempdb.dbo.#edgeSubclients') IS NOT NULL
	DROP TABLE #edgeSubclients
CREATE TABLE #retentionInfo
(
	subclientId	INT,
	trashCanRetentionInDays INT,
	maxNumberOfVersions INT,
	versionRetentionInDays INT,
	webServerURL NVARCHAR(MAX),
	pruneExpiredItems INT,
	expiredItemsRetentionInDays INT
)
CREATE CLUSTERED INDEX RetentionInfo_subclientId_IDX on #retentionInfo(subclientId);
CREATE TABLE #edgeSubclients
(
	subclientId	INT,
	associatedPolicySubclientId INT,
	cloudId	INT
)
CREATE CLUSTERED INDEX Output_policy_IDX on #edgeSubclients(associatedPolicySubclientId);
-- Check if data aging is disabled at CC level. If yes, just return empty response
IF EXISTS(	SELECT 1
			FROM JMJobAction
			WHERE opType = 10 -- Data Aging
			AND clientId = 1 AND mediaAgentID = 1 AND appType = 0 AND appId = 1 AND clientGroupId = 0  -- Commcell level
			AND action = 1 -- Disabled
		 )
BEGIN
	GOTO PROC_END
END
INSERT INTO #retentionInfo(subclientId, trashCanRetentionInDays, maxNumberOfVersions, versionRetentionInDays, webServerURL)
SELECT	componentNameId,
		ISNULL([Trash Can Retention], 0),
		ISNULL([Versions in Drive], 0),
		ISNULL([Grace Period For Versions], 0),
		ISNULL([Edge Web Server URL], 0)
FROM	(
			SELECT componentNameId, attrName, attrVal
			FROM APP_SubClientProp
			WHERE attrName IN ('Trash Can Retention', 'Versions in Drive', 'Grace Period For Versions', 'Edge Web Server URL')
			AND modified = 0
		)RET
PIVOT
(
	MAX(attrVal)
	FOR attrName IN
	(
		[Trash Can Retention],
		[Versions in Drive],
		[Grace Period For Versions],
		[Edge Web Server URL]
	)
)PVT
--Prune expired Items for object store including edge drive
UPDATE RET
SET pruneExpiredItems = 1, expiredItemsRetentionInDays = 0
FROM #retentionInfo RET
INNER JOIN APP_Application APP ON APP.id = RET.subclientId
INNER JOIN App_EdgeDriveAssociation EDA ON EDA.entityType = 65 AND EDA.entityId = APP.backupSet
-- Get all subclients associated to these policies
-- which are part of specifiedi index server
-- and  who have data aging enabled.
INSERT INTO #edgeSubclients(subclientId, associatedPolicySubclientId)
SELECT DISTINCT SUB.componentNameId, SUB.associatedSubclient
FROM APP_Application APP
INNER JOIN (SELECT componentNameId, CAST(attrVal AS INT) AS associatedSubclient
			FROM APP_SubClientProp
			where attrName = 'Associated subclient Policy' --AND cs_attrName = checksum('Associated subclient Policy')
			AND modified = 0) SUB ON APP.id = SUB.componentNameId
INNER JOIN AppEdgeDriveWebserverAssociation EWA ON APP.clientId = EWA.edgeClientId AND EWA.webserverId = @inIndexServerId --@inIndexServerId is webserver associated to edge client
INNER JOIN #retentionInfo RET ON SUB.associatedSubclient= RET.subclientId
LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON APP.clientId = CGA.clientId
WHERE APP.subclientstatus & 0x20000 <> 0 -- CV_STATUS_EDGEDRIVE_SUB
AND NOT EXISTS(SELECT 1 FROM JMJobAction
			   WHERE opType = 10 -- Data Aging
			   AND clientId = APP.clientId AND mediaAgentID = 1 AND appType = 0 AND appId = 1 AND clientGroupId = 0  -- Client level
			   AND action = 1 -- Disabled
			   )
AND NOT EXISTS(SELECT 1 FROM JMJobAction
			   WHERE opType = 10 -- Data Aging
			   AND clientId = 1 AND mediaAgentID = 1 AND appType = 0 AND appId = 1 AND clientGroupId = CGA.clientGroupId -- Client group level
			   AND action = 1 -- Disabled
			   )
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
CREATE TABLE #getIndexServers
                    (     serverURL NVARCHAR(512),
                            clientId INT,
                            clientName NVARCHAR(256),
                            cloudId INT,
                            hostName NVARCHAR(256),
                            basePort INT,
                            engineName  NVARCHAR(256),
                            serverType INT,
                            indexServerClientId INT,
                            internalCloudName NVARCHAR(256)
                    )
EXEC DM2GetIndexServers 'EDGE Drive'
UPDATE #edgeSubclients
SET cloudId = (SELECT top 1 C.CloudId
				FROM #getIndexServers AS C
				WHERE C.indexServerClientId IN
					(SELECT entityId FROM App_EdgeDriveAssociation AE
						WHERE AE.entityType = 3 AND AE.clientId IN
							(SELECT ClientId  FROM APP_Application
								WHERE id = subclientId
							)
						)
				)
SET @o_xmlText =	(
						SELECT
							(
							SELECT	trashCanRetentionInDays AS '@trashCanRetentionInDays',
									maxNumberOfVersions AS '@maxNumberOfVersions',
									versionRetentionInDays AS '@versionRetentionInDays',
									webServerURL AS '@webServerURL',
									pruneExpiredItems AS '@pruneExpiredItems',
									expiredItemsRetentionInDays AS '@expiredItemsRetentionInDays',
									(
									SELECT ES.cloudId AS '@cloudId',
									(
										SELECT	ES.subclientId AS '@subclientId',
												APP.subclientName AS '@subclientName'
										FOR XML PATH ('subclient'), TYPE
									)
									FROM #edgeSubclients ES
									INNER JOIN App_Application APP WITH(NOLOCK) ON APP.id = ES.subclientId
									WHERE ES.associatedPolicySubclientId = RET.subclientId
									FOR XML PATH('subclients'), TYPE
									)
							FROM #retentionInfo RET
							FOR XML PATH('retentionInfoList'), TYPE
							)
						FOR XML PATH('Api_GetEdgeDriveRetentionInfoResp'), TYPE
					)
PROC_END:
IF object_id('tempdb.dbo.#retentionInfo') IS NOT NULL
	DROP TABLE #retentionInfo
IF object_id('tempdb.dbo.#edgeSubclients') IS NOT NULL
	DROP TABLE #edgeSubclients
IF @o_xmlText IS NULL
	SET @o_xmlText = '<Api_GetEdgeDriveRetentionInfoResp/>'
SELECT @o_xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEdgeDriveRetentionInfo')
	delete from GxQscripts where name = 'AppGetEdgeDriveRetentionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeDriveRetentionInfo')
	delete from GXDBVersions where aliasname = 'AppGetEdgeDriveRetentionInfo'
GO

insert into GXDBVersions values(2, 'AppGetEdgeDriveRetentionInfo',  '00010001000200070000', 'AppGetEdgeDriveRetentionInfo', '00010001000200070000')
GO

