

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEdgeDriveClientAssoc.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEdgeDriveClientAssoc.sp,v $ $Id: AppGetEdgeDriveClientAssoc.sp,v 1.11.2.7 2018/12/21 18:42:19 skilaru Exp $";
--
--  +==============================================================================================================+
--  |   Procedure:  AppGetEdgeDriveClientAssoc()
--  |
--  | Description:  SP for gettting edge drive association for given Edge drive client
--  |
--  |       Input:  XML containing client Entity Info
--  |      Output:  XML containing edge drive associtions for the client
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  riyer   For fetching all Edge Drive info(UserGroup/SubclientPolicy) for an Edge Drive Client
--  +==============================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetEdgeDriveClientAssoc')
BEGIN
	print '>>> Drop Stored Procedure: AppGetEdgeDriveClientAssoc <<<'
	drop procedure AppGetEdgeDriveClientAssoc
END
IF EXISTS (select * from GxQscripts where name='AppGetEdgeDriveClientAssoc')
	delete from GxQscripts where name = 'AppGetEdgeDriveClientAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeDriveClientAssoc')
	delete from GXDBVersions where aliasname = 'AppGetEdgeDriveClientAssoc'
GO
print '... Creating Procedure: AppGetEdgeDriveClientAssoc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEdgeDriveClientAssoc
  @i_xml XML	
AS
DECLARE @clientId integer
DECLARE @r_allEDAssoc XML
DECLARE @out_xml XML
SET @clientId = ISNULL((SELECT  ref.value('@clientId', 'integer')
						FROM    @i_xml.nodes('entity') R ( ref )),0)
DECLARE @userTbl TABLE
(
	userId INT,
	userName nvarchar(MAX),
	capabilities BIGINT
)
DECLARE @internalGroupTbl TABLE
(
	groupId INT,
	groupName nvarchar(MAX),
	capabilities BIGINT
)
DECLARE @externalGroupTbl TABLE
(
	groupId		INT,
	groupName 	nvarchar(MAX),
	umdsProviderId	INT,
	capabilities BIGINT
)
BEGIN TRY
--Time to fetch the all assoc from APP_EdgeDriveAssociation table
--1. Fetch all users associated with the client
INSERT INTO @userTbl
SELECT U.id, U.login, CAST(UPROP.attrVal AS BIGINT)
FROM UMUsers U
INNER JOIN App_EdgeDriveAssociation AED ON U.id = AED.entityId AND AED.entityType = 13 AND AED.clientId =   @clientId
INNER JOIN UMUsersProp UPROP ON UPROP.componentNameId = U.id AND UPROP.attrType = 130 AND UPROP.attrName = CAST(@clientId AS NVARCHAR(MAX))
--2. Fetch all internal groups associated with thie client
INSERT INTO @internalGroupTbl
SELECT UMG.id, UMG.name, CAST(UPROP.attrVal AS BIGINT)
FROM UMGroups UMG
INNER JOIN App_EdgeDriveAssociation AED ON UMG.id = AED.entityId AND AED.entityType = 15 AND AED.clientId = @clientId
INNER JOIN UMGroupsProp UPROP ON UPROP.componentNameId = UMG.id AND UPROP.attrType = 130 AND UPROP.attrName = CAST(@clientId AS NVARCHAR(MAX))
--3. Fetch all External user groups associated with this client.
INSERT INTO @externalGroupTbl
SELECT UMDSG.id , UMDSG.name , UMDSG.umdsProviderId, CAST(UPROP.attrVal AS BIGINT)
FROM UMGroups UMDSG
INNER JOIN App_EdgeDriveAssociation AED ON UMDSG.id = AED.entityId AND AED.entityType = 62 AND AED.clientId = @clientId
INNER JOIN UMGroupsProp UPROP ON UPROP.componentNameId = UMDSG.id AND UPROP.attrType = 130 AND UPROP.attrName = CAST(@clientId AS NVARCHAR(MAX))
SET @r_allEDAssoc = (SELECT
								(select CloudType
								FROM DM2Cloud INNER JOIN App_EdgeDriveAssociation WITH (NOLOCK) ON  DM2Cloud.pseudoClientId = App_EdgeDriveAssociation.entityId
								WHERE App_EdgeDriveAssociation.entityType = 3 AND App_EdgeDriveAssociation.clientId = @clientId) as  '@cloudServerType',
								--1.Client Entity
								(select @clientId AS '@clientId',
										'3' as '@_type_'
								for xml path('clientEntity'), type),
								--2.Storage policy XML
								(SELECT TOP 1 	AG.id AS '@storagePolicyId',
												AG.name AS '@storagePolicyName'
								FROM archGroup AG INNER JOIN APP_Application AAP ON AG.id = AAP.dataArchGrpID
								INNER JOIN App_EdgeDriveAssociation AED ON AAP.backupSet = AED.entityId
								WHERE AED.entityType = 65 AND AED.clientId = @clientId
								FOR XML PATH('storagePolicy') ,type),
								--3. Users
								(SELECT capabilities AS '@capabilities',
										(SELECT userId AS '@userId',
												userName AS '@userName'
										FOR XML PATH('user'), type)
								FROM @userTbl
								FOR XML PATH('userCapabilities') ,type),
								--4. Internal Groups
								(SELECT capabilities AS '@capabilities',
										(SELECT groupId AS '@userGroupId',
												groupName AS '@userGroupName'
										FOR XML PATH('group'), type)
								FROM @internalGroupTbl
								FOR XML PATH('userGroupCapabilities') ,type),
								--5. External Groups
								( SELECT capabilities AS '@capabilities',
										(SELECT groupId AS '@id',
												groupName AS '@name',
												umdsProviderId AS '@umdsProviderId',
												domainName AS '@umdsProviderName'
										FOR XML PATH('externalGroup'), type)
									FROM @externalGroupTbl ET  INNER JOIN UMDSProviders UM ON ET.umdsProviderId = UM.id
									FOR XML PATH('externalGroupCapabilities') , type),
								--6. Get Associated Index Server
								(SELECT entityId AS '@clientId',
										App_Client.name AS '@clientName',
										entityType as '@_type_'
								FROM App_EdgeDriveAssociation INNER JOIN APP_Client WITH (NOLOCK) ON App_Client.id = App_EdgeDriveAssociation.entityId
								WHERE entityType = 3 AND clientId = @clientId
								for xml path('indexServer') , type)
					FOR XML PATH('edgeDriveAssociations') ,type)
GOTO GENERATE_OUTPUT
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    print 'Error during SP Execution. Error Message' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
SET @out_xml = ( select ISNULL(@r_allEDAssoc , '')  for xml path(''))
SELECT @out_xml
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEdgeDriveClientAssoc')
	delete from GxQscripts where name = 'AppGetEdgeDriveClientAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeDriveClientAssoc')
	delete from GXDBVersions where aliasname = 'AppGetEdgeDriveClientAssoc'
GO

insert into GXDBVersions values(2, 'AppGetEdgeDriveClientAssoc',  '00010011000200070000', 'AppGetEdgeDriveClientAssoc', '00010011000200070000')
GO

