

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEdgeCapabilties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEdgeCapabilties.sp,v $ $Id: AppGetEdgeCapabilties.sp,v 1.9.34.10 2019/12/18 22:54:48 nramalingam Exp $";
--
--  +====================================================================================================================================+
--  |   Procedure:  AppGetEdgeCapabilties()
--  |
--  +====================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetEdgeCapabilties')
BEGIN
	print '>>> Drop Stored Procedure: AppGetEdgeCapabilties <<<'
	drop procedure AppGetEdgeCapabilties
END
IF EXISTS (select * from GxQscripts where name='AppGetEdgeCapabilties')
	delete from GxQscripts where name = 'AppGetEdgeCapabilties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeCapabilties')
	delete from GXDBVersions where aliasname = 'AppGetEdgeCapabilties'
GO
print '... Creating Procedure: AppGetEdgeCapabilties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEdgeCapabilties
  @userId integer,
  @tempTbl nvarchar(128)
AS
  DECLARE @o_clientId integer;
  DECLARE @o_clientStatus integer;
  DECLARE @o_capabilities bigint;
DECLARE @capUpload   bigint= (POWER(2.0, 5 -1));
DECLARE @capBrowse      bigint= (POWER(2.0, 13 -1));
DECLARE @capDownload    bigint= (POWER(2.0, 6 -1));
DECLARE @capInPlace     bigint= (POWER(2.0, 20 -1));
DECLARE @capOutofPlace  bigint= (POWER(2.0, 22 -1));
  DECLARE @capDownloadBrowse bigint=  (@capDownload | @capBrowse );
BEGIN
	-- Performance: going under the assummption that there will be lots of clients
	IF object_id('tempdb.dbo.#edgeClients') IS NOT NULL
		DROP TABLE #edgeClients
	CREATE TABLE #edgeClients
	--DECLARE @edgeClients TABLE
	(
		clientId INT PRIMARY KEY,
		clientStatus INT,
		chClientId NVARCHAR(21),
		userAssociationType INT
	)
	-- Performance: Re-wrote query from SELECT WHERE OR IN Clauses to UNION SELECTs
	INSERT INTO #edgeClients
	SELECT
		assoc.clientId,
		assoc.clientStatus,
		CAST(assoc.clientId AS NVARCHAR(21)),
		dbo.BitwiseOR(assoc.userAssociationType)
	FROM
	(
		-- direct user entity association
		SELECT
			AE.clientId AS clientId,
			C.status AS clientStatus,
0x2 AS userAssociationType	 -- defined in ClientSyncConfig.h
		FROM
			App_EdgeDriveAssociation AE
		INNER JOIN APP_Client C ON AE.clientId = C.id
		INNER JOIN APP_Application SC ON
			AE.clientId = SC.clientId
			AND AE.entityType = 13
			AND AE.entityId = @userId
		UNION --ALL
					-- user part of internal group
		SELECT
			AE.clientId AS clientId,
			C.status AS clientStatus,
0x1 AS userAssociationType	-- defined in ClientSyncConfig.h
		FROM
			App_EdgeDriveAssociation AE
		INNER JOIN APP_Client C ON AE.clientId = C.id
		INNER JOIN APP_Application SC ON
			AE.clientId = SC.clientId
			AND AE.entityType IN(15, 62)
		INNER JOIN UMUserGroup ug ON
			AE.entityId = ug.groupId
			AND ug.userId = @userId
	)assoc
	GROUP BY assoc.clientId, assoc.clientStatus
	--assign capabilites to the Edge Drive User for this newly create subclient.
	DECLARE @sqlSelect NVARCHAR(MAX) = 'DECLARE @userId INT = ' + CAST(@userId AS NVARCHAR(20)) + ' '
	IF (@tempTbl IS NOT NULL AND @tempTbl <> '')
	BEGIN
		SET @sqlSelect += 'INSERT INTO ' + @tempTbl + ' '
	END
	SET @sqlSelect += '
		SELECT
			c.clientId,
			c.clientStatus,
			CASE
				-- If download and browse capability is assigned, assign inplace and out of place
				WHEN (c.total_caps & '+CAST(@capDownloadBrowse AS NVARCHAR(20))+' = '+CAST(@capDownloadBrowse AS NVARCHAR(20))+') THEN (c.total_caps | '+CAST(@capDownloadBrowse AS NVARCHAR(20))+' | '+CAST(@capInPlace AS NVARCHAR(20))+' | '+CAST(@capOutofPlace AS NVARCHAR(20))+')
				-- If browse capability is assigned
				WHEN (c.total_caps & '+CAST(@capBrowse AS NVARCHAR(20))+' = '+CAST(@capBrowse AS NVARCHAR(20))+') THEN (c.total_caps | '+CAST(@capBrowse AS NVARCHAR(20))+')
				-- If download capability is assigned, assign inplace and out of place
				WHEN (c.total_caps & '+CAST(@capDownload AS NVARCHAR(20))+' = '+CAST(@capDownload AS NVARCHAR(20))+') THEN (c.total_caps | '+CAST(@capDownload AS NVARCHAR(20))+' | '+CAST(@capInPlace AS NVARCHAR(20))+' | '+CAST(@capOutofPlace AS NVARCHAR(20))+')
				-- no additional capability required
				ELSE c.total_caps
			END ,
			c.userAssociationType
		FROM
			(SELECT
				TEMP.clientId,
				TEMP.clientStatus,
				dbo.BitwiseOR(TEMP.caps) total_caps,
				dbo.BitwiseOR(TEMP.userAssociationType) userAssociationType
			FROM
			(
					-- Performance: no gain for now, removal of the CAST Ops may help during heavy data lifting
					--		Need better indices on UMGroupProp and UMUserProp - look at for v11?
					SELECT
						EC.clientId AS clientId,
						EC.clientStatus AS clientStatus,
						-- if the client is not licensed remove upload capability
(CASE  WHEN (EC.clientStatus & 0x00002 = 0x00002) Then (CAST(attrVal AS BIGINT) & ~'+CAST(@capUpload AS NVARCHAR(20))+') ELSE CAST(attrVal AS BIGINT) END) AS ''caps'',
						EC.userAssociationType
					FROM
						UMUsersProp UPROP
						INNER JOIN  #edgeClients EC ON
							UPROP.componentNameId = @userId
							AND UPROP.attrType = 130
					WHERE
							UPROP.attrName = EC.chClientId
					UNION
					SELECT
						EC.clientId AS clientId,
						EC.clientStatus AS clientStatus,
						-- if the client is not licensed remove upload capability
(CASE  WHEN (EC.clientStatus & 0x00002 = 0x00002) Then (CAST(attrVal AS BIGINT) & ~'+CAST(@capUpload AS NVARCHAR(20))+') ELSE CAST(attrVal AS BIGINT) END) AS ''caps''						,
						EC.userAssociationType
					FROM
						UMGroupsProp UPROP
						INNER JOIN #edgeClients EC ON
							UPROP.attrName = EC.chClientId
							AND UPROP.attrType = 130
					WHERE UPROP.componentNameId IN (SELECT groupId FROM UMUserGroup UG WHERE UG.userId = @userId)
				)TEMP
			GROUP BY TEMP.clientId, TEMP.clientStatus) c'
	BEGIN TRY
		DECLARE @rc INT = 0
		EXEC @rc = sp_executesql @stmt = @sqlSelect
	END  TRY
	BEGIN CATCH
		-- Call procedure to print error information.
		--EXECUTE dbo.PrintError;
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	END CATCH
	IF object_id('tempdb.dbo.#edgeClients') IS NOT NULL
		DROP TABLE #edgeClients
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEdgeCapabilties')
	delete from GxQscripts where name = 'AppGetEdgeCapabilties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeCapabilties')
	delete from GXDBVersions where aliasname = 'AppGetEdgeCapabilties'
GO

insert into GXDBVersions values(2, 'AppGetEdgeCapabilties',  '00010009003400100000', 'AppGetEdgeCapabilties', '00010009003400100000')
GO

