

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEdgeAuditPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEdgeAuditPolicy.sp,v $ $Id: AppGetEdgeAuditPolicy.sp,v 1.1.2.1 2018/04/05 15:38:20 nramalingam Exp $";
--
--  +================================================================================================+
--  |   Procedure:  AppGetEdgeAuditPolicy()
--  |
--  | Description:  SP to get Monitoring policy associated to edge client
--  |
--  |       Input:  GetEdgeAuditPolicyRequest XML containing edgeClient id
--  |
--  |      Output:  GetEdgeAuditPolicyResponse containing LM entity information,status of policy,Is base policy, errorCode, errorString to determine status of the operation
--  |      Return:  errorCode
--  |
--  |   Revisions  Author           Description
--  |   ---------  nramalingam  	Get Monitoring policy associated to edge client
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetEdgeAuditPolicy <<<'

IF EXISTS (select * from sysobjects where name='AppGetEdgeAuditPolicy')
	drop procedure AppGetEdgeAuditPolicy
IF EXISTS (select * from GxQscripts where name='AppGetEdgeAuditPolicy')
	delete from GxQscripts where name = 'AppGetEdgeAuditPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeAuditPolicy')
	delete from GXDBVersions where aliasname = 'AppGetEdgeAuditPolicy'
GO
print '... Creating Procedure: AppGetEdgeAuditPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEdgeAuditPolicy
  @i_xml XML	
AS
DECLARE @edgeClientId int = 0
BEGIN TRY
	SET @edgeClientId = (SELECT  ref.value('@clientId', 'int') FROM    @i_xml.nodes('Api_GetEdgeAuditPolicyRequest/edgeClient') R ( ref ))
	IF (@edgeClientId IS NULL OR @edgeClientId = 0 )
    BEGIN
		RAISERROR ('Edge Drive Client Id is mandatory.', 16, 1 )
	END
	SELECT
	(
		SELECT
			(CASE MP.Status WHEN 0 THEN 1 ELSE 0 END) AS '@isEnabled',
			(CASE MPP.attrVal WHEN '1' THEN 1 ELSE 0 END) AS '@isBasepolicy',
			(SELECT MP.monitorPolicyId as '@policyId', MP.monitorPolicyName as 'policyName' FOR XML PATH('policy'), TYPE)
		FROM App_EdgeDriveAssociation EDA  WITH (NOLOCK) INNER JOIN APP_MonitoringPolicy MP WITH (NOLOCK)  ON  MP.monitorPolicyId = EDA.entityId
		LEFT OUTER JOIN APP_MonitoringPolicyProp MPP WITH (NOLOCK)  ON  MPP.monitorPolicyId =  MP.monitorPolicyId AND MPP.attrName = 'IsBasePolicy'
		WHERE EDA.clientId = @edgeClientId AND EDA.entityType=90 /**LM_MONITORING_POLICY_ENTITY**/
		FOR XML PATH('policyList'), TYPE
	)
	FOR XML PATH('Api_GetEdgeAuditPolicyResponse'), TYPE
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SELECT
	(
		SELECT
		ERROR_NUMBER() '@errorCode',
		'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE() '@errorMessage'
		FOR XML PATH('error'), TYPE
	)
	FOR XML PATH('Api_GetEdgeAuditPolicyResponse'), TYPE
END  CATCH

IF EXISTS (select * from GxQscripts where name = 'AppGetEdgeAuditPolicy')
	delete from GxQscripts where name = 'AppGetEdgeAuditPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeAuditPolicy')
	delete from GXDBVersions where aliasname = 'AppGetEdgeAuditPolicy'
GO

insert into GXDBVersions values(2, 'AppGetEdgeAuditPolicy',  '00010001000200010000', 'AppGetEdgeAuditPolicy', '00010001000200010000')
GO

