

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEdgeAuditNotificationFlags.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEdgeAuditNotificationFlags.sp,v $ $Id: AppGetEdgeAuditNotificationFlags.sp,v 1.1.2.8 2018/07/05 16:33:40 nshah Exp $";
--
--  +================================================================================================+
--  |   Procedure:  AppGetEdgeAuditNotificationFlags()
--  |
--  | Description:  SP for configuring audit for edge drive client
--  |
--  |       Input:  GetEdgeAuditNotificationFlagsRequest XML containing subclient id--  |
--  |      Output:  GetEdgeAuditNotificationFlagsResponse containing flags, errorCode, errorString to determine status of the operation--  |
--  |
--  |   Revisions  Author           Description
--  |   ---------  nramalingam  	To check if audit and notification is enabled for edge client
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetEdgeAuditNotificationFlags <<<'

IF EXISTS (select * from sysobjects where name='AppGetEdgeAuditNotificationFlags')
	drop procedure AppGetEdgeAuditNotificationFlags
IF EXISTS (select * from GxQscripts where name='AppGetEdgeAuditNotificationFlags')
	delete from GxQscripts where name = 'AppGetEdgeAuditNotificationFlags'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeAuditNotificationFlags')
	delete from GXDBVersions where aliasname = 'AppGetEdgeAuditNotificationFlags'
GO
print '... Creating Procedure: AppGetEdgeAuditNotificationFlags'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEdgeAuditNotificationFlags
  @i_xml XML	
AS
DECLARE @edgeClientId INT
DECLARE @webserverId INT = 0
DECLARE @systemDriveType INT
DECLARE @isFeatureEnabled INT
DECLARE @monitoringPolicyName  nvarchar(50) = 'EdgeAudit'
DECLARE @monitoringPolicyId  int = 0
DECLARE @monitoringPolicyStatus int
DECLARE @error XML
DECLARE @flags INT =0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
SET  @edgeClientId   = (SELECT ref.value('@clientId','int') FROM @i_xml.nodes('Api_GetEdgeAuditNotificationFlagsRequest/edgeClient') R ( ref ))
IF (@edgeClientID IS NULL OR @edgeClientId = 0 )
BEGIN
    RAISERROR ('edge client id is mandatory.', 16, 1 )
END
--Feature is enabled by default. To disable the feature set the key to 0
SET @isFeatureEnabled = ISNULL((SELECT TOP 1 value FROM GXGlobalParam where name = 'EnableEdgeAuditNotification'),1)
IF @isFeatureEnabled = 1
BEGIN
	--Is valid edge drive client
	IF EXISTS( SELECT 1 from App_Client CL WITH (NOLOCK) WHERE ID = @edgeClientId AND (CL.status & 0x10000000) = 0x10000000 ) -- CV_STATUS_EDGE_DRIVE
	BEGIN
		--get the systemDriveType of the edge client
		SET @systemDriveType = ISNULL((SELECT attrval FROM App_Clientprop WITH (NOLOCK) WHERE componentNameId = @edgeClientId AND attrname = 'System Drive Type' AND modified = 0),0)
		--Audit Notification feature is applicable for only default edge drive and object store
		IF(@systemDriveType =0 OR @systemDriveType = 1 ) --EdgeSystemDriveTypes
		BEGIN
			-- gets the index servers webserver associated associated with the edge client.
			SET @webserverId = ISNULL((SELECT TOP 1 webserverId FROM AppEdgeDriveWebserverAssociation where edgeClientId = @edgeClientId),0)
			IF(@webserverId>0)
			BEGIN
				SELECT @monitoringPolicyId = monitorPolicyId, @monitoringPolicyStatus = status  from App_MonitoringPolicy WITH (NOLOCK) WHERE monitorPolicyName = @monitoringPolicyName
				SET @flags =	ISNULL((SELECT dbo.BitwiseOR(tmp.val)
										FROM
										(
											-- check if audit and notification is enabled for the edge client
											SELECT dbo.BitwiseOR(CASE
WHEN  attrName = 'Edge Drive Enable Audit' and attrVal='1'  THEN 0x1
WHEN  attrName = 'Edge Drive Enable Push Notification' and attrVal='1' THEN 0x2
																	ELSE 0
																END) as val
FROM App_Clientprop WITH (NOLOCK) where componentNameId = @edgeClientId and attrName in ('Edge Drive Enable Audit','Edge Drive Enable Push Notification')
											UNION
											-- check if mongo db and mq packages are installed on the index server
											SELECT dbo.BitwiseOR(CASE SI.simpackageid
WHEN 952	THEN 0x4
WHEN 954		THEN 0x8
																	ELSE 0
																END) as val
											FROM SimInstalledPackages SI WITH (NOLOCK)
WHERE SI.ClientId =@webserverId AND SI.simpackageid in (952,954)
											UNION
											--check if the edge policy is configured
SELECT  0x10
											FROM  APP_MonitoringPolicyProp WITH (NOLOCK)
											WHERE monitorPolicyId = @monitoringPolicyId and attrname ='Cloud ID' and (attrval is not null AND attrval  <> '' AND attrval <>'0' AND @monitoringPolicyStatus = 0)
										)tmp
										),0)
			END
		END
	END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @error = ( SELECT
                            ERROR_NUMBER() '@errorCode',
                            'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE() '@errorMessage'
                           FOR XML PATH('error'), TYPE
                         )
END  CATCH
SELECT (
		SELECT
			@flags AS '@flags',
			@error FOR XML PATH('Api_GetEdgeAuditNotificationFlagsResponse'),TYPE
		)
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEdgeAuditNotificationFlags')
	delete from GxQscripts where name = 'AppGetEdgeAuditNotificationFlags'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEdgeAuditNotificationFlags')
	delete from GXDBVersions where aliasname = 'AppGetEdgeAuditNotificationFlags'
GO

insert into GXDBVersions values(2, 'AppGetEdgeAuditNotificationFlags',  '00010001000200080000', 'AppGetEdgeAuditNotificationFlags', '00010001000200080000')
GO

