

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetEDiscoveryClientProperties.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetEDiscoveryClientProperties.sp,v $ $Id: AppGetEDiscoveryClientProperties.sp,v 1.1.2.15 2019/04/16 13:47:09 abilbrey Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetEDiscoveryClientProperties"
--	|	This Procedure is used to get all properties of a client.
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetEDiscoveryClientProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppGetEDiscoveryClientProperties <<<'
	drop procedure AppGetEDiscoveryClientProperties
END
IF EXISTS (select * from GxQscripts where name='AppGetEDiscoveryClientProperties')
	delete from GxQscripts where name = 'AppGetEDiscoveryClientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEDiscoveryClientProperties')
	delete from GXDBVersions where aliasname = 'AppGetEDiscoveryClientProperties'
GO
print '... Creating Procedure: AppGetEDiscoveryClientProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetEDiscoveryClientProperties
  @xmlText XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @AllClient INT
DECLARE @clientId int
DECLARE @userId INT
DECLARE @localeId INT
DECLARE @basicProperties INT = 1
DECLARE @allProperties INT = 10
DECLARE @o_xmlText xml
DECLARE @associationEntity XML
DECLARE @securityCheckError NVARCHAR(MAX)
DECLARE @level int = 1
DECLARE @subType int = 0
IF object_id('tempdb.dbo.#EDiscoveryClientListTbl') IS NOT null DROP TABLE #EDiscoveryClientListTbl
CREATE TABLE #EDiscoveryClientListTbl (
    [cid]              INT PRIMARY KEY,
    [cname]            NVARCHAR(255),
    [cdisplayName]     NVARCHAR(255),
	[installdate] int default null
	)
	IF object_id('tempdb.dbo.#EDiscoveryClientPropTbl') IS NOT null DROP TABLE #EDiscoveryClientPropTbl
CREATE TABLE #EDiscoveryClientPropTbl (
    [cid]              INT PRIMARY KEY,
	[planId]   int default null,
	[subtype] INT default 0,
	[EDiscoverySubtype]       INT default 0,
	[ContentAnalyzerCloudId] INT default 0,
	[AnalyticsIndexServerId] INT default 0,
	[InventoryDatasourceId] INT default 0,
	[ProviderId] INT default 0,
	[FederatedDatasourceId] INT default 0,
	[serverPlanId]	INT default null,
	[filterCriteria] NVARCHAR(1024), /* case manager changes*/
	[custodians]	NVARCHAR(1024) /* case manager changes*/
	)
	IF object_id('tempdb.dbo.#EDiscoveryDataSourceTbl') IS NOT null DROP TABLE #EDiscoveryDataSourceTbl
CREATE TABLE #EDiscoveryDataSourceTbl (
    [cid]              INT ,
	[DataSourceId]   int default 0
	)
CREATE CLUSTERED INDEX EDiscoveryDataSourceTbl_cid_DataSourceId ON #EDiscoveryDataSourceTbl (cid, DataSourceId);
IF object_id('tempdb.dbo.#FinalXMLList') IS NOT null DROP TABLE #FinalXMLList
CREATE TABLE #FinalXMLList
    (
        c_id             INT,
        entitySecurityAssociation XML
    )
IF object_id('tempdb.dbo.#UserTable') IS NOT null DROP TABLE #UserTable
CREATE TABLE #UserTable
	(
		c_id             INT,
		userId INT,
		userName nvarchar(255),
		capabilities BIGINT
	)
CREATE CLUSTERED INDEX UserTable_c_id_UserId_Idx on #UserTable(c_id, userId);
SET @AllClient = (SELECT  ref.value('@allEntities', 'int') AS client
                    FROM    @xmlText.nodes('App_GetEDiscoveryClientPropertiesRequest/filterOptions') R ( ref ))
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS client
                              FROM    @xmlText.nodes('App_GetEDiscoveryClientPropertiesRequest/processinginstructioninfo/user') R ( ref )),0)
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS client
                              FROM    @xmlText.nodes('App_GetEDiscoveryClientPropertiesRequest/processinginstructioninfo/locale') R ( ref )),0)
SET @level = (SELECT  ref.value('@propertyLevel', 'int') AS client
                    FROM    @xmlText.nodes('App_GetEDiscoveryClientPropertiesRequest/filterOptions') R ( ref ))
SET @clientId = (SELECT  ref.value('@clientId', 'int') AS client
                    FROM    @xmlText.nodes('App_GetEDiscoveryClientPropertiesRequest/eDiscoveryClient') R ( ref ))
SET @subType = ISNULL((SELECT  ref.value('@eDiscoverySubType', 'int') AS client
                    FROM    @xmlText.nodes('App_GetEDiscoveryClientPropertiesRequest') R ( ref )),0)
DECLARE @OBJ_STORE_TYPE_ATTR    AS NVARCHAR(100)    = N'System Drive Type'
IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
    DROP TABLE #getIdaObjects
	CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
EXEC sec_getIdaObjectsForUser @userId,3,0,1,'#getIdaObjects' --3
IF @AllClient = 1
BEGIN
	IF (@subType = 0)	-- fix for full outer join against 2 million client property rows not needed and causing performance issues
	BEGIN
		INSERT  INTO #EDiscoveryClientListTbl (cid, cname, cdisplayName, installdate)
			SELECT --DISTINCT		-- Remove the full outer join and no longer need distinct clause to eliminate the duplicates
				c.id,
				c.name,
				c.displayName,
				c.refTime
			FROM APP_Client c
				INNER JOIN #getIdaObjects ON
					clientId = C.id
AND (c.status & 0x10000000 ) <> 0
				INNER JOIN APP_ClientProp cp ON
					cp.componentNameId = c.id
					AND cp.attrName = @OBJ_STORE_TYPE_ATTR
					--AND ISNUMERIC(cp.attrVal) = 1		-- not needed since testing against string data type below
					AND cp.attrVal = N'6'	--EdgeSystemDriveTypes_EDISCOVERY
					AND cp.modified = 0		-- added to eliminate index scan
	END
	ELSE
	BEGIN
		INSERT  INTO #EDiscoveryClientListTbl (cid, cname, cdisplayName, installdate)
			SELECT
				c.id,
				c.name,
				c.displayName,
				c.refTime
			FROM APP_Client c
				INNER JOIN #getIdaObjects ON
					clientId = C.id
AND (c.status & 0x10000000 ) <> 0
				INNER JOIN APP_ClientProp cp ON
					cp.componentNameId = c.id
					AND cp.attrName = @OBJ_STORE_TYPE_ATTR
					AND cp.attrVal = N'6'--EdgeSystemDriveTypes_EDISCOVERY
					AND cp.modified = 0		-- added to eliminate index scan
				INNER JOIN APP_ClientProp cp1 ON
					cp1.componentNameId = cp.componentNameId
					AND cp1.attrName = N'EDiscovery Subtype'
					AND cp1.attrVal = CAST(@subType  AS VARCHAR(12))
					AND cp1.modified = 0		-- added to eliminate index scan
	END
END
ELSE
BEGIN
	IF (@subType = 0)	-- fix for full outer join against 2 million client property rows not needed and causing performance issues
	BEGIN
		INSERT INTO #EDiscoveryClientListTbl (cid, cname, cdisplayName, installdate)
			SELECT
				c.id,
				c.name,
				c.displayName,
				c.refTime
			FROM #getIdaObjects sec
				INNER JOIN APP_Client c ON
					c.id = sec.clientId
AND (c.status & 0x10000000 ) <> 0 --CV_STATUS_EDGE_DRIVE
				INNER JOIN APP_ClientProp cp ON
					cp.componentNameId=c.id
					AND cp.attrName = @OBJ_STORE_TYPE_ATTR
					AND cp.attrVal = N'6'	--EdgeSystemDriveTypes_EDISCOVERY
					AND cp.modified = 0		-- added to eliminate index scan
			WHERE
				sec.clientId  = @clientId
	END
	ELSE
	BEGIN
		INSERT INTO #EDiscoveryClientListTbl (cid, cname, cdisplayName, installdate)
			SELECT
				c.id,
				c.name,
				c.displayName,
				c.refTime
			FROM #getIdaObjects sec
				INNER JOIN APP_Client c ON
					c.id = sec.clientId
AND (c.status & 0x10000000 ) <> 0 --CV_STATUS_EDGE_DRIVE
				INNER JOIN APP_ClientProp cp ON
					cp.componentNameId=c.id
					AND cp.attrName = @OBJ_STORE_TYPE_ATTR
					AND cp.attrVal = N'6'	--EdgeSystemDriveTypes_EDISCOVERY
					AND cp.modified = 0		-- added to eliminate index scan
				INNER JOIN APP_ClientProp cp1 ON
					cp1.componentNameId = cp.componentNameId
					AND cp1.attrName = N'EDiscovery Subtype'
					AND cp1.attrVal = CAST(@subType  AS VARCHAR(12))
					AND cp1.modified = 0		-- added to eliminate index scan
			WHERE
				sec.clientId  = @clientId
	END
END
-- Performance Change
-- Create Well Known External Temp Table for sec_getSecurityForEntity SP to avoid re-computing userId information.
IF OBJECT_ID ('tempdb.dbo.#sec_getSecurityForEntity_usersAndGroupsVisible') IS NOT NULL
	DROP TABLE #sec_getSecurityForEntity_usersAndGroupsVisible
CREATE TABLE #sec_getSecurityForEntity_usersAndGroupsVisible  (
	userOrGroupId INT,
	isUser INT,
	PRIMARY KEY (isUser, userOrGroupId)
)
IF OBJECT_ID('tempdb.dbo.#VisibleUsersAndUserGroups') IS NOT NULL
	DROP TABLE #VisibleUsersAndUserGroups
CREATE TABLE #VisibleUsersAndUserGroups (userOrGroupId INT)
IF OBJECT_ID('tempdb.dbo.#VisibleUsersAndUserGroups2') IS NOT NULL
	DROP TABLE #VisibleUsersAndUserGroups2
CREATE TABLE #VisibleUsersAndUserGroups2 (userOrGroupId INT)
EXEC sec_getUsersForThisUser '#VisibleUsersAndUserGroups',@userId
EXEC sec_getUserGroupsForThisUser '#VisibleUsersAndUserGroups2',@userId
INSERT INTO #sec_getSecurityForEntity_usersAndGroupsVisible
	SELECT
		userOrGroupId,
		1
	FROM #VisibleUsersAndUserGroups
	UNION ALL
	SELECT
		userOrGroupId,
		0
	FROM #VisibleUsersAndUserGroups2
DROP TABLE #VisibleUsersAndUserGroups
DROP TABLE #VisibleUsersAndUserGroups2
INSERT INTO #EDiscoveryClientPropTbl (cid, planId, subtype,ContentAnalyzerCloudId,AnalyticsIndexServerId ,InventoryDatasourceId,ProviderId,FederatedDatasourceId, serverPlanId, filterCriteria, custodians) /* case manager changes*/
	SELECT
		componentNameId                 AS cId,
		[Associated Plan] AS planId,
        [EDiscovery Subtype]            AS subtype,
		[Content Analyzer Cloud Id] AS ContentAnalyzerCloudId,
		[Analytics Index Server Id] as AnalyticsIndexServerId,
		[Inventory Datasource Id] as InventoryDatasourceId,
		[Provider Id] as ProviderId,
		[Federated Datasource Id] as FederatedDatasourceId,
		[Default Server Plan]			AS serverPlanId,
		[Case Manager Filter Criteria]	AS filterCriteria, /* case manager changes*/
		[Case Manager Custodians]		AS custodians /* case manager changes*/
	FROM (
			SELECT
				 componentNameId,
				attrName,
				attrVal
			FROM #EDiscoveryClientListTbl cl
				INNER JOIN  App_ClientProp cp ON
					cp.componentNameId = cl.cid
					AND cp.modified = 0
				AND cp.attrName IN (
					'Associated Plan',
					'EDiscovery Subtype',
'Content Analyzer cloud Id',
'Analytics Index Server Id',
'Inventory Datasource Id',
'Provider Id',
'Federated Datasource Id',
					'Default Server Plan',
					'Case Manager Filter Criteria', /* case manager changes*/
					'Case Manager Custodians' /* case manager changes*/
				)
		) AS clients
	PIVOT   (   MAX(attrVal) FOR attrName IN (
						[Associated Plan],
                        [EDiscovery Subtype],
						[Content Analyzer Cloud Id],
						[Analytics Index Server Id] ,
						[Inventory Datasource Id],
						[Provider Id],
						[Federated Datasource Id],
						[Default Server Plan],
						[Case Manager Filter Criteria],
						[Case Manager Custodians] /* case manager changes*/
				)
		) AS P
	INSERT INTO #EDiscoveryDataSourceTbl
	SELECT c.cid, p.attrVal FROM #EDiscoveryClientListTbl c
INNER JOIN app_clientProp p on p.componentNameId = c.cid and attrName='Datasource Id' and modified=0
	IF @level > 1
	BEGIN
        --security
		DECLARE @i_clientId INTEGER
		DECLARE @entitySecurityAssociation XML
		-- Simplified cursor settings
		DECLARE clientcur CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
			SELECT cid FROM #EDiscoveryClientListTbl
		OPEN clientcur
		-- Performance Issue: Cursor loop for sec_getSecurityForEntity SP takes ~600ms (~930ms with External Temp Table for user info) per iteration and is the major cost of this SP
        FETCH NEXT FROM clientcur INTO @i_clientId
        WHILE @@FETCH_STATUS = 0
        BEGIN
			EXEC [dbo].[sec_getSecurityForEntity]
				@userId,
				@entitySecurityAssociation OUTPUT,
3,
				@i_clientId
			INSERT INTO #FinalXMLList(c_id, entitySecurityAssociation)
				VALUES (@i_clientId, @entitySecurityAssociation)
			FETCH NEXT FROM clientcur INTO @i_clientId
		END
        CLOSE clientcur
		DEALLOCATE clientcur
		INSERT INTO #UserTable
		SELECT AED.clientId, U.id, U.login, CAST(UPROP.attrVal AS BIGINT)
		FROM UMUsers U
		INNER JOIN App_EdgeDriveAssociation AED ON U.id = AED.entityId AND AED.entityType = 13
		INNER JOIN UMUsersProp UPROP ON UPROP.componentNameId = U.id AND UPROP.attrType = 130 AND UPROP.attrName = CAST(AED.clientId AS NVARCHAR(MAX))
	END
SET @o_xmlText =(
	SELECT
(SELECT '3' as '@_type_', ctbl.cid as  '@clientId', ctbl.cname as '@clientName' FOR XML PATH('eDiscoveryClient'), type),-- CLIENT_ENTITY
	(SELECT cp.subtype as  '@eDiscoverySubType', cp.custodians as '@custodians', cp.filterCriteria as '@filterCriteria', ctbl.installDate as '@installDate',
--appTypeIds
	CASE WHEN @level > @allProperties THEN
		-- Fix error where all ediscovered clients appTypes being added to each client node
		(SELECT ida.appTypeId as '@val' FROM APP_IDAName ida WHERE ida.clientId = ctbl.cid  FOR XML PATH('appTypeIds'),type) ELSE NULL END,
	--providers
	CASE WHEN @level > @allProperties THEN
(SELECT '61' as '@_type_',  u.id as '@providerId', u.domainName as '@providerDomainName' FROM #EDiscoveryClientPropTbl-- PROVIDER_ENTITY
INNER JOIN UMDSProviders u ON u.id=ProviderId   where cid=ctbl.cid FOR XML PATH('providers'), type) ELSE NULL END,
--contentAnalyzerCloud
	CASE WHEN @level > @allProperties THEN
(SELECT '169' as '@_type_',  d.cloudId as  '@cloudId', d.name as '@cloudName' FROM #EDiscoveryClientPropTbl e INNER JOIN DM2Cloud d ON  e.ContentAnalyzerCloudId=d.cloudId where e.cid=ctbl.cid FOR XML PATH('contentAnalyzerCloud'), type) ELSE NULL END,--SEARCH_CLOUD_ENTITY
	--index server
	CASE WHEN @level > @allProperties THEN
(SELECT  '3' as '@_type_', c.id AS  '@clientId', c.name AS '@clientName' FROM App_EdgeDriveAssociation e INNER JOIN APP_Client c on e.entityId=c.id WHERE entityType=3 AND e.clientId=ctbl.cid FOR XML PATH('indexServer'), type) ELSE NULL END,
--inventory datasource
	CASE WHEN @level > @allProperties THEN
(SELECT  '132' as '@_type_', s.DataSourceId AS  '@seaDataSourceId', s.DataSourceName AS '@seaDataSourceName' FROM #EDiscoveryClientPropTbl e INNER JOIN SEDataSource s ON e.InventoryDatasourceId=s.DataSourceId WHERE e.cid=ctbl.cid   FOR XML PATH('inventoryDataSource'), type) ELSE NULL END,
--federated datasource
	CASE WHEN @level > @basicProperties THEN
(SELECT  '132' as '@_type_', s.DataSourceId AS  '@seaDataSourceId', s.DataSourceName AS '@seaDataSourceName' FROM #EDiscoveryClientPropTbl e INNER JOIN SEDataSource s ON e.FederatedDatasourceId =s.DataSourceId WHERE e.cid=ctbl.cid   FOR XML PATH('federatedDataSource'), type) ELSE NULL END,
--datasources
CASE WHEN @level > @allProperties THEN
(SELECT  '132' as '@_type_', s.DataSourceId AS  '@seaDataSourceId', s.DataSourceName AS '@seaDataSourceName' FROM #EDiscoveryDataSourceTbl e INNER JOIN SEDataSource s ON e.DatasourceId=s.DataSourceId WHERE  e.cid=ctbl.cid FOR XML PATH('dataSources'), type) ELSE NULL END,
--owners
CASE WHEN @level > @basicProperties THEN
(
SELECT (
		SELECT CASE
				WHEN UMO.isUSER = 1
					THEN UMU.id
				END AS '@userId',
			CASE
				WHEN UMO.isUser = 0
					THEN UMG.id
				END AS '@userGroupId',
			CASE
				WHEN UMO.isUSER = 1
					THEN UMU.LOGIN
				END AS '@userName',
			CASE
				WHEN UMO.isUser = 0
					THEN UMG.NAME
				END AS '@userGroupName',
			CASE
				WHEN UMO.isUSER = 1
					THEN 13
				ELSE 15
				END AS '@_type_'
		FROM UMOwners UMO
		INNER JOIN #sec_getSecurityForEntity_usersAndGroupsVisible Tbl
			ON UMO.isUser = Tbl.isUser
				AND UMO.userOrGroupId = Tbl.userOrGroupId
		LEFT JOIN UMUsers UMU
			ON UMO.isUser = 1
				AND UMO.userOrGroupId = UMU.id
		LEFT JOIN UMGroups UMG
			ON UMO.isUser = 0
				AND UMO.userOrGroupId = UMG.id
		WHERE UMO.entityType = 3
			AND UMO.entityId = ctbl.cid
		FOR XML PATH('owners'),
			TYPE
		)
FOR XML PATH('clientOwners'),
	TYPE
)ELSE NULL END,
(SELECT  '158' as '@_type_', planId as  '@planId', p.name as '@planName' FROM app_plan p where cp.planId=p.id   FOR XML PATH('plan'), type),--PLAN_ENTITY
(SELECT  '158' as '@_type_', p.id as  '@planId', p.name as '@planName' FROM app_plan p where cp.serverPlanId=p.id   FOR XML PATH('additionalPlans'), type),
(SELECT entitySecurityAssociation AS 'securityAssociations' FROM #FinalXMLList AS TmpXmlList WHERE TmpXmlList.c_id = cid FOR XML PATH(''), TYPE),
(SELECT capabilities AS '@capabilities', (SELECT userId AS '@userId',  userName AS '@userName' FOR XML PATH('user'), type)   FROM #UserTable usersList WHERE usersList.c_id=cid FOR XML PATH('userCapabilities') ,type)
	FROM #EDiscoveryClientPropTbl cp where cp.cid=ctbl.cid
	FOR xml path('eDiscoveryClientInfo'), TYPE)
FROM #EDiscoveryClientListTbl ctbl
FOR XML PATH('eDiscoveryClientProp'), TYPE)
EXIT_SCRIPT:
	 SET @o_xmlText = (select @o_xmlText FOR XML PATH(''),ROOT('App_GetEDiscoveryClientPropertiesResponse'))
	IF object_id('tempdb.dbo.#EDiscoveryClientPropTbl') IS NOT NULL
		DROP TABLE #EDiscoveryClientPropTbl
	IF object_id('tempdb.dbo.#EDiscoveryClientListTbl') IS NOT NULL
		DROP TABLE #EDiscoveryClientListTbl
	IF OBJECT_ID('tempdb.dbo.#usersAndGroupsVisible ') IS NOT NULL
        DROP TABLE #usersAndGroupsVisible
	IF object_id('tempdb.dbo.#FinalXMLList') IS NOT NULL
		DROP TABLE #FinalXMLList
	IF object_id('tempdb.dbo.#UserTable') IS NOT NULL
		DROP TABLE #UserTable
	IF object_id('tempdb.dbo.#EDiscoveryDataSourceTbl') IS NOT NULL
		DROP TABLE #EDiscoveryDataSourceTbl
	IF OBJECT_ID('tempdb.dbo.#sec_getSecurityForEntity_usersAndGroupsVisible') IS NOT NULL
        DROP TABLE #sec_getSecurityForEntity_usersAndGroupsVisible
	 SELECT @o_xmlText o_xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetEDiscoveryClientProperties')
	delete from GxQscripts where name = 'AppGetEDiscoveryClientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetEDiscoveryClientProperties')
	delete from GXDBVersions where aliasname = 'AppGetEDiscoveryClientProperties'
GO

insert into GXDBVersions values(2, 'AppGetEDiscoveryClientProperties',  '00010001000200150000', 'AppGetEDiscoveryClientProperties', '00010001000200150000')
GO

