

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDockScript.sp] ---------- 

--  +========================================================================+
--  | Name:  AppGetDockScript
--  | Description: Get Dock script with proper firewall settings filled out
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetDockScript')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDockScript <<<'
	drop procedure AppGetDockScript
END
IF EXISTS (select * from GxQscripts where name='AppGetDockScript')
	delete from GxQscripts where name = 'AppGetDockScript'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDockScript')
	delete from GXDBVersions where aliasname = 'AppGetDockScript'
GO
print '... Creating Procedure: AppGetDockScript'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetDockScript
  @i_instanceId INT,
  @i_clientId int,
  @i_script_output int
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
  DECLARE @o_script nvarchar(max)
	DECLARE @csName		nvarchar(256)
	DECLARE @vmAllocPolicyId  int
	DECLARE @isFirewallEnabled int =0
	declare @firewallSettings   xml
	declare @portNumber        int
	DECLARE @userName		nvarchar(256)
	DECLARE @userPassword   nvarchar(256)
	declare @osType			nvarchar(256)
	DECLARE @clientName		nvarchar(256)
	declare @hostName		nvarchar(256)
	declare @encrypTPassword nvarchar(256)
	declare @proxyClientName nvarchar(256)
	declare @proxyHostName   nvarchar(256)
	declare @dmzClientGroupId int
	declare @proxyClientid    int
	declare @virtualizationClientId int
	declare @spVersion nvarchar(256)
	declare @policyType int
	declare @RegistrationScript nvarchar(256) ='CVCloudFRELPowerShellScript'
	-------------Constansts---------
	declare @WIN_OS nvarchar(256) = 'Windows'
	declare @UNIX_OS nvarchar(256) = 'Unix'
	declare @AMAZON_POLICY_TYPE int = 1
	declare @AZURE_POLICY_TYPE int = 7
	DECLARE @csHostName		nvarchar(256)
	select @vmAllocPolicyId = attrval  from app_instanceprop where componentNameId = @i_instanceId
        and modified =0 and attrname ='Auto Scale Policy'
	--Collect common policy info
	SELECT
		@policyType =  c.value('(entity/@policyType)[1]', 'int')
	from App_VmAllocationPolicy P
	CROSS APPLY P.vxml.nodes ('policy') T(c)
	where id = @vmAllocPolicyId and alive = 1
	select  @osType =  S.Type from app_client C
	inner join simOperatingSystem S
	on C.simOperatingSystemId = S.id
	and C.id = @i_clientId
	IF ( @AZURE_POLICY_TYPE = @policyType OR @AMAZON_POLICY_TYPE = @policyType)
    BEGIN
		IF @osType = @UNIX_OS
			SET @RegistrationScript =  'CVCloudFRELShellScript'
	END
	if(@i_script_output = 1)
	BEGIN
		select @o_script = value from GxGlobalParam where name =@RegistrationScript and modified=0
	END
	else
	BEGIN
		SET @o_script = '{"OSType": "OSTypeValue","ClientName": "ClientNameValue", "ClientHostName":"ClientHostNameValue","CSName":"CSNameValue","CSHostName":"CSHostNameValue","CSUserName":"CSUserNameValue", "CSPassword":"CSPasswordValue", "ClientGroup":"ClientGroupValue", "IsFirewallEnabled":"IsFirewallEnabledValue","ClientFirewallPort":"ClientFirewallPortValue","CSFirewallPort":"CSFirewallPortValue", "ProxyHostName":"ProxyHostNameValue", "ProxyClientName":"ProxyNameValue", "ProxyPort":"ProxyPortValue", "IndexGatewayWebServerClient":"IndexGatewayWebServerClientValue","IndexGatewayWebServerHost":"IndexGatewayWebServerHostValue","IndexGatewayWebServerIISPort":"IndexGatewayWebServerIISPortValue","SPVersion":"SPVersionValue"}';
	END
    select @csName = name, @csHostName = net_hostname from app_client where id =2
	select @clientName = name, @hostName = net_hostname from app_client where id = @i_clientId
	select @spVersion = attrVal from APP_ClientProp where attrName = 'SP Version Info' and componentNameId = 2
	if(@i_script_output = 0)
	BEGIN
		SET @o_script = REPLACE(@o_script, 'SPVersionValue', @spVersion)
	END
    SET @o_script = REPLACE(@o_script, 'OSTypeValue', @osType)
    SET @o_script = REPLACE(@o_script, 'CSNameValue', @csName)
    SET @o_script = REPLACE(@o_script, 'CSHostNameValue', @csHostName)
    SET @o_script = REPLACE(@o_script, 'ClientNameValue', @clientName)
    SET @o_script =  REPLACE(@o_script, 'ClientHostNameValue', @hostName)
    select @userName = login,
            @userPassword = password
    from UMUsers
    where flags & 67 = 67
    EXEC dbo.pswEncryptionManaged @userPassword , @encrypTPassword OUTPUT
	declare @clientGroupId int
	select @clientGroupId = vxml.value('(policy/associatedClientGroup/@clientGroupId)[1]', 'int')
	from app_vmallocationpolicy where id = @vmAllocPolicyId
	declare @clientGroupName nvarchar(max)
	select @clientGroupName =name  from app_clientgroup where id = @clientGroupId
	SET @o_script = REPLACE(@o_script, 'ClientGroupValue', @clientGroupName)
	IF ( @userName is NOT NULL and  @userPassword is NOT null)
	BEGIN
    	SET @o_script = REPLACE(@o_script, 'CSUserNameValue', @userName)
    	SET @o_script = REPLACE(@o_script, 'CSPasswordValue', @encrypTPassword)
	END
	declare @restrictionType int =NULL
		-- find the restriction type from client group to the CS
	select @restrictionType = restrictionType from app_firewall where clientGroupId = @clientGroupId and forClientId =2
	if ( @restrictionType is null)
	begin
		select @restrictionType = restrictionType from app_firewall AF
		inner join app_clientGroupassoc cga
		on AF.clientGroupId =  @clientGroupId
		and AF.forClientGroupId = cga.clientGroupId
		and cga.clientId =2
	end
	if  (@restrictionType is not null)
	begin
		set @isFirewallEnabled =1
		select @portNumber = tunnelconnectionPort from app_firewallOptions where clientGroupId = @clientGroupId
	end
	else
	begin
		select @dmzClientGroupId = forClientGroupId from app_firewall AF
		inner join app_clientGroupassoc cga
		on AF.clientGroupId =  @clientGroupId
		and AF.forClientGroupId = cga.clientGroupId
		inner join App_FirewallOptions AFO
		on AFO.clientGroupId = AF.forClientGroupId
		and AFO.isDMZ =1
		if exists (select top 1 restrictionType from app_firewall AF
		inner join app_clientGroupassoc cga
		on AF.clientGroupId =  @dmzClientGroupId
		and AF.forClientGroupId = cga.clientGroupId)
		begin
			set @isFirewallEnabled =2
			select @proxyClientid = clientid from APP_ClientGroupAssoc cga
			inner join CCRClientToClient CCR
			on cga.clientId = CCR.ToClientId
			and CCR.FromClientId =2
			where cga.clientGroupId = @dmzClientGroupId
			and CCR.errorCode =0
		end
		select @portNumber = tunnelconnectionPort from app_firewallOptions where clientGroupId = @dmzClientGroupId
	end
	IF ( @isFirewallEnabled =1)
	BEGIN
		SET @o_script = REPLACE(@o_script, 'IsFirewallEnabledValue', 'True')
		IF ( @restrictionType = 0)
		begin
		    SET @o_script = REPLACE(@o_script, 'ClientFirewallPortValue', cast(@portNumber as varchar(128)))
			SET @o_script = REPLACE(@o_script, 'CSFirewallPortValue', '0')
		end
		ELSE
		begin
		    SET @o_script = REPLACE(@o_script, 'CSFirewallPortValue', cast(@portNumber as varchar(128)))
		    SET @o_script = REPLACE(@o_script, 'ClientFirewallPortValue', '0')
		end
	END
	ELSE IF ( @isFirewallEnabled =2 )
	BEGIN
		 SET @o_script = REPLACE(@o_script, 'IsFirewallEnabledValue', 'True')
		 select @proxyClientName = name , @proxyHostName = net_hostname from app_client where id = @proxyClientid
		 SET @o_script = REPLACE(@o_script, 'ProxyPortValue', cast(@portNumber as varchar(128)))
		 SET @o_script = REPLACE(@o_script, 'ClientFirewallPortValue', '0')
		 SET @o_script = REPLACE(@o_script, 'CSFirewallPortValue', '0')
    	 SET @o_script = REPLACE(@o_script, 'ProxyHostNameValue', @proxyHostName)
		 SET @o_script = REPLACE(@o_script, 'ProxyNameValue', @proxyClientName)
	END
	ELSE
				SET @o_script = REPLACE(@o_script, 'IsFirewallEnabledValue', 'False')
    -- index gateway information
    select @virtualizationClientId  = clientid from app_application where instance = @i_instanceId and apptypeId =106
	declare @indexPseduoClientId int
	declare @webServerClientId int
	declare @webserverClientName  nvarchar(256)
	declare @webserverHostName    nvarchar(256)
	declare @webserverIISPort     nvarchar(256)
	select @indexPseduoClientId = cast(p.attrval as int) from app_clientprop cp
	inner join App_PlanProp p
	on cp.attrName ='Default Data classification Plan'
	and cp.modified =0
	and p.attrName = 'Analytics Index Server Id'
	and p.componentNameId = cast(cp.attrVal as int)
	if ( isnull(@indexPseduoClientId,0) >0 )
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
		CREATE TABLE #getIndexServers
					(     serverURL NVARCHAR(512),
							clientId INT,
							clientName NVARCHAR(256),
							cloudId INT,
							hostName NVARCHAR(256),
							basePort INT,
							engineName  NVARCHAR(256),
							serverType INT,
							indexServerClientId INT,
							internalCloudName NVARCHAR(256)
					)
		CREATE CLUSTERED INDEX clientId_getIndexServers_idx on #getIndexServers(clientId)
		exec DM2GetIndexServers '', @indexPseduoClientId
		 select @webServerClientId = clientId from #getIndexServers
		 select @webserverClientName = name , @webserverHostName = net_hostname from app_client where id = @webServerClientId
		 select @webserverIISPort = attrval from app_clientprop where attrname = 'DM2WebService Web Site Port' and modified =0
		 and componentNameId = @webServerClientId
		 if ( @webserverClientName is not null and @webserverHostName is not null )
		 BEGIN
			 SET @o_script = REPLACE(@o_script, 'IndexGatewayWebServerIISPortValue', isnull(@webserverIISPort,81))
			 SET @o_script = REPLACE(@o_script, 'IndexGatewayWebServerHostValue', @webserverHostName)
			 SET @o_script = REPLACE(@o_script, 'IndexGatewayWebServerClientValue', @webserverClientName)
		 END
	END
    select @o_script
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDockScript')
	delete from GxQscripts where name = 'AppGetDockScript'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDockScript')
	delete from GXDBVersions where aliasname = 'AppGetDockScript'
GO

insert into GXDBVersions values(2, 'AppGetDockScript',  '00000000000000000000', 'AppGetDockScript', '00000000000000000000')
GO

