

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDistributedSystemClientGroupInfoList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetDistributedSystemClientGroupInfoList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDistributedSystemClientGroupInfoList <<<'
	drop procedure AppGetDistributedSystemClientGroupInfoList
END
IF EXISTS (select * from GxQscripts where name='AppGetDistributedSystemClientGroupInfoList')
	delete from GxQscripts where name = 'AppGetDistributedSystemClientGroupInfoList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDistributedSystemClientGroupInfoList')
	delete from GXDBVersions where aliasname = 'AppGetDistributedSystemClientGroupInfoList'
GO
print '... Creating Procedure: AppGetDistributedSystemClientGroupInfoList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetDistributedSystemClientGroupInfoList
  @i_userId INT,
  @o_xml XML OUTPUT,
  @i_clientGroupId INT = 0
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @isCommcellLevelAssociation int = 0
DECLARE @checkSumPlan INTEGER
SET @checkSumPlan = CHECKSUM(N'Associated Plan')
BEGIN
		-- Apply security
		IF object_id('tempdb.dbo.#tempSubclientSecurityObjects') IS NOT Null DROP TABLE #tempSubclientSecurityObjects
create table  #tempSubclientSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @i_userId, 2013, 0, '#tempSubclientSecurityObjects'
SELECT @isCommcellLevelAssociation=1 FROM #tempSubclientSecurityObjects sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
		IF OBJECT_ID('tempdb.dbo.#tempDSSubclientInfo') IS NOT NULL DROP TABLE #tempDSSubclientInfo
		IF OBJECT_ID('tempdb.dbo.#tempDSProperties') IS NOT NULL	DROP TABLE #tempDSProperties
		CREATE table #tempDSSubclientInfo (clientGroupId int, clientGroupName nvarchar(256), clientId int, clientName nvarchar(256), appTypeId int, instanceId int, backupsetId int, subclientId int,  planId int, planName nvarchar(256), accessNodeId int, accessNodeName nvarchar(256))
		CREATE table #tempDSProperties(clientId int, subclientId int, instanceId int, propertyName nvarchar(256), propertyValue nvarchar(max))
		-- Insert subclient details
		INSERT INTO #tempDSSubclientInfo (clientGroupId, clientGroupName, clientId, clientName, appTypeId, subclientId, instanceId, backupsetId)
		SELECT CGA.clientGroupId, CG.name, CGA.clientId, C.name, A.appTypeId, A.id, A.instance,  A.backupset
		FROM [APP_ClientGroup] CG  WITH(NOLOCK)
		     JOIN [APP_ClientGroupAssoc] CGA WITH(NOLOCK) on CG.id = CGA.clientGroupId
		     JOIN APP_client C WITH(NOLOCK) ON c.id = CGA.clientId
JOIN APP_Application A WITH(NOLOCK) ON C.id = A.clientId and A.appTypeId IN (81, 301) AND ((A.subclientStatus & 0x00008) = 0x00008)
INNER JOIN APP_BackupSetName BS WITH(NOLOCK) ON BS.id = A.backupset AND ((BS.status & 0x00008) = 0x00008)
WHERE CG.flag & 0x80000000 = 0x80000000 and (@i_clientGroupId = 0 or (@i_clientGroupId > 0 and CG.id = @i_clientGroupId))
		-- Delete subclients if association is not commcell level
		IF(@isCommcellLevelAssociation <> 1)
		BEGIN
			DELETE SI
			FROM #tempDSSubclientInfo SI
			WHERE NOT EXISTS (SELECT 1 FROM #tempSubclientSecurityObjects  WHERE clientId = SI.clientId AND subClientId = 0)
				AND NOT EXISTS (SELECT 1 FROM #tempSubclientSecurityObjects WHERE subclientId = SI.subclientId)
		END
	    --Update Plan details
		UPDATE SI
		SET planId=AP.id, planName=AP.name
		FROM #tempDSSubclientInfo SI
INNER JOIN APP_SubClientProp ACP WITH(NOLOCK) ON ACP.componentNameId=SI.subclientId AND ACP.attrName = 'Associated Plan' AND ACP.modified=0 AND ACP.cs_attrName = @checkSumPlan
INNER JOIN App_Plan AP WITH(NOLOCK) ON AP.id=CAST(ACP.attrVal AS INT) AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
		-- Get IDA Properties
		INSERT INTO #tempDSProperties
		SELECT distinct SI.clientId, A.id, SI.instanceId, p.attrName, p.attrVal
		FROM #tempDSSubclientInfo SI
				JOIN APP_Application A WITH(NOLOCK) ON A.id = SI.subclientId
				JOIN APP_IdaName IDA WITH(NOLOCK) ON IDA.clientId = A.clientId AND IDA.appTypeID = SI.appTypeId
				JOIN APP_IdaProp P WITH(NOLOCK) ON P.componentNameId = IDA.id AND P.modified = 0
	    --Get Instance properties for Azure SQL
		INSERT INTO #tempDSProperties
		SELECT distinct SI.clientId, SI.subclientId, I.id, p.attrName, p.attrVal
		FROM #tempDSSubclientInfo SI
JOIN app_instancename I WITH(NOLOCK) ON I.id = SI.instanceId and  SI.appTypeId IN ( 81)
				JOIN app_instanceprop P WITH(NOLOCK) ON P.componentNameId = I.id AND P.modified = 0
		 --Get Instancename for Azure SQL
		INSERT INTO #tempDSProperties
SELECT distinct SI.clientId, SI.subclientId, I.id, 'SQL Server Name', I.name
		FROM #tempDSSubclientInfo SI
JOIN app_instancename I WITH(NOLOCK) ON I.id = SI.instanceId and SI.appTypeId IN ( 81)
		--Get DB name for Azure SQL
		INSERT INTO #tempDSProperties
SELECT distinct SI.clientId, SI.subclientId, SI.instanceId , 'Database Name', SP.attrName
		FROM #tempDSSubclientInfo SI
JOIN APP_subclientProp SP WITH(NOLOCK) ON  SP.modified=0 and SP.componentnameid = SI.subclientId and attrType in (118,119) and SI.appTypeId IN (81)
		--Get Cloud User ID for Azure SQL
		INSERT INTO #tempDSProperties
		SELECT distinct SI.clientId, SI.subclientId, SI.instanceId , CP.attrName, CP.attrVal
		FROM #tempDSSubclientInfo SI
JOIN APP_ClientProp CP WITH(NOLOCK) ON  CP.componentnameid = SI.clientId and SI.appTypeId IN ( 81) and  CP.attrName ='Cloud User ID' and CP.modified=0
		SET @o_xml =(SELECT
						(SELECT
							(SELECT  distinct CGI.clientGroupId AS '@clientGroupId', CGI.clientGroupName AS '@clientGroupName'
								FOR XML PATH('clientGroup'),TYPE),
							   (SELECT
									(SELECT distinct II.appTypeId AS '@applicationId', SI.clientId as '@clientId'
									 FROM (SELECT DISTINCT clientId, appTypeId FROM #tempDSSubclientInfo WHERE SI.clientId = ClientId) II
										FOR XML PATH('appType'),TYPE
									),
									(SELECT c.propertyName as '@userPropertyName',
											(SELECT distinct propertyValue as '@userName'
												FOR XML PATH('userPassword'),TYPE
											) FROM
													(SELECT distinct P.propertyName, P.propertyValue
														FROM #tempDSProperties P
														WHERE P.subclientId = SI.subclientId and SI.instanceId = P.instanceId and SI.clientId = P.ClientId
and P.propertyName in ('Cloud User ID', 'Azure SQL Instance Username', 'Azure Username')
													) c
											FOR XML PATH('credentials'),TYPE
									),
									(SELECT distinct P.propertyName AS '@name' , P.propertyValue AS '@value'
									 FROM #tempDSProperties P
											WHERE P.subclientId = SI.subclientId and SI.instanceId = P.instanceId and SI.clientId = P.ClientId
and  P.propertyName not in ('Cloud User ID', 'Cloud User Password', 'Access Node', 'Cloud Proxy Servers', 'Azure SQL Instance Username', 'Azure SQL Instance Password', 'Azure Username', 'Azure Password', 'Associated Plan')
										FOR XML PATH('properties'),TYPE
									),
									(SELECT distinct  SI.subclientId AS '@subclientId'
									       , SI.backupsetId AS '@backupsetId'
										   , SI.instanceId AS '@instanceId'
										FOR XML PATH('subClientEntity'),TYPE
									),
									(SELECT
											CAST(propertyValue AS XML).value(('(/App_MemberServers/memberServers/client/@clientId)[1]'), 'INT') as '@clientId',
										    CAST(propertyValue AS XML).value(('(/App_MemberServers/memberServers/client/@clientName)[1]'), 'varchar(max)') as '@clientName'
										FROM (	SELECT distinct propertyValue
FROM #tempDSProperties P WHERE P.subclientId = SI.subclientId and SI.instanceId = P.instanceId and SI.clientId = P.ClientId and SI.appTypeId IN (81) and P.propertyName  in ( 'Cloud Proxy Servers')
										)m
										FOR XML PATH('accessNode'),TYPE
									),
									(SELECT
											CAST(REPLACE(propertyValue,'encoding="utf-8"', 'encoding="utf-16"') AS XML).value(('(/CvEntities_ClientEntity/@clientId)[1]'), 'INT') as '@clientId'
										FROM ( SELECT distinct propertyValue
FROM #tempDSProperties P WHERE P.subclientId = SI.subclientId and SI.instanceId = P.instanceId and SI.clientId = P.ClientId and SI.appTypeId IN (301)
and P.propertyName  in ( 'Access Node')
										)m
										FOR XML PATH('accessNode'),TYPE
									),
									(SELECT distinct SI.planId AS '@planId', SI.planName as '@planName'
										FOR XML PATH('planEntity'),TYPE
									)
							   FROM #tempDSSubclientInfo SI WHERE  SI.clientGroupId = CGI.clientGroupId
							   FOR XML PATH('distributedSystemAppInfoList'),TYPE)
						FROM ( SELECT DISTINCT clientGroupId, clientGroupName FROM #tempDSSubclientInfo) CGI
						order by clientGroupName
					FOR XML PATH('distSystemClientGroupInfoList'), TYPE)
				  FOR XML PATH(''), ROOT('App_GetDistributedSystemClientGroupInfoListResp'))
		IF object_id('tempdb.dbo.#tempDSSubclientInfo') IS NOT Null DROP TABLE #tempDSSubclientInfo
		IF OBJECT_ID('tempdb.dbo.#tempDSProperties') IS NOT NULL	DROP TABLE #tempDSProperties
		SELECT @o_xml = ISNULL(@o_xml, '<App_GetDistributedSystemClientGroupInfoListResp/>')
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDistributedSystemClientGroupInfoList')
	delete from GxQscripts where name = 'AppGetDistributedSystemClientGroupInfoList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDistributedSystemClientGroupInfoList')
	delete from GXDBVersions where aliasname = 'AppGetDistributedSystemClientGroupInfoList'
GO

insert into GXDBVersions values(2, 'AppGetDistributedSystemClientGroupInfoList',  '00000000000000000000', 'AppGetDistributedSystemClientGroupInfoList', '00000000000000000000')
GO

