

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDistributedStorages.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetDistributedStorages')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDistributedStorages <<<'
	drop procedure AppGetDistributedStorages
END
IF EXISTS (select * from GxQscripts where name='AppGetDistributedStorages')
	delete from GxQscripts where name = 'AppGetDistributedStorages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDistributedStorages')
	delete from GXDBVersions where aliasname = 'AppGetDistributedStorages'
GO
print '... Creating Procedure: AppGetDistributedStorages'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetDistributedStorages
  @userId INT,
  @localeId INT = 0,
  @xmlstr XML 	OUTPUT
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
	DECLARE @outputEntitiesStr NVARCHAR(MAX)
	DECLARE @outputErrorStr NVARCHAR(MAX)
	DECLARE @DS_TYPE_HEDVIG INT = 1
	DECLARE @distributedStorageId INT = 0
	DECLARE @includeAdvancedInfo INT = 0
	DECLARE @entitySecurityAssociation XML
	DECLARE @entitySecurity XML
	IF @userId <= 0
	BEGIN
SET @errorCode = (4625 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO PROC_EXIT
	END
	------ READ DISTRIBUTED STORAGE INFO FROM REQUEST XML ------
	DECLARE @listAllDistributedStorages INT = ISNULL((SELECT  ref.value('@listAllDistributedStorages', 'INT')
      FROM    @xmlstr.nodes('App_GetDistributedStorageRequest') R ( ref )), 0)
	DECLARE @getDSPermissionType INT = ISNULL((SELECT  ref.value('@getPermissionType', 'INT')
FROM    @xmlstr.nodes('App_GetDistributedStorageRequest') R ( ref )), 1)
	------ CHECK IF REQUIRED FIELDS ARE VALID ------
	IF @listAllDistributedStorages = 0
	BEGIN
		SET @distributedStorageId = ISNULL((SELECT  ref.value('@distributedStorageId', 'INT')
		FROM    @xmlstr.nodes('App_GetDistributedStorageRequest/distributedStorage') R ( ref )), 0)
		IF @distributedStorageId = 0
		BEGIN
SET @errorCode = (4626 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO PROC_EXIT
		END
		IF NOT EXISTS (SELECT 1 FROM App_DistributedStorage WHERE id = @distributedStorageId)
		BEGIN
SET @errorCode = (4623 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO PROC_EXIT
		END
		SET @includeAdvancedInfo = 1
	END
	ELSE
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 id FROM App_DistributedStorage)
		BEGIN
			GOTO PROC_EXIT
		END
	END
	------ SECURITY CHECK ------
	--Contains objects tables to be used by SP.
	IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
		DROP TABLE #getObjectsTable
	CREATE TABLE #getObjectsTable (entityId INT, permissionId INT)
	IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
		DROP TABLE #permissionIdTable
	CREATE TABLE #permissionIdTable (permissionId INT)
	------ MAP GetDistributedStoragePermissionType TO PERMISSION, DEFAULT PERMISSION IS EV_VISIBILITY
IF @getDSPermissionType = 2
	BEGIN
		INSERT INTO  #permissionIdTable
		(permissionId)
VALUES (260)
	END
ELSE IF @getDSPermissionType = 3
	BEGIN
		INSERT INTO  #permissionIdTable
		(permissionId)
VALUES (260), (261)
	END
	ELSE
	BEGIN
-- 31 VIEW = 31, 260 MANAGE = 260, 261 USE = 261
		INSERT INTO  #permissionIdTable
		(permissionId)
VALUES (31), (260), (261)
	END
EXEC sec_getObjectsWithPermissionsV2 @userId, 195, 0
	IF @listAllDistributedStorages = 0 AND NOT EXISTS (SELECT 1 FROM #getObjectsTable WHERE entityId = @distributedStorageId)
	BEGIN
SET @errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO PROC_EXIT
	END
	IF object_id('tempdb.dbo.#DistributedStoragePropTempTable') IS NOT NULL
		DROP TABLE #DistributedStoragePropTempTable
	CREATE TABLE #DistributedStoragePropTempTable
	(distributedStorageId INT PRIMARY KEY, credentialId INT, clusterNodes NVARCHAR(MAX), targets NVARCHAR(MAX),
	securityAssociations XML, entitySecurity XML, canManage INT DEFAULT 0)
	------ GET DISTRIBUTED STORAGE PROPERTIES ------
	IF @listAllDistributedStorages = 1
	BEGIN
		INSERT INTO #DistributedStoragePropTempTable
		(distributedStorageId, credentialId)
		SELECT ds.distributedStorageId, ca.credentialId
		FROM (select distinct entityId as distributedStorageId from #getObjectsTable) as ds
JOIN APP_CredentialAssoc ca ON ca.entityType = 195 AND ca.entityId = ds.distributedStorageId
	END
	ELSE
	BEGIN
		IF @includeAdvancedInfo = 1
		BEGIN
			-- GET SECURITY ASSOCIATIONS
			EXEC [dbo].[sec_getSecurityForEntity]
                                                @userId,
                                                @entitySecurityAssociation OUTPUT,
195,
                                                @distributedStorageId
		END
		INSERT INTO #DistributedStoragePropTempTable
		(distributedStorageId, credentialId, clusterNodes, targets, securityAssociations)
		SELECT ds.distributedStorageId, ca.credentialId, prop1.attrVal, prop2.attrVal, @entitySecurityAssociation
		FROM (SELECT distinct entityId as distributedstorageId FROM #getObjectsTable WHERE entityId = @distributedStorageId) ds
JOIN APP_CredentialAssoc ca ON ca.entityType = 195 AND ca.entityId = ds.distributedStorageId
LEFT OUTER JOIN App_DistributedStorageProp prop1 ON prop1.attrName = 'Cluster Nodes' AND prop1.cs_attrName = CHECKSUM('Cluster Nodes') AND ds.distributedStorageId = prop1.componentNameId
LEFT OUTER JOIN App_DistributedStorageProp prop2 ON prop2.attrName = 'Targets' AND prop2.cs_attrName = CHECKSUM('Targets') AND ds.distributedStorageId = prop2.componentNameId
		WHERE ds.distributedStorageId = @distributedStorageId
	END
	UPDATE #DistributedStoragePropTempTable
set canManage = 1 where distributedStorageId in (SELECT entityId as distributedstorageId FROM #getObjectsTable where permissionId = 260)
	------ COMPILE OUTPUT XML ------
	SET @outputEntitiesStr =
	(
		SELECT ds.url AS '@url', @DS_TYPE_HEDVIG AS '@type', prop.clusterNodes AS '@clusterNodes', prop.targets AS '@targets', ds.clusterIdentifier AS '@clusterIdentifier',
			prop.canManage AS '@canManage',
			(CASE WHEN @includeAdvancedInfo = 1 THEN prop.securityAssociations ELSE '' END) AS 'securityAssociations',
			(CASE WHEN @includeAdvancedInfo = 1 THEN prop.entitySecurity ELSE '' END) AS 'security',
			ds.id AS 'distributedStorage/@distributedStorageId', ds.name AS 'distributedStorage/@distributedStorageName',
			creds.credentialId AS 'credential/credentialRecord/@credentialId', creds.credentialName AS 'credential/credentialRecord/@credentialName', creds.userName AS 'credential/record/@userName'
		FROM App_DistributedStorage ds
		JOIN #DistributedStoragePropTempTable prop ON ds.id = prop.distributedStorageId
		JOIN App_Credentials creds ON creds.credentialId = prop.credentialId
		FOR XML PATH('distributedStorageInfo')
	)
PROC_EXIT:
	IF @errorCode <> 0 AND @errorString = ''
	BEGIN
		SET @errorString = (SELECT Message FROM EvLocaleMsgs WHERE MessageId = @errorCode and localeId = @localeId)
	END
	SET @outputErrorStr = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH ('error'))
	DECLARE @outputStr NVARCHAR(MAX) = ISNULL(@outputEntitiesStr, '') + ISNULL(@outputErrorStr, '')
	SET @xmlstr = @outputStr
	SET @xmlstr = (SELECT @xmlstr FOR XML PATH(''), ROOT('App_GetDistributedStorageResponse'))
	IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
		DROP TABLE #getObjectsTable
	IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
		   DROP TABLE #permissionIdTable
	IF object_id('tempdb.dbo.#DistributedStoragePropTempTable') IS NOT NULL
		DROP TABLE #DistributedStoragePropTempTable
	select @xmlstr
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDistributedStorages')
	delete from GxQscripts where name = 'AppGetDistributedStorages'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDistributedStorages')
	delete from GXDBVersions where aliasname = 'AppGetDistributedStorages'
GO

insert into GXDBVersions values(2, 'AppGetDistributedStorages',  '00000000000000000000', 'AppGetDistributedStorages', '00000000000000000000')
GO

