

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDistributedClusterTypeInstanceList.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetDistributedClusterTypeInstanceList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDistributedClusterTypeInstanceList <<<'
	drop procedure AppGetDistributedClusterTypeInstanceList
END
IF EXISTS (select * from GxQscripts where name='AppGetDistributedClusterTypeInstanceList')
	delete from GxQscripts where name = 'AppGetDistributedClusterTypeInstanceList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDistributedClusterTypeInstanceList')
	delete from GXDBVersions where aliasname = 'AppGetDistributedClusterTypeInstanceList'
GO
print '... Creating Procedure: AppGetDistributedClusterTypeInstanceList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetDistributedClusterTypeInstanceList
  @userId INT,
  @appType INT,
  @clusterType INT = 0,
  @clientId INT = 0
AS
BEGIN
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @xmlStr xml
IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
	DROP TABLE #getIdaObjects
CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
EXEC sec_getIdaObjectsForUser @userId,4,0,0,'#getIdaObjects'
SET @xmlStr = ISNULL( ( select (select client.name as '@clientName', client.id as '@clientId',ida.name as '@appName' , ida.type as '@applicationId',
						instance.name  as '@instanceName', instance.id  as '@instanceId' for xml path ('instanceEntity') , type ),
			    instanceProp.attrVal as clusterType
from #getIdaObjects
INNER JOIN APP_Client as client ON #getIdaObjects.clientId = client.id
INNER JOIN APP_iDAType as ida ON #getIdaObjects.apptypeId = ida.type
INNER JOIN APP_Application as app ON #getIdaObjects.clientId = app.clientId AND #getIdaObjects.apptypeId = app.appTypeId
INNER JOIN APP_InstanceProp as instanceProp ON app.instance = instanceProp.componentNameId
INNER JOIN APP_InstanceName as instance ON  instanceProp.componentNameId = instance.id
WHERE instanceProp.attrName=N'Distributed Cluster Type' AND (@clusterType = 0 OR instanceProp.attrVal = cast(@clusterType as nvarchar)) AND #getIdaObjects.apptypeId = @appType AND (@clientId = 0 OR client.id = @clientId)
group by instance.name , instance.id , ida.name, ida.type, client.name, client.id , instanceProp.attrVal
for xml path ('instanceList') ,
ROOT ('App_BigDataAppInstanceDetailsResponse')),  '<App_BigDataAppInstanceDetailsResponse/>')
SELECT @xmlStr as o_xmlString
DROP TABLE #getIdaObjects
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDistributedClusterTypeInstanceList')
	delete from GxQscripts where name = 'AppGetDistributedClusterTypeInstanceList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDistributedClusterTypeInstanceList')
	delete from GXDBVersions where aliasname = 'AppGetDistributedClusterTypeInstanceList'
GO

insert into GXDBVersions values(2, 'AppGetDistributedClusterTypeInstanceList',  '00000000000000000000', 'AppGetDistributedClusterTypeInstanceList', '00000000000000000000')
GO

