

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDistributedAppsClients.sp] ---------- 

-- This will generate the revision for the stored procedure. Don't remove this line!!!
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetDistributedAppsClients.sp,v $ $Id: AppGetDistributedAppsClients.sp,v 1.1.2.47 2020/11/12 08:20:47 alakra Exp $";
-- Name of the stored procedure
-- It must match with the name of the .sp file
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetDistributedAppsClients')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDistributedAppsClients <<<'
	drop procedure AppGetDistributedAppsClients
END
IF EXISTS (select * from GxQscripts where name='AppGetDistributedAppsClients')
	delete from GxQscripts where name = 'AppGetDistributedAppsClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDistributedAppsClients')
	delete from GXDBVersions where aliasname = 'AppGetDistributedAppsClients'
GO
print '... Creating Procedure: AppGetDistributedAppsClients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetDistributedAppsClients
-- Input variables of the stored procedure
  @i_xml XML
-- Tell the AWK processor that body of query starts here
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @clusterType int = ISNULL((SELECT @i_xml.value('(/App_GetDistributedAppsClientsRequest/@clusterType)[1]', 'INT')), 0)
DECLARE @requestType int = ISNULL((SELECT @i_xml.value('(/App_GetDistributedAppsClientsRequest/@requestType)[1]', 'INT')), 1) --Default data access nodes
DECLARE @appType	 int = ISNULL((SELECT @i_xml.value('(/App_GetDistributedAppsClientsRequest/@appType)[1]', 'INT')), 0)
DECLARE @clientAppType	 int = ISNULL((SELECT @i_xml.value('(/App_GetDistributedAppsClientsRequest/@clientAppType)[1]', 'INT')), 0)
DECLARE @includeOsInfo int = ISNULL((SELECT @i_xml.value('(/App_GetDistributedAppsClientsRequest/@includeOsInfo)[1]', 'INT')), 0)
DECLARE @i_flags INT = ISNULL((SELECT @i_xml.value('(/App_GetDistributedAppsClientsRequest/@flags)[1]', 'INT')), 0)
DECLARE @i_clientId INT = ISNULL((SELECT @i_xml.value('(/App_GetDistributedAppsClientsRequest/client/@clientId)[1]', 'INT')), 0)
DECLARE	@o_xml	XML
DECLARE @errorCode int = 0
DECLARE @errorMsg NVARCHAR(1024) = ''
DECLARE @userId INT =ISNULL((SELECT @i_xml.value('(App_GetDistributedAppsClientsRequest/processinginstructioninfo/user/@userId)[1]','INT')),0)
--use simOperatingSystem for detecting type of os.
IF object_id('temp.dbo.#DistAppTypeOfInst') IS NOT null DROP TABLE #DistAppTypeOfInst
IF object_id('temp.dbo.#DANClients') IS NOT null DROP TABLE #DANClients
CREATE TABLE #DANClients (name NVARCHAR(510),id INT, osId INT, hostName NVARCHAR(510) default '', clientStatus INT default 0, displayName NVARCHAR(255))
IF OBJECT_ID('tempdb.dbo.#PNClients') IS NOT NULL DROP TABLE #PNClients
IF OBJECT_ID('tempdb.dbo.#userClients') IS NOT NULL DROP TABLE #userClients
CREATE TABLE #userClients
(
    t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
IF(@userID<>0)
BEGIN
	EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#userClients'
END
IF @requestType = 0 --RESTORE_CLIENTS
BEGIN
	CREATE TABLE #DistAppTypeOfInst(instId INT, clusterType INT)
	INSERT INTO #DistAppTypeOfInst
		SELECT componentNameId, attrval
		FROM APP_InstanceProp
		WHERE
			attrName = 'Distributed Cluster Type'
			AND modified = 0
	IF @clusterType = 1 OR @clusterType = 2 OR @clusterType = 5 OR @clusterType = 9 OR @clusterType = 11 OR @clusterType = 13 --Greenplum, HADOOP, WinFS, CASSANDRA, GLUSTERFS, LUSTREFS
		OR @clusterType = 8 -- MongoDB
		OR @clusterType = 16 -- SPLUNK
	BEGIN
		SET @o_xml =
			(SELECT clients.id as '@clientId', clients.name as '@clientName', clients.displayName as '@displayName'
			FROM (SELECT  DISTINCT clientId
					FROM App_Application innerApp
					LEFT JOIN #DistAppTypeOfInst distApp ON innerApp.instance = distApp.instId
WHERE innerApp.appTypeId = 64  AND distApp.clusterType = @clusterType
					) AS f_clients
				 JOIN APP_Client clients ON clients.id = f_clients.clientId
				 INNER JOIN #userClients UC ON clients.id = UC.t_clientId
			FOR XML PATH('clients'), TYPE)
	END
	ELSE IF @clusterType = 3 OR @clusterType = 4 -- UXFS, GPFS
	BEGIN
		SET @o_xml =
			(SELECT clients.id as '@clientId', clients.name as '@clientName', clients.displayName as '@displayName'
			FROM (SELECT  DISTINCT clientId
					FROM App_Application innerApp
					LEFT JOIN #DistAppTypeOfInst distApp ON innerApp.instance = distApp.instId
WHERE innerApp.appTypeId = 64 AND distApp.clusterType IN (3,4)
					) AS f_clients
				 JOIN APP_Client clients ON clients.id = f_clients.clientId
				 INNER JOIN #userClients UC ON clients.id = UC.t_clientId
			FOR XML PATH('clients'), TYPE)
	END
	ELSE IF @clusterType = 0 --Tentatively used for network share clients.
	BEGIN
		SET @o_xml =
			(SELECT clients.id as '@clientId', clients.name as '@clientName', clients.displayName as '@displayName'
			FROM APP_Client clients
			INNER JOIN #userClients UC ON clients.id = UC.t_clientId
WHERE (clients.status & 0x8000000) = 0x8000000
			FOR XML PATH('clients'), TYPE)
	END
ELSE IF @clusterType = 6 -- 6
	BEGIN
		INSERT INTO #DANClients (name, id, osId, hostName, clientStatus, displayName)
		SELECT	DISTINCT client.name, client.id, client.simOperatingSystemid, client.net_hostname, client.status, client.displayName
		FROM	App_Client client
		JOIN #userClients UC ON client.id = UC.t_clientId
		JOIN APP_Application S ON client.id = S.clientId
		JOIN APP_InstanceProp I ON S.instance = I.componentNameId
		JOIN DM2Cloud C ON client.id =C.pseudoclientid
		WHERE I.attrName = 'Distributed Cluster Type' AND attrVal ='6'
		AND (@i_flags = 0 OR (@i_flags = C.cloudType))
		SET @o_xml =
		(SELECT ( SELECT client.id as '@clientId',
						client.name as '@clientName',
						client.hostName as '@hostName',
						client.displayName as '@displayName'
						FOR XML PATH ('client'), TYPE),
				(SELECT os.Type AS '@Type',
						os.SubType AS '@SubType',
						os.id AS '@osId',
					(SELECT cpt.osName AS '@OSName'
					FOR XML PATH ('OsDisplayInfo'), TYPE)
					FOR XML PATH ('osInfo'), TYPE)
			FROM #DANClients client
			LEFT JOIN simOperatingSystem os ON os.id = client.osId
			LEFT JOIN CT_ClientProperties cpt ON CPT.clientId = client.id
			WHERE (os.Type = 'Unix' OR os.Type = 'Windows')
		FOR XML PATH('distributedAppsClients'), TYPE)
	END
	ELSE
	BEGIN
		SET @errorCode = 1
		SET @errorMsg = 'Unknown Cluster type recieved ' + CAST (@clusterType AS NVARCHAR(3))
	END
END
ELSE IF @requestType = 1 --DATA_ACCESS_NODE
BEGIN
	IF @clusterType = 9 --Cassandra
	BEGIN
		INSERT INTO #DANClients (name, id, osId, hostName, displayName)
			SELECT DISTINCT client.name, client.id, client.simOperatingSystemid, cProp.stringVal, client.displayName
			FROM App_Client client
			INNER JOIN #userClients UC ON client.id = UC.t_clientId
			LEFT JOIN SimInstalledPackages pack ON ClientId = client.id
			INNER JOIN APP_ComponentProp cProp ON cProp.componentId = client.id
WHERE pack.simPackageID = 1211 AND cProp.propertyTypeId = 2102 AND cProp.modified = 0
	END
	ELSE IF @clusterType = 16 -- SPLUNK
	BEGIN
			INSERT INTO #DANClients (name, id, osId, displayName)
			SELECT DISTINCT client.name, client.id, client.simOperatingSystemid, client.displayName
			FROM App_Client client
			INNER JOIN #userClients UC ON client.id = UC.t_clientId
			INNER JOIN SimInstalledPackages pack ON ClientId = client.id
WHERE pack.simPackageID = 1283 OR pack.simPackageID = 382
	END
	ELSE IF @clusterType = 2 --Hadoop
	BEGIN
		INSERT INTO #DANClients (name, id, osId, displayName)
			SELECT DISTINCT client.name, client.id, client.simOperatingSystemid, client.displayName
			FROM App_Client client
			INNER JOIN #userClients UC ON client.id = UC.t_clientId
			INNER JOIN SimInstalledPackages pack ON ClientId = client.id
WHERE (pack.simPackageID = 1282)
OR (pack.simPackageID = 1101 AND (client.releaseId * 1000 + pack.HighestSP) < 16013)
	END
	ELSE IF @clusterType = 8 --MongoDB_IDA
	BEGIN
		INSERT INTO #DANClients (name, id, osId, hostName, clientStatus, displayName)
			SELECT	DISTINCT client.name, client.id, client.simOperatingSystemid, client.net_hostname, client.status, client.displayName
			FROM	App_Client client
INNER JOIN #userClients UC ON client.id = UC.t_clientId AND client.releaseId >= 16
INNER JOIN SimInstalledPackages pack ON pack.ClientId = client.id AND pack.simPackageID IN (702, 1101)
	END
	ELSE
	BEGIN
		INSERT INTO #DANClients (name, id, osId, hostName, clientStatus, displayName)
			SELECT	DISTINCT client.name, client.id, client.simOperatingSystemid, client.net_hostname, client.status, client.displayName
			FROM	App_Client client
INNER JOIN #userClients UC ON client.id = UC.t_clientId AND client.releaseId >= 16
INNER JOIN SimInstalledPackages pack ON pack.ClientId = client.id AND pack.simPackageID IN (702, 1101)
			UNION ALL
			SELECT	DISTINCT client.name, client.id, client.simOperatingSystemid, client.net_hostname, client.status, client.displayName
			FROM	App_Client client
INNER JOIN #userClients UC ON client.id = UC.t_clientId AND client.releaseId >= 16
				INNER JOIN APP_VMToPMMap AVP ON client.id = AVP.VMClientId
INNER JOIN SimInstalledPackages pack ON pack.ClientId = AVP.PMClientId AND pack.simPackageID IN (702, 1101)
	END
	IF @clientAppType != 0
	BEGIN
		IF @clientAppType = 2 -- NUTANIX
		BEGIN
			IF @clusterType = 4 -- UNIX, pick only Linux clients
			BEGIN
			SET @o_xml =
				(SELECT client.id as '@clientId', client.name as '@clientName', client.displayName as '@displayName'
					FROM #DANClients client
					LEFT JOIN simOperatingSystem os ON os.id = client.osId
					INNER JOIN SimInstalledPackages pack ON pack.ClientId = client.id
					WHERE os.SubType = 'Linux'
					AND pack.simPackageID IN (702, 1101) -- FileSystem
					AND pack.HighestSP >= 15  -- SP15 and above
				FOR XML PATH('clients'), TYPE)
			END
			ELSE IF @clusterType = 5 -- Windows
			BEGIN
				SET @o_xml =
				(SELECT client.id as '@clientId', client.name as '@clientName', client.displayName as '@displayName'
					FROM #DANClients client
					LEFT JOIN simOperatingSystem os ON os.id = client.osId
					INNER JOIN SimInstalledPackages pack ON pack.ClientId = client.id
					WHERE os.Type = 'Windows'
					AND pack.simPackageID IN (702, 1101) -- FileSystem
					AND pack.HighestSP >= 15  -- SP15 and above
				FOR XML PATH('clients'), TYPE)
			END
		END
		ELSE IF @clientAppType = 10 -- QUMULO
		BEGIN
			IF @clusterType = 4 -- UNIX, pick only Linux clients
			BEGIN
			SET @o_xml =
				(SELECT client.id as '@clientId', client.name as '@clientName', client.displayName as '@displayName'
					FROM #DANClients client
					LEFT JOIN simOperatingSystem os ON os.id = client.osId
					INNER JOIN SimInstalledPackages pack ON pack.ClientId = client.id
					WHERE os.SubType = 'Linux'
					AND pack.simPackageID IN (702, 1101) -- FileSystem
					AND pack.HighestSP >= 21  -- SP21 and above
				FOR XML PATH('clients'), TYPE)
			END
			ELSE IF @clusterType = 5 -- Windows
			BEGIN
				SET @o_xml =
				(SELECT client.id as '@clientId', client.name as '@clientName', client.displayName as '@displayName'
					FROM #DANClients client
					LEFT JOIN simOperatingSystem os ON os.id = client.osId
					INNER JOIN SimInstalledPackages pack ON pack.ClientId = client.id
					WHERE os.Type = 'Windows'
					AND pack.simPackageID IN (702, 1101) -- FileSystem
					AND pack.HighestSP >= 21  -- SP21 and above
				FOR XML PATH('clients'), TYPE)
			END
		END
	END
ELSE IF @appType = 64
	BEGIN
		IF @clusterType = 1 OR @clusterType = 2 OR @clusterType = 11 OR @clusterType = 13 -- GREENPLUM, HADOOP, GLUSTERFS, LUSTREFS
		BEGIN
		-- linux clients
		SET @o_xml =
			(SELECT client.id as '@clientId', client.name as '@clientName', client.displayName as '@displayName'
				FROM #DANClients client
				LEFT JOIN simOperatingSystem os ON os.id = client.osId
				WHERE os.SubType = 'Linux'
			FOR XML PATH('clients'), TYPE)
		END
		ELSE IF @clusterType = 3 -- GPFS
		BEGIN
		-- linux and aix clients
		SET @o_xml =
			(SELECT client.id as '@clientId', client.name as '@clientName', client.displayName as '@displayName'
				FROM #DANClients client
				LEFT JOIN simOperatingSystem os ON os.id = client.osId
				WHERE os.SubType = 'Linux' OR os.SubType = 'AIX'
			FOR XML PATH('clients'), TYPE)
		END
		ELSE IF @clusterType = 4 -- UXFS
		BEGIN
		-- Unix clients
		SET @o_xml =
			(SELECT client.id as '@clientId', client.name as '@clientName', client.displayName as '@displayName'
				FROM #DANClients client
				LEFT JOIN simOperatingSystem os ON os.id = client.osId
				WHERE os.Type = 'Unix'
			FOR XML PATH('clients'), TYPE)
		END
		ELSE IF @clusterType = 5 -- WINFS
		BEGIN
			-- MR 284687: Netapp Recall Configuration tab should not list monitoring clients for primary and secondary client selection.
IF ((@i_flags & CAST(0x20000 AS INT)) <> 0) AND (@i_clientId > 0)
			BEGIN
				DECLARE @networkHostName NVARCHAR(MAX) = ''
				IF OBJECT_ID('tempdb.dbo.#MonitoringClientsTbl') IS NOT NULL
					DROP TABLE #MonitoringClientsTbl
				CREATE TABLE #MonitoringClientsTbl
				(
					clientId INT PRIMARY KEY
				)
				SELECT @networkHostName = net_hostname FROM APP_Client (NOLOCK) WHERE id = @i_clientID
				INSERT INTO #MonitoringClientsTbl
					EXEC APPGetFileMonitoringClients @networkHostName
				DELETE T
				FROM #DANClients T
					INNER JOIN #MonitoringClientsTbl M
						ON T.id = M.clientId
				IF OBJECT_ID('tempdb.dbo.#MonitoringClientsTbl') IS NOT NULL
					DROP TABLE #MonitoringClientsTbl
			END
			-- windows clients
			SET @o_xml =
			(SELECT client.id as '@clientId', client.name as '@clientName', client.displayName as '@displayName'
				FROM #DANClients client
				LEFT JOIN simOperatingSystem os ON os.id = client.osId
				WHERE os.Type = 'Windows'
			FOR XML PATH('clients'), TYPE)
		END
		ELSE IF @clusterType = 9 -- Cassandra
		BEGIN
		SET @o_xml =
			(SELECT client.id as '@clientId', client.name as '@clientName', client.hostName as '@hostName', client.displayName as '@displayName'
				FROM #DANClients client
			FOR XML PATH('clients'), TYPE)
		END
		ELSE IF @clusterType = 16 -- SPLUNK
		BEGIN
		SET @o_xml =
			(SELECT client.id as '@clientId', client.name as '@clientName', client.hostName as '@hostName', client.displayName as '@displayName'
				FROM #DANClients client
			FOR XML PATH('clients'), TYPE)
		END
		ELSE IF @clusterType = 8 -- MONGODB_IDA
		BEGIN
			-- Unix and windows clients with MA installed
			IF @includeOsInfo = 1
			BEGIN
				SET @o_xml =
				(SELECT ( SELECT client.id as '@clientId', client.name as '@clientName',client.hostName as '@hostName', client.displayName as '@displayName'  FOR XML PATH ('client'), TYPE), (SELECT os.Type AS '@Type', os.SubType AS '@SubType', os.id AS '@osId', (SELECT cpt.osName AS '@OSName' FOR XML PATH ('OsDisplayInfo'), TYPE) FOR XML PATH ('osInfo'), TYPE)
					FROM #DANClients client
					LEFT JOIN simOperatingSystem os ON os.id = client.osId
					LEFT JOIN SimInstalledPackages pack ON pack.ClientId = client.id
					LEFT JOIN SimInstalledPackages mongo_pack ON mongo_pack.ClientId = client.id
					LEFT JOIN CT_ClientProperties cpt ON CPT.clientId = client.id
					WHERE (os.Type = 'Unix' OR os.Type = 'Windows') AND
					pack.simPackageID IN (1301, 51)
					AND mongo_pack.simPackageID IN (1281, 381)
AND (client.clientStatus & 0x00002 <> 0x00002)
AND (client.clientStatus & 0x00004 <> 0x00004)
				FOR XML PATH('distributedAppsClients'), TYPE)
			END
			ELSE
			BEGIN
				SET @o_xml =
					(SELECT client.id as '@clientId', client.name as '@clientName', client.displayName as '@displayName'
						FROM #DANClients client
						LEFT JOIN simOperatingSystem os ON os.id = client.osId
						LEFT JOIN SimInstalledPackages pack ON pack.ClientId = client.id
						LEFT JOIN SimInstalledPackages mongo_pack ON mongo_pack.ClientId = client.id
						WHERE (os.Type = 'Unix' OR os.Type = 'Windows') AND
						pack.simPackageID IN (1301, 51)
						AND mongo_pack.simPackageID IN (1281, 381)
AND (client.clientStatus & 0x00002 <> 0x00002)
AND (client.clientStatus & 0x00004 <> 0x00004)
					FOR XML PATH('clients'), TYPE)
			END
		END
		ELSE
		BEGIN
			SET @errorCode = 1
			SET @errorMsg = 'Unknown Cluster type recieved: ' + CAST (@clusterType AS NVARCHAR(3))
		END
	END
	ELSE
	BEGIN
		-- Select clients with same apptype as input
		SET @o_xml =
			(SELECT client.id as '@clientId', client.name as '@clientName', client.displayName as '@displayName'
				FROM #DANClients client
				JOIN APP_IDAName ida ON client.id = ida.clientId
				WHERE ida.appTypeId = @appType
				AND ((SELECT clientV.releaseId
						FROM APP_Client clientV
WHERE client.id = clientV.id) > 16 --should be v12 or greater
					OR (SELECT HighestSP
						FROM SimInstalledPackages pack
						WHERE pack.ClientId = client.id
AND pack.simPackageID IN (702, 1101)) >= 5 ) --OR File system must be atleast sp5 or above
			FOR XML PATH('clients'), TYPE)
	END
END
ELSE IF @requestType = 2 --PROXY Nodes for NAS
BEGIN
	CREATE TABLE #PNClients (name NVARCHAR(510),id INT, osId INT, displayName NVARCHAR(255))
	BEGIN
		INSERT INTO #PNClients
			SELECT DISTINCT client.name, client.id, client.simOperatingSystemid, client.displayName
			FROM App_Client client
			INNER JOIN #userClients UC ON client.id = UC.t_clientId
			INNER JOIN SimInstalledPackages pack ON ClientId = client.id
		WHERE client.releaseId >= 16 AND
						  --Referred from getclientlistAndInitialProps.sp#1116
pack.simPackageID IN (51, 1301) AND pack.HighestSP >= 9
	END
		BEGIN
		SET @o_xml =
			(SELECT client.id as '@clientId', client.name as '@clientName', client.displayName as '@displayName'
				FROM #PNClients client
			FOR XML PATH('clients'), TYPE)
		END
	END
ELSE
BEGIN
	SET @errorCode = 2
	SET @errorMsg = 'Unknown Request type recieved ' + CAST (@requestType AS NVARCHAR(3))
END
	SELECT (SELECT  @o_xml,
			(SELECT
						@errorCode as '@errorCode',
						@errorMsg as '@errorMessage'
						FOR XML PATH('response'), TYPE)
			FOR XML PATH('App_GetDistributedAppsClientsResponse'), TYPE) as o_xml
IF object_id('temp.dbo.#DistAppTypeOfInst') IS NOT null DROP TABLE #DistAppTypeOfInst
IF object_id('temp.dbo.#DANClients') IS NOT null DROP TABLE #DANClients
IF object_id('temp.dbo.#PNClients') IS NOT null DROP TABLE #PNClients
IF OBJECT_ID('tempdb.dbo.#userClients') IS NOT NULL DROP TABLE #userClients
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDistributedAppsClients')
	delete from GxQscripts where name = 'AppGetDistributedAppsClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDistributedAppsClients')
	delete from GXDBVersions where aliasname = 'AppGetDistributedAppsClients'
GO

insert into GXDBVersions values(2, 'AppGetDistributedAppsClients',  '00010001000200470000', 'AppGetDistributedAppsClients', '00010001000200470000')
GO

