

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDiscoveryContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +-----------------------------------------------------------------------+
--  |                       SP: "AppGetDiscoveryContent.sp"                           |
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetDiscoveryContent <<<'

IF EXISTS (select * from sysobjects where name='AppGetDiscoveryContent')
	drop procedure AppGetDiscoveryContent
IF EXISTS (select * from GxQscripts where name='AppGetDiscoveryContent')
	delete from GxQscripts where name = 'AppGetDiscoveryContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDiscoveryContent')
	delete from GXDBVersions where aliasname = 'AppGetDiscoveryContent'
GO
print '... Creating Procedure: AppGetDiscoveryContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetDiscoveryContent
  @i_xml XML
AS
DECLARE @o_xml XML
DECLARE @scList TABLE
(
	id int,
	name nvarchar(256)
)
DECLARE @instanceId int
DECLARE @discoveryType INT
DECLARE @contentType INT
SET @instanceId =  @i_xml.value('(App_DiscoveryContentReq/subclientList/@instanceId)[1]','int')
SET @discoveryType = @i_xml.value('(App_DiscoveryContentReq/@discoveryType)[1]', 'int')
IF @discoveryType = 5
	SET @contentType = 135
ELSE
	SET @contentType = 134
INSERT INTO @scList
SELECT id,subclientname FROM APP_Application AA WHERE instance = @instanceId AND (subclientname like 'Do Not Backup' OR
((AA.subclientStatus & 0x00020)=0
AND (AA.subclientStatus & 0x00004)=0
AND (AA.subclientStatus & 0x00002)=0
AND AA.appTypeId <> 1000 ))                  	  --DR Subclient
SET @o_xml =
(SELECT sList.id 'scEntity/@subclientId', sList.name 'scEntity/@subclientName',
(SELECT attrName '@contentName',
		attrVal '@contentValue',
		attrType '@contentType'
FROM	APP_SubClientProp ASP
WHERE	(attrType=@contentType) AND modified=0 AND componentNameId=sList.id
FOR XML PATH ('contentInfo'),type)
FROM (SELECT DISTINCT id,name FROM @scList)  sList
FOR XML PATH ('scDiscoveryContent'), root ('App_DiscoveryContent'))
SELECT @o_xml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDiscoveryContent')
	delete from GxQscripts where name = 'AppGetDiscoveryContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDiscoveryContent')
	delete from GXDBVersions where aliasname = 'AppGetDiscoveryContent'
GO

insert into GXDBVersions values(2, 'AppGetDiscoveryContent',  '00000000000000000000', 'AppGetDiscoveryContent', '00000000000000000000')
GO

