

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDevices.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetDevices.sp,v $ $Id: AppGetDevices.sp,v 1.2.2.47 2020/07/07 16:14:06 cnaik Exp $";
--	+===================================================================+
--	| APPGetLaptopClientList - Get Laptop Client list 					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetDevices')
BEGIN
	print '>>> Drop Stored Procedure: APPGetDevices <<<'
	drop procedure APPGetDevices
END
IF EXISTS (select * from GxQscripts where name='APPGetDevices')
	delete from GxQscripts where name = 'APPGetDevices'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetDevices')
	delete from GXDBVersions where aliasname = 'APPGetDevices'
GO
print '... Creating Procedure: APPGetDevices'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetDevices
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @xmlString XML OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString VARCHAR(1024) OUTPUT
-----------------------------------------------------------
AS
  DECLARE @r_xmlString XML;
BEGIN
	SET NOCOUNT ON
	-- AEB:	ProdCS incurring high level of blocking waits on JM Tables.
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @function		VARCHAR(80) = 'APPGetDevices'
	SET @o_errCode = 0 -- BE OPTIMISTIC
	SET @o_errString = ''
	DECLARE @excludeStatusMask			INT = 48		--(cast(0x00010 AS INT) | cast(0x00020 AS INT))
	DECLARE @excludeStatusMaskForSync	INT = 54		--(cast(0x00002 AS INT) | cast(0x00004 AS INT) | cast(0x00010 AS INT) | cast(0x00020 AS INT))
	IF object_id('tempdb.dbo.#clientList') IS NOT NULL
		DROP TABLE #clientList
	CREATE TABLE #clientList (
		cId INT NOT NULL,
		clientName NVARCHAR(255) DEFAULT '',
		hostName NVARCHAR(255) DEFAULT '',
		appId INT DEFAULT 0,
		instId INT DEFAULT 0,
		bSet INT DEFAULT 0,
		subId INT DEFAULT 0,
		lastbkupTime INT DEFAULT 0,
		lastSuccessBkupTime INT DEFAULT 0,
		nextBkupTime INT DEFAULT 0,
		backupSize BIGINT DEFAULT 0,
		lastDataProtectedTime INT DEFAULT 0,
		capabilities BIGINT DEFAULT 0,
		totalbackupsize BIGINT DEFAULT 0,
		totalbackupSizeSubClient BIGINT DEFAULT 0,
		totalbackupSizeBackupset BIGINT DEFAULT 0,
		isOwner INT DEFAULT 1,
		flag INT DEFAULT 0,
		lastOnlineTime INT DEFAULT 0,
		lastOfflineTime INT DEFAULT 0,
		isSyncAllowed INT DEFAULT 0,
		clientStatus INT DEFAULT 0,
		specialClientFlags INT DEFAULT 0,
		isLockedClient INT DEFAULT 0,
		isIndexingV2 INT DEFAULT 0,
		isUserCentricClient INT DEFAULT 0,
		physicalClientID INT DEFAULT 0,
		planId INT DEFAULT 0,
		planName NVARCHAR(255) DEFAULT '',
		activationUserId INT DEFAULT 0,
		activationUserName NVARCHAR(255) DEFAULT '',
        activatedMode INT,
		isClientDeconfigured INT DEFAULT 2,
		isMAForClientDeconfigured INT DEFAULT 2,
		-- SubClient Content - populate when @getContent = 1
		assocSubC INT DEFAULT 0,
		useSCPfilters INT DEFAULT 0,
		useGlobalFilter INT DEFAULT 0,
		lastGeoLocation			xml DEFAULT NULL,
		lastGeoLocationTime		int DEFAULT NULL,
		geoLocationDisplayMode	int DEFAULT NULL,
		taskId					INT DEFAULT NULL,
		features				XML DEFAULT NULL,
		encryptionXML			XML	DEFAULT NULL,
		showDLP INT DEFAULT 0,  -- The default is to hide DLP unless set in plan or clientgroup as per checks in AppGetDLPProps.spb
		regionId int,
		regionName nvarchar(127),
		regionDisplayName nvarchar(127),
		companyid				INT DEFAULT NULL,
		companyName				NVARCHAR(127) DEFAULT NULL,
		companyDomainName		NVARCHAR(127) DEFAULT NULL,
		restoreAuthUsersXML		XML DEFAULT NULL,
		lastBackupJobInfo XML,
		SLAStatus INT DEFAULT(3),
		SLACategory INT DEFAULT(0),
		SLACategoryDescription  NVARCHAR(255) DEFAULT '',
		nwReadiness INT DEFAULT(0),
		nwReadinessUpdatedTime  BIGINT DEFAULT(null),
		retireClientPhase INT DEFAULT(0),
		isCloudLaptop INT DEFAULT 0
		)
	CREATE CLUSTERED INDEX ClientList_cId_IDX ON #clientList (cId)
		-- SubClient Filter Tables
		IF object_id('tempdb.dbo.#GlobalExcludeFilters') IS NOT NULL
			DROP TABLE #GlobalExcludeFilters
		CREATE TABLE #GlobalExcludeFilters
		(
			fsType	INT,		-- 1 Windows, 2 UNIX
			value	NVARCHAR(MAX)
		)
		CREATE CLUSTERED INDEX GlobalExcludeFilters_Idx ON #GlobalExcludeFilters(fsType)
		IF object_id('tempdb.dbo.#SubClientContent') IS NOT NULL
			DROP TABLE #SubClientContent
		CREATE TABLE #SubClientContent (
			contentType		INT,		-- 1 subclient type, 2 subclient policy type
			scId			INT,
			created			INT,
			modified		INT,
			fileName		NVARCHAR(1024),
			type			INT
		)
		CREATE CLUSTERED INDEX SubClientContent_Idx ON #SubClientContent(contentType, scId)
		IF object_id('tempdb.dbo.#DLPProperties') IS NOT NULL
			DROP TABLE #DLPProperties
		CREATE TABLE #DLPProperties
		(
			dlpClientId      int PRIMARY KEY,
			isDLPEnabledOnClient int,
			isDLPEnabledOnGroup int,
			isDLPRMEnabledOnGroup int,
			isDLPRMEnabledOnClient int,
			propertiesXML      XML
		)
		IF object_id('tempdb.dbo.#runTimeInfo') IS NOT NULL
		DROP TABLE #runTimeInfo
		CREATE TABLE #runTimeInfo
		(
			  taskId int,
			  subclientId int,
			  frequencyType int,
			  nextBackupTime int
		)
		CREATE CLUSTERED INDEX runTimeInfo_subclientId_nextBackupTime_Idx on #runTimeInfo(subclientId, nextBackupTime);
	BEGIN TRY
		-----------------------------------------------
		--- EXTRACT DATA FROM THE XML                              ---
		-----------------------------------------------
		DECLARE @userId		INT = 0
		SELECT @userId = ref.value('@userId', 'INT')
		FROM @xmlString.nodes('App_LapTopClientListReq/user') R(ref)
		DECLARE @localeId INTEGER = 0
		SELECT
			@localeId = ISNULL(ref.value('@localeId', 'INT'), 0)
		FROM @xmlString.nodes('App_LapTopClientListReq/locale') R(ref)
		DECLARE @clientId	INT = 0
		SELECT
			@clientId = CASE
							WHEN c.clientId IS NOT NULL AND c.clientId > 0 THEN c.clientId
							WHEN c.clientId IS NULL OR c.clientId = 0 THEN (
									SELECT ISNULL(id, 0)
									FROM APP_Client
									WHERE
										c.clientName IS NOT NULL
										AND c.clientName <> ''
										AND name = c.clientName
								)
							ELSE 0
						END
		FROM (
				SELECT
					ref.value('@clientId', 'INT') clientId,
					ref.value('@clientName', 'NVARCHAR(256)') clientName
				FROM @xmlString.nodes('App_LapTopClientListReq/client') R(ref)
			) c
		DECLARE @getFsLikeClients	INT = 0
		DECLARE @getEndUserClient	INT = 0
		DECLARE @clientListType		INT = 3 -- Unique Clients
		DECLARE @filterUserId		INT = 0
		DECLARE @getContent			INT = 0
		DECLARE @getGeoLocation     INT = 0
		DECLARE @filterProviderId   INT = -1
		DECLARE @userCompanyId      INT = ISNULL(dbo.AppGetCompanyForUserOrUserGroup(@userId, 1), -1)
		DECLARE @isGeolocationDisabledForCompany     INT = 0
		DECLARE @nowUTCTimeUnix		INT = dbo.getunixtimebig(getutcdate())
		SELECT
			@filterUserId = ISNULL(ref.value('@userId', 'INT'), 0)
		FROM @xmlString.nodes('App_LapTopClientListReq/filter/userFilter') R(ref)
		SELECT
			@getFsLikeClients = ISNULL(ref.value('@getFsLikeClients', 'INT'), 0),
			@getEndUserClient = ISNULL(ref.value('@getEndUserClient', 'INT'), 0),
			@clientListType = ISNULL(ref.value('@clientListType', 'INT'), 3),
			-- If getContent=0 disable Global Filters and SCP Filters
			@getContent = ISNULL (ref.value('@getContent', 'INT'), ISNULL(ref.value('@getAllProperties', 'INT'), 0)),
			@getGeoLocation = ISNULL(ref.value('@getAllProperties', 'INT'), 0)
		FROM @xmlString.nodes('App_LapTopClientListReq/filter') R(ref)
		SELECT @filterProviderId = ISNULL(ref.value('@providerId', 'INT'), -1)
			FROM @xmlString.nodes('App_LapTopClientListReq/filter/provider') R(ref)
		DECLARE @useGlobalFilterForAllSubClients INT = 0
		IF (@getContent = 1)
		BEGIN
			SELECT @useGlobalFilterForAllSubClients = CAST(value AS INT)
			FROM GXGlobalParam
			WHERE name = N'Use Global Filters for all Subclients'
				AND modified = 0
		END
	-------------------------------------------------------------------------
	--  FETCH THE LIST OF CLIENTS WE WILL BE REPORTING ON                  --
	-------------------------------------------------------------------------
	IF object_id('tempdb.dbo.#tempLaptopSecurityObjects') IS NOT NULL
		DROP TABLE #tempLaptopSecurityObjects
create table  #tempLaptopSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2009, 0, '#tempLaptopSecurityObjects'
	IF OBJECT_ID('tempdb.dbo.#appgetdeviceClientList') IS NOT NULL
			DROP TABLE #appgetdeviceClientList
		CREATE TABLE #appgetdeviceClientList (
			clientId INT,
			t_appTypeId INT,
			t_instanceId INT,
			t_backupsetId INT,
			t_subclientId INT
			)
		CREATE INDEX appgetdeviceClientList_idx1 ON #appgetdeviceClientList (clientId)
		IF object_id('tempdb.dbo.#CompanyClients') IS NOT NULL
			DROP TABLE #CompanyClients
		CREATE TABLE #CompanyClients
		(
			clientId	INT
		)
		CREATE CLUSTERED INDEX CompanyClients_Idx ON #CompanyClients(clientId)
		EXEC sec_getIdaObjectsForUser @userId,
3,
			0 /*View*/,
			0,
			'#appgetdeviceClientList'
		IF @filterUserId <> 0
		BEGIN
			DELETE
			FROM #appgetdeviceClientList
			WHERE clientId NOT IN (
					SELECT DISTINCT clientId
					FROM sec_getClientOwnersExpandUG Owners
					WHERE Owners.userId = @filterUserId
					)
		END
		IF @clientId <> 0
		BEGIN
			DELETE
			FROM #appgetdeviceClientList
			WHERE clientId <> @clientId
		END
		IF @filterProviderId <> -1
		BEGIN
		INSERT INTO #CompanyClients
			SELECT ACGA.clientId from APP_ClientGroupAssoc ACGA WITH(NOLOCK)
				INNER JOIN App_CompanyProp ACP WITH(NOLOCK) ON
ACP.attrValInt=ACGA.clientGroupId AND ACP.attrName='Associated Smart Client Group' AND ACP.componentNameId=@filterProviderId AND ACP.modified=0
		DELETE
		FROM #appgetdeviceClientList
		WHERE clientId NOT IN
					(SELECT clientId FROM #CompanyClients)
		END
		DECLARE @defaultGeoLocatoinDisplayMode  INT = 2
		DECLARE @globalGeoLocatoinDisplayMode   INT
		SET @globalGeoLocatoinDisplayMode = ISNULL((SELECT TOP 1 value FROM GXGlobalParam WHERE modified = 0  AND name = 'Geo Location Display Mode'), @defaultGeoLocatoinDisplayMode);
		IF (@globalGeoLocatoinDisplayMode IS NULL OR @globalGeoLocatoinDisplayMode < 0 OR @globalGeoLocatoinDisplayMode > 2)
			SET @globalGeoLocatoinDisplayMode = @defaultGeoLocatoinDisplayMode
SET @isGeolocationDisabledForCompany = (SELECT 1 FROM APP_CompanyProp where componentNameID=@userCompanyId AND attrname='Geo Location Display Mode' AND attrval='0' AND modified=0 AND cs_attrName=checksum('Geo Location Display Mode'))
		-- Logic -- First preference to Company level setting to see if disabled at company level
		--		 -- If not disabled at comp[any level, then we see if disabled for global setting		--		 -- If any one of them is disabled, we will not show maps
		IF (@isGeolocationDisabledForCompany=1) OR (@globalGeoLocatoinDisplayMode=0)
		BEGIN
			SET @getGeoLocation = 0
		END
		INSERT #clientList (
			Cid,
			clientName,
			hostname,
			clientStatus,
			specialClientFlags,
			appId,
			capabilities,
			planId,
			isUserCentricClient,
			physicalClientID,
			planName,
            activatedMode,
			isClientDeconfigured,
			isMAForClientDeconfigured,
			bSet,
			flag,
			subId,
			instId,
			lastDataProtectedTime,
			isSyncAllowed,
			isLockedClient,
			isIndexingV2,
			lastGeoLocation,
			lastGeoLocationTime,
			geoLocationDisplayMode,
			backupSize,
			totalbackupSizeSubClient,
			totalbackupSizeBackupset,
			isCloudLaptop
			)
		SELECT
			c.id,
			c.displayName,
			c.net_hostName,
			c.STATUS,
			c.specialClientFlags,
			AAP.appTypeId,
			0 capabilities,
			ISNULL(CAST(pid.attrVal AS INT), 0),
			ISNULL(CAST(ucc.attrVal AS INT), 0),
			ISNULL(CAST(pcid.attrVal AS INT), 0),
			ISNULL(p.name, ''),
            ISNULL(acpact.attrVal,0),
			ISNULL(CAST(acpcs.attrVal AS INT), 2),
			ISNULL(CAST(acpma.attrVal AS INT), 2),
			ISNULL(AAP.backupSet, 0),
			ISNULL(AAP.subclientStatus, 0),
			ISNULL(AAP.id, 0),
			ISNULL(AAP.instance, 0),
			ISNULL(CAST(ASCP.attrval AS INT), 0),
			CASE	-- Consider only clients which are laptops and not deleted
				WHEN ((c.STATUS & 4096) = 4096 AND (c.STATUS & @excludeStatusMaskForSync) = 0) THEN 1
				ELSE 0
			END,
			CASE
				WHEN eds.attrVal IS NULL THEN 0
WHEN eds.attrVal = 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a' THEN 1
				ELSE 0
			END,
			ISNULL(CAST(idxV2.attrVal AS INT), 0),
			REPLACE(gl.attrVal, N'App_GeoLocation', 'lastGeoLocation'),
			ISNULL(gl.created, 0),
			ISNULL(gl1.attrVal, @globalGeoLocatoinDisplayMode),
			ISNULL(CAST(ASCP1.attrval AS BIGINT), 0),
			ISNULL(CAST(ASCP2.attrval AS BIGINT), 0),
			ISNULL(CAST(ABP.attrval AS BIGINT), 0),
			ISNULL(CAST(cloudAPP.attrVal AS INT), 0)
		FROM #appgetdeviceClientList um
			INNER JOIN APP_Client c
				ON c.id = um.clientId
AND c.STATUS & 0x1000 = 0x1000
			LEFT OUTER JOIN APP_ClientProp pid ON
				pid.componentNameId = um.clientId
				AND pid.modified = 0
AND pid.attrName = 'Associated Plan'
				AND ISNUMERIC(pid.attrVal) = 1
			LEFT OUTER JOIN APP_ClientProp ucc ON
				ucc.componentNameId = um.clientId
				AND ucc.modified = 0
AND ucc.attrName = 'User Centric Client'
				AND ISNUMERIC(ucc.attrVal) = 1
			LEFT OUTER JOIN APP_ClientProp pcid ON
				pcid.componentNameId = um.clientId
				AND pcid.modified = 0
AND pcid.attrName = 'Physical Client Id'
				AND ISNUMERIC(pcid.attrVal) = 1
			LEFT OUTER JOIN APP_Plan p ON
				pid.attrVal IS NOT NULL
				AND p.id = CAST(pid.attrVal AS INT)
			LEFT OUTER JOIN APP_ClientProp acpact ON
				acpact.componentNameId = um.clientId
				AND acpact.modified = 0
AND acpact.attrName = 'Activated Mode'
				AND ISNUMERIC(acpact.attrVal) = 1
			LEFT OUTER JOIN APP_ClientProp acpcs ON
				acpcs.componentNameId = um.clientId
				AND acpcs.modified = 0
				AND acpcs.attrName = 'PlatformDeleted 4'
				AND ISNUMERIC(acpcs.attrVal) = 1
			LEFT OUTER JOIN APP_ClientProp acpma ON
				acpma.componentNameId = um.clientId
				AND acpma.modified = 0
				AND acpma.attrName = 'PlatformDeleted 2'
				AND ISNUMERIC(acpma.attrVal) = 1
			INNER JOIN APP_Application AAP
ON (AAP.subClientStatus & 0x00008) = 0x00008 AND AAP.clientId=um.clientId AND AAP.subclientStatus & @excludeStatusMask = 0
			INNER JOIN APP_BackupSetName BS
ON BS.id=AAP.backupSet AND (BS.STATUS & 0x00008) = 0x00008
			INNER JOIN APP_AppTypeGroupAssoc ATGA
				ON AAP.appTypeId=ATGA.appTypeId AND ATGA.appGroupId=35 AND ATGA.typeOfGroup=0
			LEFT OUTER JOIN APP_SubClientProp ASCP
				ON ASCP.componentNameId=AAP.id AND ASCP.attrname='Last Data Protected Time' AND ASCP.modified=0 AND ASCP.cs_attrName = CHECKSUM(N'Last Data Protected Time')
			LEFT OUTER JOIN APP_SubClientProp ASCP1
				ON ASCP1.componentNameId=AAP.id AND ASCP1.attrname='Last Backup Size' AND ASCP1.modified=0 AND ASCP1.cs_attrName = CHECKSUM(N'Last Backup Size')
			LEFT OUTER JOIN APP_SubClientProp ASCP2
				ON ASCP2.componentNameId=AAP.id AND ASCP2.attrname='Application Size' AND ASCP2.modified=0 AND ASCP2.cs_attrName = CHECKSUM(N'Application Size')
			LEFT OUTER JOIN APP_BackupSetProp ABP
				ON ABP.componentNameId=AAP.backupSet AND ABP.attrname='Application Size' AND ABP.modified=0
			LEFT OUTER JOIN APP_ClientProp eds ON
				eds.componentNameId = c.id
				AND eds.modified = 0
AND eds.attrName = '7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807'
				AND ISNUMERIC(CASE eds.attrVal
WHEN  'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a'  THEN 1
														ELSE 0
																  END) = 1
			LEFT OUTER JOIN APP_ClientProp idxV2 ON
				idxV2.componentNameId = c.id
				AND idxV2.modified = 0
				AND idxV2.attrName = dbo.GetIndexingV2PropNameByAppType(AAP.appTypeId)
				AND ISNUMERIC(idxV2.attrVal) = 1
			LEFT OUTER JOIN APP_ClientProp gl ON
				@getGeoLocation = 1
				AND gl.componentNameId = c.id
				AND gl.modified = 0
				AND gl.attrName = 'Client Geo Location'
				and  gl.attrVal LIKE '<App_GeoLocation%status_code=''SUCCESS''%'
			LEFT OUTER JOIN APP_ClientProp gl1 ON
				@getGeoLocation = 1
				AND gl1.componentNameId = c.id
				AND gl1.modified = 0
				AND gl1.attrName = 'Geo Location Display Mode'
			LEFT OUTER JOIN APP_SubClientProp cloudAPP ON
cloudAPP.componentNameId = AAP.id AND cloudAPP.modified = 0 AND cloudAPP.attrName = 'Cloud Mode Enabled' AND cloudAPP.cs_attrName = CHECKSUM(N'Cloud Mode Enabled')
		WHERE
(c.status & 0x10000000) = 0 -- make sure it is not an edge clients
		-- GET COMPANY DETAILS ONLY FOR CLIENT DETAILS RESPONSE, i.e. WHEN CLIENTID IS PASSED
		IF @clientId <> 0
		BEGIN
			UPDATE CL
				SET companyId = U.id, companyName = U.hostName, companyDomainName = U.domainName
			FROM #clientList CL
INNER JOIN App_ClientProp CP ON CP.componentNameId = CL.Cid AND CP.attrname = 'Installation Company ID' AND CP.modified = 0
			INNER JOIN UMDSPRoviders U ON U.id = CAST(CP.attrVal AS INT)
		END
		IF (@getContent = 1)
		BEGIN
			-- Set SubClient Content filtering
			UPDATE cl
				SET assocSubC = ISNULL(CAST(assocSCP.attrVal AS INT), 0),
					useSCPfilters = ISNULL(CAST(scpFilter.attrVal AS INT), 1),
					useGlobalFilter = ISNULL(CAST(globalFilter.attrVal AS INT), @useGlobalFilterForAllSubClients)
			FROM #clientList cl
				LEFT OUTER JOIN APP_SubClientProp assocSCP ON
					assocSCP.componentNameId = cl.subId
					AND assocSCP.attrName = N'Associated subclient Policy'
					AND assocSCP.cs_attrName = CHECKSUM(N'Associated subclient Policy')
					AND assocSCP.modified = 0
					AND ISNUMERIC(assocSCP.attrVal) = 1
				LEFT OUTER JOIN APP_SubClientProp scpFilter ON
					scpFilter.componentNameId = cl.subId
					AND scpFilter.attrName = N'use SCP filters'
					AND scpFilter.modified = 0
					AND scpFilter.cs_attrName = CHECKSUM(N'use SCP filters')
					AND ISNUMERIC(scpFilter.attrVal) = 1
				LEFT OUTER JOIN APP_SubClientProp globalFilter ON
					(
						(
							ISNULL(CAST(assocSCP.attrVal AS INT), 0) = 0
							AND globalFilter.componentNameId = cl.subId
						)
						OR (
							ISNULL(CAST(assocSCP.attrVal AS INT), 0) <> 0 AND globalFilter.componentNameId = ISNULL(CAST(assocSCP.attrVal AS INT), 0)
						)
					)
                    AND globalFilter.attrName = N'use cs setting for global filters'
                    AND globalFilter.modified = 0
                    AND globalFilter.cs_attrName = CHECKSUM(N'use cs setting for global filters')
			UPDATE #clientList
				SET useGlobalFilter = ISNULL(CAST(scp.attrVal AS INT), @useGlobalFilterForAllSubClients)
			FROM APP_SubClientProp scp
			WHERE
				useGlobalFilter = 0
				AND (
					(
						assocSubC = 0
						AND scp.componentNameId = subId
					)
					OR (
						assocSubC <> 0
						AND scp.componentNameId = assocSubC
					)
				)
				AND scp.attrName = N'use global filters'
				AND scp.modified = 0
				AND scp.cs_attrName = CHECKSUM(N'use global filters')
			-- Get Exclude Filters
			INSERT #GlobalExcludeFilters
                SELECT 1 /* Windows */, Data
				FROM dbo.SplitString(ISNULL((SELECT value FROM GXGlobalParam WHERE modified = 0 AND name = N'Windows FS Exclude Filters'), N''), N' ')
				WHERE Data != N''
				UNION ALL
				SELECT 2 /* UNIX */, Data
				FROM dbo.SplitString(ISNULL((SELECT value FROM GXGlobalParam WHERE modified = 0 AND name = N'Unix FS Exclude Filters'), N''), N' ')
				WHERE Data != N''
			-- Get Content
			INSERT INTO #SubClientContent
				SELECT
					1 /* subclient */,
					cl.subId,
					sff.created,
					sff.modified,
					sff.fileName,
					CASE
						WHEN (
								cl.assocSubC <> 0
								AND sff.type = 1
								)
							THEN 18
						WHEN (
								cl.assocSubC <> 0
								AND sff.type = 3
								)
							THEN 20 -- ADDED TO SUPPORT EXCLUDE FILTERS
						ELSE type
						END AS '@valueType'
				FROM APP_ScFilterFile sff
					INNER JOIN #clientList cl ON
						sff.componentNameId = cl.subId
						AND sff.modified = 0
				UNION ALL
				--associated policy client
				SELECT
					2 /* subclient policy */,
					cl.assocSubC,
					sff.created,
					sff.modified,
					sff.fileName,
					sff.type
				FROM APP_ScFilterFile sff
				INNER JOIN #clientList cl ON
					sff.componentNameId = cl.assocSubC
					AND sff.modified = 0
					AND (
						sff.type = 1
						OR cl.useSCPfilters <> 0
					) -- Conditionally return filters (09May2011)
		END
		UPDATE T1
		SET
			T1.activationUserName=ISNULL(UU.name, T1.activationUserName),
			T1.activationUserId = ISNULL(UU.id, T1.activationUserId)
		FROM #clientList T1
			LEFT OUTER JOIN UMOwners UM WITH(NOLOCK)
ON UM.entityId=T1.cId AND UM.entityType=3  AND UM.isUser=1 AND T1.planId <> 0
			LEFT OUTER JOIN UMUsers UU
				ON UU.id=UM.userOrGroupId
        IF @clientId <> 0
        BEGIN
		        UPDATE T1
		            SET T1.geoLocationDisplayMode=ISNULL(ACP2.attrVal, @globalGeoLocatoinDisplayMode),
		            T1.lastGeoLocation=REPLACE(ACP1.attrVal, N'App_GeoLocation', 'lastGeoLocation'),
		            T1.lastGeoLocationTime=ISNULL(ACP1.created, 0)
		        FROM #clientList T1
			        INNER JOIN APP_ClientProp ACP1
				        ON ACP1.componentNameId=T1.physicalClientID AND ACP1.attrName = 'Client Geo Location'
					        AND  ACP1.attrVal LIKE '<App_GeoLocation%status_code=''SUCCESS''%' AND ACP1.modified = 0
			        LEFT OUTER JOIN APP_ClientProp ACP2
				        ON ACP2.componentNameId=T1.physicalClientID AND ACP2.attrName = 'Geo Location Display Mode' AND ACP2.modified = 0
		        WHERE T1.isUserCentricClient=1 AND T1.physicalClientID <> 0 and @getGeoLocation=1
				-- Populate the privacy settings for given device (Passkey feature)
				DECLARE @authType       integer=1
				DECLARE @enableAuthorizeForRestore integer=0
				DECLARE @expirationTimeStamp integer = 0
IF EXISTS(SELECT 1 FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName='AuthorizationType' AND attrVal = '2' AND modified = 0)
				BEGIN
					SET @authType = 2  -- USE_PASSKEY (attrVal = '2')
					DECLARE @authUsers XML = ISNULL((SELECT cast(attrVal as xml) FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId
AND attrName='AuthorizedUsersForRestore' AND modified = 0),'')
					SET @expirationTimeStamp = ISNULL((select T.c.query('..').value('(/authorizedUsers/@expirationTime)[1]','integer') from @authUsers.nodes('/App_AuthorizedUsersForRestore/authorizedUsers/user') AS T(c)
													WHERE T.c.value('@userId','int') = @userId),0)
					IF @expirationTimeStamp > dbo.GetUnixTime(GETUTCDATE())
					BEGIN
						SET @enableAuthorizeForRestore = 1
					END
				END
				UPDATE #clientList SET restoreAuthUsersXML = (SELECT @authType AS '@authType',
																(SELECT @enableAuthorizeForRestore as '@enableAuthorizeForRestore',
																(SELECT @expirationTimeStamp as '@time'
																	FOR XML PATH('expirationTime'), TYPE)
																FOR XML PATH('passkeySettings'), TYPE)
																FOR XML PATH('advancedPrivacySettings'),TYPE)
					WHERE cId = @clientId
				-- Set retireClientPhase to 1 if uninstall jobs are running on client.
				IF EXISTS(SELECT DISTINCT JUPDATE.clientId FROM JMQinetixUpdateStatus JUPDATE WITH (NOLOCK)
							INNER JOIN JMAdminJobInfoTable JINFO WITH (NOLOCK) ON JINFO.jobId = JUPDATE.jobId AND JUPDATE.commCellId = JINFO.commCellId
							AND JINFO.opType = 68 -- UNINSTALLCLIENT (JobManager.x)
							AND JINFO.commCellId = 2 /* DEFAULT_COMMCELL_ID */ WHERE JUPDATE.clientId = @clientId)
				BEGIN
					UPDATE #clientList SET retireClientPhase = 1 WHERE cId = @clientId
				END
        END
        ELSE
        BEGIN
		        UPDATE T1
		            SET T1.geoLocationDisplayMode=T2.geoLocationDisplayMode,
		            T1.lastGeoLocation=T2.lastGeoLocation,
		            T1.lastGeoLocationTime=T2.lastGeoLocationTime
		        FROM #clientList T1
			        INNER JOIN #clientList T2
				        ON T2.cId=T1.physicalClientID
		        WHERE T1.isUserCentricClient=1 AND T1.physicalClientID <> 0 and @getGeoLocation=1
        END
		IF @clientListType = 1 -- User Only Want Physical Client  - App.x - enum ClientListType
		BEGIN
			DELETE #clientList
			WHERE isUserCentricClient <> 0 -- Physical client don't have UserCentric Client Value Set in App_clientProp
		END
		ELSE IF @clientListType = 2 -- User Only Want User Centric Client  - App.x - enum ClientListType
		BEGIN
			DELETE #clientList
			WHERE isUserCentricClient = 0 -- User Centric client have UserCentric Client Value Set in App_clientProp
		END
		ELSE IF @clientListType = 3 -- Only Unique Client - Remove all clientId which are present as Physical Client Id's in user centric client
		BEGIN
			DELETE #clientList
			WHERE cId IN (
					SELECT cl.physicalClientID
					FROM #clientList cl
					WHERE cl.isUserCentricClient <> 0
					) -- Delete all physical clients for which there is atleaset 1 user centric client
		END
		IF @getEndUserClient != 1
		BEGIN
			DELETE #clientList
			WHERE subId = 0
		END
		DELETE #clientList
		WHERE bSet = 0		-- if backupset is not set delete it
		-- Get Total backup size from subclient and backupset
		UPDATE #clientList SET totalbackupsize=totalbackupSizeSubClient + totalbackupSizeBackupset
			WHERE lastDataProtectedTime > 0
		--1. First start with the next runtime populated by the client.
		--2. From the list of schedules, use the next runtime from the client for the OSC schedules that are enabled.
		--   And use the nextRuntime value for the time schedules.  Then get the MIN of those times as the next backup time
		--	 and also, for after job complete schedule, set value to -1 since next run time will not get populated anywhere
		--3. If there are no schedules for the client set the value back to 0
		--Step 1.
		UPDATE #clientList
				SET nextBkupTime = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_ClientProp
														  WHERE componentNameId=cId AND attrName='Next Run Time In'
														 AND modified=0 AND ISNUMERIC(attrVal) = 1
														  ), nextBkupTime)
		--Step 2.
		INSERT INTO #runTimeInfo (taskId, subclientId, frequencyType, nextBackupTime)
		SELECT
			tId,
			u.subId,
			fqType,
			u.nextBkupTime
		FROM #clientList AS cl
		INNER JOIN
			(SELECT
				T.subId AS subId, T.taskId AS tId, T.freq_type AS fqType, MIN(T.nextBkupTime) AS nextBkupTime
				FROM
				(SELECT
					cl.subId,
CASE WHEN p.freq_type = 1024	--Automatic_Schedule
						AND t.disabled = 0					-- Make sure we only pick schedules that are enabled
						THEN CASE WHEN cl.nextBkupTime > 0 AND  cl.nextBkupTime > @nowUTCTimeUnix	-- And a next runtime that is in the future
							THEN cl.nextBkupTime			-- Use time set by client
							ELSE -1							-- Pseudo clients will not have entry in property table
							END
					ELSE rt.nextTime						-- Use time set by scheduler
					END AS nextBkupTime,
					t.taskId,
					p.freq_type
					FROM #clientList cl
					INNER JOIN TM_AssocEntity ae ON
						--CHECK USER HAVING ASSOCIATION FOR THE ENTITY
						(ae.subclientId = cl.subId)
						OR (ae.clientId = cl.cId AND ae.apptypeId = cl.appId AND ae.instanceId = cl.instId  AND ae.backupsetId = cl.bSet AND ae.subclientId = 0)
						OR (ae.clientId = cl.cId AND ae.apptypeId = cl.appId AND ae.instanceId = cl.instId AND ae.backupsetId = 0 AND ae.subclientId = 0)
						OR (ae.clientId = cl.cId AND ae.apptypeId = cl.appId AND ae.instanceId = 0 AND ae.backupsetId = 0 AND ae.subclientId = 0)
						OR (ae.clientId = cl.cId AND ae.apptypeId = 0 AND ae.instanceId = 0 AND ae.backupsetId = 0 AND ae.subclientId = 0)
						OR (ae.clientGroupId in (select clientGroupId FROM APP_ClientGroupAssoc WHERE clientId = cl.cId) and ae.clientId = 0 AND ae.apptypeId = 0 AND ae.instanceId = 0 AND ae.backupsetId = 0 AND ae.subclientId = 0)
					INNER JOIN TM_Task t ON
						t.taskId = ae.taskId AND t.disabled = 0
					INNER JOIN TM_SubTask st ON
						ae.taskId = st.taskId
					INNER JOIN TM_SubTaskOptions sto ON
						sto.subTaskId = st.subTaskId
						AND sto.optionId = 458405394
						AND sto.value IN (1, 2)
					INNER JOIN TM_PatternAssoc pa ON
						pa.subTaskId = st.subTaskId
					JOIN TM_Pattern p ON
						p.patternId = pa.patternId
					LEFT OUTER JOIN TM_RunTime rt ON
						rt.patternId = pa.patternId
						AND rt.processed = 0
				) T
				GROUP BY T.subId, T.taskId, T.freq_type, T.nextBkupTime
			) AS u ON u.subId = cl.subId
		--FIX FOR SUBCLIENTS WITH MULTIPLE SCHEDULES
		UPDATE cl
SET nextBkupTime = CASE WHEN ST.frequencyType = 4096 THEN -1 ELSE RT.nextTime END, -- set -1 if After_Job_Completes
			taskId = ST.taskId
		FROM #clientList AS cl
		JOIN
		(
			SELECT ROW_NUMBER() OVER (PARTITION BY T.subclientId ORDER BY T.nextBackupTime) AS rowNum, MIN(nextBackupTime) nextTime, subclientId
			FROM #runTimeInfo T
			GROUP BY subclientId, nextBackupTime
		) RT ON RT.subclientId = cl.subId AND RT.rowNum = 1
		JOIN #runTimeInfo ST ON ST.subclientId = RT.subclientId AND ST.nextBackupTime = RT.nextTime
		--Step 3.
		UPDATE #clientList
			SET nextBkupTime = 0
			WHERE taskId = 0
		-- This code returns all Encryption Settings which are enabled for a client
		UPDATE #clientList set encryptionXML =	(SELECT
ISNULL((SELECT attrVal FROM App_ClientProp WITH(NOLOCK) where componentNameId = cId AND attrName = 'Encryption Settings' AND modified = 0),2) as  '@encryptionSettings',
ISNULL((SELECT attrVal FROM App_ClientProp WITH(NOLOCK) where componentNameId = cId AND attrName = 'Encrypt: Type' AND modified = 0),2) as '@cipherType',
ISNULL((SELECT attrVal FROM App_ClientProp WITH(NOLOCK) where componentNameId = cId AND attrName = 'Encrypt: drToolAccess' AND modified = 0),0) as '@directMediaAccess',
ISNULL((SELECT attrVal FROM App_ClientProp WITH(NOLOCK) where componentNameId = cId AND attrName = 'Encrypt: Key Length' AND modified = 0),128) as '@encryptKeyLength',
ISNULL((SELECT attrVal FROM App_ClientProp WITH(NOLOCK) where componentNameId = cId AND attrName = 'Override Global Encryption Settings' AND modified = 0),3) as '@overrideGlobalSettings'
									FOR XML PATH('encryptionInfo'),TYPE)
		UPDATE CL
		SET lastBackupJobInfo = AP.attrVal
		FROM #clientList CL
			INNER JOIN APP_IDAName(NOLOCK) A ON A.clientId = CL.cId AND A.apptypeid = CL.appid
			INNER JOIN APP_IDAProp (NOLOCK) AP ON AP.componentNameId = A.id AND AP.attrname = N'Last Backup Job Info' AND AP.modified = 0
		-- Compute SLA
		IF object_id('tempdb..#SLA_EntityInfo') IS NOT NULL DROP TABLE #SLA_EntityInfo
		CREATE TABLE #SLA_EntityInfo (
		clientId INT, appTypeId INT, instanceId INT, backupsetId INT, appId INT, -- entity IDs to set
		status INT, category INT, slaDays INT)
		insert into #SLA_EntityInfo(clientId, appTypeId)
		SELECT  cId, appId
		FROM #clientList
		exec RptGetSLAOfEntities 2
		UPDATE CL
		SET CL.SLAStatus = (CASE WHEN SLA.status = 1 THEN 1 WHEN SLA.status = 2 THEN 2 ELSE 3 END),
			CL.SLACategory = SLA.Category,
			CL.SLACategoryDescription = dbo.WR_GetSLACategoryString(@localeId,SLA.Category)
		FROM #clientList CL
			INNER JOIN #SLA_EntityInfo SLA
				ON CL.cId = SLA.clientId and CL.appId = SLA.appTypeId
		;WITH nwReadniess(clientId, latestUpdateTime)
		AS
		(
			SELECT ToClientId, MAX(LastUpdateTime) FROM CCRClientToClient WITH(NOLOCK) WHERE FromClientId = 2 AND serviceType = 0 GROUP BY ToClientId
		)
		UPDATE cl
		SET nwReadiness = CASE WHEN CCR.flag IS NULL THEN 0 WHEN CCR.flag = 1 THEN 1 ELSE 2 END, lastOnlineTime = CCR.lastOnlineTime, lastOfflineTime = CCR.lastOfflineTime, nwReadinessUpdatedTime = CCR.lastUpdateTime
		FROM  nwReadniess R
				INNER JOIN CCRClientToClient CCR WITH(NOLOCK)
					ON R.clientId = CCR.ToClientId AND R.latestUpdateTime = CCR.LastUpdateTime
				RIGHT OUTER JOIN #clientList cl
					ON cl.cId = CCR.ToClientId AND FromClientId = 2 AND serviceType = 0
		--==========================================================
		-- This code returns all features which a client has enabled
		--==========================================================
		 UPDATE #clientList set features = (
			SELECT F.Value AS '@featureType',1 AS '@enable'
			FROM
dbo.cte_split_inline((SELECT CP.attrVal FROM App_ClientProp CP WHERE CP.componentNameId = cId AND attrName = 'Feature' and modified = 0),',') F
			WHERE F.Value <> 0
			FOR XML PATH ('features'),TYPE)
		--Conditions to get capabilities
		--1) For client that are not VM get the capabilities of a client.
		--2) For request from webconsole, return the capabilities of a VM
		--3) For request from vcenter plugin, return the capabilities of a proxy(When @scope = 5)
		--4) For Edge Client, read the capabilities from UMUserCredentials
		-- AEB:	previous query with OR'd where clause to compute capabilities was very costly on ProdCS SP5
		--		so changed OR'd clauses into sub-queries and OR'd all computed capabilities together for better performance.
		--		New Temp Table indexes improved performance.
		CREATE CLUSTERED INDEX tempLaptopSecurityObjects_idx1 ON #tempLaptopSecurityObjects (clientId, capabilities)
		CREATE NONCLUSTERED INDEX tempLaptopSecurityObjects_idx2 ON #tempLaptopSecurityObjects (clientGroupId, capabilities)
		UPDATE #clientList
			SET capabilities = capabilities | ISNULL(
						(
							SELECT dbo.BitwiseOR(capabilities)
							FROM #tempLaptopSecurityObjects AS sec
							WHERE
								sec.clientId = cId
								AND appId <> 106
						), 0) | ISNULL(
						(
							SELECT dbo.BitwiseOR(capabilities)
							FROM #tempLaptopSecurityObjects AS sec
							WHERE
								EXISTS (SELECT TOP 1 cga.clientId FROM APP_ClientGroupAssoc cga WHERE cga.clientId = cId AND cga.clientGroupId = sec.clientGroupId)
								AND appId <> 106
						), 0) | ISNULL(
						(
							SELECT dbo.BitwiseOR(capabilities)
							FROM #tempLaptopSecurityObjects AS sec
							WHERE
sec.commCellId <> 0 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.archGroupId=0 AND sec.complianceReportId=0 AND sec.complianceReportId=0 AND sec.archGroupId=0 AND sec.cdPolicyId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.instanceId=0 AND sec.legalHoldId=0 AND sec.libraryId=0 AND sec.mediaAgentId=0									AND sec.querySetId=0 AND sec.reviewSetId=0 AND sec.tagId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0
						), 0)
	--set region
	UPDATE cl set regionId= r.id, regionName = r.name, regionDisplayName = r.DisplayName
	FROM  #clientList cl
INNER JOIN APP_AdvanceSettings aas ON aas.entityId=cl.cid AND aas.entityType=3 and aas.keyName='Region Id' AND aas.enabled=1 AND aas.deleted=0
	INNER JOIN app_Region r ON CAST(r.id AS NVARCHAR(20)) LIKE aas.value
		IF object_id('tempdb.dbo.#tempLaptopSecurityObjects') IS NOT NULL
			DROP TABLE #tempLaptopSecurityObjects
		IF OBJECT_ID('tempdb.dbo.#usersAndGroupsVisible ') IS NOT NULL
			DROP TABLE #usersAndGroupsVisible
		CREATE TABLE #usersAndGroupsVisible (
			userOrGroupId INT,
			isUser INT,
			PRIMARY KEY (
				userOrGroupId,
				isUser
				)
			)
		IF OBJECT_ID('tempdb.dbo.#VisibleUsersAndUserGroups') IS NOT NULL
			DROP TABLE #VisibleUsersAndUserGroups
		CREATE TABLE #VisibleUsersAndUserGroups (userOrGroupId INT)
		EXEC sec_getUsersForThisUser '#VisibleUsersAndUserGroups',
			@userId
		INSERT INTO #usersAndGroupsVisible
		SELECT userOrGroupId,
			1
		FROM #VisibleUsersAndUserGroups
		TRUNCATE TABLE #VisibleUsersAndUserGroups
		EXEC sec_getUserGroupsForThisUser '#VisibleUsersAndUserGroups',
			@userId
		INSERT INTO #usersAndGroupsVisible
		SELECT userOrGroupId,
			0
		FROM #VisibleUsersAndUserGroups
		DROP TABLE #VisibleUsersAndUserGroups
		------------------------------------DLPProperties Start------------------------------------------------------------------------------------------------------
		-- Below sp body is used to fetch dlp properties
BEGIN
	-- The default is to hide DLP unless set in clientgroup or plan.
	-- These checks are added below after considering the code in [https:--cvs.commvault.com/source/xref/11.0-win/vaultcxWeb/src/commvault/web/summary/SummaryHandler.java?a=true&h=1008#1033]
	DECLARE @showDLPFlag int = 0
	DECLARE @planId int = 0
	-- Step1: If there is global registry setting to not show DLP from webconsole, honor it. No need to check at client group/client level
	IF(EXISTS(SELECT 1 FROM GXGlobalParam WHERE name = 'WebconsoleDisableDLP' AND modified = 0 AND value ='1'))
		SET @showDLPFlag = 0
	ELSE
	BEGIN
SET @planId = ISNULL((SELECT CONVERT(int,attrVal) FROM App_ClientProp WITH(NOLOCK) WHERE attrName = 'Associated Plan' AND componentNameId = @clientId AND modified = 0),0)
		-- Step2: If Client has plan and plan has DLP enabled, then
		--				check if atleast one clientgroup belonging to client has "allow owners to enable Data encryption" set to 1. If present then showDLP. Else don't showDLP.
		IF (@planId <> 0 AND
			EXISTS(SELECT  1
			FROM UMPermissions permission INNER JOIN
				 UMRolesPermissions roleToPermissionMap ON roleToPermissionMap.permissionId =  permission.id
WHERE       roleToPermissionMap.roleId = dbo.AppPlanGetEntityValue(@planId, 'Feature',  default)
					AND permission.permissionName = 'DLP')
			)
		BEGIN
			IF (EXISTS(SELECT 1 FROM APP_ComponentProp CP WITH(NOLOCK) JOIN APP_ClientGroupAssoc CGA WITH(NOLOCK)
					ON CP.componentid = CGA.clientGroupId AND CGA.clientId = @clientId
					AND CP.modified = 0
					AND CP.longval = 1 -- Enabled on a group
AND CP.propertytypeid = 3623))
			BEGIN
				SET @showDLPFlag = 1
			END
		END
		-- Step3: If client has NO plan
		IF (@planId = 0)
		BEGIN
			DECLARE @enableDLPClient int = ISNULL((SELECT CONVERT(int, attrVal) FROM APP_ClientProp WITH(NOLOCK) WHERE attrName = 'enableDLP' AND modified = 0 AND componentNameId = @clientId),0)
			-- Step3a: Check if "enableDLP" is set to 1 at client level, then we showDLP - This is to allow exisiting customers who were using
			--			dlp before update continue to see that option in webconsole
			IF @enableDLPClient = 1
			BEGIN
				SET @showDLPFlag = 1
			END
			-- Step3b: If registry "WebconsoleUseClientDLPSettings" is set then reflect value of "enableDLP" in app_clientprop table
ELSE IF EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE entityId = @clientId AND entityType = 3 AND keyName = N'WebconsoleUseClientDLPSettings'
					AND enabled = 1 AND deleted = 0 AND CONVERT(NVARCHAR(16),value) = N'TRUE')
			BEGIN
				SET @showDLPFlag = @enableDLPClient
			END
			-- Step3c: Check if atleast one clientgroup has "allow owners to enable data encryption" set to true. If yes, then showDLP else no.
			ELSE IF (EXISTS(SELECT 1 FROM APP_ComponentProp CP WITH(NOLOCK) JOIN APP_ClientGroupAssoc CGA WITH(NOLOCK)
					ON CP.componentid = CGA.clientGroupId AND CGA.clientId = @clientId
					AND CP.modified = 0
					AND CP.longval = 1 -- Enabled on a group
AND CP.propertytypeid = 3623)
					)
			BEGIN
				SET @showDLPFlag = 1
			END
		END
	END
	IF(@showDLPFlag = 1)
	BEGIN
		UPDATE #ClientList SET showDLP = 1
		--Need to check for DLP flags.
		DECLARE @IsWebconsoleDisableDLP int = 0
		DECLARE @IsWebconsoleDisableSecureErase int = 0
		SET @IsWebconsoleDisableSecureErase  = ISNULL((SELECT top 1 value FROM GXGlobalParam WHERE name = 'WebconsoleDisableSecureErase' AND modified = 0), 0)
		IF(@IsWebconsoleDisableDLP=0 OR @IsWebconsoleDisableSecureErase=0)
		BEGIN
INSERT INTO #DLPProperties
		SELECT cId, ISNULL(cp.attrVal,0),0,0,0,''
		FROM #clientList cl
		INNER JOIN APP_ClientProp cp on cp.componentNameId=cl.cId and attrName='enableDLP' and modified=0
WHERE appId in (SELECT appTypeId FROM GetAppTypesForAppGroup(22,0))  or appId = 63
UPDATE #DLPProperties
		SET isDLPRMEnabledOnClient = (SELECT ISNULL(attrVal,0) FROM APP_ClientProp WHERE componentNameId=dlpClientId and attrName='enableRmDLP' and modified=0)
UPDATE #DLPProperties
		SET isDLPEnabledOnGroup =
			ISNULL( ( SELECT top 1 1 FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																											WHERE CGA.clientId = dlpClientId
																												AND CGA.clientGroupId = CG.id )
																										AND attrName = 'enableDLP'
																										AND attrVal = '1' ),0)
UPDATE #DLPProperties
		SET isDLPRMEnabledOnGroup =
			ISNULL( ( SELECT top 1 1 FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																											WHERE CGA.clientId = dlpClientId
																												AND CGA.clientGroupId = CG.id )
																										AND attrName = 'enableRmDLP'
																										AND attrVal = '1' ),0)
			DECLARE @c_id INT
		DECLARE DLPCur CURSOR FOR
SELECT distinct dlpClientId FROM #DLPProperties WHERE isDLPEnabledOnClient = 1 OR isDLPEnabledOnGroup=1 OR isDLPRMEnabledOnClient=1 or isDLPRMEnabledOnGroup=1
				OPEN DLPCur
				FETCH NEXT FROM DLPCur INTO @c_id
				WHILE @@FETCH_STATUS = 0
				BEGIN
					DECLARE @dlpProp XML
					exec GetDLPPropXML @c_id,@IsWebconsoleDisableDLP,@IsWebconsoleDisableSecureErase, @dlpProp output
UPDATE #DLPProperties set propertiesXML = @dlpProp where dlpClientId= @c_id
					FETCH NEXT FROM DLPCur INTO @c_id
				END
				CLOSE DLPCur
				DEALLOCATE DLPCur
			END
		END
END
		------------------------------------DLPProperties End------------------------------------------------------------------------------------------------------
		SET @xmlString = (
				SELECT (
					SELECT backupSize AS '@backupSize',
						capabilities AS '@capabilities',
						isOwner AS '@isOwner',
						totalbackupsize AS '@totalBackupSize',
						isSyncAllowed AS '@isSyncAllowed',
						flag AS '@subclientStatus',
						clientStatus AS '@clientStatus',
						specialClientFlags AS '@specialClientFlags',
						dlp.isDLPEnabledOnClient AS '@isDLPEnabledOnClient',
						dlp.isDLPRMEnabledOnClient AS '@isDLPRMEnabledOnClient',
						isLockedClient AS '@isLocked',
						isIndexingV2 AS '@isIndexingV2',
						isUserCentricClient AS '@isUserCentricClient',
						showDLP AS '@showDLP',
(SELECT CASE WHEN (activatedMode=2 OR activatedMode=0) AND (isUserCentricClient<>1) AND (specialClientFlags&0x2=0) THEN 1 ELSE NULL END) AS '@bShowActivateOption', -- 1) User Centric client: Always show acitvate option to physical clients for admin to acitivate any user. 2) Device centric clients: show activate button when client is not activated.
						(SELECT CASE WHEN isClientDeconfigured = 2 THEN NULL ELSE isClientDeconfigured END) AS '@isClientDeconfigured',
						(SELECT CASE WHEN isMAForClientDeconfigured = 2 THEN NULL ELSE isMAForClientDeconfigured END) AS '@isMAForClientDeconfigured',
						SLAStatus AS '@slaStatus',
						isCloudLaptop AS '@isCloudLaptop',
						SLACategory AS '@slaCategory',
						SLACategoryDescription AS '@slaCategoryDescription',
						nwReadiness AS '@readinessStatus',
						retireClientPhase AS '@retireClientPhase',
						(
							SELECT dirDelim
							FROM APP_iDAType
							WHERE APP_iDAType.type = cl.appId
							) AS '@dirDelim',
						(CASE WHEN lastGeoLocation IS NULL
												THEN NULL
											WHEN (geoLocationDisplayMode IS NULL OR geoLocationDisplayMode < 0 OR geoLocationDisplayMode > 2)
												THEN @defaultGeoLocatoinDisplayMode
											ELSE
													geoLocationDisplayMode
											END) as '@geoLocationDisplayMode' ,
					(SELECT lastGeoLocation),
					(SELECT CASE WHEN lastGeoLocation IS NULL THEN NULL
								ELSE
								  (SELECT  lastGeoLocationTime as '@time', 55 '@_type_' FOR XML PATH ('lastGeoLocationTime'), TYPE)
								END),
						(
							SELECT CASE
									WHEN planId = 0
										THEN NULL
									ELSE (
											SELECT planId AS '@planId',
												158 '@_type_',
												planName AS '@planName'
											FOR XML PATH('plan'),
												TYPE
											)
									END
							),
						(
							SELECT CASE
									WHEN (activationUserName IS NULL) OR (activationUserName='')
										THEN NULL
									ELSE (
											SELECT activationUserId AS '@userId',
												13 '@_type_',
												activationUserName AS '@userName'
											FOR XML PATH('lastActivationUser'),
												TYPE
											)
									END
							),
						(
							SELECT CASE
								WHEN physicalClientID = 0
									THEN NULL
								ELSE (
										SELECT physicalClientID AS '@clientId',
												3 '@_type_',
												ISNULL((select AC.name from  APP_Client AC where AC.id=physicalClientID),'') as '@clientName'
										FOR XML PATH ('physicalClient'),
										TYPE
										)
									END
							),
						(
							SELECT lastbkupTime AS '@time',
								55 '@_type_'
							FOR XML PATH('lastBackupTime'),
								TYPE
							),
						(
							SELECT lastSuccessBkupTime AS '@time',
								55 '@_type_'
							FOR XML PATH('lastSuccessBackupTime'),
								TYPE
							),
						(
							SELECT lastOnlineTime AS '@time',
								55 '@_type_'
							FOR XML PATH('lastOnlineTime'),
								TYPE
							),
						(
							SELECT lastOfflineTime AS '@time',
								55 '@_type_'
							FOR XML PATH('lastOfflineTime'),
								TYPE
							),
						(
							SELECT nwReadinessUpdatedTime AS '@time',
								55 AS '@_type_'
							FOR XML PATH('readinessLastUpdatedTime'),
								TYPE
							),
						(
							SELECT lastDataProtectedTime AS '@time',
								55 '@_type_'
							FOR XML PATH('lastDataProtectedTime'),
								TYPE
							),
						(
							SELECT nextBkupTime AS '@time',
								55 '@_type_'
							FOR XML PATH('nextBackupTime'),
								TYPE
							),
						(
							SELECT cId AS '@clientId',
								clientName AS '@clientName',
								hostname AS '@hostName',
								appId AS '@applicationId',
								instId AS '@instanceId',
								bSet AS '@backupsetId',
								subId AS '@subclientId',
								7 '@_type_'
							FOR XML PATH('subClient'),
								TYPE
							),
						-- Subclient Contents
						(
							CASE @getContent
								WHEN 1 THEN (
									CASE
										WHEN cl.assocSubC > 0 THEN (
											SELECT
												clientId as '@clientId',
												appId as '@applicationId',
												instance as '@instanceId',
												backupSet as '@backupsetId',
												cl.subId as '@subclientId',
												7 '@_type_'
											FROM APP_Application
											WHERE id = cl.assocSubC
											FOR XML PATH ('assocSPsubclient'), TYPE
										)
										ELSE NULL
									END
								)
								ELSE NULL
							END
						),
						(
							CASE @getContent
								WHEN 1 THEN (
									CASE (SELECT COUNT(*) FROM #SubClientContent c WHERE c.contentType = 1 AND c.scId = cl.subId)
										WHEN 0 THEN NULL
										ELSE (
											SELECT
												created as '@createTime',
												modified AS '@modifyTime',
												fileName AS '@value',
												type as '@valueType'
											FROM #SubClientContent c
											WHERE c.contentType = 1
												AND c.scId = cl.subId
											FOR XML PATH ('content'),  ROOT('contents'), TYPE
										)
									END
								)
								ELSE NULL
							END
						),
						(
							--  FOLLOWING ADDED SO WE CAN "RESTORE" TO SCP CONTENTS
							CASE @getContent
								WHEN 1 THEN (
									CASE (SELECT COUNT(*) FROM #SubClientContent c WHERE c.contentType = 2 AND c.scId = cl.assocSubC)
										WHEN 0 THEN NULL
										ELSE (
											SELECT
												created as '@createTime',
												modified AS '@modifyTime',
												fileName AS '@value',
												type as '@valueType'
											FROM #SubClientContent c
											WHERE c.contentType = 2
												AND c.scId = cl.assocSubC
												--AND decoupleSCPcontent = 0
											FOR XML PATH ('content'), ROOT ('SCPcontents'), TYPE
										)
									END
								)
								ELSE NULL
							END
						),
						(
							CASE @getContent
								WHEN 1 THEN (
									CASE
										WHEN cl.useGlobalFilter = 1
											AND EXISTS(SELECT appTypeId FROM GetAppTypesForAppGroup(22,0) where appTypeId = cl.appId )	--'APPGRP_W2KFileSystem
											THEN (
												SELECT gef.value '@value', 13 as '@valueType'
												FROM #GlobalExcludeFilters gef
												WHERE gef.fsType = 1	-- Windows
												FOR XML PATH('content'), ROOT('globalContents'), TYPE
											)
										WHEN cl.useGlobalFilter = 1
											AND EXISTS(SELECT appTypeId FROM GetAppTypesForAppGroup(34,0) where appTypeId = cl.appId)	--'APPGRP_UnixFileSystem
											THEN (
												SELECT gef.value '@value', 13 as '@valueType'
												FROM #GlobalExcludeFilters gef
												WHERE gef.fsType = 2	-- UNIX
												FOR XML PATH('content'), ROOT('globalContents'), TYPE
											)
										ELSE NULL
									END
								)
								ELSE NULL
							END
						),
						(
							SELECT (
									SELECT CASE
											WHEN UMO.isUSER = 1
												THEN UMU.id
											END AS '@userId',
										CASE
											WHEN UMO.isUser = 0
												THEN UMG.id
											END AS '@userGroupId',
										CASE
											WHEN UMO.isUSER = 1
												THEN UMU.LOGIN
											END AS '@userName',
										CASE
											WHEN UMO.isUSER = 1
												THEN UMU.name
											END AS '@name',
										CASE
											WHEN UMO.isUSER = 1
												THEN UMU.email
											END AS '@userEmail',
										CASE
											WHEN UMO.isUser = 0
												THEN UMG.NAME
											END AS '@userGroupName',
										CASE
											WHEN UMO.isUSER = 1
												THEN 13
											ELSE 15
											END AS '@_type_'
									FROM UMOwners UMO
									INNER JOIN #usersAndGroupsVisible Tbl
										ON UMO.isUser = Tbl.isUser
											AND UMO.userOrGroupId = Tbl.userOrGroupId
									LEFT JOIN UMUsers UMU
										ON UMO.isUser = 1
											AND UMO.userOrGroupId = UMU.id
									LEFT JOIN UMGroups UMG
										ON UMO.isUser = 0
											AND UMO.userOrGroupId = UMG.id
									WHERE UMO.entityType = 3
										AND UMO.entityId = cl.Cid
									FOR XML PATH('owners'),
										TYPE
									)
							FOR XML PATH('clientOwners'),
								TYPE
							),
							(SELECT dlp.propertiesXML),
							(SELECT features),
							(select encryptionXML),
							(SELECT cl.regionId as '@regionId', cl.regionName as '@regionName', cl.regionDisplayName as '@displayName' FOR XML PATH('region'),							TYPE),
							(SELECT cl.companyName AS '@connectName',
								(SELECT cl.companyId AS '@id', cl.companyDomainName AS '@domainName' FOR XML PATH ('shortName'), TYPE)
							 FOR XML PATH ('company'), TYPE),
							(SELECT restoreAuthUsersXML),
							(SELECT s.n.query('.') FROM cl.lastBackupJobInfo.nodes('lastBackupJobInfo') s(n))
					FROM #clientList cl
					LEFT OUTER JOIN #DLPProperties dlp
						ON dlp.dlpClientId = cl.cId
					ORDER BY clientName
					FOR XML PATH('clientsFileSystem'), TYPE
				),
				( SELECT @o_errCode '@errorCode', @o_errString '@errorMessage'
						  FOR XML PATH('error'), TYPE
				)
				FOR XML PATH('App_LapTopClientLstResp')
			)
	END TRY
	----=====================================================================
	----==============  COME HERE IF THERE WAS A PROBLEM!     ===============
	----=====================================================================
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_errCode    = ERROR_NUMBER()
		SET @o_errString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
		SET @xmlString = ( SELECT
					( SELECT @o_errCode '@errorCode', @o_errString '@errorMessage'
						  FOR XML PATH('error'), TYPE
					)
		FOR XML PATH(''),
		ROOT('App_LapTopClientLstResp'))
	END CATCH
	SELECT @xmlString
	-- drop temp table
	IF object_id('tempdb.dbo.#clientList') IS NOT NULL
		DROP TABLE #clientList
	--------------------------------------------
	-- SOME CODE, FOR STANDALONE DEBUGGING  ----
	--------------------------------------------
	/*
	IF EXISTS (Select * from sysObjects where name = 'APPGetLaptopClientList')
		  Drop proc APPGetLaptopClientList
	GO
	DECLARE @xml XML
	DECLARE @xmltext nvarchar(max)=
	'<App_LapTopClientListReq><filter clientListType="4"/><user userId="1" /></App_LapTopClientListReq>'
	SET @xml = @xmltext
	exec APPGetLaptopClientProperties @xml
	*/
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDevices')
	delete from GxQscripts where name = 'AppGetDevices'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDevices')
	delete from GXDBVersions where aliasname = 'AppGetDevices'
GO

insert into GXDBVersions values(2, 'AppGetDevices',  '00010002000200470000', 'AppGetDevices', '00010002000200470000')
GO

