

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDeviceInfoForCSDB.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetDeviceInfoForCSDB <<<'

IF EXISTS (select * from sysobjects where name='AppGetDeviceInfoForCSDB')
	drop procedure AppGetDeviceInfoForCSDB
IF EXISTS (select * from GxQscripts where name='AppGetDeviceInfoForCSDB')
	delete from GxQscripts where name = 'AppGetDeviceInfoForCSDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDeviceInfoForCSDB')
	delete from GXDBVersions where aliasname = 'AppGetDeviceInfoForCSDB'
GO
print '... Creating Procedure: AppGetDeviceInfoForCSDB'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetDeviceInfoForCSDB
  @i_DBName VARCHAR(MAX)
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE	@errorCode		INT = 0
DECLARE	@errorString	NVARCHAR(1024) = N''
BEGIN
BEGIN TRY
	-- Output xml string.
	SELECT name '@logicalFileName', physical_name '@fileName', size '@fileMaxSize',0 '@id'
	FROM sys.master_files
	WHERE database_id=DB_ID(@i_DBName)
	FOR XML PATH('sqlDbdeviceItem'),ROOT('Api_DBDeviceInfoResponse')
	RETURN
END TRY
 BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
     SET @errorCode = ERROR_NUMBER()
     SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
 END CATCH
ERROR_EXIT:
	SELECT @errorCode '@errorCode', @errorString '@errorMessage'
	FOR XML PATH('errorResp'),ROOT('Api_DBDeviceInfoResponse')
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDeviceInfoForCSDB')
	delete from GxQscripts where name = 'AppGetDeviceInfoForCSDB'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDeviceInfoForCSDB')
	delete from GXDBVersions where aliasname = 'AppGetDeviceInfoForCSDB'
GO

insert into GXDBVersions values(2, 'AppGetDeviceInfoForCSDB',  '00000000000000000000', 'AppGetDeviceInfoForCSDB', '00000000000000000000')
GO

