

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDeletedCompanyUnusedLibraries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetDeletedCompanyUnusedLibraries.sp,v $ $Id: AppGetDeletedCompanyUnusedLibraries.sp,v 1.1.2.3 2020/12/21 06:57:20 jswaminathan Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"AppGetDeletedCompanyUnusedLibraries"           |
--  |       Author	    :	sghatbale                            			|
--  | Execute the System stored procedure to get the company    			|
--  | media libraries which are not used by any policy i.e. bascially 		|
--  | unused company libraries. Check if such library has any data, if  	|
--  | it does not have data, then that qualifies for deletion in delete     |
--  | company flow.						|
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetDeletedCompanyUnusedLibraries')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDeletedCompanyUnusedLibraries <<<'
	drop procedure AppGetDeletedCompanyUnusedLibraries
END
IF EXISTS (select * from GxQscripts where name='AppGetDeletedCompanyUnusedLibraries')
	delete from GxQscripts where name = 'AppGetDeletedCompanyUnusedLibraries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDeletedCompanyUnusedLibraries')
	delete from GXDBVersions where aliasname = 'AppGetDeletedCompanyUnusedLibraries'
GO
print '... Creating Procedure: AppGetDeletedCompanyUnusedLibraries'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetDeletedCompanyUnusedLibraries
  @companyId INTEGER
AS
  DECLARE @libraryId INTEGER
  DECLARE @libraryName NVARCHAR(256)
  DECLARE @isTapeLibrary INTEGER
IF OBJECT_ID('tempdb..#UnusedLibraries') IS NOT NULL DROP TABLE #UnusedLibraries
	CREATE TABLE #UnusedLibraries(id Integer NOT NULL,
									name NVARCHAR(256),
									isTapeLibrary Integer NOT NULL,
									hasData Integer DEFAULT 0
									PRIMARY KEY (id))
IF OBJECT_ID('tempdb..#usedLibraries') IS NOT NULL DROP TABLE #usedLibraries
	CREATE TABLE #usedLibraries(id Integer NOT NULL
									PRIMARY KEY (id))
INSERT INTO #UnusedLibraries
SELECT DISTINCT ML.LibraryId, ML.AliasName, (CASE WHEN ML.LibraryTypeId <> 3  THEN 1 ELSE 0 END), 0
FROM MMLibrary ML WITH(NOLOCK)
INNER JOIN App_CompanyEntities App WITH(NOLOCK)
	ON ML.libraryid = App.entityId
AND App.entityType = 9
		AND App.companyId = @companyId
LEFT JOIN MMMasterPool MMP WITH(NOLOCK)
	ON MMP.LibraryId = ML.LibraryId
LEFT JOIN MMDrivePool MD WITH(NOLOCK)
	ON MMP.MasterPoolId = MD.MasterPoolId
LEFT JOIN MMDataPath MDP WITH(NOLOCK)
	ON MD.DrivePoolId = MDP.DrivePoolId
LEFT JOIN archGroupCopy AGC WITH(NOLOCK)
	ON AGC.id = MDP.copyId
WHERE AGC.id is NULL
INSERT INTO #usedLibraries
SELECT entityId
FROM App_CompanyEntities ACE WITH (NOLOCK)
WHERE entityType = 9
		AND companyId = @companyId
AND flags & 0x4 = 0
EXCEPT
SELECT id
FROM #UnusedLibraries
DECLARE @libId INT  = 0
DECLARE @errCode INTEGER = 0
-- table to be used to capture o/p of SP MMCheckMPCanDelete
IF OBJECT_ID('tempdb.dbo.#tempMMCheckMPCanDeleteTbl') IS NOT NULL DROP TABLE #tempMMCheckMPCanDeleteTbl
CREATE TABLE #tempMMCheckMPCanDeleteTbl(errorCode INTEGER, errorString VARCHAR(MAX), JobsListXML XML, SIDBListXML XML)
DECLARE unusedLibrariesCursor CURSOR STATIC FOR
    SELECT id
    FROM #UnusedLibraries
	WHERE isTapeLibrary = 0
OPEN unusedLibrariesCursor
FETCH NEXT FROM unusedLibrariesCursor INTO @libId
WHILE @@FETCH_STATUS = 0
BEGIN
	DELETE FROM #tempMMCheckMPCanDeleteTbl
    EXEC MMCheckMPCanDelete 0, @libId
	SELECT @errCode = ISNULL((SELECT top 1 errorCode FROM #tempMMCheckMPCanDeleteTbl) , 0)
IF @errCode & 2 <> 0
	BEGIN
		-- Library has data
		UPDATE #UnusedLibraries
		SET hasData = 1
		WHERE id = @libId
	END
    FETCH NEXT FROM unusedLibrariesCursor INTO @libId
END
CLOSE unusedLibrariesCursor
DEALLOCATE unusedLibrariesCursor
INSERT INTO #usedLibraries
SELECT id
FROM #UnusedLibraries
WHERE hasData = 1
UPDATE App_CompanyEntities
SET flags = App.flags | 0x4
FROM App_CompanyEntities App
INNER JOIN #usedLibraries ML WITH(NOLOCK)
	ON ML.id = App.entityId
AND App.entityType = 9
UPDATE MMLibrary
SET aliasName = SUBSTRING(aliasName, 1, CHARINDEX(': scheduled for deletion', aliasName)-1)
FROM MMLibrary ML
INNER JOIN #usedLibraries UL
	ON UL.id = ML.LibraryId
WHERE CHARINDEX(': scheduled for deletion',  ML.aliasName ) > 0
SELECT id AS 'libraryId', name as 'libraryName', isTapeLibrary as 'isTapeLibrary'
FROM #UnusedLibraries
WHERE hasData = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDeletedCompanyUnusedLibraries')
	delete from GxQscripts where name = 'AppGetDeletedCompanyUnusedLibraries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDeletedCompanyUnusedLibraries')
	delete from GXDBVersions where aliasname = 'AppGetDeletedCompanyUnusedLibraries'
GO

insert into GXDBVersions values(2, 'AppGetDeletedCompanyUnusedLibraries',  '00010001000200030000', 'AppGetDeletedCompanyUnusedLibraries', '00010001000200030000')
GO

