

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDeletedCompanyEntities.sp] ---------- 

--  +------------------------------------------------------------------------------------------+
--  |   Procedure : "AppGetDeletedCompanyEntities"
--  |   Description: Stored procedure to get all the entities of deleted company based on
--	|   entity type passed in.
--  |   Author: sghatbale
--  +------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetDeletedCompanyEntities')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDeletedCompanyEntities <<<'
	drop procedure AppGetDeletedCompanyEntities
END
IF EXISTS (select * from GxQscripts where name='AppGetDeletedCompanyEntities')
	delete from GxQscripts where name = 'AppGetDeletedCompanyEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDeletedCompanyEntities')
	delete from GXDBVersions where aliasname = 'AppGetDeletedCompanyEntities'
GO
print '... Creating Procedure: AppGetDeletedCompanyEntities'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetDeletedCompanyEntities
  @companyId INTEGER,
  @entityType INTEGER,
  @excludeMAClients INTEGER = 0
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
  DECLARE @r_entityId INTEGER
DECLARE @c_flags INT = 0
SELECT @c_flags = (SELECT flags FROM UMDSProviders WHERE id = @companyId AND enabled=0)
IF  @c_flags & 0x0002 = 0x0002
BEGIN
IF @entityType = 17
	BEGIN
		SELECT entityId as 'r_entityId'
		FROM App_CompanyEntities App
		INNER JOIN ArchGroup AG
		ON AG.id = App.entityId
AND AG.flags & (256 | 16384 | 33554432 | 8388608 | 536870912) = 0
WHERE App.entityType = 17 AND
			App.companyId = @companyId AND
App.flags & 0x4 = 0
	END
ELSE IF @entityType = 160
	BEGIN
		SELECT entityId as 'r_entityId'
		FROM App_CompanyEntities App
		INNER JOIN ArchGroup AG
		ON AG.id = App.entityId
AND AG.flags & (256 | 16384 | 33554432 | 8388608) <> 0
WHERE App.entityType = 17 AND
			App.companyId = @companyId AND
App.flags & 0x4 = 0
	END
ELSE IF @entityType = 3 AND @excludeMAClients = 1
	BEGIN
		-- Exclude client with MA
		SELECT entityId as 'r_entityId'
		FROM App_CompanyEntities App
		INNER JOIN App_Client AC
			ON AC.id = App.entityId
AND App.entityType = 3
		LEFT JOIN MMHost MMH
			ON MMH.clientId = AC.id
		WHERE MMH.clientId is NULL AND
			App.companyId = @companyId AND
App.flags & 0x4 = 0
	END
ELSE IF @entityType = 6
	BEGIN
		-- Returns the backupsets which are mapped to this company but their corresponding client is not mapped to this company
		SELECT DISTINCT Bkp.id  as 'r_entityId'
		FROM APP_BackupSetName Bkp
		INNER JOIN App_CompanyEntities App
On Bkp.id = App.entityId AND App.entityType = 6
		INNER JOIN APP_Application Appl
			On Appl.backupSet = Bkp.id
		LEFT JOIN App_CompanyEntities App2
On App2.entityId = Appl.clientId AND App2.entityType = 3
		WHERE App.companyId = @companyId
			AND App2.entityId is NULL
			AND Bkp.status = 0
AND App.flags & 0x4 = 0
	END
ELSE IF @entityType = 7
	BEGIN
		-- Returns the subclients which are mapped to this company but their corresponding client is not mapped to this company
		SELECT DISTINCT Appl.id as 'r_entityId'
		FROM App_Application Appl
		INNER JOIN App_CompanyEntities App
On App.entityId = Appl.id AND App.entityType = 7
		LEFT JOIN App_CompanyEntities App2
On App2.entityId = Appl.clientId AND App2.entityType = 3
		LEFT JOIN App_CompanyEntities App3
On App3.entityId = Appl.backupSet AND App3.entityType = 6
		WHERE App.companyId = @companyId
			AND App2.entityId is NULL
			AND App3.entityId is NULL
AND App.flags & 0x4 = 0
	END
ELSE IF @entityType = 5
	BEGIN
		-- Returns the instances which are mapped to this company but their corresponding client is not mapped to this company
		SELECT DISTINCT AI.id  as 'r_entityId'
		FROM APP_InstanceName AI
		INNER JOIN App_CompanyEntities App
On AI.id = App.entityId AND App.entityType = 5
		INNER JOIN APP_Application Appl
			On Appl.instance = AI.id
		LEFT JOIN App_CompanyEntities App2
On App2.entityId = Appl.clientId AND App2.entityType = 3
		WHERE App.companyId = @companyId
			AND App2.entityId is NULL
			AND AI.id <> 1
			AND AI.id NOT IN (SELECT componentNameId
				  FROM APP_InstanceProp WITH(NOLOCK) INNER JOIN App_InstanceName WITH(NOLOCK)
ON App_instancename.id=componentNameId and attrName = 'Discovered VM Instance' and APP_InstanceProp.modified=0 and status=0x200000 AND attrVal = '1')   /*default VM instance*/
AND App.flags & 0x4 = 0
	END
ELSE IF @entityType = 68
	BEGIN
		-- The schedule tasks which are associated with non-deletable clients or client of another company/MSP should not be deleted.
-- Hence set flag 0x4 for such schedule taks & return the remaining schedule tasks for deletion.
		UPDATE ACE
SET ACE.flags = ACE.flags | 0x4
		FROM App_CompanyEntities ACE
		INNER JOIN TM_SubTask ST WITH (NOLOCK)
			ON ACE.entityId = ST.subTaskId
AND ACE.entityType = 68
				AND ACE.companyId = @companyId
		INNER JOIN TM_task T WITH (NOLOCK)
			ON T.taskId = ST.taskId
AND T.taskType = 2
		INNER JOIN TM_AssocEntity TAE WITH (NOLOCK)
			ON TAE.taskId = T.taskId
		LEFT JOIN App_CompanyEntities ACE2 WITH (NOLOCK)
ON ACE2.entityType = 3
				AND ACE2.entityId = TAE.clientId
				AND ACE2.companyId = @companyId
		WHERE ACE2.entityId is NULL
OR ACE2.flags & 0x4 <> 0
		SELECT T.taskId  as 'r_entityId'
		FROM TM_SubTask ST
		INNER JOIN TM_task T WITH (NOLOCK)
			ON T.taskId = ST.taskId
AND T.taskType = 2
		INNER JOIN App_CompanyEntities ACE WITH (NOLOCK)
ON ACE.entityType = 68
			AND ACE.entityId = ST.subTaskId
			AND ACE.companyId = @companyId
AND ACE.flags & 0x4 = 0
	END
	ELSE
	BEGIN
		DECLARE @dynamicSQLStr NVARCHAR(MAX) = ''
		DECLARE @idColName VARCHAR(128) = ''
                ,@tableName VARCHAR(128) = ''
                ,@whereClause VARCHAR(512) = ''
		SELECT @idColName = idColName, @tableName = tableName, @whereClause = whereClause
		FROM APP_Entity
		WHERE
			entityType = @entityType
		IF @whereClause = ''
			SET @whereClause = '1=1'
		IF PATINDEX('%flags%', @whereClause) <> 0 AND PATINDEX('%.flags%', @whereClause) = 0
		BEGIN
			-- Sometimes whereclause has columns such flags which may be ambiguous with the table it is joining to, so better add table table in clause.
			SET @whereClause = REPLACE(@whereClause, 'flags', @tableName + '.' + 'flags')
		END
		SET @dynamicSQLStr =  'SELECT entityId as r_entityId
								FROM App_CompanyEntities App
								INNER JOIN '+ @tableName +
								' ON App.entityId = '  + @tableName + '.' + @idColName +
								' WHERE App.entityType = ' + CAST (@entityType AS VARCHAR(10))  + ' AND
								  App.companyId = ' + CAST (@companyId AS VARCHAR(10))  +
' AND App.flags & 0x4 = 0 ' +
								' AND ' + @whereClause
		EXEC (@dynamicSQLStr)
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDeletedCompanyEntities')
	delete from GxQscripts where name = 'AppGetDeletedCompanyEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDeletedCompanyEntities')
	delete from GXDBVersions where aliasname = 'AppGetDeletedCompanyEntities'
GO

insert into GXDBVersions values(2, 'AppGetDeletedCompanyEntities',  '00000000000000000000', 'AppGetDeletedCompanyEntities', '00000000000000000000')
GO

