

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDefaultWebserverId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetDefaultWebserverId.sp,v $ $Id: AppGetDefaultWebserverId.sp,v 1.1.2.1 2020/12/14 16:43:13 riyer Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetDefaultWebserverId')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDefaultWebserverId <<<'
	drop procedure AppGetDefaultWebserverId
END
IF EXISTS (select * from GxQscripts where name='AppGetDefaultWebserverId')
	delete from GxQscripts where name = 'AppGetDefaultWebserverId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDefaultWebserverId')
	delete from GXDBVersions where aliasname = 'AppGetDefaultWebserverId'
GO
print '... Creating Procedure: AppGetDefaultWebserverId'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetDefaultWebserverId
AS
  DECLARE @r_errorCode INTEGER
  DECLARE @r_webserverId INTEGER
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @r_errorCode = 0
SET @r_webserverId = 0
--First, check to see if global param is set for default webserver
SET @r_webserverId = ISNULL((SELECT TOP 1 CONVERT(INT,value) FROM GXGlobalParam WITH (NOLOCK) WHERE modified = 0 AND name = N'Web Search Server for Super Search'),0)
--If global param was found, verify that the give client is not deconfigured AND has webserver, mongodb packages installed
IF @r_webserverId <> 0
BEGIN
	--Check to see if the global param is valid and has webserver & MongoDB packages installed
	SET @r_webserverId = ISNULL((
				SELECT top 1 AC.id
				FROM App_Client AC WITH (NOLOCK) INNER JOIN simInstalledPackages A on AC.id = A.clientId
												INNER JOIN simInstalledPackages B ON A.clientId = B.clientId
				WHERE AC.id = @r_webserverId AND (AC.status & 2) = 0
AND A.simPackageId IN (252, 1174)
AND B.simPackageID IN (952, 1604)
			), 0)
END
--If no webserver assigned, fetch default client with webserver, mongodb installed.
IF @r_webserverId = 0
BEGIN
	--Find first client with both webserver and mongodb packages installed
	SELECT TOP 1 @r_webserverId = C.id
	FROM App_Client C INNER JOIN simInstalledPackages A on C.id = A.clientId
	 					INNER JOIN simInstalledPackages B ON A.clientId = B.clientId
	WHERE (C.status & 2) = 0
AND A.simPackageId IN (252, 1174)
AND B.simPackageID IN (952, 1604)
	ORDER BY C.id ASC
	SET @r_errorCode = @@ERROR
	IF @r_errorCode = 0
	BEGIN
		UPDATE 	GxGlobalParam
        SET 	value = CAST(@r_webserverId AS NVARCHAR(64))
        WHERE 	name = N'Web Search Server for Super Search' AND modified = 0
	END
END
SELECT @r_errorCode as r_errorCode, @r_webserverId as r_webserverId
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDefaultWebserverId')
	delete from GxQscripts where name = 'AppGetDefaultWebserverId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDefaultWebserverId')
	delete from GXDBVersions where aliasname = 'AppGetDefaultWebserverId'
GO

insert into GXDBVersions values(2, 'AppGetDefaultWebserverId',  '00010001000200010000', 'AppGetDefaultWebserverId', '00010001000200010000')
GO

