

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDeactivatedCompanyRunningBackupJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  					  AppGetDeactivatedCompanyRunningBackupJobs						|
--	|			Procedure to get list of backup jobs for the deactivated company				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetDeactivatedCompanyRunningBackupJobs')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDeactivatedCompanyRunningBackupJobs <<<'
	drop procedure AppGetDeactivatedCompanyRunningBackupJobs
END
IF EXISTS (select * from GxQscripts where name='AppGetDeactivatedCompanyRunningBackupJobs')
	delete from GxQscripts where name = 'AppGetDeactivatedCompanyRunningBackupJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDeactivatedCompanyRunningBackupJobs')
	delete from GXDBVersions where aliasname = 'AppGetDeactivatedCompanyRunningBackupJobs'
GO
print '... Creating Procedure: AppGetDeactivatedCompanyRunningBackupJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetDeactivatedCompanyRunningBackupJobs
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @companyId INT
-----------------------------------------------------------
AS
  DECLARE @jobIds INT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	IF object_id('tempdb.dbo.#CompanyClientList') IS NOT NULL
		DROP TABLE #CompanyClientList
	CREATE TABLE  #CompanyClientList ( cId  int  PRIMARY KEY)
	IF object_id('tempdb.dbo.#CompanyJobList') IS NOT NULL
		DROP TABLE #CompanyJobList
	CREATE TABLE  #CompanyJobList ( jobId  int  PRIMARY KEY)
	INSERT INTO #CompanyClientList
SELECT entityId FROM App_CompanyEntities WHERE companyId=@companyId and entityType=3 and modified=0
IF EXISTS(SELECT 1 FROM umdsproviders WHERE id = @companyId  AND flags & 0x0010 <> 0)
	BEGIN
		INSERT INTO #CompanyJobList
		SELECT jobID
		FROM RunningBackups bkp
		INNER JOIN #CompanyClientList c ON bkp.clientId=c.cId
	END
	SELECT jobId FROM #CompanyJobList
	IF object_id('tempdb.dbo.#CompanyClientList') IS NOT NULL
		DROP TABLE #CompanyClientList
	IF object_id('tempdb.dbo.#CompanyJobList') IS NOT NULL
		DROP TABLE #CompanyJobList
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDeactivatedCompanyRunningBackupJobs')
	delete from GxQscripts where name = 'AppGetDeactivatedCompanyRunningBackupJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDeactivatedCompanyRunningBackupJobs')
	delete from GXDBVersions where aliasname = 'AppGetDeactivatedCompanyRunningBackupJobs'
GO

insert into GXDBVersions values(2, 'AppGetDeactivatedCompanyRunningBackupJobs',  '00000000000000000000', 'AppGetDeactivatedCompanyRunningBackupJobs', '00000000000000000000')
GO

