

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDataStoreList.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetDataStoreList.sp,v $ $Id: AppGetDataStoreList.sp,v 1.10.48.5 2018/06/25 21:01:20 pktr Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetDataStoreList"
--	|	This Procedure is used to get the list of available data stores
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetDataStoreList <<<'

IF EXISTS (select * from sysobjects where name='AppGetDataStoreList')
	drop procedure AppGetDataStoreList
IF EXISTS (select * from GxQscripts where name='AppGetDataStoreList')
	delete from GxQscripts where name = 'AppGetDataStoreList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDataStoreList')
	delete from GXDBVersions where aliasname = 'AppGetDataStoreList'
GO
print '... Creating Procedure: AppGetDataStoreList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetDataStoreList
-- Input arguments
  @i_xmlText XML
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_ReturnResult XML;
--Check if any tmp table is existing before then drop it
IF object_id('tempdb.dbo.#tmpESXServerTbl') is not null
				DROP TABLE #tmpESXServerTbl
--Create the tmp table
CREATE TABLE #tmpESXServerTbl (  t_esxServerId	integer, t_esxServerName varchar(256) )
DECLARE @dataCenter INT = 0
DECLARE @vendorId INTEGER = 101
	SELECT @dataCenter = isnull(ref.value('@dataCenterId', 'integer') ,0)
		FROM  @i_xmlText.nodes ('Ida_GetDataStoreListReq') R(ref)
IF @dataCenter > 0
BEGIN
	SELECT @vendorId = CAST(attrVal AS INT)
			FROM App_VMDataCenterMap M
			INNER JOIN APP_InstanceProp IP
				ON M.vDataCenterId = @dataCenter
				AND M.instanceId = IP.componentNameId
				AND M.removalTimeStamp IS NULL
	WHERE	IP.attrName = 'Virtual Server Instance Type' AND IP.modified = 0
	SET @r_ReturnResult =
			ISNULL( (
				SELECT
				ds.value('@capacity', 'BIGINT') as '@totalSizeInBytes',
				ds.value('@freeSpace', 'BIGINT') as '@freeSpaceInBytes',
				isnull(ds.value('@fileSystemType', 'NVARCHAR(MAX)'),'') as '@dataStoreType',
				( SELECT D.id as '@dataStoreId', D.name as '@dataStoreName' FOR XML PATH ('dataStoreEntity'), TYPE),
				( SELECT H.id as '@esxServerId', H.name as '@esxServerName' FOR XML PATH ('hostEntity'), TYPE)
				FROM
				APP_VMDataCenter DC
				INNER JOIN App_VMDataStore D
				ON DC.id = @dataCenter
				AND DC.removalTimeStamp IS NULL
				AND D.vDataCenterId = DC.id
				AND D.removalTimeStamp IS NULL
				INNER JOIN VMHostToDataStores VD
				ON D.id = VD.vDataStoreId
				INNER JOIN App_VMHost H
				ON VD.vHostId = H.id
				AND H.removalTimeStamp IS NULL
				CROSS APPLY D.vxml.nodes('datastores') M(ds)
				WHERE ds.value('@capacity', 'BIGINT') > (10.0 * 1024 * 1024 * 1024) OR (H.vxml.value('(QSMServer_QVirtualHostReq/@vendorType)[1]','INT') = @vendorId AND @vendorId IN (401, 402,403))
				FOR XML PATH('DataStoreInfoList'), ROOT('Ida_GetDataStoreListResp')
			), '<Ida_GetDataStoreListResp/>')
END
ELSE
BEGIN
	--Put the data from xml into the table
	INSERT INTO #tmpESXServerTbl ( t_esxServerId, t_esxServerName)
		SELECT ref.value('@esxServerId', 'integer'), ref.value('@esxServerName', 'varchar(256)')
		FROM  @i_xmlText.nodes ('Ida_GetDataStoreListReq/ESXServerList') R(ref)
	SELECT	@vendorId = CAST(attrVal AS INT)
	FROM	#tmpESXServerTbl H
			INNER JOIN App_VMHost VH
				ON H.t_esxServerId = VH.id
			INNER JOIN App_VMDataCenterMap M
				ON VH.vDataCenterId = M.vDataCenterId
			INNER JOIN APP_InstanceProp IP
				ON M.instanceId = IP.componentNameId
	WHERE	IP.attrName = 'Virtual Server Instance Type' AND IP.modified = 0
	IF @vendorId = 102
	BEGIN
		IF OBJECT_ID('tempdb..#tempResults') IS NOT NULL
			DROP TABLE #tempResults
		create table #tempResults (esxServerId INT, dataStoreId INT, shouldMerge INT)
		insert INTO #tempResults
		select MIN(t_esxServerId), MIN(D.id), CASE WHEN COUNT(*) > 1 THEN 0 ELSE 1 END
		FROM [dbo].App_VMDataStore D
				INNER JOIN VMHostToDataStores
				ON D.id = vDataStoreId
				AND D.removalTimeStamp IS NULL
				INNER JOIN #tmpESXServerTbl
				ON t_esxServerId = vHostId
				INNER JOIN App_VMHost H
				ON vHostId = H.id
				AND H.removalTimeStamp IS NULL
				CROSS APPLY D.vxml.nodes('datastores') M(ds)
				WHERE ds.value('@capacity', 'BIGINT') > (10.0 * 1024 * 1024 * 1024)
				GROUP BY D.uniqueName
		UPDATE T
		SET shouldMerge = 0
		FROM #tempResults T
			INNER JOIN (SELECT vDataStoreId, COUNT(DISTINCT vHostId) nHosts
						FROM VMHostToDataStores HD
							INNER JOIN #tempResults TR
								ON HD.vDataStoreId = TR.dataStoreId
						GROUP BY vDataStoreId
						) I
				ON I.vDataStoreId = T.dataStoreId
		WHERE nHosts > 1
		SET @r_ReturnResult =
		ISNULL( (
			SELECT D.id AS '@dataStoreId', CASE shouldMerge WHEN 1 THEN H.name + ' - ' + D.name ELSE D.name END AS '@dataStoreName'
			FROM #tempResults T
				INNER JOIN App_VMHost H
					ON T.esxServerId = H.id
				INNER JOIN App_VMDataStore D
					ON T.dataStoreId = D.id
			FOR XML PATH('DataStoreList'), ROOT('Ida_GetDataStoreListResp')
			), '<Ida_GetDataStoreListResp/>')
		IF OBJECT_ID('tempdb..#tempResults') IS NOT NULL
			DROP TABLE #tempResults
	END
	ELSE
	BEGIN
		SET @r_ReturnResult =
			ISNULL( (
				SELECT DISTINCT D.id AS '@dataStoreId', (CASE WHEN @vendorId = 102 THEN H.name + ' - ' ELSE '' END) + D.name AS '@dataStoreName'
				FROM [dbo].App_VMDataStore D
				INNER JOIN VMHostToDataStores
				ON D.id = vDataStoreId
				AND D.removalTimeStamp IS NULL
				INNER JOIN #tmpESXServerTbl
				ON t_esxServerId = vHostId
				INNER JOIN App_VMHost H
				ON vHostId = H.id
				AND H.removalTimeStamp IS NULL
				CROSS APPLY D.vxml.nodes('datastores') M(ds)
				WHERE ds.value('@capacity', 'BIGINT') > (10.0 * 1024 * 1024 * 1024) OR (H.vxml.value('(QSMServer_QVirtualHostReq/@vendorType)[1]','INT') = @vendorId AND @vendorId IN (401, 402,403))
				FOR XML PATH('DataStoreList'), ROOT('Ida_GetDataStoreListResp')
			), '<Ida_GetDataStoreListResp/>')
	END
END
SELECT @r_ReturnResult;
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDataStoreList')
	delete from GxQscripts where name = 'AppGetDataStoreList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDataStoreList')
	delete from GXDBVersions where aliasname = 'AppGetDataStoreList'
GO

insert into GXDBVersions values(2, 'AppGetDataStoreList',  '00010010004800050000', 'AppGetDataStoreList', '00010010004800050000')
GO

