

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDataSourceSrvrForBackupset.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetDataSourceSrvrForBackupset"
--	|	This Procedure is used to get server cient id for Indexing Data source  of backupset
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetDataSourceSrvrForBackupset')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDataSourceSrvrForBackupset <<<'
	drop procedure AppGetDataSourceSrvrForBackupset
END
IF EXISTS (select * from GxQscripts where name='AppGetDataSourceSrvrForBackupset')
	delete from GxQscripts where name = 'AppGetDataSourceSrvrForBackupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDataSourceSrvrForBackupset')
	delete from GXDBVersions where aliasname = 'AppGetDataSourceSrvrForBackupset'
GO
print '... Creating Procedure: AppGetDataSourceSrvrForBackupset'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetDataSourceSrvrForBackupset
-- Input arguments
  @i_backupsetId integer
AS
  DECLARE @o_srvrClientId integer	
BEGIN
DECLARE @datasourceId INT
SELECT @datasourceId = attrVal FROM APP_BackupSetProp WITH(NOLOCK)
	WHERE componentNameId = @i_backupsetId and attrname = 'Indexing datasource id'
DECLARE @cloudId INT
SELECT @cloudId = CI.CloudID FROM SECollectionInfo CI
				INNER JOIN
				SEDataSource AS DS ON DS.CoreId = CI.CoreId
				WHERE DS.DataSourceId = @datasourceId
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
CREATE TABLE #getIndexServers
                    (     serverURL NVARCHAR(512),
                            clientId INT,
                            clientName NVARCHAR(256),
                            cloudId INT,
                            hostName NVARCHAR(256),
                            basePort INT,
                            engineName  NVARCHAR(256),
                            serverType INT,
                            indexServerClientId INT,
                            internalCloudName NVARCHAR(256)
                    )
EXEC DM2GetIndexServers  '', 0, @cloudId
SELECT  TOP 1 @o_srvrClientId = clientId FROM #getIndexServers
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
SELECT @o_srvrClientId
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDataSourceSrvrForBackupset')
	delete from GxQscripts where name = 'AppGetDataSourceSrvrForBackupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDataSourceSrvrForBackupset')
	delete from GXDBVersions where aliasname = 'AppGetDataSourceSrvrForBackupset'
GO

insert into GXDBVersions values(2, 'AppGetDataSourceSrvrForBackupset',  '00000000000000000000', 'AppGetDataSourceSrvrForBackupset', '00000000000000000000')
GO

