

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDataSourceInfoBySubclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetDataSourceInfoBySubclient.sp,v $ $Id: AppGetDataSourceInfoBySubclient.sp,v 1.1.4.11.4.1 2021/04/26 21:47:51 bkharabe Exp $";
--
--  +========================================================================+
--  |      Cursor:  AppGetDataSourceInfoBySubclient()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetDataSourceInfoBySubclient')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDataSourceInfoBySubclient <<<'
	drop procedure AppGetDataSourceInfoBySubclient
END
IF EXISTS (select * from GxQscripts where name='AppGetDataSourceInfoBySubclient')
	delete from GxQscripts where name = 'AppGetDataSourceInfoBySubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDataSourceInfoBySubclient')
	delete from GXDBVersions where aliasname = 'AppGetDataSourceInfoBySubclient'
GO
print '... Creating Procedure: AppGetDataSourceInfoBySubclient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetDataSourceInfoBySubclient
AS
  DECLARE @o_appId INTEGER;
  DECLARE @o_dataSourceId INTEGER;
  DECLARE @o_cloudId INTEGER;
  DECLARE @o_coreName NVARCHAR(256);
  DECLARE @o_clientId INTEGER;
  DECLARE @o_clientName NVARCHAR(256);
  DECLARE @o_hostName NVARCHAR(256);
  DECLARE @o_basePort INTEGER;
  DECLARE @o_url NVARCHAR(256);
  DECLARE @o_isCloud INTEGER;
  DECLARE @o_context NVARCHAR(256);
  DECLARE @o_engineName NVARCHAR(256);
  DECLARE @o_minDocSize BIGINT;
  DECLARE @o_maxDocSize BIGINT;
  DECLARE @o_pushOnlyMetadata INTEGER;
  DECLARE @o_includeFilters NVARCHAR(256);
  DECLARE @o_excludeFilters NVARCHAR(256);
  DECLARE @o_caConfig NVARCHAR(MAX);
  DECLARE @o_literalProperties NVARCHAR(MAX);
  DECLARE @o_serverType INTEGER;
  DECLARE @o_indexServerClientId INTEGER;
  DECLARE @o_internalCloudName NVARCHAR(256);
  DECLARE @o_dcPlanId INTEGER;
BEGIN
IF OBJECT_ID('tempdb.dbo.#tempclientDsMapping') IS NOT NULL
	DROP TABLE #tempclientDsMapping
CREATE TABLE #tempclientDsMapping (
	clientId INTEGER,
	appId INTEGER,
	dataSourceId INTEGER,
	PRIMARY KEY (dataSourceId, clientId, appId)	-- Performance converted from HEAP to CLUSTERED table and better joins in queries below
)
INSERT INTO #tempclientDsMapping
	SELECT
		CP.componentNameId,
		App.id,
		CP.attrVal
	FROM APP_ClientProp CP WITH (NOLOCK)
		INNER JOIN APP_Application App WITH (NOLOCK) ON
			CP.componentNameId = App.clientId
			AND CP.attrName = N'Indexing datasource id'
			AND CP.modified = 0
	UNION 	-- Performance converted to 1 data set operation
	SELECT
		C.id,
		SC.id,
		SCP.attrVal
	FROM APP_CLIENT C with (nolock)
		INNER JOIN APP_Application SC WITH (NOLOCK) ON
			C.id = SC.clientId
		INNER JOIN App_SubclientProp SCP WITH (NOLOCK) ON
			SCP.componentNameId = SC.id
			AND SCP.attrName = N'Indexing datasource id'
			AND SCP.cs_attrName = CHECKSUM(N'Indexing datasource id')		-- Performance eliminated CXPACKETs and SCAN of the App_SubclientProp table
			AND SCP.modified = 0
IF OBJECT_ID('tempdb.dbo.#tempDsDetails') IS NOT NULL     DROP TABLE #tempDsDetails
CREATE TABLE #tempDsDetails (
	dataSourceId INTEGER,
	cloudId INTEGER,
	coreName NVARCHAR(256),
	datasourceName NVARCHAR(MAX),
	clientId INTEGER,
	clientName NVARCHAR(256),
	hostName NVARCHAR(256),
	basePort INTEGER,
	url NVARCHAR(256),
	isCloud INTEGER,
	context NVARCHAR(256),
	engineName NVARCHAR(256),
	minDocSize BIGINT,
	maxDocSize BIGINT,
	pushOnlyMetadata INTEGER,
	includeFilters NVARCHAR(256),
	excludeFilters NVARCHAR(256),
	caConfig NVARCHAR(MAX),
	literalProperties NVARCHAR(MAX),
    serverType INTEGER,
    indexServerClientId INTEGER,
    internalCloudName NVARCHAR(256),
    dcPlanId INTEGER
)
INSERT INTO #tempDsDetails
(dataSourceId, cloudId, coreName, datasourceName)
SELECT DISTINCT DSC.dataSourceId, CI.CloudID,  CI.ActualCoreName, DS.DisplayName
FROM SEDataSource as DS WITH (NOLOCK)
INNER JOIN SECollectionInfo aS CI WITH (NOLOCK)
ON DS.coreId = CI.coreId
INNER JOIN #tempclientDsMapping DSC
ON DS.DataSourceId = DSC.dataSourceId
DECLARE @curDSId INTEGER
DECLARE @curCloudId INTEGER
DECLARE @curCoreName NVARCHAR(256)
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
CREATE TABLE #getIndexServers
(
		serverURL NVARCHAR(512),
        clientId INT,
        clientName NVARCHAR(256),
        cloudId INT,
        hostName NVARCHAR(256),
        basePort INT,
        engineName  NVARCHAR(256),
        serverType INT,
        indexServerClientId INT,
        internalCloudName NVARCHAR(256)
)
EXEC DM2GetIndexServers
UPDATE DS
SET DS.clientId = INS.clientId,
	DS.clientName = INS.clientName,
	DS.hostName = INS.hostName,
	DS.engineName = INS.engineName,
	DS.basePort = INS.basePort,
	DS.url = INS.serverURL + '/solr/' + DS.coreName,
    DS.serverType = INS.serverType,
    DS.indexServerClientId = INS.indexServerClientId,
    DS.internalCloudName = INS.internalCloudName
FROM #getIndexServers INS
INNER JOIN #tempDsDetails DS
ON INS.cloudId = DS.cloudId
UPDATE DS
SET DS.minDocSize =  DSD.minumumdocumentsize,
	DS.maxDocSize =  DSD.maximumdocumentsize,
	DS.pushOnlyMetadata = DSD.pushonlymetadata,
	DS.includeFilters = DSD.includefilters,
	DS.excludeFilters = DSD.excludefilters,
	DS.caConfig = DSD.caconfig,
	DS.literalProperties = DSD.literalproperties,
	DS.dcPlanId = DSD.dcplanid
FROM
(SELECT dsId,
	ISNULL(minumumdocumentsize, 0) AS minumumdocumentsize,
	ISNULL(maximumdocumentsize, 0) as maximumdocumentsize,
	CASE ISNULL(pushonlymetadata, 'false')
		WHEN 'true' THEN 1 ELSE 0 END AS pushonlymetadata,
	ISNULL(includefilters, '') AS includefilters,
	ISNULL(excludefilters, '') AS excludefilters,
	ISNULL(caconfig, '') AS caconfig,
	ISNULL(literalproperties, '') AS literalproperties,
	ISNULL(dcplanid, 0) as dcplanid
	 FROM
(SELECT DSP.dataSourceId AS dsId, P.PropertyName AS propName, DSP.PropertyValue as propValue
FROM SEDataSourceProperty DSP WITH (NOLOCK)
INNER JOIN SEProperty P
ON DSP.PropertyId = P.PropertyId
AND P.PropertyName IN ('minumumdocumentsize', 'maximumdocumentsize', 'pushonlymetadata', 'includefilters', 'excludefilters', 'caconfig', 'literalproperties', 'dcplanid')
) AS SRC
PIVOT
(
	MAX(propValue) FOR propName in (minumumdocumentsize, maximumdocumentsize, pushonlymetadata, includefilters, excludefilters, caconfig, literalproperties, dcplanid)
	)AS PVT) AS DSD
INNER JOIN #tempDsDetails DS
ON DS.dataSourceId = DSD.dsId
SELECT
	C.appId,
	DSD.dataSourceId,
	DSD.cloudId,
	DSD.engineName,
	DSD.clientId,
	DSD.clientName,
	DSD.hostName,
	DSD.basePort,
	DSD.url,
	ISNULL(DSD.isCloud,0) AS isCloud,
	ISNULL(DSD.minDocSize,0) AS minDocSize,
	ISNULL(DSD.maxDocSize,0) AS maxDocSize,
	ISNULL(DSD.pushOnlyMetadata,0) AS pushOnlyMetadata,
	DSD.includeFilters,
	DSD.excludeFilters,
	DSD.caConfig,
	DSD.literalProperties,
    DSD.serverType,
    DSD.indexServerClientId,
    DSD.internalCloudName,
    ISNULL(DSD.dcPlanId, 0) as dcPlanId,
	DSD.datasourceName AS datasourceName
FROM #tempDsDetails DSD
INNER JOIN #tempclientDsMapping C
ON C.dataSourceId = DSD.dataSourceId
IF OBJECT_ID('tempdb.dbo.#tempclientDsMapping') IS NOT NULL     DROP TABLE #tempclientDsMapping
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
IF OBJECT_ID('tempdb.dbo.#tempDsDetails') IS NOT NULL     DROP TABLE #tempDsDetails
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDataSourceInfoBySubclient')
	delete from GxQscripts where name = 'AppGetDataSourceInfoBySubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDataSourceInfoBySubclient')
	delete from GXDBVersions where aliasname = 'AppGetDataSourceInfoBySubclient'
GO

insert into GXDBVersions values(2, 'AppGetDataSourceInfoBySubclient',  'v1.1.4.11.4.1', 'AppGetDataSourceInfoBySubclient', 'v1.1.4.11.4.1')
GO

