

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDataSourceDetailsForEntityExtraction.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetDataSourceDetailsForEntityExtraction.sp,v $ $Id: AppGetDataSourceDetailsForEntityExtraction.sp,v 1.1.4.9 2020/10/20 03:46:22 bkharabe Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetDataSourceDetailsForEntityExtraction')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDataSourceDetailsForEntityExtraction <<<'
	drop procedure AppGetDataSourceDetailsForEntityExtraction
END
IF EXISTS (select * from GxQscripts where name='AppGetDataSourceDetailsForEntityExtraction')
	delete from GxQscripts where name = 'AppGetDataSourceDetailsForEntityExtraction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDataSourceDetailsForEntityExtraction')
	delete from GXDBVersions where aliasname = 'AppGetDataSourceDetailsForEntityExtraction'
GO
print '... Creating Procedure: AppGetDataSourceDetailsForEntityExtraction'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetDataSourceDetailsForEntityExtraction
  @input XML
AS
  DECLARE @output XML
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @minDocSize INT;
DECLARE @maxDocSize INT;
DECLARE @includeFilters NVARCHAR(MAX);
DECLARE @excludeFilters NVARCHAR(MAX);
DECLARE @dcPlanId INT;
DECLARE @entityList NVARCHAR(MAX);
DECLARE @literalProperties NVARCHAR(MAX);
DECLARE @caCloudId INT;
DECLARE @dcPolicyId INT;
DECLARE @ciPolicyId INT;
DECLARE @ciPolicyOpType INT;
DECLARE @ciPolicyDetails XML
DECLARE @dataSourceUrl NVARCHAR(MAX);
DECLARE @crawlType INT
DECLARE @dsId INT
DECLARE @jobId INT
DECLARE @dsCloudId INT
DECLARE @indexStoreClientId INT
DECLARE @coreName NVARCHAR(256)
SELECT @dsId = ISNULL(T.c.value('@dataSourceId', 'int'), 0),
	@jobId = ISNULL(T.c.value('@jobId', 'int'), 0)
FROM   @input.nodes('/App_GetDataSourceInforForEntityExtractionRequest[1]') T(c)
IF @jobId <> 0
	BEGIN
	    -- try populating from TM_JobOption
	    SELECT @dsId = CAST(TM.value AS INT)
	    FROM TM_JobOptions TM
WHERE jobId = @jobId AND optionId = 608389867
	END
SELECT DISTINCT @dsCloudId = CI.CloudID, @coreName = CI.ActualCoreName
FROM SEDataSource as DS WITH (NOLOCK)
INNER JOIN SECollectionInfo aS CI WITH (NOLOCK)
ON DS.coreId = CI.coreId
WHERE DS.DataSourceId = @dsId
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
CREATE TABLE #getIndexServers
(
        serverURL NVARCHAR(512),
        clientId INT,
        clientName NVARCHAR(256),
        cloudId INT,
        hostName NVARCHAR(256),
        basePort INT,
        engineName  NVARCHAR(256),
        serverType INT,
        indexServerClientId INT,
        internalCloudName NVARCHAR(256)
)
EXEC DM2GetIndexServers @i_cloudId= @dsCloudId
SELECT @dataSourceUrl = serverURL + '/solr/' + @coreName + '/update', @indexStoreClientId = clientId
FROM #getIndexServers
SELECT @dcPlanId = PropertyValue
FROM SEDataSourceProperty WITH (NOLOCK)
WHERE dataSourceId = @dsId
AND PropertyId = (SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'dcplanid')
SELECT  @literalProperties = ISNULL(PropertyValue, '')
FROM SEDataSourceProperty WITH (NOLOCK)
WHERE dataSourceId = @dsId
AND PropertyId = (SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'literalproperties')
SELECT @crawlType = PropertyValue
FROM SEDataSourceProperty WITH (NOLOCK)
WHERE dataSourceId = @dsId
AND PropertyId = (SELECT TOP 1 PropertyId FROM SEProperty (NOLOCK) WHERE PropertyName = 'crawltype')
SELECT @dcPolicyId = attrVal
FROM App_PlanProp WITH (NOLOCK)
WHERE componentNameId = @dcPlanId AND attrName = 'Data classification policy' AND modified = 0
SELECT @ciPolicyId = attrVal
FROM App_PlanProp WITH (NOLOCK)
WHERE componentNameId = @dcPlanId AND attrName = 'Content Indexing Policy' AND modified = 0
SELECT @ciPolicyDetails = policyDetails
FROM APP_ConfigurationPolicyDetails WITH (NOLOCK)
WHERE componentNameId = @ciPolicyId
SELECT @includeFilters = T.cc.value('filters[1]/fileFilters[1]/@includeDocTypes', 'NVARCHAR(MAX)'),
@minDocSize = ISNULL(T.cc.value('filters[1]/fileFilters[1]/@minDocSize', 'INTEGER'), 0),
@maxDocSize = ISNULL(T.cc.value('filters[1]/fileFilters[1]/@maxDocSize', 'INTEGER'), 0),
@ciPolicyOpType = ISNULL(T.cc.value('@opType', 'INTEGER'), 0)
FROM @ciPolicyDetails.nodes('/ciPolicy') T(cc)
SELECT @excludeFilters = COALESCE(@excludeFilters + ',', '') + excludeFilter FROM
(SELECT T.cc.value('@val', 'NVARCHAR(MAX)') as excludeFilter
FROM @ciPolicyDetails.nodes('/ciPolicy/filters/fileFilters/excludePaths') T(cc)) AS A
SELECT @caCloudId = attrVal
FROM App_PlanProp WITH (NOLOCK)
WHERE componentNameId = @dcPlanId AND attrName = 'Content Analyzer Cloud Id' AND modified = 0
IF @crawlType = 5 AND @ciPolicyOpType = 1 AND @includeFilters is null
BEGIN
	SET @includeFilters = '*.*'
END
IF object_id('tempdb.dbo.#tblEntities') IS NOT NULL DROP TABLE #tblEntities
 CREATE TABLE #tblEntities (
	entityId INT
)
INSERT INTO #tblEntities
SELECT ISNULL(x.l.value('@entityId[1]', 'INT'), 0)
FROM APP_ConfigurationPolicyDetails
CROSS APPLY policyDetails.nodes('/dcPolicy/extractionPolicy/extractionPolicyList/tags/entityDetail') x(l)
where componentNameId = @dcPolicyId
SELECT @entityList = COALESCE(@entityList+',' ,'') + CAST(entityId AS NVARCHAR(25))
FROM #tblEntities
SET @output = (	SELECT @dsId AS '@dataSourceId',
		@minDocSize as '@minDocSize',
		@maxDocSize as '@maxDocSize',
		@includeFilters as '@includeFilters',
		@excludeFilters as '@excludeFilters',
		@dcPlanId as '@dcPlanId',
		@entityList as '@entityList',
		@literalProperties as '@literalProperties',
		@caCloudId as '@caCloudId',
		@dcPolicyId as '@dcPolicyId',
		@dataSourceUrl AS '@dataSourceUrl',
        @dsCloudId AS '@indexStoreCloudId',
        @indexStoreClientId AS '@indexStoreClientId',
        @ciPolicyId as '@ciPolicyId',
        @ciPolicyOpType as '@ciPolicyOpType'
	FOR XML PATH('App_GetDataSourceInforForEntityExtractionResponse'))
SELECT @output
IF object_id('tempdb.dbo.#tblEntities') IS NOT NULL DROP TABLE #tblEntities
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDataSourceDetailsForEntityExtraction')
	delete from GxQscripts where name = 'AppGetDataSourceDetailsForEntityExtraction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDataSourceDetailsForEntityExtraction')
	delete from GXDBVersions where aliasname = 'AppGetDataSourceDetailsForEntityExtraction'
GO

insert into GXDBVersions values(2, 'AppGetDataSourceDetailsForEntityExtraction',  '00010001000400090000', 'AppGetDataSourceDetailsForEntityExtraction', '00010001000400090000')
GO

