

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDataPreInstallMode.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppGetDataPreInstallMode()
--  |
--  | Description:  Retrieves data from DB during pre-install. At present fetches Webconsole.
--  |
--  |       Input:  -
--  |      Output:  WebconsoleUrl contains Url in xml format
--  |
--  |
--  |
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppGetDataPreInstallMode <<<'

IF EXISTS (select * from sysobjects where name='AppGetDataPreInstallMode')
	drop procedure AppGetDataPreInstallMode
IF EXISTS (select * from GxQscripts where name='AppGetDataPreInstallMode')
	delete from GxQscripts where name = 'AppGetDataPreInstallMode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDataPreInstallMode')
	delete from GXDBVersions where aliasname = 'AppGetDataPreInstallMode'
GO
print '... Creating Procedure: AppGetDataPreInstallMode'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetDataPreInstallMode
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @WebconsoleUrl XML
SET @WebconsoleUrl = ''
-- Fetch webconsole url
IF 1 = (@i_xmlText.exist('/App_GetDataInPreInstallModeReq'))    -- At present no attribte is present in App_GetDataInPreInstallModeReq.
BEGIN
SET @WebconsoleUrl = ISNULL((select value AS webConsoleUrl from GXGlobalParam WITH (NOLOCK) where name = 'WebConsoleURL' for xml path('App_GetDataInPreInstallModeResp')),'<App_GetDataInPreInstallModeResp/>')
END
ELSE
	SET @WebconsoleUrl = '<App_GetDataInPreInstallModeResp/>'
SELECT @WebconsoleUrl
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDataPreInstallMode')
	delete from GxQscripts where name = 'AppGetDataPreInstallMode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDataPreInstallMode')
	delete from GXDBVersions where aliasname = 'AppGetDataPreInstallMode'
GO

insert into GXDBVersions values(2, 'AppGetDataPreInstallMode',  '00000000000000000000', 'AppGetDataPreInstallMode', '00000000000000000000')
GO

