

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDataPathID.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetDataPathID')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDataPathID <<<'
	drop procedure AppGetDataPathID
END
IF EXISTS (select * from GxQscripts where name='AppGetDataPathID')
	delete from GxQscripts where name = 'AppGetDataPathID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDataPathID')
	delete from GXDBVersions where aliasname = 'AppGetDataPathID'
GO
print '... Creating Procedure: AppGetDataPathID'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetDataPathID
  @subclientId INT,
  @mediaAgent VARCHAR(MAX),
  @libraryName VARCHAR(MAX),
  @drivePoolName VARCHAR(MAX),
  @scratchPoolName VARCHAR(MAX),
  @dataStoragePolicyId INT,
  @referIncStoragePolicyId INT
AS
  DECLARE @dataPathId integer = 0
  DECLARE @precedence integer = 0
  DECLARE @errCode integer = 0
  DECLARE @errString varchar(MAX) = 'Success'
BEGIN TRY
	DECLARE @isValidMA INT = 0
	--Validate given Media agent
	SET @isValidMA = ISNULL((SELECT MMH.ClientId
							FROM MMHost MMH WITH (NOLOCK), APP_Client APPCli WITH (NOLOCK)
							WHERE APPCli.name = @mediaAgent
									AND APPCli.id = MMH.ClientId), 0)
	IF( @isValidMA = 0 )
	BEGIN
		SET @errCode = 1
		SET @errString = 'Media agent[' + @mediaAgent + '] is not a valid Media agent.'
		GOTO SKIP
	END
	--Validate given data SP
	DECLARE @isValidSP INT = 0
	SET @isValidSP = ISNULL((SELECT id FROM archGroup WITH (NOLOCK) WHERE id = @dataStoragePolicyId), 0)
	IF( @isValidSP = 0 )
	BEGIN
		SET @errCode = 2
		SET @errString = 'Data Storage policy id [' + CAST(@dataStoragePolicyId as VARCHAR(MAX))  + '] is not a valid Data SP. Please give valid Data SP id.'
		GOTO SKIP
	END
	DECLARE @dataSPName VARCHAR(MAX) = (SELECT name FROM archGroup WITH (NOLOCK) WHERE id = @dataStoragePolicyId)
	--Get Incremental SP
	DECLARE @incSP INT = 0
	IF @referIncStoragePolicyId = 1
	BEGIN
		SET @incSP = ISNULL((SELECT incrSP FROM archGroup WITH (NOLOCK) WHERE id = @dataStoragePolicyId), 0)
		IF( @incSP = 0 )
		BEGIN
			SET @errCode = 3
			SET @errString = 'Data Storage policy [' + @dataSPName + '] is not associated to incremental storage policy. Please check if valid incremental storage policy is associated to subclient.'
			GOTO SKIP
		END
		SET @dataStoragePolicyId = @incSP
	END
	--Identify datapathID for a given library, mediaAgent, drivePool, scratchPool and StoragePolicyId
	IF @drivePoolName = 'N/A' OR @scratchPoolName = 'N/A'
	BEGIN
		SET @dataPathId = ISNULL((SELECT MMDP.datapathid
							  FROM archGroup AG WITH (NOLOCK),MMDataPath MMDP WITH (NOLOCK), MMDrivePool MMDrP WITH (NOLOCK), MMMasterPool MMMP WITH (NOLOCK), MMLibrary MML WITH (NOLOCK), MMHost MMH WITH (NOLOCK), APP_Client APPCli WITH (NOLOCK)
							  WHERE MMDP.DrivePoolId = MMDrP.DrivePoolId
									AND AG.id = @dataStoragePolicyId
									AND MMDrP.MasterPoolId = MMMP.MasterPoolId
									AND MMMP.LibraryId = MML.LibraryId
									AND MML.AliasName = @libraryName
									AND MMDP.CopyId = AG.defaultCopy
									AND MMDP.HostClientId = MMH.ClientId
									AND MMH.ClientId = APPCli.id
									AND APPCli.name = @mediaAgent), 0)
	END
	ELSE
	BEGIN
		SET @dataPathId = ISNULL((SELECT MMDP.datapathid
							  FROM archGroup AG WITH (NOLOCK),MMDataPath MMDP WITH (NOLOCK), MMDrivePool MMDrP WITH (NOLOCK), MMMasterPool MMMP WITH (NOLOCK), MMLibrary MML WITH (NOLOCK), MMHost MMH WITH (NOLOCK), APP_Client APPCli WITH (NOLOCK), MMSpareGroup MMSG WITH(NOLOCK)
							  WHERE MMDrP.DrivePoolName = @drivePoolName
									AND AG.id = @dataStoragePolicyId
									AND MMDP.DrivePoolId = MMDrP.DrivePoolId
									AND MMDrP.MasterPoolId = MMMP.MasterPoolId
									AND MMMP.LibraryId = MML.LibraryId
									AND MML.AliasName = @libraryName
									AND MMDP.CopyId = AG.defaultCopy
									AND MMDP.HostClientId = MMH.ClientId
									AND MMH.ClientId = APPCli.id
									AND APPCli.name = @mediaAgent
									AND MMDP.SpareGroupId = MMSG.SpareGroupId
									AND MMSG.LibraryId =  MML.LibraryId
									AND MMSG.SpareGroupName = @scratchPoolName), 0)
	END
	IF( @dataPathId = 0 )
	BEGIN
		SET @errCode = 4
		SET @errString = 'Library[' + @libraryName + '], MA[' + @mediaAgent + '] is not a valid data path for storage policy[' + @dataSPName + ']. Please give valid datapath.'
		GOTO SKIP
	END
	SET @precedence = ISNULL((SELECT MAX(precedence) FROM APP_AppToDataPath WITH (NOLOCK) WHERE componentNameId = @subclientId and backupType = 1), 0 )
	SET @precedence = @precedence + 1
	IF EXISTS (SELECT componentNameId FROM APP_AppToDataPath WITH (NOLOCK) WHERE componentNameId = @subclientId and dataPathId = @dataPathId)
	BEGIN
		SET @errCode = 5
		SET @errString = 'Library[' + @libraryName + '], MA[' + @mediaAgent + '] data path is available for subclient[' + CAST(@subClientId as VARCHAR(MAX)) + '].'
		GOTO SKIP
	END
SKIP:
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   set @errCode = ERROR_NUMBER()
   set @errString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
SELECT @dataPathId, @precedence, @errCode, @errString

IF EXISTS (select * from GxQscripts where name = 'AppGetDataPathID')
	delete from GxQscripts where name = 'AppGetDataPathID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDataPathID')
	delete from GXDBVersions where aliasname = 'AppGetDataPathID'
GO

insert into GXDBVersions values(2, 'AppGetDataPathID',  '00000000000000000000', 'AppGetDataPathID', '00000000000000000000')
GO

