

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDataDataClassificationPlanDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetDataDataClassificationPlanDetails.sp,v $ $Id: AppGetDataDataClassificationPlanDetails.sp,v 1.1.2.4.8.1 2021/01/07 16:03:25 adutt Exp $";
--
--  +========================================================================+
--  |      Cursor:  AppGetDataDataClassificationPlanDetails()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetDataDataClassificationPlanDetails')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDataDataClassificationPlanDetails <<<'
	drop procedure AppGetDataDataClassificationPlanDetails
END
IF EXISTS (select * from GxQscripts where name='AppGetDataDataClassificationPlanDetails')
	delete from GxQscripts where name = 'AppGetDataDataClassificationPlanDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDataDataClassificationPlanDetails')
	delete from GXDBVersions where aliasname = 'AppGetDataDataClassificationPlanDetails'
GO
print '... Creating Procedure: AppGetDataDataClassificationPlanDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetDataDataClassificationPlanDetails
  @i_planId integer,
  @i_subclientId integer
AS
  DECLARE @planId INTEGER;
  DECLARE @name NVARCHAR(512);
  DECLARE @type INTEGER;
  DECLARE @subType INTEGER;
  DECLARE @pclass INTEGER;
  DECLARE @description NVARCHAR(MAX);
  DECLARE @dcPolicyId INTEGER;
  DECLARE @retXml XML;
  DECLARE @analyticsEngineClientId INTEGER;
  DECLARE @analyticsEngineClientName NVARCHAR(512);
  DECLARE @contentAnalyzerCloudId INTEGER;
  DECLARE @contentAnalyzerCloudName NVARCHAR(512);
BEGIN
IF OBJECT_ID('tempdb.dbo.#PlanDetails_PlanProps')       IS NOT NULL DROP TABLE #PlanDetails_PlanProps
CREATE TABLE #PlanDetails_PlanProps (
depth INT,
componentNameId INT,
attrName VARCHAR(512),
attrType INT,
attrVal VARCHAR(MAX),
[entityTypeId] INT,
[Status] INT)
IF OBJECT_ID('tempdb.dbo.#tempDCPlanList') IS NOT NULL     DROP TABLE #tempDCPlanList
CREATE TABLE #tempDCPlanList (
    planId INTEGER,
    name NVARCHAR(512),
    type INTEGER,
    subType INTEGER,
    pclass INTEGER,
    description NVARCHAR(MAX),
	dcPolicyId INTEGER,
	ciPolicyId INTEGER,
	enableExactSearch INTEGER,
    analyticsEngineClientId INTEGER,
    analyticsEngineClientName NVARCHAR(512),
    contentAnalyzerCloudId INTEGER,
    contentAnalyzerCloudName NVARCHAR(512))
IF (@i_planId=0)
BEGIN
	SELECT TOP 1  @i_planId=attrVal
	FROM App_ClientProp CP (NOLOCK)
	JOIN App_Application A (NOLOCK) ON A.clientid = CP.componentNameId
WHERE  CP.attrName = 'Default Data classification Plan' AND CP.attrType = 7 AND CP.modified = 0
	AND A.id = @i_subClientId
END
INSERT INTO #tempDCPlanList
(planId, name, type, subType, pclass, description)
SELECT id, name, type, subType, pclass,  description
FROM App_Plan WITH (NOLOCK)
WHERE subType = 117506053 AND id = @i_planId
EXEC AppPlanGetPlanComponentsV2 @i_planId
UPDATE P
SET dcPolicyId = PD.attrVal
FROM #tempDCPlanList P
INNER JOIN #PlanDetails_PlanProps PD
ON P.planId = PD.componentNameId
WHERE attrName = 'Data classification policy'
UPDATE P
SET ciPolicyId = PD.attrVal
FROM #tempDCPlanList P
INNER JOIN #PlanDetails_PlanProps PD
ON P.planId = PD.componentNameId
WHERE attrName = 'Content Indexing Policy'
select @retXml=policyDetails from APP_ConfigurationPolicyDetails AC where (AC.componentNameId in (select ciPolicyId from #tempDCPlanList)) and modified=0
update #tempDCPlanList
SET enableExactSearch=ISNULL(ref.value('@enableExactSearch','int'),0) from @retXml.nodes('ciPolicy') R ( ref )
UPDATE P
SET analyticsEngineClientId = PD.attrVal
FROM #tempDCPlanList P
INNER JOIN #PlanDetails_PlanProps PD
ON P.planId = PD.componentNameId
WHERE attrName = 'Analytics Index Server Id'
UPDATE P
SET analyticsEngineClientName = C.name
FROM #tempDCPlanList P
INNER JOIN APP_Client C WITH (NOLOCK)
ON P.analyticsEngineClientId = C.id
UPDATE P
SET contentAnalyzerCloudId = PD.attrVal
FROM #tempDCPlanList P
INNER JOIN #PlanDetails_PlanProps PD
ON P.planId = PD.componentNameId
WHERE attrName = 'Content Analyzer Cloud Id'
UPDATE P
SET contentAnalyzerCloudName = C.name
FROM #tempDCPlanList P
INNER JOIN DM2Cloud C WITH (NOLOCK)
ON P.contentAnalyzerCloudId = C.cloudId
SELECT * FROM #tempDCPlanList
IF OBJECT_ID('tempdb.dbo.#tempDCPlanList') IS NOT NULL     DROP TABLE #tempDCPlanList
IF OBJECT_ID('tempdb.dbo.#PlanDetails_PlanProps')       IS NOT NULL DROP TABLE #PlanDetails_PlanProps
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDataDataClassificationPlanDetails')
	delete from GxQscripts where name = 'AppGetDataDataClassificationPlanDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDataDataClassificationPlanDetails')
	delete from GXDBVersions where aliasname = 'AppGetDataDataClassificationPlanDetails'
GO

insert into GXDBVersions values(2, 'AppGetDataDataClassificationPlanDetails',  'v1.1.2.4.8.1', 'AppGetDataDataClassificationPlanDetails', 'v1.1.2.4.8.1')
GO

