

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDataCenterList.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetDataCenterList.sp,v $ $Id: AppGetDataCenterList.sp,v 1.18.14.6 2019/06/04 15:21:11 pktr Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "GetDataCenterList"
--	|	This Procedure is used to get the list of available data centers
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetDataCenterList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDataCenterList <<<'
	drop procedure AppGetDataCenterList
END
IF EXISTS (select * from GxQscripts where name='AppGetDataCenterList')
	delete from GxQscripts where name = 'AppGetDataCenterList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDataCenterList')
	delete from GXDBVersions where aliasname = 'AppGetDataCenterList'
GO
print '... Creating Procedure: AppGetDataCenterList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetDataCenterList
-- Input arguments
  @i_xmlText XML
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_ReturnResult XML;
DECLARE		@userId AS INT = ISNULL (( SELECT ref.value('@userId', 'INT')
								FROM  @i_xmlText.nodes ('Ida_GetDataCenterListReq/user') R(ref)), 0)
DECLARE		@policyType AS VARCHAR(MAX) = ISNULL (( SELECT ref.value('@policyType', 'NVARCHAR(255)')
								FROM  @i_xmlText.nodes ('Ida_GetDataCenterListReq/policyType') R(ref)), 0)
DECLARE @policyTypeId AS INT
if @policyType='0' OR @policyType = '4' or @policyType = '13' or @policyType ='6'  -- VMWARE
  SET @policyTypeId=101
else if @policyType='2' or @policyType = '12' or @policyType ='5'-- HYPER-V (MICROSOFT)
  SET @policyTypeId=102
else if  @policyType='1' -- AMAZON
  SET @policyTypeId=301
else if @policyType='3' -- AZURE
  SET @policyTypeId=401
else if @policyType='11' -- ORACLE CLOUD
  SET @policyTypeId=1101
else if @policyType='8' -- DOCKER
  SET @policyTypeId=1001
-- FOLLOWING BLOCK SO WE CAN "TRACE" WHAT IS ACTUALLY BEING PASSED DOWN TO DB in Table "TrackNotificationProcs"
DECLARE @brAlertTrace AS INT =ISNULL((select value from gxglobalParam Where name = 'bralertTrace'), 0)
if @brAlertTrace <> 0
BEGIN
	DECLARE @xmlStr AS VARCHAR(MAX) = CONVERT(varchar(MAX), @i_xmlText)
	exec br_ntTrace '.. AppGetVMInstanceList2', @userId, 0, 0, 0, @xmlStr
END
IF object_id('tempdb.dbo.#dCenterList') is not null DROP TABLE #dCenterList
CREATE TABLE #dCenterList  (dataCenterId INT,
                                                vCenterName NVARCHAR(255),
                                                dataCenterName NVARCHAR(255),
												clientName NVARCHAR(255),
                                                instanceId INT,
                                                clientId INT,
                                                canSee INT
                                                )
INSERT #dCenterList
SELECT d.id ,case when IP2.attrVal ='' or @policyTypeId in ( 1001,1101) then c.name else IP2.attrVal end as vCenter , case when @policyTypeId in ( 1001,1101) then C.name else d.name end, C.name, I.id, C.id, 0
			FROM   APP_InstanceName AS I
			INNER JOIN APP_InstanceProp AS IP ON
				IP.componentNameId = I.id
				AND IP.attrName = 'Virtual Server Instance Type'
				AND IP.attrVal = @policyTypeId
			INNER JOIN APP_InstanceProp AS IP2 ON
				IP2.componentNameId = I.id
				AND IP2.attrName =  'Virtual Server Host'
			INNER JOIN (select DISTINCT clientId, instance from APP_Application) APP on
			APP.instance = I.id
			INNER JOIN APP_Client C ON
			C.id = APP.clientId
			AND C.status & 0x00002 = 0
				AND (I.status & 0x00002) = 0
			LEFT JOIN App_VMDataCenterMap AS dm ON
			 dm.instanceId = I.id
			LEFT JOIN App_VMDataCenter d
			on d.id = dm.vDataCenterId
			AND scmOldId =0
		        where  d.removalTimeStamp  is NULL
			and dm.removalTimeStamp is NULL
IF OBJECT_ID('tempdb.dbo.#clientLstWithAgentMgmtCap') IS NOT NULL
		DROP TABLE #clientLstWithAgentMgmtCap
	CREATE TABLE #clientLstWithAgentMgmtCap
	(
		clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT
	)
EXEC sec_getIdaObjectsForUser @userId, 3, 2, 0, '#clientLstWithAgentMgmtCap'
--Select only those objects on which user has Agent managemnet rights
Update DC   SET canSee = 1
FROM #dCenterList DC INNER JOIN #clientLstWithAgentMgmtCap CL ON DC.clientId = CL.clientId
IF OBJECT_ID('tempdb.dbo.#clientLstWithAgentMgmtCap') IS NOT NULL
		DROP TABLE #clientLstWithAgentMgmtCap
if @userId = 0										-- emulates how it worked "without" security check
	UPDATE #dCenterList	SET canSee = 1
SET @r_ReturnResult = ISNULL ( ( SELECT dataCenterId AS '@dataCenterId', vCenterName AS '@vCenterName', dataCenterName AS '@dataCenterName',
						( SELECT instanceId as '@instanceId', clientId as '@clientId', clientName as '@clientName' FOR XML PATH ('instanceEntity'), TYPE)
						FROM #dCenterList
						WHERE canSee <> 0
						FOR XML PATH('dataCenterList'), ROOT('Ida_GetDataCenterListResp') ), '<Ida_GetDataCenterListResp/>')
DROP TABLE #dCenterList
SELECT @r_ReturnResult;
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDataCenterList')
	delete from GxQscripts where name = 'AppGetDataCenterList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDataCenterList')
	delete from GXDBVersions where aliasname = 'AppGetDataCenterList'
GO

insert into GXDBVersions values(2, 'AppGetDataCenterList',  '00010018001400060000', 'AppGetDataCenterList', '00010018001400060000')
GO

