

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDRBackupProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored Precedure: GetCommCellProperties
--  |
--  | Description:
--  |  To get the DR Backup Properties
--  |
--  |   Revisions  Author					Description
--  |   ---------  -------			---------------------------------------------
--  |   1.0        Mohammad Dilshad		To get the DR Backup Properties
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetDRBackupProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDRBackupProperties <<<'
	drop procedure AppGetDRBackupProperties
END
IF EXISTS (select * from GxQscripts where name='AppGetDRBackupProperties')
	delete from GxQscripts where name = 'AppGetDRBackupProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDRBackupProperties')
	delete from GXDBVersions where aliasname = 'AppGetDRBackupProperties'
GO
print '... Creating Procedure: AppGetDRBackupProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetDRBackupProperties
AS
--This will turn off message: "xxx rows affected".
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
	DECLARE @outXML XML
	DECLARE @drSubclient INT = ISNULL((SELECT TOP(1) id FROM APP_Application WHERE appTypeId = 1000 AND subclientStatus <>  4), 1)
	DECLARE @numberOfMetadata INT = ISNULL((SELECT value FROM GXGlobalParam WHERE NAME = N'DRNumFulls' AND modified = 0), 0)
	DECLARE @isUseVSS INT = ISNULL((SELECT attrVal FROm APP_SubClientProp WHERE componentNameId = @drSubclient AND modified = 0 AND attrName = N'Use VSS Enabled'), 1)
	DECLARE @dataArchiveGroupId INT = ISNULL((SELECT dataArchGrpID FROm APP_Application WHERE id = @drSubclient), 0)
	DECLARE @prepostOption INT = ISNULL((SELECT attrVal FROm APP_SubClientProp WHERE componentNameId = @drSubclient AND modified = 0 AND attrName = N'sys: pre post option'), 0)
	DECLARE @backupMetadataFolder NVARCHAR(2048) = ISNULL((SELECT value FROM GXGlobalParam WHERE NAME = N'DRDumpLocation' AND modified = 0), N'')
	DECLARE @wildCardSetting NVARCHAR(2048) = ISNULL((SELECT value FROM GXGlobalParam WHERE NAME = N'DRDumpClientLogWildCard' AND modified = 0), N'')
	DECLARE @preScanProcess NVARCHAR(2048) = ISNULL((SELECT attrVal FROm APP_SubClientProp WHERE componentNameId = @drSubclient AND modified = 0 AND attrName = N'sys:pre PreIfind'), N'')
	DECLARE @postScanProcess NVARCHAR(2048) = ISNULL((SELECT attrVal FROm APP_SubClientProp WHERE componentNameId = @drSubclient AND modified = 0 AND attrName = N'sys:post PostIfind'), N'')
	DECLARE @preBackupProcess NVARCHAR(2048) = ISNULL((SELECT attrVal FROm APP_SubClientProp WHERE componentNameId = @drSubclient AND modified = 0 AND attrName = N'sys:pre PreBackup'), N'')
	DECLARE @postBackupProcess NVARCHAR(2048) = ISNULL((SELECT attrVal FROm APP_SubClientProp WHERE componentNameId = @drSubclient AND modified = 0 AND attrName = N'sys:post PostBackup'), N'')
	DECLARE @prePostUserName NVARCHAR(256) = ISNULL((SELECT attrVal FROm APP_SubClientProp WHERE componentNameId = @drSubclient AND modified = 0 AND attrName = N'prepost username'), N'')
	DECLARE @networkUserName NVARCHAR(256) = (SELECT userName FROM APP_CommCell WHERE id = 2)
	DECLARE @usePrePostUser INT = (SELECT CAST(attrVal AS INT) FROm APP_SubClientProp WHERE componentNameId = @drSubclient AND modified = 0 AND attrName = N'use prepost username')
	DECLARE @cloudUserName NVARCHAR(256) = ISNULL((SELECT value FROM GXGlobalParam WHERE NAME = N'DRCloudUserName' AND modified = 0), N'')
	DECLARE @libraryName NVARCHAR(512) = ISNULL((SELECT value FROM GXGlobalParam WHERE NAME = N'DRCloudLibraryName' AND modified = 0), N'')
	DECLARE @libraryId NVARCHAR(100) = ISNULL((SELECT value FROM GXGlobalParam WHERE NAME = N'DRCloudLibraryID' AND modified = 0), N'')
	DECLARE @uploadBackupMetadataToCloud INT = 0
	DECLARE @uploadBackupMetadataToCloudLib INT = ISNULL((SELECT CASE WHEN value = 'true' THEN 1 ELSE 0 END value FROM GXGlobalParam WHERE NAME = N'DRCloudLibraryUploadSet' AND modified = 0), 0)
	IF LEN(@cloudUserName) > 0
		SET @uploadBackupMetadataToCloud = 1
	SET @outXML = (SELECT
					(SELECT
						@numberOfMetadata AS '@numberOfMetadata',
						@backupMetadataFolder AS '@backupMetadataFolder',
						@wildCardSetting AS '@wildCardSetting',
						@isUseVSS AS '@isUseVSS',
						@uploadBackupMetadataToCloud AS '@uploadBackupMetadataToCloud',
						@uploadBackupMetadataToCloudLib AS '@uploadBackupMetadataToCloudLib',
						(SELECT
							@dataArchiveGroupId AS '@storagePolicyId',
							(SELECT name FROM archGroup WHERE id = @dataArchiveGroupId) AS '@storagePolicyName'
							FOR XML PATH('storagePolicy'),TYPE),
						(SELECT
								@cloudUserName AS '@userName'
							FOR XML PATH('cloudCredentials'),TYPE),
						(SELECT
								@libraryId AS '@libraryId',
								@libraryName AS '@libraryName'
							FOR XML PATH('cloudLibrary'),TYPE),
						(SELECT
								@networkUserName AS '@userName'
							FOR XML PATH('networkUserAccount'),TYPE)
					FOR XML PATH ('exportSettings'), TYPE),
					(SELECT
						(CASE WHEN (@prepostOption & 1) = 1 THEN 1 ELSE 0 END) AS '@runPostScanProcess',
						(CASE WHEN (@prepostOption & 2) = 2 THEN 1 ELSE 0 END) AS '@runPostBackupProcess',
						@preScanProcess AS '@preScanProcess',
						@postScanProcess AS '@postScanProcess',
						@preBackupProcess AS '@preBackupProcess',
						@postBackupProcess AS '@postBackupProcess',
						CASE WHEN @usePrePostUser = 2 THEN 1 WHEN @usePrePostUser = 1 THEN 0 END AS '@useImpersonateUser',
						(SELECT
							@prePostUserName AS '@userName'
							FOR XML PATH('impersonateUser'),TYPE)
					FOR XML PATH ('prePostProcessSettings'), TYPE)
				FOR XML PATH('drBackupInfo'),
			ROOT('App_GetDRBackupInfoResponse'))
	SELECT @outXML AS ReturnResult
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDRBackupProperties')
	delete from GxQscripts where name = 'AppGetDRBackupProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDRBackupProperties')
	delete from GXDBVersions where aliasname = 'AppGetDRBackupProperties'
GO

insert into GXDBVersions values(2, 'AppGetDRBackupProperties',  '00000000000000000000', 'AppGetDRBackupProperties', '00000000000000000000')
GO

