

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDM2CloudServers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetDM2CloudServers.sp,v $ $Id: AppGetDM2CloudServers.sp,v 1.1.2.20.4.2 2021/01/15 09:05:13 pankajkumar Exp $";
-- ----------------------------------------------------------------------*/
--	This Sp is used to get client properties for following pseudo clients
--		- index server
--		- index server pool
--		- content analyzer cloud
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetDM2CloudServers')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDM2CloudServers <<<'
	drop procedure AppGetDM2CloudServers
END
IF EXISTS (select * from GxQscripts where name='AppGetDM2CloudServers')
	delete from GxQscripts where name = 'AppGetDM2CloudServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDM2CloudServers')
	delete from GXDBVersions where aliasname = 'AppGetDM2CloudServers'
GO
print '... Creating Procedure: AppGetDM2CloudServers'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetDM2CloudServers
  @i_clientId INT = 0,
  @o_caCloudId INT OUTPUT
AS
SET @o_caCloudId = ISNULL((SELECT TOP 1 cloudId FROM DM2Cloud (NOLOCK) WHERE CloudType = 2 AND pseudoClientId = @i_clientId),0)
IF @o_caCloudId > 0
BEGIN
	--Content Extractor ClOUD
DECLARE @caClientId INT = ISNULL ((SELECT TOP 1 clientid FROM DM2SearchServerCoreInfo WITH (NOLOCK) WHERE cloudId= @o_caCloudId AND cloudType = 2),0)
	IF  @caClientId > 0
		EXEC DM2GetAnalyticsMA @caClientId, 2, 0
	INSERT INTO #indexServer (clusterType,	cloudServerType, cloudId, cloudStatus,	cloudName , cloudDisplayName)
	SELECT CloudType, CloudType, cloudId, status, name, displayName
	FROM DM2CLOUD (NOLOCK)
	WHERE CLOUDiD =@o_caCloudId
END
ELSE IF EXISTS (SELECT TOP 1 cloudId FROM DM2Cloud (NOLOCK) WHERE CloudType = 6 AND pseudoClientId = @i_clientId)
BEGIN
	DECLARE @hacCloudId INT
SELECT @hacCloudId = cloudId FROM DM2Cloud WHERE pseudoClientId = @i_clientId AND CloudType = 6
	INSERT INTO #indexServer (clusterType,	cloudServerType, cloudId, cloudStatus,	cloudName ,
								cloudDisplayName,	indexDirectory ,analyticsEnabled,
								zkCloudId ,	zkCloudName
							)
	SELECT DISTINCT cloudType, cloudType, CloudId,	status, name,  displayname,'','', 0, ''
	FROM DM2Cloud C (NOLOCK)
	where C.cloudId = @hacCloudId
    INSERT INTO #zkNodes (clientId, zkClientName, zkDisplayName, zkNodeStatus, t_metaXML)
    SELECT CI.ClientId, C.name, C.displayName, CI.status , CAST(CI.NodeProps AS XML)
	FROM DM2SearchServerCoreInfo AS CI
	INNER JOIN APP_Client C ON CI.ClientId = C.id
WHERE CI.CloudId = @hacCloudId AND CloudType = 6
    UPDATE #zkNodes
    SET zkListenerPort = t_metaXML.value('(/NodeMetaProp/nodeMetaInfos[@name="zkListenerPort"]/@value)[1]', 'VARCHAR(10)'),
        zkDataPort = t_metaXML.value('(/NodeMetaProp/nodeMetaInfos[@name="zkDataPort"]/@value)[1]', 'VARCHAR(10)'),
        zkElectionPort  = t_metaXML.value('(/NodeMetaProp/nodeMetaInfos[@name="zkElectionPort"]/@value)[1]', 'VARCHAR(10)'),
        zkServerId = t_metaXML.value('(/NodeMetaProp/nodeMetaInfos[@name="zkServerId"]/@value)[1]', 'VARCHAR(10)'),
		zkDataDir = t_metaXML.value('(/NodeMetaProp/nodeMetaInfos[@name="zkDataDir"]/@value)[1]', 'NVARCHAR(1024)')
END
ELSE
BEGIN
	DECLARE @cloudId INT = 0
	DECLARE @pseudoClientId INT = 0
	DECLARE @poolClientId INT = 0
	DECLARE @poolCloudId INT = 0
	DECLARE @cloudType INT =0
	SELECT TOP 1 @cloudId = cloudId, @cloudType= cloudType, @pseudoClientId= pseudoClientId, @poolClientId = indexserverpoolclientId from DM2Cloud (nolock) where pseudoClientId = @i_clientId
IF @cloudType IN (1,5,9)
	BEGIN
		DECLARE @nodePropertiesXML TABLE (t_clientId INT , t_nodeProps XML, t_status INT, t_isSelected INT)
		INSERT INTO @nodePropertiesXML (t_clientId, t_nodeProps, t_status, t_isSelected )
		SELECT DISTINCT ClientId, NodeProps, status, 1
		FROM  DM2SearchServerCoreInfo (nolock)
		WHERE   cloudId = @cloudId AND  cloudType = @cloudType
		-- for cluster, get all node of the associated pool
IF @cloudType =5 -- cluster
		BEGIN
			SET @poolCloudId = ISNULL(( SELECT TOP 1 CloudId from DM2Cloud (nolock) where pseudoClientId = @poolClientId),0)
			INSERT INTO @nodePropertiesXML (t_clientId, t_nodeProps, t_status, t_isSelected )
			SELECT DISTINCT ClientId, NodeProps, 0 , 0
			FROM DM2SearchServerCoreInfo S (nolock)
			LEFT JOIN @nodePropertiesXML X ON S.clientId= X.t_clientId
WHERE  S.cloudId = @poolCloudId AND X.t_clientId IS NULL AND S.cloudType = 9
		END
ELSE IF @cloudType = 1
	BEGIN
		--Legacy engine
		--DO NOT INCLUDE  nodes from existing analytics engine / index server pool
        INSERT INTO @nodePropertiesXML (t_clientId, t_nodeProps, t_status, t_isSelected )
		SELECT DISTINCT C.id, '', 0, 0
		FROM APP_CLIENT C (NOLOCK)
		JOIN simInstalledPackages P (NOLOCK) ON C.id = P.ClientId
LEFT JOIN DM2SearchServerCoreInfo S(NOLOCK) ON P.ClientId = S.clientId AND S.CloudType IN (1,5,9)
WHERE P.simPackageID IN ( 1306, 55) AND S.clientId IS NULL
		--SET DEFAULT VALUES
		DECLARE @nodePropsMap TABLE (t_clientId INT, t_name NVARCHAR(1024), t_value NVARCHAR(1024))
		INSERT INTO @nodePropsMap
		SELECT DISTINCT t_clientId, 'PORTNO', (CASE WHEN  attrVal = 'Instance001' THEN '20000' ELSE ('2000'+ SUBSTRING (attrVal, LEN(ATTRVAL), LEN(ATTRVAL))) END)
		FROM APP_ClientProp CP (NOLOCK)
		INNER JOIN @nodePropertiesXML T ON  T.t_clientId = CP.componentNameId AND attrName = 'Galaxy Instance name'
		WHERE t_isSelected = 0
		--DEFAULT INDEX DIRECTORY
		INSERT INTO @nodePropsMap
		SELECT DISTINCT t_clientId, 'INDEXLOCATION', dbo.GetDefaultAnalyticsIndexPath(t_clientId, '')
		FROM @nodePropertiesXML
		WHERE t_isSelected = 0
		--DEFAULT PORT NO
		--port no should be same as instance no
		UPDATE @nodePropertiesXML
		SET t_nodeProps = (SELECT t_name as '@name', T_value AS '@value'
					FROM @nodePropsMap P WHERE P.t_clientId = N.t_clientId FOR XML PATH('nodeMetaInfos'), ROOT('NodeMetaProp'))
		FROM @nodePropertiesXML N
		WHERE t_isSelected = 0
	END
		--get node properties
		DECLARE @nodeNameValueMap TABLE (t_clientId INT, t_name NVARCHAR(1024), t_value NVARCHAR(1024), tr_isSelected INT)
		INSERT INTO @nodeNameValueMap
		SELECT DISTINCT t_clientId, ref1.value('@name', 'NVARCHAR(1024)'), ref1.value('@value', 'NVARCHAR(1024)'), t_isSelected
		FROM  @nodePropertiesXML N
			CROSS APPLY N.t_nodeProps.nodes('NodeMetaProp/nodeMetaInfos') as R1(ref1)
		--set avialable nodes as not selected state
		UPDATE @nodeNameValueMap
		SET t_value = 'false'
		WHERE tr_isSelected  =0 AND t_name = 'ISENABLED'
IF @cloudType IN (1,5,9)
		BEGIN
			--in case if webserver package is uninstalled
			UPDATE  @nodeNameValueMap
			SET		t_value = 'false'
			WHERE	t_name = 'WEBSERVER'
			--Reset webserver package  status
			MERGE  @nodeNameValueMap as Dest
			USING (SELECT DISTINCT T.t_clientId
						FROM simInstalledPackages P (nolock)
						INNER JOIN @nodePropertiesXML T ON  T.t_clientId = P.clientId
WHERE P.simPackageID IN (252, 263,1156,1174)) AS Src
					on  Dest.t_clientId = Src.t_clientId
				AND Dest.t_name = 'WEBSERVER'
			WHEN MATCHED
				THEN UPDATE SET  t_value = 'true'
			WHEN NOT MATCHED THEN
				INSERT (t_clientId, t_name, t_value)
				Values( Src.t_clientId, 'WEBSERVER', 'true');
		END
		IF NOT EXISTS (SELECT 1 FROM @nodeNameValueMap WHERE t_name = 'ISENABLED' )
			INSERT INTO @nodeNameValueMap (t_clientId, t_name, t_value)
			SELECT DISTINCT T.t_clientId, 'ISENABLED', 'true'
			FROM DM2SearchServerCoreInfo S (nolock)
			INNER JOIN @nodePropertiesXML T ON  T.t_clientId = S.clientId
			WHERE S.CloudType = @cloudType
		--get index location from cloud level
		DECLARE @clodMetaProp TABLE (t_name NVARCHAR(1024), t_value NVARCHAR(1024))
		INSERT INTO @clodMetaProp (t_name, t_value)
		EXEC APPGetDM2CloudMetaProp @CloudId , 'INDEXLOCATION'
IF @cloudType = 5
		BEGIN
			--index location is stored at cloud level for cluster cloud
			INSERT INTO @nodeNameValueMap (t_clientId,t_name, t_value)
			SELECT DISTINCT  t_clientId, C.t_name, C.t_value
			FROM  @nodeNameValueMap P
			CROSS JOIN @clodMetaProp C
			WHERE C.t_name = 'INDEXLOCATION'
			AND NOT EXISTS ( SELECT 1 FROM @nodeNameValueMap T WHERE T.t_name  = 'INDEXLOCATION' AND T.t_clientId =P.t_clientId )
			INSERT INTO @clodMetaProp (t_name, t_value)
			EXEC APPGetDM2CloudMetaProp @CloudId , 'REPLICATION'
			INSERT INTO @clodMetaProp (t_name, t_value)
			EXEC APPGetDM2CloudMetaProp @CloudId , 'LANGUAGE'
		END
ELSE IF @cloudType = 1
		BEGIN
		--use index location from cloud level if not specified at node level
			INSERT INTO @nodeNameValueMap (t_clientId,t_name, t_value)
			SELECT DISTINCT  t_clientId, C.t_name, C.t_value
			FROM  @nodeNameValueMap P
			CROSS JOIN @clodMetaProp C
			WHERE C.t_name = 'INDEXLOCATION'
			AND NOT EXISTS ( SELECT 1 FROM @nodeNameValueMap T WHERE T.t_name  = 'INDEXLOCATION' AND T.t_clientId =P.t_clientId )
		END
		INSERT INTO #nodeProperties  (
				clientId,clientName, clientDisplayName, indexDirectory,
				javaMaxMem,	portNo,	analyticsEnabled, isWebserver,
				nodeStatus	,URL )
		SELECT DISTINCT S.t_clientId,	C.NAME, C.displayName,
		ISNULL((SELECT TOP 1 t_value FROM @nodeNameValueMap WHERE t_name = 'INDEXLOCATION' AND t_clientId = S.t_clientId),N'NA') ,
		ISNULL((SELECT TOP 1 t_value FROM @nodeNameValueMap WHERE t_name = 'JVMMAXMEMORY' AND t_clientId = S.t_clientId),'4096') ,
		ISNULL((SELECT TOP 1 t_value FROM @nodeNameValueMap WHERE t_name = 'PORTNO' AND t_clientId = S.t_clientId),'20000') ,
		ISNULL((SELECT TOP 1 t_value FROM @nodeNameValueMap WHERE t_name = 'ISENABLED' AND t_clientId = S.t_clientId),'false'),
		ISNULL((SELECT TOP 1 t_value FROM @nodeNameValueMap WHERE t_name = 'WEBSERVER' AND t_clientId = S.t_clientId),'false'),
		S.t_status,
		N'http://' + C.net_hostname + ':' + ISNULL((SELECT t_value FROM @nodeNameValueMap WHERE t_name = 'PORTNO' AND t_clientId = S.t_clientId),'20000')
		FROM @nodePropertiesXML S
		JOIN APP_CLIENT C (NOLOCK) ON S.t_clientId = C.id
		INSERT INTO #indexServer (	cloudServerType, cloudId, cloudStatus,	cloudName ,
									cloudDisplayName,	indexDirectory ,analyticsEnabled,
									zkCloudId ,	zkCloudName
								)
		SELECT DISTINCT S.cloudType, S.CloudId,	0,'','','',
			'true', 0, ''
		FROM DM2SearchServerCoreInfo S (NOLOCK)
		JOIN APP_CLIENT C (NOLOCK) ON S.clientId = C.id
		where cloudid =@cloudId AND cloudType = @cloudType
IF @cloudType = 9
		BEGIN
				--port no should be same as instance no
				INSERT INTO #nodeProperties  (	clientId,clientName, clientDisplayName, indexDirectory,	javaMaxMem,	portNo,	analyticsEnabled, isWebserver, nodeStatus	,URL )
				SELECT DISTINCT C.Id,	C.NAME, C.displayName, N'NA' ,'4096' ,  (CASE WHEN  attrVal = 'Instance001' THEN '20000' ELSE ('2000'+ SUBSTRING (attrVal, LEN(ATTRVAL), LEN(ATTRVAL))) END),'false','false', 0, ''
				FROM APP_CLIENT C (NOLOCK)
				JOIN SimInstalledPackages SP (NOLOCK) ON SP.clientId = C.id
				JOIN APP_ClientProp CP (NOLOCK) ON SP.clientId = CP.componentNameId AND attrName = 'Galaxy Instance name'
LEFT JOIN DM2SearchServerCoreInfo S (NOLOCK) ON S.clientId = C.id AND S.cloudType IN (1,9)
WHERE SP.simPackageID IN ( 55, 1306) AND S.clientId IS NULL
		END
		IF EXISTS (SELECT 1 FROM #indexServer)
		BEGIN
			UPDATE #indexServer
			SET cloudName  =C.name,
			cloudDisplayName = C.displayName,
			cloudStatus = C.status,
			zkCloudId= C.zookeeperCloudId,
			zkCloudName = CL.name,
			indexServerClientId = C.pseudoClientId
			FROM DM2Cloud C (NOLOCK)
				JOIN #indexServer  T ON C.cloudId = T.cloudId
				LEFT JOIN App_client CL (NOLOCK) ON C.zookeeperCloudId =CL.id
			UPDATE #indexServer
			SET indexDirectory  =(SELECT TOP 1 t_value FROM @clodMetaProp where t_name ='INDEXLOCATION')
			UPDATE #indexServer
			SET replicationFactor  =(SELECT TOP 1 t_value FROM @clodMetaProp where t_name ='REPLICATION'),
				indexServerLanguage =ISNULL((SELECT TOP 1 t_value FROM @clodMetaProp where t_name ='LANGUAGE'),0)
			UPDATE #indexServer
SET indexServerPoolId  = (CASE WHEN C.CloudType = 9 THEN C.pseudoClientId ELSE C.indexServerPoolClientId END)
			FROM DM2Cloud C (NOLOCK)
				JOIN #indexServer  T ON C.cloudId = T.cloudId
			UPDATE #indexServer
			SET indexServerPoolName  = C.name
			FROM APP_client C (NOLOCK)
				JOIN #indexServer  T ON C.Id = T.indexServerPoolId
			WHERE T.indexServerPoolId > 0
			UPDATE #indexServer
			SET clusterType = CAST (I.attrVal AS INT)
			FROM APP_InstanceProp I (NOLOCK)
			JOIN APP_Application S (NOLOCK) ON I.componentNameId = S.instance
WHERE S.ClientId = @i_clientId AND I.attrname = 'Distributed Cluster Type' AND I.modified = 0
			UPDATE #indexServer
			SET planId = plan1.id,
				planName = plan1.Name
			FROM APP_Application S (NOLOCK)
			JOIN APP_PlanProp planProp (NOLOCK) ON S.dataArchGrpId = CAST(planProp.attrval AS INT) AND planProp.attrName ='Storage Policy' AND planProp.modified =0
			JOIN APP_Plan plan1 (NOLOCK) ON planProp.componentNameId = plan1.id
WHERE S.ClientId = @i_clientId AND S.appTypeID = 64  AND S.subClientStatus & 0x00008>0 AND plan1.subType = 33554437
			--exclude CV_DEFAULT storage policy
			UPDATE #indexServer
			SET storagePolicyId = S.dataArchGrpId,
				storagePolicyName = AG.name
			FROM APP_Application S (NOLOCK)
			JOIN archGroup AG (NOLOCK) ON S.dataArchGrpID = AG.id
WHERE S.ClientId = @i_clientId AND S.appTypeID = 64 AND S.subClientStatus & 0x00008>0 AND S.dataArchGrpID > 1
		END
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDM2CloudServers')
	delete from GxQscripts where name = 'AppGetDM2CloudServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDM2CloudServers')
	delete from GXDBVersions where aliasname = 'AppGetDM2CloudServers'
GO

insert into GXDBVersions values(2, 'AppGetDM2CloudServers',  'v1.1.2.20.4.2', 'AppGetDM2CloudServers', 'v1.1.2.20.4.2')
GO

