

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDCPlanEntitiesForCIJobPrologue.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetDCPlanEntitiesForCIJobPrologue.sp,v $ $Id: AppGetDCPlanEntitiesForCIJobPrologue.sp,v 1.1.2.4 2020/12/22 16:13:05 alakra Exp $";
--	+===================================================================+
--	| AppGetDCPlanEntitiesForCIJobPrologue  									|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetDCPlanEntitiesForCIJobPrologue')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDCPlanEntitiesForCIJobPrologue <<<'
	drop procedure AppGetDCPlanEntitiesForCIJobPrologue
END
IF EXISTS (select * from GxQscripts where name='AppGetDCPlanEntitiesForCIJobPrologue')
	delete from GxQscripts where name = 'AppGetDCPlanEntitiesForCIJobPrologue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDCPlanEntitiesForCIJobPrologue')
	delete from GXDBVersions where aliasname = 'AppGetDCPlanEntitiesForCIJobPrologue'
GO
print '... Creating Procedure: AppGetDCPlanEntitiesForCIJobPrologue'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetDCPlanEntitiesForCIJobPrologue
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @userId INT,
  @localeId INT,
  @dcPlanId INT,
  @commcellId INT
AS
SET NOCOUNT ON
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
    CREATE TABLE #getIndexServers
            (     serverURL NVARCHAR(512),
                  clientId INT,
                  clientName NVARCHAR(256),
                  cloudId INT,
                  hostName NVARCHAR(256),
                  basePort INT,
                  engineName  NVARCHAR(256),
                  serverType INT,
                  indexServerClientId INT,
                  internalCloudName NVARCHAR(256)
            )
	INSERT INTO #DCPlanInfoSubclientInfoTbl
	SELECT DISTINCT AAP.id, AAP.subclientName, AAP.appTypeId, AAP.backupSet, AAP.instance, AAP.clientId, AAP.dataArchGrpID
	FROM APP_SubClientProp ASCP WITH(READUNCOMMITTED)
		INNER JOIN APP_Application AAP WITH(READUNCOMMITTED)
ON AAP.id=ASCP.componentNameId AND ASCP.attrname='Associated DC Plan' AND ASCP.cs_attrName = CHECKSUM(N'Associated DC Plan') AND ASCP.attrval=@dcPlanId AND ASCP.modified=0
DECLARE @planIndexServerId INT = dbo.AppPlanGetEntityValueV2(@dcPlanId, 'Analytics Index Server Id',  default)
	EXEC DM2GetIndexServers @i_indexServerClientId=@planIndexServerId
	INSERT INTO #AccessNodesInfoTbl
	SELECT DISTINCT AC.id, AC.name	-- Get MA for said Storage Policy (with webserver and Index Gateway package)
	FROM #DCPlanInfoSubclientInfoTbl DCP
		INNER JOIN ArchGroup AG WITH(READUNCOMMITTED)
			ON AG.id=DCP.storagePolicyId AND DCP.storagePolicyId > 1
		INNER JOIN MMDataPath DPath WITH(READUNCOMMITTED)
			ON AG.defaultCopy = DPath.CopyId
		INNER JOIN MMDrivePool DPool WITH(READUNCOMMITTED)
			ON DPath.DrivePoolId = DPool.DrivePoolId
		INNER JOIN App_Client AC  WITH(READUNCOMMITTED)
			ON AC.id=DPool.ClientId
		INNER JOIN simInstalledPackages SIM_Required_Packages WITH(READUNCOMMITTED)	-- Webserver OR Index Gateway Package Manadatory
ON SIM_Required_Packages.ClientId=AC.id AND SIM_Required_Packages.simPackageID IN (252, 263, 1174, 1156)
	UNION
	-- We need to provide MA of DC plan index server as access node too
	SELECT clientId,clientName FROM #getIndexServers
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDCPlanEntitiesForCIJobPrologue')
	delete from GxQscripts where name = 'AppGetDCPlanEntitiesForCIJobPrologue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDCPlanEntitiesForCIJobPrologue')
	delete from GXDBVersions where aliasname = 'AppGetDCPlanEntitiesForCIJobPrologue'
GO

insert into GXDBVersions values(2, 'AppGetDCPlanEntitiesForCIJobPrologue',  '00010001000200040000', 'AppGetDCPlanEntitiesForCIJobPrologue', '00010001000200040000')
GO

