

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDCPlanEntitiesForCIJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetDCPlanEntitiesForCIJob.sp,v $ $Id: AppGetDCPlanEntitiesForCIJob.sp,v 1.1.2.5 2020/12/18 06:15:23 alakra Exp $";
--	+===================================================================+
--	| AppGetDCPlanEntitiesForCIJob  									|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetDCPlanEntitiesForCIJob')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDCPlanEntitiesForCIJob <<<'
	drop procedure AppGetDCPlanEntitiesForCIJob
END
IF EXISTS (select * from GxQscripts where name='AppGetDCPlanEntitiesForCIJob')
	delete from GxQscripts where name = 'AppGetDCPlanEntitiesForCIJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDCPlanEntitiesForCIJob')
	delete from GXDBVersions where aliasname = 'AppGetDCPlanEntitiesForCIJob'
GO
print '... Creating Procedure: AppGetDCPlanEntitiesForCIJob'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetDCPlanEntitiesForCIJob
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @xmlString XML OUTPUT
AS
SET NOCOUNT ON
	DECLARE @errCode			INTEGER = 0 -- error code
	DECLARE @errString			VARCHAR(1024)  ='' -- error string
BEGIN TRY
    SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	-- User Id
   DECLARE @i_userId INT = ISNULL((SELECT ref.value('@userId', 'INT')
           FROM @xmlString.nodes('Api_GetDCPlanEntitiesForCIJob/processinginstructioninfo/user') r (ref)), 1)
   -- Locale
   DECLARE @i_localeId INT = ISNULL((SELECT  ref.value('@localeId', 'INT')
           FROM @xmlString.nodes('Api_GetDCPlanEntitiesForCIJob/processinginstructioninfo/locale') R ( ref )),0)
	-- Get planId
	DECLARE @dcPlanId INT = ISNULL((SELECT ref.value('@planId', 'INT') FROM @xmlString.nodes('Api_GetDCPlanEntitiesForCIJob/plan') R ( ref )), 0)
	DECLARE @includePlanInfo INT = ISNULL((SELECT ref.value('@includePlanInfo', 'INT') FROM @xmlString.nodes('Api_GetDCPlanEntitiesForCIJob') R ( ref )), 0)
	IF OBJECT_ID('tempdb.dbo.#DCPlanInfoSubclientInfoTbl') IS NOT NULL DROP TABLE #DCPlanInfoSubclientInfoTbl
	IF OBJECT_ID('tempdb.dbo.#AccessNodesInfoTbl') IS NOT NULL DROP TABLE #AccessNodesInfoTbl
	CREATE TABLE #DCPlanInfoSubclientInfoTbl (id INT NOT NULL IDENTITY PRIMARY KEY, subclientId INT, subclientName NVARCHAR(255), appTypeId INT,backupSetId INT, instanceId INT, clientId INT, storagePolicyId INT)
	CREATE TABLE #AccessNodesInfoTbl (dataAccessNodeId INT ,  dataAccessNodeName NVARCHAR(255))
	-- 2 is Default Commcell Id. May be needed by JobManager Code which is going to call below SP
	EXEC dbo.AppGetDCPlanEntitiesForCIJobPrologue @i_userId, @i_localeId, @dcPlanId, 2
	-- For a given DC Plan, fetch plan CI Policy Id
DECLARE @ciPolicyId INT  = ISNULL(dbo.AppPlanGetEntityValueV2(@dcPlanID,'Content Indexing Policy',default),0)
	DECLARE @ciPolicyXML XML
	DECLARE @ciPolicyFinalXML XML
	DECLARE @planXML XML
	IF (@ciPolicyId > 0)
	BEGIN
		-- If we got the configuration Policy , then get the entire configuration policy reponse
        SET @ciPolicyXML = (
                                SELECT 30 AS '@propertyLevel',  -- ListPropertyLevels_AllProperties
                                (
                                    SELECT
                                    (
                                        SELECT @ciPolicyId AS '@policyId' FOR XML PATH('policyEntity'), TYPE
                                    )
                                    FOR XML PATH('policy'), TYPE
                                ) ,
                                (
                                    SELECT
                                        (
                                            SELECT 'skipSelectStatment' AS '@name', '1' AS '@value'
                                            FOR XML PATH('attributes'), TYPE
                                        )
                                    FOR XML PATH('processinginstructioninfo'), TYPE
                                )
                                FOR XML PATH('Ida_GetConfigurationPolicyReq'), TYPE
                              )
        EXEC AppConfigurationPolicyGet @ciPolicyXML OUTPUT
		SET @ciPolicyFinalXML = (SELECT @ciPolicyXML.value('(/Ida_GetConfigurationPolicyResp/policies[1]/@policyType)[1]', 'INT') as '@policyType',
									@ciPolicyXML.value('(/Ida_GetConfigurationPolicyResp/policies[1]/@flags)[1]', 'INT') as '@flags',
									@ciPolicyXML.query('/Ida_GetConfigurationPolicyResp/policies[1]/*')
								FOR XML PATH('ciPolicy'), TYPE)
	END
	-- In our current implementation, caller is not expected to ask for all plan details. This is for future support
	IF (@includePlanInfo = 1)
	BEGIN
		DECLARE @planDetails XML
		-- Temp result tables - plan Details table
		IF object_id('tempdb.dbo.#tempPlanDetailsTbl') IS NOT null DROP TABLE #tempPlanDetailsTbl
		CREATE TABLE #tempPlanDetailsTbl
		(
			spOutput XML
		)
		EXEC AppPlanGetDetailsV2 @dcPlanID, @i_userId, 0, 0, 0, @planDetails OUTPUT
		SELECT @planDetails= spOutput from #tempPlanDetailsTbl
		-- First fetch plan Info
		SET @planXML =(SELECT @planDetails.query('/Api_GetPlanDetailsResp/plan')
                                    FOR XML PATH(''), TYPE)
		-- Now remove and insert new tag XML tag --- CiPolicy
		SET @planXML.modify('delete  (/plan/ciPolicy)')
		SET @planXML.modify(' insert sql:variable("@ciPolicyFinalXML") into (/plan)[1] ')
	END
	ELSE
	BEGIN
		SET @planXML =(	SELECT @ciPolicyFinalXML
								FOR XML PATH('plan'),TYPE)
	END
	-- We are not populating any other Message object for Plan Ifno. But that can be extended later if needed.
	SET @xmlString = (SELECT @planXML,
							(SELECT subclientId AS '@subclientId',subclientName AS '@subclientName', apptypeId AS '@applicationId',backupsetId AS '@backupsetId',instanceId AS '@instanceId',clientId AS '@clientId'
									FROM #DCPlanInfoSubclientInfoTbl
								FOR XML PATH('subclients'),TYPE),
							(SELECT dataAccessNodeName AS '@clientName',dataAccessNodeId AS '@clientId'
									FROM #AccessNodesInfoTbl
								FOR XML PATH('accessNodes'),TYPE),
							(
								SELECT @errCode  AS '@errorCode', @errString AS '@errorMessage'
									FOR    XML PATH('error'), TYPE
							)
							FOR XML PATH('Api_DCPlanEntitiesForCIJobResponse'),TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errCode = ERROR_NUMBER()
    SET @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @xmlString = ( SELECT
					(
						SELECT @errCode  AS '@errorCode', @errString AS '@errorMessage'
							FOR    XML PATH('error'), TYPE
					)
                 FOR XML PATH('Api_DCPlanEntitiesForCIJobResponse'), TYPE
                )
END CATCH
SELECT @xmlString
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDCPlanEntitiesForCIJob')
	delete from GxQscripts where name = 'AppGetDCPlanEntitiesForCIJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDCPlanEntitiesForCIJob')
	delete from GXDBVersions where aliasname = 'AppGetDCPlanEntitiesForCIJob'
GO

insert into GXDBVersions values(2, 'AppGetDCPlanEntitiesForCIJob',  '00010001000200050000', 'AppGetDCPlanEntitiesForCIJob', '00010001000200050000')
GO

