

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDBSubClientProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- 4 backupset types for SharePoint -- corresponding to enum SharepointBackupSetType
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetDBSubClientProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDBSubClientProperties <<<'
	drop procedure AppGetDBSubClientProperties
END
IF EXISTS (select * from GxQscripts where name='AppGetDBSubClientProperties')
	delete from GxQscripts where name = 'AppGetDBSubClientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDBSubClientProperties')
	delete from GXDBVersions where aliasname = 'AppGetDBSubClientProperties'
GO
print '... Creating Procedure: AppGetDBSubClientProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetDBSubClientProperties
  @subclientId INT,
  @propertyLevel INT,
  @localeId INT,
  @xmlResult XML OUTPUT
AS
	DECLARE	@applicationId		INT
	DECLARE	@clientId		INT
	DECLARE	@databaseID			INT
	DECLARE	@databaseSize		INT
	DECLARE @creationTime		INT
	DECLARE	@options			INT
	DECLARE @options2			INT
	DECLARE @systemFlags		INT
	DECLARE @status				INT
	DECLARE @status2			BIGINT
	DECLARE @dbrecoveryOrder	INT
	DECLARE @dbowner			NVARCHAR(MAX)
	DECLARE @index			INT
	DECLARE @dbName			NVARCHAR(MAX)
	DECLARE @dbParameters	NVARCHAR(MAX)
	DECLARE @numberOfBackupStreams	INT
	DECLARE @numberOfTransactionLogStreams	INT
	DECLARE @disableAutoDiscovery INT
	DECLARE @discoverType			INT
	DECLARE @mssqlblockSize			INT
	DECLARE @mssqlbufferCount		INT
	DECLARE @mssqlmaxTransferSize	INT
	DECLARE @mssqldisableLogConsistencyCheck INT
	DECLARE @backupRules			INT
	DECLARE @ffgName			NVARCHAR(MAX)
	DECLARE	@fileId			INT
	DECLARE	@fileGroupId			INT
	DECLARE @isFile INT
	DECLARE @msSqlSubclientType INT
	DECLARE @subclientRecoveryType		INT
	DECLARE @useBlockLevelBackupWithOptimizedRecovery INT
	DECLARE @mssqlEnableShrink INT = 0
	DECLARE @mssqlLogSizeThresholdMB INT = 0
	DECLARE @mssqlLogFreePercentThreshold INT = 0
	DECLARE @blockLevelSPOSBackup INT
	DECLARE @isRebootNowPermitted INT
	DECLARE @sDumpSweepCache NVARCHAR(MAX)
	DECLARE @sBackupStagingDir NVARCHAR(MAX)
	DECLARE @DeterminePstOwnership	INT
	DECLARE	@pstOwnerBasedOnLaptop	INT
	DECLARE	@startingFolderPath		NVARCHAR(MAX)
	DECLARE	@pstsWithNoOwnerInfoMailbox		NVARCHAR(MAX)
	DECLARE	@adProperty				NVARCHAR(MAX)
	DECLARE	@createSeparateParent	INT
	DECLARE	@createPSTSpecificFolder			NVARCHAR(MAX)
	DECLARE	@usePstName				INT
	DECLARE	@usePstNameForNoOwner	INT
	DECLARE @refCopyContent			NVARCHAR(MAX)
	DECLARE @refCopyAssociation		NVARCHAR(MAX)
	DECLARE @exchangeMbSubclientType	INT
	DECLARE @description		VARCHAR(MAX)
	DECLARE @forceFull			VARCHAR(MAX)
	DECLARE @dbPath				VARCHAR(MAX)
	DECLARE @logPath			VARCHAR(MAX)
	DECLARE @storageGroup		VARCHAR(MAX)
	DECLARE @databaseName		VARCHAR(MAX)
	DECLARE @bUseEventCheck		INT
	DECLARE @lastEventCheckTime	INT
	DECLARE @lastEventCheckTimeType INT
	DECLARE @backupFromPassiveCopy INT = 0
	DECLARE @backupFromActiveCopy INT = 0
	DECLARE @useLastActivation INT = 0
	DECLARE @serverType INT = 1
	DECLARE @numberOfExchangeBackupStreams INT = 1
	DECLARE @optimizeForMessageLevelRecovery INT = 0
	DECLARE @dagOptions INT = 0
	DECLARE @isUseBlockLevelBackup INT = 0
	DECLARE @databaseTitle		VARCHAR(MAX)
	DECLARE @RelativePath		VARCHAR(MAX)
	DECLARE @dbiid				VARCHAR(MAX)
	DECLARE @dbiid1				VARCHAR(MAX)
	DECLARE @dbiid2				VARCHAR(MAX)
	DECLARE @dbiid3				VARCHAR(MAX)
	DECLARE @dbiid4				VARCHAR(MAX)
	DECLARE @cc_prop_name				VARCHAR(MAX)
	DECLARE @cc_prop_val				VARCHAR(MAX)
	DECLARE @cc_prop_auto_discovery		INTEGER
	DECLARE @cc_prop_Enterprise_Flag	INTEGER
	DECLARE @cc_auto_add_mailboxes		INTEGER
	DECLARE @cc_google_multidomain		INTEGER
	DECLARE	@cc_google_teamDrive		INTEGER
	DECLARE	@cc_google_domainId			VARCHAR(MAX)
	DECLARE	@cc_oneDrive_oneNote		INTEGER
	DECLARE @cc_regex_list				XML
	DECLARE @cloudDbContent XML
	DECLARE @configXml		XML
	DECLARE @CloudConnectorInfoTbl TABLE
	(
	subclientId		int,
	includePath		VARCHAR(MAX),
	excludePath		VARCHAR(MAX),
	includeAccounts VARCHAR(MAX),
	excludeAccounts VARCHAR(MAX)
	)
	DECLARE @SybaseDBInfo TABLE (
								databaseName NVARCHAR(MAX),
								databaseID INT,
								databaseSize INT,
								creationTime INT,
								options INT,
								options2 INT,
								systemFlags INT,
								status INT,
								status2 BIGINT,
								dbrecoveryOrder INT,
								dbowner NVARCHAR(MAX))
	DECLARE @MSSQLDBInfo TABLE (databaseName NVARCHAR(MAX),
								databaseID INT,
								discoverType INT
								)
	DECLARE @MSSQLFFGInfo TABLE (ffgName NVARCHAR(MAX),
	fileGroupName NVARCHAR(MAX),
	fileName NVARCHAR(MAX),
	fileId INT,
	fileGroupId INT,
	isFile INT,
	discoverType INT
	)
	DECLARE @MSExchangeDBInfo TABLE (databaseName VARCHAR(MAX),
									storageGroupName VARCHAR(MAX),
									mbDescription VARCHAR(MAX),
									forceFull VARCHAR(MAX),
									dbPath VARCHAR(MAX),
									logPath VARCHAR(MAX),
									discoverType VARCHAR(MAX)
									)
	DECLARE @MSExchangeDBServer TABLE (databaseName NVARCHAR(MAX),
									server NVARCHAR(MAX)
									)
	DECLARE @LotusNotesDBInfo TABLE (RelativePath VARCHAR(MAX),
									databaseTitle VARCHAR(MAX),
									dbiid1 VARCHAR(MAX),
									dbiid2 VARCHAR(MAX),
									dbiid3 VARCHAR(MAX),
									dbiid4 VARCHAR(MAX)
									)
	DECLARE @selectiveOnlineFull	INT
	DECLARE @backupMode				INT
	DECLARE @oracleData				INT
	DECLARE @backupControlFile		INT
	DECLARE @backupSPFile			INT
	DECLARE @protectBackupRecoveryArea	INT
	DECLARE @dataFilesPerBFS		INT
	DECLARE @maxBackupSetSizeInKB	BIGINT
	DECLARE @sectionSizeInKB		BIGINT
	DECLARE @archiveFilesPerBFS		INT
	DECLARE @maxOpenFiles			INT
	DECLARE @oracleTag				VARCHAR(MAX)
	DECLARE @lightsOutScript		INT
	DECLARE @warning				INT
	DECLARE @useSQLConntect			INT
	DECLARE @delayTimeinMin			INT
	DECLARE @sleepTimeinMin			INT
	DECLARE @sleepTimeinSec			INT
	DECLARE @triesNumber			INT
	DECLARE @startupPFile			VARCHAR(MAX)
	DECLARE @skipReadOnly			INT
	DECLARE @skipOffline			INT
	DECLARE @skipInaccessible		INT
	DECLARE @validate				INT
	DECLARE @enableTableBrowse		INT
	DECLARE @mergeIncImageCopies	INT
	DECLARE @resyncCatalog			INT
	DECLARE @backupArchiveLog		INT
	DECLARE @backupArchiveLogOption	INT
	DECLARE @archiveDelete			INT
	DECLARE @archiveDeleteAll		INT
	DECLARE @disableSwitchCurrentLog	INT
	DECLARE @useRmanForLogBackup	INT
	DECLARE @logThresholdStreams	INT
	DECLARE @selectArchiveLogDestForBackup	INT
	DECLARE @archiveLogDestForBackup	VARCHAR(MAX)
	DECLARE @archiveLogDestForBackupTBL TABLE( archiveLogDestForBkp VARCHAR(MAX) )
	DECLARE @backupCopyInterface    INT
	DECLARE @oracleDataBackupStreams XML
	DECLARE @oracleLogBackupStreams XML
	DECLARE @selectArchiveLogDestForDelete	INT
	DECLARE @archiveLogDestForDelete	VARCHAR(MAX)
	DECLARE @archiveLogDestForDeleteTBL TABLE( archiveLogDestForDel VARCHAR(MAX) )
	DECLARE @dataThresholdStreams	INT
	DECLARE @oracleSubclientType	INT
	DECLARE @archiveDataFilesPath	NVARCHAR(MAX)
	DECLARE @createUniformView		INT
	DECLARE @dataExportFormat		INT
	DECLARE @historyDatabase		INT
	DECLARE @retainDataInHistoryTables INT
	DECLARE @retainDataOnMedia		INT
	DECLARE @archClientName			NVARCHAR(MAX)
	DECLARE @archClientId           INT
	DECLARE @archInstanceName		NVARCHAR(MAX)
	DECLARE @archInstanceId			INT
	DECLARE @archDomainName			NVARCHAR(MAX)
	DECLARE @archUserName			NVARCHAR(MAX)
	DECLARE @archContent			NVARCHAR(MAX)
	DECLARE @dataExport				INT
	DECLARE @snapImageCopy			INT
	DECLARE @imageCopyDir			NVARCHAR(MAX)
	--DB2:Start
	DECLARE @db2BackupData				INT
	DECLARE @db2BackupType				INT
	DECLARE @db2BackupMode				INT
	DECLARE @db2NumberofBuffer			INT
	DECLARE @db2BufferSize				INT
	DECLARE @db2Parallelism				INT
	DECLARE @db2UseCompression			INT
	DECLARE @db2BackupLogFiles			INT
	DECLARE @db2DeleteLogFilesAfter		INT
	DECLARE @db2DisableSwitchCurrentLog	INT
	DECLARE @db2UseDedupeDevice			INT
	DECLARE @db2EnableTableBrowse		INT
	DECLARE @skipLogsInBackupImage		INT
	DECLARE @db2DataPartitionStreams	NVARCHAR(1024)
	--DB2:End
	--SAP for Oracle:Start
	DECLARE @sapSelectiveOnlineFull		INT
	DECLARE @sapBackupDevice			INT
	DECLARE @sapBackupMode				INT
	DECLARE @sapBackupArchiveLog		INT
	DECLARE @sapArchiveDelete			INT
	DECLARE @sapDisableSwitchCurrentLog INT
	DECLARE @sapArchiveLogSecondCopy	INT
	DECLARE @sapData					INT
	--SAP for Oracle:End
	-- Virtual Server:Start
	DECLARE @vmContent XML
	DECLARE @vmContentStr VARCHAR(MAX)
	DECLARE @vmFilter XML
	DECLARE @vmFilterStr VARCHAR(MAX)
	DECLARE @vmDiskFilter XML
	DECLARE @vmDiskFilterStr VARCHAR(MAX)
	-- vmBackupInfo for Virtual Server
	DECLARE @vmTotalCount				BIGINT
	DECLARE @vmProtectedCount			BIGINT
	DECLARE @vmNotProtectedCount		BIGINT
	DECLARE @vmPendingCount				BIGINT
	DECLARE @vmBackedUpWithErrorCount	BIGINT
	DECLARE @vmNeverBackedUpCount		BIGINT
	DECLARE	@parentSubclientId	INT = 0
	DECLARE @datastoreFreespaceRequired	NVARCHAR(MAX)
	DECLARE @datastoreFreespaceCheck	NVARCHAR(MAX)
	DECLARE @useChangedTrackingOnVM INT
	DECLARE @autoDetectVMOwner INT
	DECLARE @quiesceGuestFileSystemAndApplications INT
	DECLARE @vsaMemberServer			XML
	DECLARE @mssqlFFGDBId				NVARCHAR(MAX)
	DECLARE @mssqlFFGDBName				NVARCHAR(MAX)
	DECLARE @blockLevelReplication INT
	DECLARE @fileName			NVARCHAR(MAX)
	DECLARE @fileGroupName			NVARCHAR(MAX)
	DECLARE @proxyESXServer				XML
	DECLARE @vmCollectFileDetails			INT
	DECLARE @vmCollectFileDetailsForSnap	INT
	DECLARE @vmSnapRetentionOverride		INT
	DECLARE @vmSnapRetentionCount			INT
	DECLARE @retainSnap						INT
	DECLARE @vmCheckPointSetting			INT
	DECLARE @hypervisorCBTDefault			INT
	DECLARE @isVsaCrossAccountEnabled INT
	DECLARE @snapCopyAamazonClient INT
	DECLARE @snapCopyAaccountId	BIGINT
	DECLARE @snapCopyAaccessKey    NVARCHAR(255)
	DECLARE @isVsaCrossAccountCopyEnabled INT
	DECLARE @hcNodesXml					  XML
	-- Virtual Server:End
	-- Sharepoint:Start
	DECLARE @contentDatabaseSqlClientId NVARCHAR(16)
	DECLARE @contentDatabaseSqlClientName NVARCHAR(256)
	DECLARE @contentDatabasenumStreams NVARCHAR(16)
	DECLARE @contentDatabaseVDITimeOut NVARCHAR(16)
	DECLARE @spEnableArchiving NVARCHAR(16)
	DECLARE @rbsstoreclientId NVARCHAR(16)
	DECLARE @rbsstoreclientName NVARCHAR(256)
	DECLARE @sharePointBackupsetType INT
	-- Sharepoint:End
	-- GitApps:Start for GitHub and AzureDevOps' common attributes.
	DECLARE @gitAcccountName Nvarchar(1024)
	-- GitApps:End
	--Informix:Start
	DECLARE	@informixBackupMode			INT
	DECLARE	@informixincrementalLevel	INT
	DECLARE @informixBackupixbar		INT
	DECLARE	@informixBackuponconfig		INT
	DECLARE @informixMaxBarStreams		INT
	--Informix:End
	DECLARE @MySQLDBInfo TABLE (dbName NVARCHAR(MAX),
									dbSize VARCHAR(MAX),
									creationTime VARCHAR(MAX),
									discoverFlag VARCHAR(MAX),
									engineName VARCHAR(MAX)
									)
	DECLARE @PostGreDBInfo TABLE (dbName NVARCHAR(MAX),
									dbSize VARCHAR(MAX),
									creationTime VARCHAR(MAX)
									)
	DECLARE @collectObjectListDuringBackup INT
	DECLARE @postgreSubclientType INT = 0
	SET @applicationId = (SELECT appTypeId FROM APP_Application WITH (NOLOCK) WHERE APP_Application.id = @subclientId)
	SET @clientId = (SELECT clientId FROM APP_Application WITH (NOLOCK) WHERE APP_Application.id = @subclientId)
IF @applicationId = 106
	BEGIN
		SET @parentSubclientId = ISNULL((select top 1 CAST(attrVal AS INT) from APP_ClientProp CP WITH (NOLOCK) WHERE CP.componentNameId = @clientId and CP.attrName='VSA Discover Subclient ID' and modified=0 order by created desc),0)
	END
	--Gather Sybase properties
IF(@applicationId = 5 AND @propertyLevel >= 30)
	BEGIN
		SET @numberOfBackupStreams = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Sybase Data backup streams' AND modified = 0)
		SET @numberOfTransactionLogStreams = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Sybase Log backup streams' AND modified = 0)
		DECLARE SybaseDBCur CURSOR FOR (select attrName, attrval from APP_SubClientProp WITH (NOLOCK) where attrtype = 116 AND componentNameId = @subclientId AND modified=0)
		OPEN SybaseDBCur
		FETCH SybaseDBCur INTO @dbName, @dbParameters
		SET @index = 0
		WHILE @@FETCH_STATUS = 0
		BEGIN
				select
					@databaseID = CASE WHEN Id = 1 THEN Data ELSE @databaseID END,
					@databaseSize = CASE WHEN Id = 2 THEN Data ELSE @databaseSize END,
					@creationTime = CASE WHEN Id = 3 THEN Data ELSE @creationTime END,
					@options = CASE WHEN Id = 4 THEN Data ELSE @options END,
					@options2 = CASE WHEN Id = 5 THEN Data ELSE @options2 END,
					@systemFlags = CASE WHEN Id = 6 THEN Data ELSE @systemFlags END,
					@status = CASE WHEN Id = 7 THEN Data ELSE @status END,
					@status2 = CASE WHEN Id = 8 THEN Data ELSE @status2 END,
					@dbrecoveryOrder = CASE WHEN Id = 9 THEN Data ELSE @dbrecoveryOrder END,
					@dbowner = CASE WHEN Id = 10 THEN Data ELSE @dbowner END
					FROM SplitString(@dbParameters,' ')
					--SET @databaseSize = NULLIF(@databaseSize,'0')
					--SET @options = NULLIF(@options,'0')
					--SET @options2 = NULLIF(@options2,'0')
					--SET @systemFlags = NULLIF(@systemFlags,'0')
					--SET @dbrecoveryOrder = NULLIF(@dbrecoveryOrder,'0')
				INSERT	INTO @SybaseDBInfo VALUES(@dbName, @databaseID, @databaseSize, @creationTime, @options, @options2, @systemFlags, @status, @status2, @dbrecoveryOrder, @dbowner)
				SET @index = @index + 1
				FETCH SybaseDBCur INTO @dbName, @dbParameters
		END
		CLOSE SybaseDBCur
		DEALLOCATE SybaseDBCur
		--Construct output XML
		SET	@xmlResult =
						(SELECT
							(SELECT	@numberOfBackupStreams AS '@numberOfBackupStreams',
									@numberOfTransactionLogStreams AS '@numberOfTransactionLogStreams'
							FOR XML PATH('sybaseSubclientProp'), TYPE),
							(SELECT
								(SELECT databaseName AS '@databaseName',
									databaseID AS '@databaseId',
									databaseSize AS '@databaseSize',
									--creationTime AS '@creationTime',
									options AS '@options',
									options2 AS '@options2',
									systemFlags AS '@systemFlags',
									status AS '@status',
									status2 AS '@status2',
									dbrecoveryOrder AS '@dbRecoveryOrder',
									dbowner AS '@owner',
									(SELECT creationTime as '@time',
										55 AS '@_type_'
										FOR XML PATH('creationTime'), TYPE)
										FROM @SybaseDBInfo AS sybaseDBInfo
										WHERE sybaseDBInfo.databaseName = SybaseDBInfoMain.databaseName
									FOR XML PATH('sybaseContent'),TYPE)
								FROM @SybaseDBInfo AS SybaseDBInfoMain
								FOR XML PATH('content'),TYPE)
						FOR XML PATH('DBSubClientProp'), TYPE)
	END
	--Gather MSSQL properties
IF(@applicationId = 81 AND @propertyLevel >= 30)
	BEGIN
	SET @msSqlSubclientType = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'mssql subclient type' AND modified = 0)
	SET @numberOfBackupStreams = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'mssql Data backup streams' AND modified = 0)
	SET @numberOfTransactionLogStreams = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'mssql Log backup streams' AND modified = 0)
	SET @disableAutoDiscovery = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'MSSQL Disable AutoDiscovery' AND modified = 0)
	SET @subclientRecoveryType = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'SQL Special Subclient Type' AND modified = 0)
	SET @mssqlblockSize = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'MSSQL Tunable BlockSize' AND modified = 0)
	SET @mssqlbufferCount = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'MSSQL Tunable BufferCount' AND modified = 0)
	SET @mssqlmaxTransferSize = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'MSSQL Tunable Max TransferSize' AND modified = 0)
	SET @mssqldisableLogConsistencyCheck = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'MSSQL Disable Log Consistency' AND modified = 0)
	SET @backupRules = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'mssql Bkp Conversion' AND modified = 0)
	SET @mssqlFFGDBId = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'mssql FFG db Id' AND modified = 0)
	SET @mssqlFFGDBName = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'mssql FFG db Name' AND modified = 0)
	IF @backupRules NOT IN (1,3,5,7)
		SET @backupRules = 0
	SET @mssqlEnableShrink = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'mssql enable log shrink' AND modified = 0)
	IF @mssqlEnableShrink = 1
	BEGIN
		SET @mssqlLogSizeThresholdMB = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'mssql shrink threshold size' AND modified = 0)
		SET @mssqlLogFreePercentThreshold = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'mssql shrink threshold free percent' AND modified = 0)
	END
	-- Database subclient.
	IF @msSqlSubclientType = 1
	BEGIN
		SET @useBlockLevelBackupWithOptimizedRecovery = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Use block-level backup with optimize recovery' AND modified = 0), 0)
		SET @blockLevelSPOSBackup = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Use block level SPOS backup' AND modified = 0), 0)
		SET @isUseBlockLevelBackup = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK)  WHERE componentNameID = @subclientId AND attrName = 'Use block level backup' AND modified = 0), 0)
		SET @isRebootNowPermitted = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'MSSQL Reboot now/later on QSNAP Installation' AND modified = 0), 0)
		DECLARE MSSQLDBCur CURSOR FOR (select attrName, attrval from APP_SubClientProp WITH (NOLOCK) where attrtype = 118 AND componentNameId = @subclientId  AND modified = 0)
			OPEN MSSQLDBCur
				FETCH MSSQLDBCur INTO @dbName, @dbParameters
				SET @index = 0
				WHILE @@FETCH_STATUS = 0
				BEGIN
					select
						@databaseID = CASE WHEN Id = 1 THEN Data ELSE @databaseID END,
						@discoverType = CASE WHEN Id = 2 THEN Data ELSE @discoverType END
						FROM SplitString(@dbParameters,' ')
					INSERT	INTO @MSSQLDBInfo VALUES(@dbName, @databaseID, @discoverType)
					SET @index = @index + 1
					FETCH MSSQLDBCur INTO @dbName, @dbParameters
				END
			CLOSE MSSQLDBCur
		DEALLOCATE MSSQLDBCur
		-- XML field for dump & sweep cache.
		-- This one used for LOG backups (database subclient type).
		SET @sDumpSweepCache = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'mssql dump sweep cache' AND modified = 0), N'')
	    SET @sBackupStagingDir = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'mssql backup staging directory' AND modified = 0), N'')
	END
	IF @msSqlSubclientType = 2
	BEGIN
		--FFG content
		DECLARE MSSQLFFGCur CURSOR FOR (select attrName, attrval from APP_SubClientProp WITH (NOLOCK) where attrtype = 119
		AND componentNameId = @subclientId  AND modified = 0)
			OPEN MSSQLFFGCur
				FETCH MSSQLFFGCur INTO @ffgName, @dbParameters
			--	SET @index = 0
				WHILE @@FETCH_STATUS = 0
				BEGIN
					SELECT
						@fileId = CASE WHEN Id = 1 THEN Data ELSE @fileId END,
						@fileGroupId = CASE WHEN Id = 2 THEN Data ELSE @fileGroupId END,
						@isFile = CASE WHEN Id = 3 THEN Data ELSE @isFile END,
						@discoverType = CASE WHEN Id = 4 THEN Data ELSE @discoverType END
						FROM SplitString(@dbParameters,' ')
					SELECT
						@fileGroupName = CASE WHEN Id = 1 THEN DATA ELSE @fileGroupName END,
						@fileName = CASE WHEN Id = 2 THEN DATA ELSE @fileName END
						FROM SplitString(@ffgName, ':')
					INSERT	INTO @MSSQLFFGInfo VALUES(@ffgName, @fileGroupName, @fileName, @fileId, @fileGroupId,@isFile, @discoverType)
	--				SET @index = @index + 1
					FETCH MSSQLFFGCur INTO @ffgName, @dbParameters
				END
			CLOSE MSSQLFFGCur
		DEALLOCATE MSSQLFFGCur
	END
	SET	@xmlResult =
		(SELECT
			(SELECT	@msSqlSubclientType As '@sqlSubclientType',
					--@runPostBackup AS '@runPostBackup',
					@numberOfBackupStreams AS '@numberOfBackupStreams',
					@numberOfTransactionLogStreams AS '@numberOfTransactionLogStreams',
					@disableAutoDiscovery AS '@disableAutoDiscovery',
					@mssqlblockSize AS '@blockSize',
					@mssqlbufferCount AS '@bufferCount',
					@mssqlmaxTransferSize AS '@maxTransferSize',
					@mssqldisableLogConsistencyCheck AS '@disableLogConsistencyCheck',
					@backupRules AS '@backupRules',
					@subclientRecoveryType AS '@subclientRecoveryType',
					@mssqlFFGDBId AS '@mssqlFFGDBId',
					@mssqlFFGDBName AS '@mssqlFFGDBName',
					@useBlockLevelBackupWithOptimizedRecovery AS '@useBlockLevelBackupWithOptimizedRecovery',
					@isUseBlockLevelBackup AS '@blockLevelBackup',
					@mssqlEnableShrink AS '@enableLogShrinkOperation',
					@mssqlLogSizeThresholdMB AS '@thresholdLogFileSizeInMB',
					@mssqlLogFreePercentThreshold AS '@thresholdLogFreeSpaceInPercent',
					@blockLevelSPOSBackup AS '@blockLevelSPOSBackup',
					@isRebootNowPermitted AS '@isRebootNowPermitted',
					@sDumpSweepCache AS '@dumpSweepCache',
					@sBackupStagingDir AS '@backupStagingDir'
				FOR XML PATH('mssqlSubClientProp'), TYPE),
				(SELECT
					(SELECT databaseName AS '@databaseName',
						databaseID AS '@databaseId',
						discoverType AS '@discoverType'
						FROM @MSSQLDBInfo AS mssqlDBInfo
						WHERE mssqlDBInfo.databaseName = MSSQLDBInfoMain.databaseName
						FOR XML PATH('mssqlDbContent'),TYPE)
					FROM @MSSQLDBInfo AS MSSQLDBInfoMain
						FOR XML PATH('content'),TYPE),
				(SELECT
					(SELECT ffgName AS '@databaseName',
						fileGroupName AS '@fileGroupName',
						fileName AS '@logicalFileName',
						fileId AS '@fileId',
						fileGroupId As '@fileGroupId',
						isFile As '@isFile',
						discoverType AS '@discoverType'
						FROM @MSSQLFFGInfo AS mssqlFFGInfo
						WHERE mssqlFFGInfo.ffgName = MSSQLFFGInfoMain.ffgName
						FOR XML PATH('mssqlFGContent'),TYPE)
					FROM @MSSQLFFGInfo AS MSSQLFFGInfoMain
					FOR XML PATH('content'),TYPE)
		FOR XML PATH('DBSubClientProp'), TYPE)
	END
	--Gather Exchange PST Archiver Properties
IF(@applicationId = 54 AND @propertyLevel >= 30)
	BEGIN
		SET @DeterminePstOwnership = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'PST Owner Based On ACL' AND modified = 0), 0)
		SET @pstOwnerBasedOnLaptop = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'PST Owner Based On Laptop' AND modified = 0), 0)
		SET @startingFolderPath = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'PST Starting Folder Path' AND modified = 0), '')
		SET @pstsWithNoOwnerInfoMailbox = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'PST with no owner info' AND modified = 0), '')
		SET @adProperty =  ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'PST AD Propert' AND modified = 0), '')
		SET @createSeparateParent = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Merge Into Mailbox' AND modified = 0), 0)
		SET @createPSTSpecificFolder = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'PST Specific Folder' AND modified = 0), '')
		SET @usePstName = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use PST Name' AND modified = 0), 0)
		SET @usePstNameForNoOwner = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use PST Name For No Owner' AND modified = 0), 0)
		SET @refCopyContent = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Reference Copy Content' AND modified = 0), '')
		SET @refCopyAssociation = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Reference Copy Association' AND modified = 0), '')
		SET @exchangeMbSubclientType = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'ReferenceCopy PST Archiving' AND modified = 0), 0)
		SET	@xmlResult =
		(SELECT
				(SELECT @refCopyContent AS '@refCopyContent',
				@refCopyAssociation AS '@refCopyAssociation',
				@exchangeMbSubclientType AS '@exchangeMbSubclientType',
				(SELECT
					@DeterminePstOwnership AS '@DeterminePstOwnership',
					@pstOwnerBasedOnLaptop AS '@pstOwnerBasedOnLaptop',
					@startingFolderPath AS	'@startingFolderPath',
					@pstsWithNoOwnerInfoMailbox	AS '@pstsWithNoOwnerInfoMailbox',
					@adProperty	AS	'@adProperty'
					FOR XML PATH('pstOwner'), TYPE),
				(SELECT
					@createPSTSpecificFolder	AS	'@createPSTSpecificFolder',
					@createSeparateParent AS '@pstWithOwnerInfo',
					@usePstName		AS			'@pstFolderInfo',
					@usePstNameForNoOwner AS	'@pstWithNoOwnerInfo'
					FOR XML PATH('pstFolder'),TYPE)
			FOR XML PATH('exchangePSTArchiverSubClientProp'),TYPE)
		FOR XML PATH('DBSubClientProp'), TYPE)
		SET @xmlResult.modify('delete /DBSubClientProp/exchangePSTArchiverSubClientProp[empty(./*) and not(./@*)]')
		SET @xmlResult.modify('delete /DBSubClientProp[empty(./*) and not(./@*)]')
	END
	--Gather MSExchangeDB properties
IF((@applicationId = 53 OR @applicationId = 137) AND @propertyLevel >= 30)
	BEGIN
		SET @bUseEventCheck = NULLIF((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Last Exchange Event Check Time Enabled' AND modified = 0),'0')
		IF @bUseEventCheck <> ''
		BEGIN
			SET @lastEventCheckTime = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Last Exchange Event Check Time' AND modified = 0)
			SET @lastEventCheckTimeType = 55
		END
		SET @dagOptions = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DAG Backup Copy option' AND modified = 0), 0)
IF (@dagOptions & 0x0002) = 0x0002
			SET @backupFromPassiveCopy = 1
		ELSE
			SET @backupFromPassiveCopy = 0
IF (@dagOptions & 0x0001) = 0x0001
			SET @backupFromActiveCopy = 1
		ELSE
			SET @backupFromActiveCopy = 0
IF (@dagOptions & 0x0004) = 0x0004
			SET @useLastActivation = 1
		ELSE
			SET @useLastActivation = 0
		SET @serverType = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DAG Auto Server Selection' AND modified = 0), 1)
		SET @numberOfExchangeBackupStreams = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'sys:nStreamsExchange' AND modified = 0), 1)
		SET @optimizeForMessageLevelRecovery = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use block-level backup with optimize recovery' AND modified = 0), 0)
		INSERT @MSExchangeDBServer
		SELECT attrName, attrVal FROM APP_SubClientProp WHERE componentNameId = @subclientId AND attrType = 126 AND modified = 0
		UPDATE @MSExchangeDBServer
		SET databaseName = REPLACE(databaseName, 'Microsoft Information Store\', '')
		UPDATE @MSExchangeDBServer
		SET databaseName = REPLACE(databaseName, '0x12', '')
		DECLARE ExchangeDBCur CURSOR FOR (select attrName, attrval from APP_SubClientProp WITH (NOLOCK) where attrtype = 112 AND componentNameId = @subclientId AND modified=0)
		OPEN ExchangeDBCur
			FETCH ExchangeDBCur INTO @dbName, @dbParameters
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @description = NULL
				SET @forceFull = NULL
				SET @dbPath = NULL
				SET @logPath = NULL
				SET @discoverType = NULL
				SET @storageGroup = NULL
				SET @databaseName = NULL
				SELECT
					@description = CASE WHEN Id = 1 THEN Data ELSE @description END,
					@forceFull = CASE WHEN Id = 2 THEN Data ELSE @forceFull END,
					@dbPath = CASE WHEN Id = 3 THEN Data ELSE @dbPath END,
					@logPath = CASE WHEN Id = 4 THEN Data ELSE @logPath END,
					@discoverType = CASE WHEN Id = 5 THEN Data ELSE @discoverType END
					FROM SplitString(@dbParameters,' ')
				IF CHARINDEX ('\', @dbName) = 0
					BEGIN
						SET @databaseName = @dbName
					END
				ELSE
					BEGIN
						SELECT
							@storageGroup = CASE WHEN Id = 1 THEN Data ELSE @storageGroup END,
							@databaseName = CASE WHEN Id = 2 THEN Data ELSE @databaseName END
							FROM SplitString(@dbName,'\')
					END
				INSERT	INTO @MSExchangeDBInfo VALUES(@databaseName, @storageGroup, @description, @forceFull, @dbPath, @logPath, @discoverType)
				FETCH ExchangeDBCur INTO @dbName, @dbParameters
			END
		CLOSE ExchangeDBCur
		DEALLOCATE ExchangeDBCur
		--Construct output XML
		SET	@xmlResult =
						(SELECT
							(SELECT	@bUseEventCheck AS '@useEventCheck',
									@backupFromPassiveCopy AS '@backupFromPassiveCopy',
									@backupFromActiveCopy AS '@backupFromActiveCopy',
									@useLastActivation AS '@useLastActivation',
									@serverType AS '@serverType',
									@numberOfExchangeBackupStreams AS '@numberOfExchangeBackupStreams',
									@optimizeForMessageLevelRecovery AS '@optimizeForMessageLevelRecovery',
									(SELECT databaseName AS '@databaseName',
											server AS '@server'
											FROM @MSExchangeDBServer
									FOR XML PATH('exchDBAssociatedServer'),TYPE),
									(SELECT @lastEventCheckTime as '@time',
											@lastEventCheckTimeType AS '@_type_'
											FOR XML PATH('lastEventCheckTime'), TYPE)
							FOR XML PATH('exchangeDBSubClientProp'), TYPE),
							(SELECT
								(SELECT storageGroupName AS '@storageGroup',
									databaseName AS '@databaseName',
									forceFull AS '@forceFull'
									FOR XML PATH('exchangeDBContent'),TYPE)
									FROM @MSExchangeDBInfo AS MSExchangeDBInfoMain
							FOR XML PATH('content'),TYPE)
						FOR XML PATH('DBSubClientProp'), TYPE)
		SET @xmlResult.modify('delete /DBSubClientProp/exchangeDBSubClientProp/lastEventCheckTime[empty(./*) and not(./@*)]')
		SET @xmlResult.modify('delete /DBSubClientProp/exchangeDBSubClientProp[empty(./*) and not(./@*)]')
		SET @xmlResult.modify('delete /DBSubClientProp[empty(./*) and not(./@*)]')
	END
--Gather PROPERTY_MYSQL properties
IF( @applicationId = 104  AND @propertyLevel >= 30 )
	BEGIN
		DECLARE @mysqlDbSize		VARCHAR(MAX) = '0'
		DECLARE @mysqlCreationTime	VARCHAR(MAX) = '0'
		DECLARE @mysqlDiscoverFlag	VARCHAR(MAX) = '0'
		DECLARE @mysqlEngineName	VARCHAR(MAX)
		DECLARE @isProxyEnabled		INT
		DECLARE @isFailOverToProduction INT
		DECLARE @proxyInstanceId INT = (SELECT instance FROM App_Application WHERE id = @subclientId) -- should return only one row
		-- get proxy Instanceid from Instance Prop
		SET @proxyInstanceId = ISNULL((SELECT CAST(attrval AS INT) FROM App_InstanceProp WITH (NOLOCK)
										WHERE componentNameId = @proxyInstanceId AND
modified = 0 AND attrName = 'MySQL proxy instance id '),0)
		SET @numberOfBackupStreams = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'MySQL Data backup streams' AND modified = 0)
		SET @numberOfTransactionLogStreams = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'MySQL For Log Backup' AND modified = 0)
		SET @isUseBlockLevelBackup = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK)  WHERE componentNameID = @subclientId AND attrName = 'Use block level backup' AND modified = 0)
SET @isProxyEnabled = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK)  WHERE componentNameID = @subclientId AND attrName = 'MySQL use proxy for backup' AND modified = 0)
SET @isFailOverToProduction = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK)  WHERE componentNameID = @subclientId AND attrName = 'MySQL fail over to production' AND modified = 0)
		DECLARE MySQLDBCur CURSOR FOR (select attrName, attrval from APP_SubClientProp WITH (NOLOCK) where attrtype = 120 AND componentNameId = @subclientId AND modified=0)
		OPEN MySQLDBCur
			FETCH MySQLDBCur INTO @dbName, @dbParameters
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @mysqlDbSize = NULL
				SET @mysqlCreationTime = NULL
				SET @mysqlDiscoverFlag = NULL
				SET @mysqlEngineName = 'UNKNOWN'
				SELECT
					@mysqlDbSize = CASE WHEN Id = 1 THEN Data ELSE @mysqlDbSize END,
					@mysqlCreationTime = CASE WHEN Id = 2 THEN Data ELSE @mysqlCreationTime END,
					@mysqlDiscoverFlag = CASE WHEN Id = 3 THEN Data ELSE @mysqlDiscoverFlag END,
					@mysqlEngineName = CASE WHEN Id = 4 THEN Data ELSE @mysqlEngineName END
					FROM SplitString(@dbParameters,' ')
				INSERT	INTO @MySQLDBInfo VALUES(@dbName, @mysqlDbSize, @mysqlCreationTime, @mysqlDiscoverFlag, @mysqlEngineName)
				FETCH MySQLDBCur INTO @dbName, @dbParameters
			END
		CLOSE MySQLDBCur
		DEALLOCATE MySQLDBCur
		--Construct output XML
		SET	@xmlResult =
						(SELECT
							(SELECT	@numberOfBackupStreams AS '@numberOfBackupStreams',
									@numberOfTransactionLogStreams AS '@numberOfTransactionLogStreams',
									@isUseBlockLevelBackup AS '@isUseBlockLevelBackup',
									(SELECT @isProxyEnabled as '@isProxyEnabled',
										@isFailOverToProduction as'@isFailOverToProduction',
										(SELECT @proxyInstanceId AS '@instanceId',
											(SELECT name FROM App_InstanceName WHERE id = @proxyInstanceId) AS '@instanceName',
											(SELECT TOP 1 clientId FROM App_Application WHERE instance = @proxyInstanceId) AS '@clientId',
											(SELECT TOP 1 name FROM App_Application aa JOIN APP_Client ac ON aa.clientId=ac.id AND aa.instance = @proxyInstanceId) AS '@clientName'
										FOR XML PATH('proxyInstance'), TYPE)
									FOR XML PATH('proxySettings'), TYPE)
							FOR XML PATH('mySqlSubclientProp'), TYPE),
							(SELECT
								(SELECT dbName AS '@databaseName',
									dbSize AS '@databaseSize',
									creationTime AS '@creationTime',
									discoverFlag AS '@discoverFlag',
									engineName AS '@engineName'
								FOR XML PATH('mySQLContent'),TYPE)
								FROM @MySQLDBInfo
							FOR XML PATH('content'),TYPE)
						FOR XML PATH('DBSubClientProp'), TYPE)
		SET @xmlResult.modify('delete /DBSubClientProp/mySQLContent[empty(./*) and not(./@*)]')
		SET @xmlResult.modify('delete /DBSubClientProp[empty(./*) and not(./@*)]')
	END
	--Gather PostGreDB properties
IF( @applicationId = 125  AND @propertyLevel >= 30 )
	BEGIN
		DECLARE @postgredbSize VARCHAR(MAX)
		DECLARE @postgrecreationTime VARCHAR(MAX)
		SET @numberOfBackupStreams = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'PostgreSQL Data backup streams' AND modified = 0), 1)
		SET @collectObjectListDuringBackup = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'PostGres Collect Metadata Flag' AND modified = 0), 0)
		SET @postgreSubclientType = 0
		IF EXISTS (SELECT 1 FROM APP_BackupsetProp B, APP_Application A WHERE A.id = @subclientId AND A.backupset = B.componentNameId AND B.attrName = 'FS BackupSet' AND B.attrVal = '1' AND B.modified = 0)
			SET @postgreSubclientType |= 1 -- FS Backupset
		IF EXISTS (SELECT 1 FROM APP_SubclientProp WHERE componentNameID = @subclientId AND attrName = 'Enable Snap Backups' AND attrVal = '1' AND modified = 0)
			SET @postgreSubclientType |= 2
		IF EXISTS (SELECT 1 FROM APP_SubclientProp WHERE componentNameID = @subclientId AND attrName = 'Use block level backup' AND attrVal = '1' AND modified = 0)
			SET @postgreSubclientType |= 4
		SET @isUseBlockLevelBackup = (SELECT attrVal FROM APP_SubclientProp WHERE componentNameID = @subclientId AND attrName = 'Use block level backup' AND modified = 0)
		DECLARE PostGreSQLDBCur CURSOR FOR (select attrName, attrval from APP_SubClientProp WITH (NOLOCK) where attrtype = 122 AND componentNameId = @subclientId AND modified=0)
		OPEN PostGreSQLDBCur
			FETCH PostGreSQLDBCur INTO @dbName, @dbParameters
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @postgredbSize = NULL
				SET @postgrecreationTime = NULL
				SELECT
					@postgredbSize = CASE WHEN Id = 1 THEN Data ELSE @postgredbSize END,
					@postgrecreationTime = CASE WHEN Id = 2 THEN Data ELSE @postgrecreationTime END
					FROM SplitString(@dbParameters,' ')
				INSERT	INTO @PostGreDBInfo VALUES(@dbName, @postgredbSize, @postgrecreationTime)
				FETCH PostGreSQLDBCur INTO @dbName, @dbParameters
			END
		CLOSE PostGreSQLDBCur
		DEALLOCATE PostGreSQLDBCur
		--Construct output XML
		SET	@xmlResult =
						(SELECT
							(SELECT	@numberOfBackupStreams AS '@numberOfBackupStreams',
									@collectObjectListDuringBackup AS '@collectObjectListDuringBackup',
									@postgreSubclientType AS '@subclientTypeFlag',
									@isUseBlockLevelBackup AS '@isUseBlockLevelBackup'
							FOR XML PATH('postgreSQLSubclientProp'), TYPE),
							(SELECT
								(SELECT dbName AS '@databaseName',
									dbSize AS '@databaseSize',
									creationTime AS '@creationTime'
								FOR XML PATH('postgreSQLContent'),TYPE)
								FROM @PostGreDBInfo
							FOR XML PATH('content'),TYPE)
						FOR XML PATH('DBSubClientProp'), TYPE)
		SET @xmlResult.modify('delete /DBSubClientProp/postgreSQLContent[empty(./*) and not(./@*)]')
		SET @xmlResult.modify('delete /DBSubClientProp[empty(./*) and not(./@*)]')
	END
	--Gather LotusNotesDB properties
IF(( @applicationId = 59 OR @applicationId = 77 ) AND @propertyLevel >= 30 )
	BEGIN
		DECLARE LotusNotesDBCur CURSOR FOR (select attrName, attrval from APP_SubClientProp WITH (NOLOCK) where attrtype = 102 AND componentNameId = @subclientId AND modified=0)
		OPEN LotusNotesDBCur
			FETCH LotusNotesDBCur INTO @dbName, @dbParameters
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @databaseTitle = NULL
				SET @RelativePath = NULL
				SET @dbiid	= NULL
				SET @dbiid1	= NULL
				SET @dbiid2	= NULL
				SET @dbiid3	= NULL
				SET @dbiid4	= NULL
				SELECT
					@databaseTitle = CASE WHEN Id = 1 THEN Data ELSE @databaseTitle END,
					@dbiid = CASE WHEN Id = 2 THEN Data ELSE @dbiid END
					FROM SplitString(@dbParameters,' ')
					SET @databaseTitle = REPLACE(@databaseTitle, '-1', ' ')
				SELECT
					@dbiid1 = CASE WHEN Id = 1 THEN Data ELSE @dbiid1 END,
					@dbiid2 = CASE WHEN Id = 2 THEN Data ELSE @dbiid2 END,
					@dbiid3 = CASE WHEN Id = 3 THEN Data ELSE @dbiid3 END,
					@dbiid4 = CASE WHEN Id = 4 THEN Data ELSE @dbiid4 END
					FROM SplitString(@dbiid,':')
				IF CHARINDEX ('\', @dbName) = 1
					SET @RelativePath = SUBSTRING(@dbName, 2, LEN(@dbName))
				ELSE
					SET @RelativePath = @dbName
				INSERT	INTO @LotusNotesDBInfo VALUES(@RelativePath, @databaseTitle, @dbiid1, @dbiid2, @dbiid3, @dbiid4)
				FETCH LotusNotesDBCur INTO @dbName, @dbParameters
			END
		CLOSE LotusNotesDBCur
		DEALLOCATE LotusNotesDBCur
		--Construct output XML
		SET	@xmlResult =
						(SELECT
							(SELECT
								(SELECT RelativePath AS '@relativePath',
									databaseTitle AS '@databaseTitle',
									dbiid1 AS '@dbiid1',
									dbiid2 AS '@dbiid2',
									dbiid3 AS '@dbiid3',
									dbiid4 AS '@dbiid4'
									FOR XML PATH('lotusNotesDBContent'),TYPE)
									FROM @LotusNotesDBInfo
							FOR XML PATH('content'),TYPE)
						FOR XML PATH('DBSubClientProp'), TYPE)
		SET @xmlResult.modify('delete /DBSubClientProp/lotusNotesDBContent[empty(./*) and not(./@*)]')
		SET @xmlResult.modify('delete /DBSubClientProp[empty(./*) and not(./@*)]')
	END
	--Gather CV_APPTYPE_ORACLE8/CV_APPTYPE_ORACLE_RAC properties
IF(( @applicationId = 22 OR @applicationId = 80 ) AND @propertyLevel >= 30 )
	BEGIN
		SET @oracleSubclientType = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Subclient Type' AND modified = 0), 0)
		IF @oracleSubclientType = 1
		BEGIN
			DECLARE @oracleArchiveProp XML = (REPLACE((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle DB Archive Config Options XML' AND modified = 0), 'UTF-8', 'UTF-16'))
			SELECT
					@archiveDataFilesPath = Tbl.Col.value('(./@archiveDataFilesPath)', 'nvarchar(max)'),
					@createUniformView = Tbl.Col.value('(./@createUniformView)', 'int'),
					@dataExportFormat = Tbl.Col.value('(./@dataExportFormat)', 'int'),
					@historyDatabase = Tbl.Col.value('(./@historyDatabase)', 'int'),
					@retainDataInHistoryTables = Tbl.Col.value('(./@retainDataInHistoryTables)', 'int'),
					@retainDataOnMedia = Tbl.Col.value('(./@retainDataOnMedia)', 'int')
				FROM @oracleArchiveProp.nodes('/App_DatabaseArchiveOptions') as Tbl(Col)
			SELECT @archClientName = Tbl.Col.value('(./@clientName)', 'nvarchar(max)')
				FROM @oracleArchiveProp.nodes('/App_DatabaseArchiveOptions/client') as Tbl(Col)
			SELECT @archClientId = Tbl.Col.value('(./@clientId)', 'integer')
				FROM @oracleArchiveProp.nodes('/App_DatabaseArchiveOptions/client') as Tbl(Col)
			SELECT @archInstanceName = Tbl.Col.value('(./@instanceName)', 'nvarchar(max)')
				FROM @oracleArchiveProp.nodes('/App_DatabaseArchiveOptions/databaseName') as Tbl(Col)
			SELECT @archInstanceId = Tbl.Col.value('(./@instanceId)', 'integer')
				FROM @oracleArchiveProp.nodes('/App_DatabaseArchiveOptions/databaseName') as Tbl(Col)
			SELECT	@archDomainName = Tbl.Col.value('(./@domainName)', 'nvarchar(max)'),
					@archUserName = Tbl.Col.value('(./@userName)', 'nvarchar(max)')
				FROM @oracleArchiveProp.nodes('/App_DatabaseArchiveOptions/historyConnectUserAccount') as Tbl(Col)
			SET @archContent = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle DB Archive Config XML' AND modified = 0)
			SET @dataExport = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Data Export' AND modified = 0), 0)
		END
		ELSE
		BEGIN
			SET @selectiveOnlineFull = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Online Selective Full' AND modified = 0)
			SET @backupMode = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Backup Mode' AND modified = 0), 0)
			IF @backupMode <> 1
				SET @oracleData = 1
			ELSE
			BEGIN
				IF EXISTS (SELECT * FROM oracleObjects WHERE subClientId = @subclientId AND setType = 2)
					SET @oracleData = 1
				ELSE
					SET @oracleData = 0
			END
			SET @backupControlFile = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Backup Control Files' AND modified = 0), 1)
			SET @backupSPFile = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Backup SP File' AND modified = 0), 0)
			SET @protectBackupRecoveryArea = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Protect Backup Recovery Area' AND modified = 0), 0)
			SET @dataFilesPerBFS = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Data FPS' AND modified = 0), 32)
			SET @maxBackupSetSizeInKB = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Max Backup Set Size' AND modified = 0), 0)
			SET @sectionSizeInKB = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Section Size' AND modified = 0), 0)
			SET @archiveFilesPerBFS = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Arch per bfs' AND modified = 0), 0)
			SET @maxOpenFiles = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Max Open Files' AND modified = 0), 8)
			SET @oracleTag = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Tag' AND modified = 0), '')
			SET @lightsOutScript = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Light out Script' AND modified = 0), 0)
			SET @warning = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle LOS Backup Warning' AND modified = 0), 0)
			SET @useSQLConntect = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Use SQL Connect' AND modified = 0), 0)
			SET @delayTimeinMin = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle LOS Backup Delay Min' AND modified = 0), 2)
			SET @sleepTimeinMin = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle LOS Backup Sleep Mins' AND modified = 0), 1)
			SET @sleepTimeinSec = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle LOS Backup Sleep Secs' AND modified = 0), 10)
			SET @triesNumber = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle LOS Backup Max Tries Secs' AND modified = 0), 3)
			SET @startupPFile = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Startup pfile path' AND modified = 0), '')
			SET @skipReadOnly = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Skip read only' AND modified = 0), 0)
			SET @skipOffline = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Skip offline' AND modified = 0), 0)
			SET @skipInaccessible = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Skip inaccessible' AND modified = 0), 0)
			SET @validate = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Set Validate' AND modified = 0), 0)
			SET @enableTableBrowse = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Enable Table Browse' AND modified = 0), 0)
			SET @mergeIncImageCopies = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Merge Incr Image Copy' AND modified = 0), 0)
			SET @resyncCatalog = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Resync Catalog' AND modified = 0), 0)
			SET @backupArchiveLog = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Backup Archive Log' AND modified = 0), 1)
			SET @backupArchiveLogOption = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Backup Archive Log Option' AND modified = 0), 0)
			SET @archiveDelete = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Archive Log Deleting' AND modified = 0), 1)
			SET @archiveDeleteAll = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Archive Delete All' AND modified = 0), 0)
			SET @disableSwitchCurrentLog = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle LOS disable Switch' AND modified = 0), 0)
			SET @useRmanForLogBackup = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Use Rman For Log Backup' AND modified = 0), 0)
			SET @logThresholdStreams = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Log backup streams' AND modified = 0), 1)
			SET @selectArchiveLogDestForBackup = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Backup Archive Log Flag' AND modified = 0), 0)
			SET @archiveLogDestForBackup = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Backup Archive Log Destinations' AND modified = 0)
			IF @archiveLogDestForBackup != '`'
			BEGIN
				INSERT INTO @archiveLogDestForBackupTBL
				SELECT data FROM dbo.SplitString(@archiveLogDestForBackup, '?')
				DELETE @archiveLogDestForBackupTBL WHERE archiveLogDestForBkp = '`'
			END
			SET @selectArchiveLogDestForDelete = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Delete Archive Log Flag' AND modified = 0), 0)
			SET @archiveLogDestForDelete = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Delete Archive Log Destinations' AND modified = 0)
			IF @archiveLogDestForDelete != '`'
			BEGIN
				INSERT INTO @archiveLogDestForDeleteTBL
				SELECT data FROM dbo.SplitString(@archiveLogDestForDelete, '?')
				DELETE @archiveLogDestForDeleteTBL WHERE archiveLogDestForDel = '`'
			END
			SET @dataThresholdStreams = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Data backup streams' AND modified = 0), 1)
			SET @snapImageCopy = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Snap Image Copy' AND modified = 0), 0)
			SET @imageCopyDir = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Image Copy Dir' AND modified = 0), '')
			SET @backupCopyInterface = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Backup Copy Interface' AND modified = 0), 0)
			SET @oracleDataBackupStreams =
				(SELECT
					(SELECT
						stream.prop.value('attribute[1]','INT') as '@instanceId',
						stream.prop.value('attribute[2]','INT') as '@streamNumber',
						stream.prop.value('attribute[3]','INT') as '@priority'
						FROM attrValXML.nodes('/Cover/stream') as stream(prop)
					 FOR XML PATH('oracleDataBackupStreams'), TYPE)
				FROM APP_SubclientProp scp1 WITH (NOLOCK)
				CROSS APPLY (SELECT attrValXML=CAST('<Cover><stream><attribute>'+REPLACE(REPLACE([attrVal],'+','</attribute></stream><stream><attribute>'),' ','</attribute><attribute>')+'</attribute></stream></Cover>' AS XML)) CastXML1
				WHERE attrName = 'Oracle RAC Data Properties' AND modified = 0 AND componentNameId = @subclientId
				FOR XML PATH('OracleBackupStreams'), TYPE)
			SET @oraclelogBackupStreams =
				(SELECT
					(SELECT
						stream.prop.value('attribute[1]','INT') as '@instanceId',
						stream.prop.value('attribute[2]','INT') as '@streamNumber',
						stream.prop.value('attribute[3]','INT') as '@priority'
						FROM attrValXML.nodes('/Cover/stream') as stream(prop)
					 FOR XML PATH('oracleLogBackupStreams'), TYPE)
				FROM APP_SubclientProp scp1 WITH (NOLOCK)
				CROSS APPLY (SELECT attrValXML=CAST('<Cover><stream><attribute>'+REPLACE(REPLACE([attrVal],'+','</attribute></stream><stream><attribute>'),' ','</attribute><attribute>')+'</attribute></stream></Cover>' AS XML)) CastXML1
				WHERE attrName = 'Oracle RAC Log Properties' AND modified = 0 AND componentNameId = @subclientId
				FOR XML PATH('OracleBackupStreams'), TYPE)
		END
		--Construct output XML
		SET	@xmlResult =
						(SELECT
							(SELECT	@selectiveOnlineFull AS '@selectiveOnlineFull',
									@oracleData AS '@data',
									@backupMode AS '@backupMode',
									@numberOfTransactionLogStreams AS '@numberOfTransactionLogStreams',
									@backupControlFile AS '@backupControlFile',
									@backupSPFile AS '@backupSPFile',
									@protectBackupRecoveryArea AS '@protectBackupRecoveryArea',
									@dataFilesPerBFS AS '@dataFilesPerBFS',
									@maxBackupSetSizeInKB AS '@maxBackupSetSizeInKB',
									@sectionSizeInKB AS '@sectionSizeInKB',
									@archiveFilesPerBFS AS '@archiveFilesPerBFS',
									@maxOpenFiles AS '@maxOpenFiles',
									@oracleTag AS '@oracleTag',
									@lightsOutScript AS '@lightsOutScript',
									@warning AS '@warning',
									@useSQLConntect AS '@useSQLConntect',
									@delayTimeinMin AS '@delayTimeinMin',
									@sleepTimeinMin AS '@sleepTimeinMin',
									@sleepTimeinSec AS '@sleepTimeinSec',
									@triesNumber AS '@triesNumber',
									@startupPFile AS '@startupPFile',
									@skipReadOnly AS '@skipReadOnly',
									@skipOffline AS '@skipOffline',
									@skipInaccessible AS '@skipInaccessible',
									@validate AS '@validate',
									@enableTableBrowse AS '@enableTableBrowse',
									@mergeIncImageCopies AS '@mergeIncImageCopies',
									@resyncCatalog AS '@resyncCatalog',
									@backupArchiveLog AS '@backupArchiveLog',
									@backupArchiveLogOption AS '@backupArchiveLogOption',
									@archiveDelete AS '@archiveDelete',
									@archiveDeleteAll AS '@archiveDeleteAll',
									@disableSwitchCurrentLog AS '@disableSwitchCurrentLog',
									@useRmanForLogBackup AS '@useRmanForLogBackup',
									@logThresholdStreams AS '@logThresholdStreams',
									@selectArchiveLogDestForBackup AS '@selectArchiveLogDestForBackup',
									@selectArchiveLogDestForDelete AS '@selectArchiveLogDestForDelete',
									@dataExport AS '@dataExport',
									@snapImageCopy AS '@snapImageCopy',
									@imageCopyDir AS '@imageCopyDir',
									@dataThresholdStreams AS '@dataThresholdStreams',
									@oracleSubclientType AS '@dbSubclientType',
									@archContent AS '@archiveContent',
									@backupCopyInterface AS '@backupCopyInterface',
									@oracleDataBackupStreams.query('/OracleBackupStreams/oracleDataBackupStreams'),
									@oracleLogBackupStreams.query('/OracleBackupStreams/oracleLogBackupStreams'),
									(SELECT tblArchiveLogDestForBackupTBL.archiveLogDestForBkp AS 'archiveLogDestForBackup'
												FROM @archiveLogDestForBackupTBL AS tblArchiveLogDestForBackupTBL
												WHERE @selectArchiveLogDestForBackup <> 0
											FOR XML PATH(''), TYPE),
									(SELECT tblarchiveLogDestForDeleteTBL.archiveLogDestForDel AS 'archiveLogDestForDelete'
												FROM @archiveLogDestForDeleteTBL AS tblarchiveLogDestForDeleteTBL
												WHERE @selectArchiveLogDestForDelete <> 0
											FOR XML PATH(''), TYPE),
									(SELECT	@dataExportFormat AS '@dataExportFormat',
												@historyDatabase AS '@historyDatabase',
												@archiveDataFilesPath AS '@archiveDataFilesPath',
												@createUniformView AS '@createUniformView',
												@retainDataInHistoryTables AS '@retainDataInHistoryTables',
												@retainDataOnMedia AS '@retainDataOnMedia',
												(SELECT @archInstanceName AS '@instanceName',
														@archInstanceId AS '@instanceId'
													FOR XML PATH('databaseName'), TYPE),
												(SELECT @archUserName AS '@userName',
														@archDomainName AS '@domainName'
													FOR XML PATH('historyConnectUserAccount'), TYPE),
												(SELECT @archClientName AS '@clientName',
														@archClientId AS '@clientId'
													FOR XML PATH('client'), TYPE)
											FOR XML PATH('archiveOptions'), TYPE)
							FOR XML PATH('oracleSubclientProp'), TYPE),
							(SELECT
								(SELECT
								distinct tblspace.name AS '@tableSpace',
								isnull(pdbs.name, '') AS '@database',
								obj.type AS '@fileType',
								ISNULL(dataFiles.name,'') AS '@dataFile'
								FOR XML PATH('oracleContent'),TYPE)
								FROM	oracleTableSpaces tblspace
									LEFT JOIN OraclePluggableDbs pdbs on tblSpace.pdbId = pdbs.pdbId
									LEFT JOIN oracleDataFiles dataFiles on dataFiles.tblId = tblspace.id
									LEFT JOIN oracleObjects obj ON  (obj.objId = tblspace.id and obj.type =5)
										OR	(isnull(tblspace.pdbId, 0) != 0 and obj.objId = pdbs.pdbId  and obj.type = 20)
										OR  (obj.objId = dataFiles.id and  obj.type = 1)
									LEFT JOIN APP_Application app ON app.id = obj.subClientId
								WHERE	obj.subClientId = @subclientId
									AND	tblSpace.deleted = 0
									AND	@propertyLevel >= 30
							FOR XML PATH('content'),TYPE)
						FOR XML PATH('DBSubClientProp'), TYPE)
		SET @xmlResult.modify('delete /DBSubClientProp/oracleSubclientProp[empty(./*) and not(./@*)]')
		SET @xmlResult.modify('delete /DBSubClientProp[empty(./*) and not(./@*)]')
	END
	--Gather CV_APPTYPE_UNIX_DB2/CV_APPTYPE_DB2 properties
IF (@applicationId IN ( 62, 37,  103) AND @propertyLevel >= 30 )
	BEGIN
		SET @db2BackupData = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DB2 Data Backup' AND modified = 0), 1)
		SET @db2BackupType = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DB2 Backup Type' AND modified = 0), 0)
		SET @db2BackupMode = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DB2 Backup Mode' AND modified = 0), 0)
		SET @db2NumberofBuffer = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DB2 Backup Buffers' AND modified = 0)
		SET @db2BufferSize = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DB2 Buffers Size' AND modified = 0)
		SET @db2Parallelism = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DB2 Backup Parallelism' AND modified = 0)
		SET @db2UseCompression = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DB2 Backup Compression' AND modified = 0)
		SET @db2BackupLogFiles = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DB2 ArchiveLog Option' AND modified = 0)
		SET @db2DeleteLogFilesAfter = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DB2 DeleteLog Option' AND modified = 0)
		SET @db2DisableSwitchCurrentLog = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DB2 LOS disable switch' AND modified = 0)
		SET @numberOfBackupStreams = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DB2 Data backup streams' AND modified = 0), 1)
		SET @db2UseDedupeDevice = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DB2 Use Dedupe Device' AND modified = 0)
		SET @db2EnableTableBrowse = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DB2 Enable Table Browse' AND modified = 0)
		SET @skipLogsInBackupImage = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DB2 Skip Logs In Backup Image' AND modified = 0)
IF (@applicationId = 103)
			SET @db2DataPartitionStreams = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DB2 Data Partition Streams' AND modified = 0)
		--Construct output XML
		SET	@xmlResult =
						(SELECT
							(SELECT	@db2BackupData AS '@db2BackupData',
									@db2BackupType AS '@db2BackupType',
									@db2BackupMode AS '@db2BackupMode',
									@db2NumberofBuffer AS '@db2NumberofBuffer',
									@db2BufferSize AS '@db2BufferSize',
									@db2Parallelism AS '@db2Parallelism',
									@db2UseCompression AS '@db2UseCompression',
									@db2BackupLogFiles AS '@db2BackupLogFiles',
									@db2DeleteLogFilesAfter AS '@db2DeleteLogFilesAfter',
									@db2DisableSwitchCurrentLog AS '@db2DisableSwitchCurrentLog',
									@numberOfBackupStreams AS '@numberOfBackupStreams',
									@db2UseDedupeDevice AS '@db2UseDedupeDevice',
									@db2EnableTableBrowse AS '@enableTableBrowse',
									@skipLogsInBackupImage AS '@skipLogsInBackupImage',
									@db2DataPartitionStreams AS '@db2DpfStreams'
							FOR XML PATH('db2SubclientProp'), TYPE),
							(SELECT
                                				(SELECT
									distinct tblspace.name AS '@db2TableSpace',
									ISNULL(dataFiles.name,'') AS '@db2DataFile'
									FOR XML PATH('db2Content'),TYPE)
									FROM   oracleTableSpaces tblspace
													LEFT JOIN oracleDataFiles dataFiles on dataFiles.tblId = tblspace.id
													LEFT JOIN oracleObjects obj ON  (obj.objId = tblspace.id and obj.type =5)
																	OR  (obj.objId = dataFiles.id and  obj.type = 1)
													LEFT JOIN APP_Application app ON app.id = obj.subClientId
									WHERE obj.subClientId = @subclientId
													AND       tblSpace.deleted = 0
													AND       @propertyLevel >= 30
								FOR XML PATH('content'),TYPE)
						FOR XML PATH('DBSubClientProp'), TYPE)
		SET @xmlResult.modify('delete /DBSubClientProp/db2SubclientProp[empty(./*) and not(./@*)]')
		SET @xmlResult.modify('delete /DBSubClientProp[empty(./*) and not(./@*)]')
	END
	--Gather CV_APPTYPE_INFORMIX properties
IF (@applicationId = 3 AND @propertyLevel >= 30 )
	BEGIN
		SET @informixBackupMode = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Informix Backup Mode' AND modified = 0), 2)
		SET @informixincrementalLevel = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Informix incr level' AND modified = 0), 1)
		SET @informixBackupixbar = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Informix IXBAR' AND modified = 0), 1)
		SET @informixBackuponconfig = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Informix OnCFG' AND modified = 1), 1)
		SET @informixMaxBarStreams = ISNULL((SELECT attrVal FROM  APP_InstanceProp INST WITH (NOLOCK) WHERE INST.componentNameId IN (SELECT instance FROM APP_Application APP WITH(NOLOCK) WHERE APP.id = @subclientId) AND attrname = 'Informix Max Bar Streams' AND modified = 0), 0)
		--Construct output XML
		SET	@xmlResult =
						(SELECT
							(SELECT	@informixBackupMode AS '@backupMode',
									@informixincrementalLevel AS '@incrementalLevel',
									@informixBackupixbar AS '@backupixbar',
									@informixBackuponconfig AS '@backuponconfig',
									@informixMaxBarStreams AS '@maxBarStreams'
							FOR XML PATH('informixSubclientProp'), TYPE),
							(SELECT
                                	(SELECT
									distinct tblspace.name AS '@tableSpace',
									obj.type AS '@fileType'
									FOR XML PATH('informixContent'),TYPE)
									FROM	oracleTableSpaces tblspace
										INNER JOIN oracleObjects obj ON  (obj.objId = tblspace.id and obj.type =5)
										INNER JOIN APP_Application app ON app.id = obj.subClientId
									WHERE obj.subClientId = @subclientId
													AND       tblSpace.deleted = 0
													AND       @propertyLevel >= 30
								FOR XML PATH('content'),TYPE)
						FOR XML PATH('DBSubClientProp'), TYPE)
		SET @xmlResult.modify('delete /DBSubClientProp/informixSubclientProp[empty(./*) and not(./@*)]')
		SET @xmlResult.modify('delete /DBSubClientProp[empty(./*) and not(./@*)]')
	END
	--Gather CV_APPTYPE_SAP_FOR_ORACLE properties
IF( @applicationId = 61 AND @propertyLevel >= 30 )
	BEGIN
		SET @sapSelectiveOnlineFull = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Online Selective Full' AND modified = 0)
		SET @sapBackupDevice = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Backup Device' AND modified = 0), 0 )
		SET @sapBackupMode = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Backup Mode' AND modified = 0), 0)
		SET @sapBackupArchiveLog = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Backup Archive Log' AND modified = 0)
		SET @sapArchiveDelete = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Archive Log Deleting' AND modified = 0)
		SET @sapDisableSwitchCurrentLog = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle LOS disable Switch' AND modified = 0)
		SET @sapArchiveLogSecondCopy = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Archive Log Second Copy' AND modified = 0)
		SET @numberOfBackupStreams = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Oracle Data backup streams' AND modified = 0)
		IF EXISTS (SELECT 1 FROM oracleObjects WHERE subclientId = @subclientId) OR (@sapBackupMode != 1)
			SET @sapData = 1
		ELSE
			SET @sapData = 0
		--Construct output XML
		SET	@xmlResult =
						(SELECT
							(SELECT	@sapSelectiveOnlineFull AS '@sapSelectiveOnlineFull',
									@sapBackupDevice AS '@sapBackupDevice',
									@sapData AS '@sapData',
									@sapBackupMode AS '@sapBackupMode',
									@sapBackupArchiveLog AS '@sapBackupArchiveLog',
									@sapArchiveDelete AS '@sapArchiveDelete',
									@sapDisableSwitchCurrentLog AS '@sapDisableSwitchCurrentLog',
									@sapArchiveLogSecondCopy AS '@sapArchiveLogSecondCopy',
									@numberOfBackupStreams AS '@numberOfBackupStreams'
							FOR XML PATH('sapForOracleSubclientProp'), TYPE),
							(SELECT
								(SELECT
								distinct tblspace.name AS '@sapTableSpace',
								ISNULL(dataFiles.name,'') AS '@sapDataFile'
								FOR XML PATH('sapForOracleDBContent'),TYPE)
								FROM	oracleTableSpaces tblspace
									LEFT JOIN oracleDataFiles dataFiles on dataFiles.tblId = tblspace.id
									LEFT JOIN oracleObjects obj ON  (obj.objId = tblspace.id and obj.type =5)
										OR  (obj.objId = dataFiles.id and  obj.type = 1)
									LEFT JOIN APP_Application app ON app.id = obj.subClientId
								WHERE	obj.subClientId = @subclientId
									AND	tblSpace.deleted = 0
									AND	@propertyLevel >= 30
							FOR XML PATH('content'),TYPE)
						FOR XML PATH('DBSubClientProp'), TYPE)
		SET @xmlResult.modify('delete /DBSubClientProp/sapForOracleSubclientProp[empty(./*) and not(./@*)]')
		SET @xmlResult.modify('delete /DBSubClientProp[empty(./*) and not(./@*)]')
	END
	--Gather CV_APPTYPE_SAP_HANA properties
IF( @applicationId = 135 AND @propertyLevel >= 30 )
	BEGIN
		SET @numberOfBackupStreams = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'HANA Data backup streams' AND modified = 0), 1)
		--Construct output XML
		SET	@xmlResult =
						(SELECT
							(SELECT	@numberOfBackupStreams AS '@numberOfBackupStreams'
							FOR XML PATH('sapHANASubclientProp'), TYPE),
							(SELECT @numberOfBackupStreams AS '@dataThresholdStreams'
							FOR XML PATH('oracleSubclientProp'), TYPE)
						FOR XML PATH('DBSubClientProp'), TYPE)
		SET @xmlResult.modify('delete /DBSubClientProp/sapHANASubclientProp[empty(./*) and not(./@*)]')
		SET @xmlResult.modify('delete /DBSubClientProp/oracleSubclientProp[empty(./*) and not(./@*)]')
		SET @xmlResult.modify('delete /DBSubClientProp[empty(./*) and not(./@*)]')
	END
	--Gather CV_APPTYPE_VIRTUAL_SERVER properties
IF( @applicationId = 106 AND @propertyLevel >= 5 )
	BEGIN
		DECLARE @vendorType INTEGER
		SELECT @vendorType = dbo.MapVSVendorId(CAST(IP.attrVal AS INT), -1)
						FROM APP_Application APP
								INNER JOIN APP_InstanceProp IP
									ON (IP.componentNameId = APP.instance AND IP.attrName = 'Virtual Server Instance Type')
							WHERE APP.id=@subclientId
		IF (@propertyLevel >= 30)
		BEGIN
			SET @vmContentStr = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Virtual Server Dyanimc Content' AND modified = 0)
			SET @vmContent = @vmContentStr
			SET @vmFilterStr = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Virtual Server Filters' AND modified = 0)
			SET @vmFilter = @vmFilterStr
			SET @vmDiskFilterStr = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Virtual Server Disk Filters' AND modified = 0)
			SET @vmDiskFilter = @vmDiskFilterStr
			-- Add vm counts for vWeb
			-- Get All VM and there status
			DECLARE @VMStatusTbl Table
			(
				vmClientId			INT,
				vmStatus            INT
			)
			-- Get Latest Job for all VM of concerned subclient from client prop table
	        -- Table Varible is fine here as we won't be looking at too large data set here
	        DECLARE @clientListTbl Table
			(
				clientId			INT,
				subclientID			INT,
				jobId               INT
			)
			-- Exclude Deleted VM's from Hypervisior
	        INSERT INTO @clientListTbl
			SELECT ACP.componentNameId , CAST(ACP2.attrVal AS INT), CAST(ACP.attrVal AS INT) FROM APP_ClientProp ACP WITH (NOLOCK)
			INNER JOIN APP_ClientProp ACP2
				ON ACP2.componentNameId=ACP.componentNameId AND ACP2.attrName='Last Backup Subclient' AND ACP2.modified=0
			LEFT OUTER JOIN APP_ClientProp ACP1
				ON ACP1.componentNameId=ACP.componentNameId AND ACP1.attrName='Virtual Machine Deletion Time' AND ACP1.modified=0 AND ACP1.attrVal<>'0'
			WHERE ACP.attrName='Last Backup JobID' AND ACP.modified=0 AND ACP1.id is NULL
			-- Get Latest Job cycle. From that job cycle, get all vm's along with there status in that cycle mapped with latest job id for that vm
			INSERT INTO @VMStatusTbl(vmclientId, vmStatus)
			SELECT DISTINCT AVP.VMclientId, CAST(AVP.attrVal AS INT) FROM @clientListTbl CLT
														INNER JOIN APP_VMProp AVP WITH (NOLOCK)
															ON AVP.jobId=CLT.jobId AND AVP.attrName = 'vmStatus' AND CLT.clientId=AVP.VMclientId
														WHERE CLT.subclientID=@subclientId
			SELECT
				@vmProtectedCount = ISNULL(SUM(CASE WHEN vmStatus = 0 THEN 1 ELSE 0 END),0),  -- count successfully backed up vms during last job for that subclient
				@vmBackedUpWithErrorCount = ISNULL(SUM(CASE WHEN vmStatus = 3 THEN 1 ELSE 0 END),0), -- count backed up with errors vms during last job for that subclient
				@vmPendingCount = ISNULL(SUM(CASE WHEN (VMSTATUS = 2 OR VMSTATUS=4) THEN 1 ELSE 0 END),0)  -- count pending vms during last job for that subclient
			FROM @VMStatusTbl
			SET @vmNeverBackedUpCount = 0
			-- count failed to backed up vms during last job for that subclient
			--SET @vmNotProtectedCount = (SELECT COUNT(DISTINCT VMclientId) FROM APP_VMProp WITH (NOLOCK) WHERE jobId = ISNULL((SELECT MAX(jobId) FROM JMBkpStats WITH (NOLOCK) WHERE appId = @subclientId AND status in ( 1,3,14,16)), 0)
			--						AND attrName = 'vmStatus' AND attrVal = 1)
	        -- Any VM for which valid job is there and Job is not yet aged
	        DECLARE @deleteVMListTbl Table
			(
				clientId			INT
			)
			insert into @deleteVMListTbl
			select componentNameId from app_clientprop where attrName='Virtual Machine Deletion Time' AND modified=0 and isnull(attrval, 0) !=0
	        -- Any VM for which valid job is there and Job is not yet aged
	        SET @vmNotProtectedCount = ISNULL((SELECT COUNT(DISTINCT JQ.clientid) FROM JMQinetixUpdateStatus JQ WITH (NOLOCK)
										INNER JOIN JMBkpStats JS WITH (NOLOCK)
											ON JQ.jobId = JS.jobId AND JQ.commCellId = JS.commCellId AND JS.appId = @subclientId
										INNER JOIN APP_Client AC ON AC.id = JQ.clientId
										LEFT OUTER JOIN @deleteVMListTbl dt ON dt.clientId = JQ.clientId
										LEFT OUTER JOIN @VMStatusTbl CT ON CT.vmClientId = JQ.clientId
										WHERE CT.vmClientId IS NULL and dt.clientId is null ), 0)
	        -- Count total vms configured in subclient
			SET @vmTotalCount = @vmNotProtectedCount + @vmProtectedCount + @vmBackedUpWithErrorCount + @vmPendingCount
			-- Add VSA specific subclient properties
			SET @datastoreFreespaceRequired = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'VS DS Freespace Required' AND modified = 0)
			SET @datastoreFreespaceCheck = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'VS Perform DS Freespace Check' AND modified = 0),1)
			SET @hypervisorCBTDefault = ISNULL((SELECT distinct 1 FROM  APP_InstanceProp INST WITH (NOLOCK) WHERE INST.componentNameId IN (SELECT instance FROM APP_Application APP WITH(NOLOCK) WHERE APP.id = @subclientId) AND attrname = 'Virtual Server Instance Type' AND modified = 0 AND attrval IN('100','101','103','601','801','402','301')), 0)
			SET @useChangedTrackingOnVM = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Change Tracking on VM' AND modified = 0), @hypervisorCBTDefault)
			SET @quiesceGuestFileSystemAndApplications = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'VS QUIESCE SIMPANA' AND modified = 0)
			SET @autoDetectVMOwner = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Virtual Server Auto Detect VM Owner' AND modified = 0)
			SET @vmCollectFileDetails = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Virtual Server Catalog File Details' AND modified = 0)
			SET @vmCollectFileDetailsForSnap = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Virtual Server Catalog File Details For Snap' AND modified = 0)
			SET @vmSnapRetentionOverride = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Virtual Server Retention override' AND modified = 0)
			SET @vmSnapRetentionCount = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Virtual Server Number Of Snaps To Retain' AND modified = 0)
			SET @retainSnap = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Virtual Server Retain Snapshot' AND modified = 0)
			SET @vmCheckPointSetting = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Use VM Checkpoint Setting' AND modified = 0),0)
			SET @vsaMemberServer = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Virtual Server Proxy Client List' AND modified = 0),'<App_MemberServers/>')
			SET @vsaMemberServer = (SELECT CAST(REPLACE(CAST(@vsaMemberServer AS VARCHAR(MAX)), 'encoding="utf-16"', 'encoding="utf-8"') AS XML).query('/App_MemberServers/memberServers'))
			SET @isVsaCrossAccountEnabled = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Enable cross account copy' AND modified = 0)
			SET @isVsaCrossAccountCopyEnabled = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Enable cross account full copy' AND modified = 0)
			SET @snapCopyAamazonClient = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Cross account copy destination client' AND modified = 0)
			SET @snapCopyAaccountId = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Cross account copy destination account id' AND modified = 0)
			SET @snapCopyAaccessKey = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Cross account copy destination access key' AND modified = 0)
			SET @hcNodesXml = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Healthcare Systems' AND modified = 0)
			-- check if block level replication is enabled for this subclient
			SET @blockLevelReplication = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Virtual Server Block Level Replication' AND modified = 0)
			IF @parentSubclientId <> 0
				SET @proxyESXServer = ISNULL((SELECT CAST(REPLACE(CAST(attrVal AS VARCHAR(MAX)), 'encoding="utf-16"', 'encoding="utf-8"') AS XML) FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @parentSubclientId AND attrName = 'Virtual Server SNAP info' AND modified = 0),'<VirtualServer_VSSnapInfo/>')
			else
				SET @proxyESXServer = ISNULL((SELECT CAST(REPLACE(CAST(attrVal AS VARCHAR(MAX)), 'encoding="utf-16"', 'encoding="utf-8"') AS XML) FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Virtual Server SNAP info' AND modified = 0),'<VirtualServer_VSSnapInfo/>')
			SET @proxyESXServer = @proxyESXServer.query('/VirtualServer_VSSnapInfo/*')
			SET	@xmlResult =
							(SELECT
								(SELECT	@vmTotalCount AS '@vmTotalCount',
										@vmProtectedCount AS '@vmProtectedCount',
										@vmNotProtectedCount AS '@vmNotProtectedCount',
										@vmPendingCount AS '@vmPendingCount',
										@vmBackedUpWithErrorCount AS '@vmBackedUpWithErrorCount',
										@vmNeverBackedUpCount AS '@vmNeverBackedUpCount'
								FOR XML PATH('vmBackupInfo'), TYPE),
								(SELECT @vmContent.query('/VirtualServer_VMSubClientEntity/*')
								 FOR XML PATH('vmContent'), TYPE),
								 (SELECT @vmFilter.query('/VirtualServer_VMSubClientEntity/*')
								 FOR XML PATH('vmFilter'), TYPE),
								 (SELECT @vmDiskFilter.query('/EVGui_VMSubclientDiskFilterList/*')
								 FOR XML PATH('vmDiskFilter'), TYPE),
								 (SELECT	@datastoreFreespaceRequired AS '@datastoreFreespaceRequired',
										@datastoreFreespaceCheck AS '@datastoreFreespaceCheck',
										@useChangedTrackingOnVM AS '@useChangedTrackingOnVM',
										@quiesceGuestFileSystemAndApplications AS '@quiesceGuestFileSystemAndApplications',
										@autoDetectVMOwner AS '@autoDetectVMOwner',
										@blockLevelReplication AS '@blockLevelReplication',
										@vendorType			AS '@vendorType',
										@vmCollectFileDetails AS '@collectFileDetails',
										@vmCollectFileDetailsForSnap AS '@collectFileDetailsForSnap',
										@retainSnap			AS '@retainSnap',
										@vmCheckPointSetting AS '@useVMCheckpointSetting',
										@isVsaCrossAccountEnabled AS '@isCrossAccountEnabled',
										@isVsaCrossAccountCopyEnabled AS '@isCrossAccountCopyEnabled',
										(SELECT @snapCopyAaccountId AS '@accountId',
												@snapCopyAaccessKey AS '@accessKey',
												(SELECT @snapCopyAamazonClient AS '@clientId'
												FOR XML PATH('amazonClient'), TYPE)
										FOR XML PATH('destinationAccount'), TYPE),
										@vmSnapRetentionOverride AS 'virtualServerRetention/@retentionOverride',
										@vmSnapRetentionCount AS 'virtualServerRetention/@snapCopiesToRetain',
										(SELECT @hcNodesXml.query('/App_HCSubclientProp/*')
	                                        FOR XML PATH('hcSubclientProp'), TYPE),
										(SELECT @vsaMemberServer
											FOR XML PATH('proxies'), TYPE),
										(SELECT @proxyESXServer
											FOR XML PATH('proxyESXServer'), TYPE)
						FOR XML PATH('vsaSubclientProp'), TYPE)
					FOR XML PATH('DBSubClientProp'), TYPE)
		END
		ELSE
		BEGIN
			SET	@xmlResult =
				(SELECT
					(SELECT	@vendorType			AS '@vendorType'
							FOR XML PATH('vsaSubclientProp'), TYPE)
					FOR XML PATH('DBSubClientProp'), TYPE)
		END
	END
	--Gather CV_APPTYPE_MS_SHAREPOINTV2_DOC properties
IF( (@applicationId = 78 ) AND @propertyLevel >= 30 )
	BEGIN
		SET @contentDatabaseSqlClientId = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'SharePoint SQL Client Id' AND modified = 0)
		SET @contentDatabaseSqlClientName = (SELECT name FROM App_Client WITH (NOLOCK) WHERE id = @contentDatabaseSqlClientId)
		SET @contentDatabasenumStreams = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'mssql Data backup streams' AND modified = 0)
		SET @contentDatabaseVDITimeOut = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'MSSQL VDI Timeout' AND modified = 0)
		SET @spEnableArchiving = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Enable Content DB Archiving' AND modified = 0)
		SET @rbsstoreclientId = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'SharePoint RBS Store Client Id' AND modified = 0)
		SET @rbsstoreclientName = (SELECT name FROM App_Client WITH (NOLOCK) WHERE id = @rbsstoreclientId)
SET @sharePointBackupsetType = (SELECT (CASE WHEN (BKP.status & 0x0800) = 0x0800 THEN 1
WHEN (BKP.status & 0x8000) = 0x8000 THEN 3
WHEN (BKP.status & 0x80000) = 0x80000 THEN 4
ELSE 2 END)
										FROM App_Application APP WITH (NOLOCK) INNER JOIN  APP_BackupSetName BKP WITH (NOLOCK)
											ON APP.backupSet = BKP.id AND APP. id = @subclientId)
DECLARE @defaultContentName NVARCHAR(64) = ISNULL((SELECT message FROM EvLocaleMsgs WITH (NOLOCK) Where [messageId] =  (CASE WHEN @sharePointBackupsetType = 1 THEN (3577 | (CAST(POWER(2, 24) AS BIGINT) * 35)) ELSE (3576 | (CAST(POWER(2, 24) AS BIGINT) * 35)) END) AND [localeId] = @localeId), N'/MB')
		DECLARE @spContentTable TABLE(contentPath XML, type INT, contentDisplayPath NVARCHAR(MAX), clientName NVARCHAR(512))
		INSERT INTO @spContentTable
		SELECT filename,
		type,
		NULL,
		CAST(fileName AS XML).value('(/EVGui_SharePointItem/localClient/@clientName)[1]', 'NVARCHAR(MAX)')
		FROM APP_ScFilterFile WHERE componentNameId = @subclientId AND type IN (21,22,23) AND modified = 0
		UPDATE @spContentTable SET contentDisplayPath = REPLACE(contentPath.value('(/EVGui_SharePointItem/@contentPath)[1]', 'NVARCHAR(MAX)'),'\MB\', '')
		--Construct output XML
		SET	@xmlResult =
						(SELECT
							(SELECT
									@contentDatabasenumStreams AS '@ContentDatabasenumStreams',
									@contentDatabaseVDITimeOut AS '@ContentDatabaseVDITimeout',
									@sharePointBackupsetType AS '@backupsetType',
									(SELECT @spEnableArchiving AS 'enableArchiving',
												(SELECT @rbsstoreclientId AS 'clientId',
														@rbsstoreclientName AS 'clientName'
												FOR XML PATH('rbsstoreclient'), TYPE)
											FOR XML PATH('rbsstoreoptions'), TYPE),
									(SELECT @contentDatabaseSqlClientId AS 'clientId',
											@contentDatabaseSqlClientName AS 'clientName'
											FOR XML PATH('ContentDatabaseSqlClient'), TYPE)
								FOR XML PATH ('sharepointsubclientprop'), TYPE),
							(SELECT
							  	[@spContentPath] = CASE WHEN type = 21 THEN contentDisplayPath END,
							   	[@spExceptFilterPath] = CASE WHEN type = 22 THEN contentDisplayPath END,
							   	[@spExcludeFilterPath] = CASE WHEN type = 23 THEN contentDisplayPath END,
							   	(CASE WHEN contentDisplayPath = '\MB' THEN @defaultContentName
							   		WHEN clientName IS NOT NULL THEN
										CASE WHEN ISNUMERIC(contentDisplayPath) = 1 THEN clientName ELSE STUFF(contentDisplayPath, 1, PATINDEX('%\%',contentDisplayPath)-1, clientName) END
									ELSE contentDisplayPath END) AS '@spContentDisplayPath',
							  	(SELECT
								[@contentType] = type,
								[@ContentPath] = CASE WHEN type = 21 THEN CAST(contentPath AS NVARCHAR(MAX)) END,
							   	[@exceptFilterPath] = CASE WHEN type = 22 THEN CAST(contentPath AS NVARCHAR(MAX)) END,
							   	[@excludeFilterPath] = CASE WHEN type = 23 THEN CAST(contentPath AS NVARCHAR(MAX)) END,
								CAST(REPLACE(CAST(contentPath AS NVARCHAR(MAX)) COLLATE Latin1_General_BIN, N'EVGui_SharePointItem', 'content') AS XML)
							  FOR XML PATH('sharepointContents'),TYPE)
							  FROM @spContentTable
							  FOR XML PATH('content'),TYPE)
						FOR XML PATH('DBSubClientProp'), TYPE)
		SET @xmlResult.modify('delete /DBSubClientProp/spContent[empty(./*) and not(./@*)]')
		SET @xmlResult.modify('delete /DBSubClientProp[empty(./*) and not(./@*)]')
	END
	--Gather All Cloud Connector Subclient properties
IF( (@applicationId = 134) AND (@propertyLevel > 5) )
	BEGIN
		--Gather CV_APPTYPE_CLOUD_APPS properties
		DECLARE @cloudInstType INT = 0
		DECLARE @autoUpdateDbList INT
		SELECT @cloudInstType = CAST(attrVal AS INT) FROM APP_Application A WITH (NOLOCK), APP_InstanceProp I WITH (NOLOCK)
							WHERE A.id = @subclientId AND A.instance = I.componentNameId
							AND I.attrName = 'Cloud Apps Instance Type' AND I.modified = 0
		IF (ISNULL(@cloudInstType, 0) = 1 OR ISNULL(@cloudInstType, 0) = 2) --GMAIL or GDRIVE
		BEGIN
			--Fetch all individual properties and set the
			SET @cc_prop_auto_discovery = (	SELECT cast(attrVal as integer)
											FROM App_SubclientProp
											WHERE componentNameId = @subclientId
											AND attrName = 'Cloud Connector Auto Discovery' AND modified = 0)
			SET @cc_prop_Enterprise_Flag = (SELECT cast(attrVal as integer)
											FROM App_SubclientProp
											WHERE componentNameId = @subclientId
											AND attrName = 'Cloud Connector Enterprise' AND modified = 0)
			SET @cc_auto_add_mailboxes =	(SELECT cast(attrVal as integer)
												FROM App_SubclientProp
												WHERE componentNameId = @subclientId
												AND attrName = 'Auto Add New Content' AND modified = 0)
			SET @cc_regex_list =			(SELECT attrVal
												FROM App_SubclientProp
												WHERE componentNameId = @subclientId
												AND attrName = 'Regular Expression' AND modified = 0)
			SET @cc_google_multidomain =	(SELECT cast(attrVal as integer)
												FROM App_SubclientProp WHERE componentNameId = @subclientId
												AND attrName = 'Google Multi Domain Enabled' AND modified = 0)
			SET @cc_google_teamDrive  =		(SELECT cast(attrVal as integer)
												FROM App_SubclientProp WHERE componentNameId = @subclientId
												AND attrName = 'Google TeamDrive Enabled' AND modified = 0)
			SET @cc_google_domainId  =		(SELECT attrVal FROM App_SubclientProp WHERE componentNameId = @subclientId
												AND attrName = 'Google Domain Id' AND modified = 0)
			IF(@cc_prop_Enterprise_Flag=1)
			BEGIN
				DELETE FROM @CloudConnectorInfoTbl
				SET	@xmlResult =(SELECT
									(
										(SELECT @cloudInstType AS '@instanceType',
											(SELECT	@cc_prop_auto_discovery 	AS '@isAutoDiscoveryEnabled',
													@cc_prop_Enterprise_Flag	AS '@isEnterprise',
													@cc_auto_add_mailboxes		AS '@autoAddNewMailboxes',
													@cc_google_multidomain		AS '@enableMultiDomain',
													@cc_google_teamDrive		AS '@enableTeamDrive',
													@cc_google_domainId			AS '@domainId',
													(SELECT @cc_regex_list.query('/App_GoogleSubclient/*')
													FOR XML PATH(''), TYPE)
											FOR XML PATH('googleSubclientProp'), TYPE)
										FOR XML PATH('cloudAppsSubClientProp'), TYPE)
									),
									(
										SELECT 	attrName 	AS 'cloudconnectorContent/includeAccounts/@contentName',
												attrVal 	AS 'cloudconnectorContent/includeAccounts/@contentValue',
												attrType	AS 'cloudconnectorContent/includeAccounts/@contentType'
										FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrType IN (134, 135) and modified=0
										FOR XML PATH('content') ,type
									)
								FOR XML PATH('DBSubClientProp'), TYPE)
			END
			ELSE
			BEGIN
				DELETE FROM @CloudConnectorInfoTbl
				INSERT INTO @CloudConnectorInfoTbl
				SELECT 	componentNameId , attrName, '','',''
				FROM 	APP_SubclientProp
				WHERE 	attrVal = 'Include Account' and componentNameId = @subclientId and modified = 0
				INSERT INTO @CloudConnectorInfoTbl
				SELECT 	componentNameId , '' , attrName,'',''
				FROM 	APP_SubclientProp
				WHERE 	attrVal = 'Exclude Account' and componentNameId = @subclientId and modified = 0
			--select * from @CloudConnectorInfoTbl
			--Construct output XML
				SET	@xmlResult =(SELECT
									(
										(SELECT @cloudInstType AS '@instanceType',
											(SELECT	@cc_prop_auto_discovery 	AS '@isAutoDiscoveryEnabled',
													@cc_prop_Enterprise_Flag	AS '@isEnterprise'
											FOR XML PATH('googleSubclientProp'), TYPE)
										FOR XML PATH('cloudAppsSubClientProp'), TYPE)
									),
									(
										SELECT 	includePath 	AS 'cloudconnectorContent/@includePath',
												excludePath 	AS 'cloudconnectorContent/@excludePath'
										FROM  	@CloudConnectorInfoTbl a
										FOR XML PATH('content') ,type
									)
								FOR XML PATH('DBSubClientProp'), TYPE)
			END
		END
		ELSE IF (ISNULL(@cloudInstType, 0) = 3) --CloudAppsInstanceType_SALESFORCE
		BEGIN
			DECLARE @backupSfObjects INT = 0
			DECLARE @backupFileObjects INT = 0
			DECLARE @edgeEnabled INT = 0
			DECLARE @backupMetaData INT = 0
			DECLARE @downloadCachePath NVARCHAR(1024) = N''
			DECLARE @backupObjs XML
			DECLARE @exludeObjs XML
			DECLARE @syncDatabase XML
			DECLARE @backupArchivedandDeletedRecs INT = 0
			SET @backupSfObjects = (SELECT CAST(attrVal AS INT) FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Salesforce Backup Salesforce Objects' AND modified = 0)
			SET @backupFileObjects = (SELECT CAST(attrVal AS INT) FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Salesforce Backup File Objects' AND modified = 0)
			SET @edgeEnabled = (SELECT CAST(attrVal AS INT) FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Salesforce Edge Enabled' AND modified = 0)
			SET @backupMetaData = (SELECT CAST(attrVal AS INT) FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Salesforce Backup Metadata' AND modified = 0)
			SET @downloadCachePath = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Salesforce Download Cache Path' AND modified = 0)
			SET @backupObjs = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Salesforce Backup Objects' AND modified = 0)
			SET @exludeObjs = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Salesforce Exclude Objects' AND modified = 0)
			SET @syncDatabase = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Salesforce Sync Database' AND modified = 0)
			SET @backupArchivedandDeletedRecs = (SELECT CAST(attrVal AS INT) FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Salesforce Backup Archived and Deleted Records' AND modified = 0)
			SET	@xmlResult =
							(SELECT
								(SELECT @cloudInstType AS '@instanceType',
									(SELECT
										ISNULL(@backupSfObjects, 0) as '@backupSfObjects',
										ISNULL(@backupFileObjects, 0) as '@backupFileObjects',
										ISNULL(@edgeEnabled, 0) as '@edgeEnabled',
										ISNULL(@backupMetaData, 0) as '@backupSFMetadata',
										ISNULL(@backupArchivedandDeletedRecs, 0) as '@backupArchivedandDeletedRecs',
										(SELECT @backupObjs.query('/App_SalesforceSubClient/*')),
										(SELECT @exludeObjs.query('/App_SalesforceSubClient/*'))
									 FOR XML PATH ('salesforceSubclient'), TYPE)
							FOR XML PATH('cloudAppsSubClientProp'), TYPE)
						FOR XML PATH('DBSubClientProp'), TYPE)
		END
		ELSE IF( ISNULL(@cloudInstType, 0) = 4) --CloudAppsInstanceType_AMAZON_RDS
		BEGIN
			DECLARE @rdsDynamicContentProperty XML
			DECLARE @autoUpdateList INT
			DECLARE @waitForSnapshot INT
			DECLARE @TempTable TABLE (rdsDynamicContentProperty XML)
			DECLARE @i_rdsXML XML = '<App_RDSSubclientContentListReq opType="1"><rdsSubclient><scEntity subclientId="'+CAST(@subclientId AS NVARCHAR(32))+'"/></rdsSubclient></App_RDSSubclientContentListReq>'
			DECLARE @overrideType INT
			DECLARE @PrimaryCopy INT
			DECLARE @archGroup INT
			DECLARE @isCrossAccountEnabled INT
			DECLARE @CAamazonClient INT
			DECLARE @CAaccountId	BIGINT
			DECLARE @CAaccessKey    NVARCHAR(255)
			DECLARE @isCrossAccountCopyEnabled INT
			INSERT INTO @TempTable EXEC [dbo].[APPGetRDSSubclientContentList] @i_rdsXML
			SET @rdsDynamicContentProperty = (SELECT rdsDynamicContentProperty FROM @TempTable)
			SET @autoUpdateList = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Auto update instance list' AND modified = 0)
			SET @waitForSnapshot = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Wait for snapshot to complete' AND modified = 0)
			SET @overrideType = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Override storage policy copy retention' AND modified = 0)
			SET @isCrossAccountEnabled = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Enable cross account copy' AND modified = 0)
			SET @isCrossAccountCopyEnabled = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Enable cross account full copy' AND modified = 0)
			SET @CAamazonClient = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Cross account copy destination client' AND modified = 0)
			SET @CAaccountId = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Cross account copy destination account id' AND modified = 0)
			SET @CAaccessKey = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Cross account copy destination access key' AND modified = 0)
			SET @archGroup = (SELECT dataArchGrpID FROM APP_Application WITH (NOLOCK) WHERE id = @subclientId)
			SET @PrimaryCopy = (SELECT defaultSnapCopy FROM archGroup WITH (NOLOCK) WHERE id = @archGroup)
			SET @cloudDbContent = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Cloud DB Dynamic Content' AND modified = 0)
			SET @xmlResult =
							(SELECT
								(SELECT @cloudInstType AS '@instanceType',
									(SELECT
										@autoUpdateList AS '@autoUpdateList',
										@waitForSnapshot AS '@waitForSnapshot',
										@isCrossAccountEnabled AS '@isCrossAccountEnabled',
										@isCrossAccountCopyEnabled AS '@isCrossAccountCopyEnabled',
										(SELECT @CAaccountId AS '@accountId',
												@CAaccessKey AS '@accessKey',
												(SELECT @CAamazonClient AS '@clientId'
												FOR XML PATH('amazonClient'), TYPE)
										FOR XML PATH('destinationAccount'), TYPE),
										(SELECT @rdsDynamicContentProperty.query('/App_RDSSubclientContentListResp/rdsSubclient/*')),
										(SELECT
											@overrideType AS '@overrideType',
											(SELECT
												retentionDays as '@retentionDays',
												retentionJobs as '@retentionJobs',
												fullCycles as '@fullCycles',
												flags as '@r_Flag',
												weekStart as '@weekStart',
												monthStart as '@monthStart',
												yearStart as '@yearStart',
												archiverRetDays as '@archiverRetDays',
												minutesSinceDayStarts as '@minutesSinceDayStarts',
												(CASE
													WHEN copyId = @PrimaryCopy
														THEN 1
													ELSE 0
												END) as '@isPrimaryCopy',
												(SELECT
													copyId as '@copyId',
													(SELECT name FROM archGroupCopy WHERE id = copyId) as '@copyName'
												FOR XML PATH('copy'), TYPE)
											FROM
												archAppCopyAgingRule
											WHERE appId = @subclientId
											FOR XML PATH('copySettings'), TYPE)
										FOR XML PATH('rdsRetention'), TYPE)
									FOR XML PATH ('rdsSubclient'), TYPE)
								FOR XML PATH ('cloudAppsSubClientProp'), TYPE),
								(SELECT @cloudDbContent.query('/App_CloudDBEntity/*')
										FOR XML PATH('cloudDbContent'), TYPE)
							FOR XML PATH ('DBSubClientProp'), TYPE)
		END
		ELSE IF( ISNULL(@cloudInstType, 0) = 22 --CloudAppsInstanceType_AMAZON_DYNAMODB
		OR ISNULL(@cloudInstType, 0) = 26 --CloudAppsInstanceType_AMAZON_Redshift
		OR ISNULL(@cloudInstType, 0) = 27) --CloudAppsInstanceType_AMAZON_DocumenDB
		BEGIN
			DECLARE @temporaryReadThroughput BIGINT
			SET @cloudDbContent = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Cloud DB Dynamic Content' AND modified = 0)
			SET @configXml = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Config XML' AND modified = 0)
			SET @temporaryReadThroughput = ISNULL((SELECT  ref.value('@temporaryReadThroughput', 'bigint') AS dyn
            FROM    @configXml.nodes('App_DynamoDBSubclient') R ( ref )), 0)
			SET	@xmlResult = (
								SELECT
									(SELECT @cloudDbContent.query('/App_CloudDBEntity/*')
										FOR XML PATH('cloudDbContent'), TYPE),
									(SELECT @cloudInstType AS '@instanceType',
										(SELECT @temporaryReadThroughput AS '@temporaryReadThroughput'
											FOR XML PATH ('dynamoDBSubclient'), TYPE)
									FOR XML PATH('cloudAppsSubClientProp'), TYPE)
								FOR XML PATH('DBSubClientProp'), TYPE
							)
		END
		ELSE IF( ISNULL(@cloudInstType, 0) = 32 --CloudAppsInstanceType_AZURE_TABLE_STORAGE
		OR ISNULL(@cloudInstType, 0) = 23 ) --CloudAppsInstanceType_AZURE_COSMOS_DB
		BEGIN
			SET @cloudDbContent = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Cloud DB Dynamic Content' AND modified = 0)
			SET	@xmlResult = (
								SELECT
									(SELECT @cloudDbContent.query('/App_CloudDBEntity/*')
										FOR XML PATH('cloudDbContent'), TYPE),
									(SELECT @cloudInstType AS '@instanceType'
									FOR XML PATH('cloudAppsSubClientProp'), TYPE)
								FOR XML PATH('DBSubClientProp'), TYPE
							)
		END
		ELSE IF( ISNULL(@cloudInstType, 0) = 5 OR ISNULL(@cloudInstType, 0) = 6 --CloudAppsInstanceType_AZURE_BLOB OR CloudAppsInstanceType_AMAZON_S3
		OR ISNULL(@cloudInstType, 0) = 14 OR ISNULL(@cloudInstType, 0) = 15 --CloudAppsInstanceType_ORACLE_STORAGE_SERVICE OR CloudAppsInstanceType_OPENSTACK
		OR ISNULL(@cloudInstType, 0) = 20 OR ISNULL(@cloudInstType, 0) = 21 --CloudAppsInstanceType_GOOGLE_CLOUD OR CloudAppsInstanceType_AZURE_DATA_LAKE
		OR ISNULL(@cloudInstType, 0) = 24 OR ISNULL(@cloudInstType, 0) = 25) --CloudAppsInstanceType_IBM_COS OR CloudAppsInstanceType_ALIBABA_OSS
		BEGIN
			DECLARE @FSContentInfo TABLE (
											contentType INT,
											content NVARCHAR(MAX))
			INSERT  INTO @FSContentInfo
            SELECT type, fileName FROM APP_ScFilterFile WITH (NOLOCK)
            WHERE componentNameId = @subclientId and modified = 0
			DECLARE @collectACL NVARCHAR(8)
			SET @collectACL = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Enable ACL Collection' AND modified = 0)
			SET @xmlResult =
							(SELECT
								(SELECT @cloudInstType AS '@instanceType',
									@collectACL AS '@collectACL'
								FOR XML PATH ('cloudAppsSubClientProp'), TYPE),
								(SELECT content AS '@path'
									FROM @FSContentInfo AS fsContentInfo
									WHERE fsContentInfo.contentType = 1
								FOR XML PATH('content'),TYPE),
								(SELECT content AS '@excludePath'
									FROM @FSContentInfo AS fsContentInfo
									WHERE fsContentInfo.contentType = 3
								FOR XML PATH('content'),TYPE)
							FOR XML PATH ('DBSubClientProp'), TYPE)
		END
		ELSE IF( ISNULL(@cloudInstType, 0) IN (8,9,10,11,13))
		--CloudAppsInstanceType_ORACLE_DATABASE, CloudAppsInstanceType_ORACLE_JAVA, CloudAppsInstanceType_ORACLE_MYSQL, CloudAppsInstanceType_ORACLE_APPLICATION_CONTAINER, CloudAppsInstanceType_ORACLE_SOA
		BEGIN
			DECLARE @keepForever INT
			DECLARE @includeDatabase INT
SET @autoUpdateDbList = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Auto Update instance list' AND modified = 0)
SET @keepForever = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'OPaaS Keep Forever' AND modified = 0)
SET @includeDatabase = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'OPaaS Include Database' AND modified = 0)
			SET @xmlResult =
							(SELECT
								(SELECT @cloudInstType AS '@instanceType',
									(SELECT @autoUpdateDbList AS '@autoUpdateList',
											@keepForever as '@keepForever',
											@includeDatabase as '@includeDatabase'
									FOR XML PATH ('oraCloudSubclient'), TYPE)
								FOR XML PATH ('cloudAppsSubClientProp'), TYPE)
							FOR XML PATH ('DBSubClientProp'), TYPE)
		END
		ELSE IF(ISNULL(@cloudInstType, 0) = 19 ) -- OCI_DATABASE
		BEGIN
			DECLARE @ociContent XML
SET @ociContent = (SELECT CAST(attrVal AS VARCHAR(MAX)) FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Virtual Server Dyanimc Content' AND modified = 0)
			SET @xmlResult =
							(SELECT
								(SELECT @cloudInstType AS '@instanceType'
								FOR XML PATH ('cloudAppsSubClientProp'), TYPE),
								(SELECT @ociContent.query('/VirtualServer_VMSubClientEntity/*')
								FOR XML PATH('vmContent'), TYPE)
							FOR XML PATH ('DBSubClientProp'), TYPE)
		END
		ELSE IF (ISNULL(@cloudInstType, 0) = 7) --CloudAppsInstanceType_ONEDRIVE
		BEGIN
			--Fetch all individual properties and set the
			SET @cc_prop_auto_discovery = (	SELECT cast(attrVal as integer)
											FROM App_SubclientProp
											WHERE componentNameId = @subclientId
											AND attrName = 'Cloud Connector Auto Discovery' AND modified = 0)
			SET @cc_prop_Enterprise_Flag = (SELECT cast(attrVal as integer)
											FROM App_SubclientProp
											WHERE componentNameId = @subclientId
											AND attrName = 'Cloud Connector Enterprise' AND modified = 0)
			SET @cc_auto_add_mailboxes =	(SELECT cast(attrVal as integer)
												FROM App_SubclientProp
												WHERE componentNameId = @subclientId
												AND attrName = 'Auto Add New Content' AND modified = 0)
			SET @cc_regex_list =			(SELECT attrVal
												FROM App_SubclientProp
												WHERE componentNameId = @subclientId
												AND attrName = 'Regular Expression' AND modified = 0)
			SET @cc_oneDrive_oneNote =		(SELECT attrVal FROM App_SubclientProp WHERE componentNameId = @subclientId
												AND attrName = 'OneNote Enabled'AND modified  = 0)
			IF(@cc_prop_Enterprise_Flag=1)
			BEGIN
				DELETE FROM @CloudConnectorInfoTbl
				SET	@xmlResult =(SELECT
									(
										(SELECT @cloudInstType AS '@instanceType',
											(SELECT	@cc_prop_auto_discovery 	AS '@isAutoDiscoveryEnabled',
													@cc_prop_Enterprise_Flag	AS '@isEnterprise',
													@cc_auto_add_mailboxes		AS '@autoAddNewMailboxes',
													@cc_oneDrive_oneNote		AS '@enableOneNote',
													(SELECT @cc_regex_list.query('/App_OneDriveSubclient/*')
													FOR XML PATH(''), TYPE)
											FOR XML PATH('oneDriveSubclient'), TYPE)
										FOR XML PATH('cloudAppsSubClientProp'), TYPE)
									),
									(
										SELECT 	attrName 	AS 'cloudconnectorContent/includeAccounts/@contentName',
												attrVal 	AS 'cloudconnectorContent/includeAccounts/@contentValue',
												attrType	AS 'cloudconnectorContent/includeAccounts/@contentType'
										FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrType IN (134, 135) and modified=0
										FOR XML PATH('content') ,type
									)
								FOR XML PATH('DBSubClientProp'), TYPE)
			END
			ELSE
			BEGIN
				DELETE FROM @CloudConnectorInfoTbl
				INSERT INTO @CloudConnectorInfoTbl
				SELECT 	componentNameId , attrName, '','',''
				FROM 	APP_SubclientProp
				WHERE 	attrVal = 'Include Account' and componentNameId = @subclientId and modified = 0
				INSERT INTO @CloudConnectorInfoTbl
				SELECT 	componentNameId , '' , attrName,'',''
				FROM 	APP_SubclientProp
				WHERE 	attrVal = 'Exclude Account' and componentNameId = @subclientId and modified = 0
			--select * from @CloudConnectorInfoTbl
			--Construct output XML
				SET	@xmlResult =(SELECT
									(
										(SELECT @cloudInstType AS '@instanceType',
											(SELECT	@cc_prop_auto_discovery 	AS '@isAutoDiscoveryEnabled',
													@cc_prop_Enterprise_Flag	AS '@isEnterprise'
											FOR XML PATH('oneDriveSubclient'), TYPE)
										FOR XML PATH('cloudAppsSubClientProp'), TYPE)
									),
									(
										SELECT 	includePath 	AS 'cloudconnectorContent/@includePath',
												excludePath 	AS 'cloudconnectorContent/@excludePath'
										FROM  	@CloudConnectorInfoTbl a
										FOR XML PATH('content') ,type
									)
								FOR XML PATH('DBSubClientProp'), TYPE)
			END
		END
		ELSE IF (ISNULL(@cloudInstType,0) = 33) --CloudAppsInstanceType_GitHub
		BEGIN
				DECLARE @gitHubSubclientType INT
				DECLARE @gitAllRepoFlag INT
				DECLARE @gitRepoList XML
				SET @gitHubSubclientType = (SELECT attrVal from APP_SubClientProp with (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'GitHub Subclient Type' AND modified=0)
				SET @gitAcccountName = ISNULL((SELECT attrVal from APP_SubClientProp with (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Git App Account Name' AND modified=0),'')
				SET @gitAllRepoFlag = ISNULL((SELECT attrVal from APP_SubClientProp with (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Git App All Repositories Flag' AND modified=0),0)
				SET @gitRepoList =ISNULL((SELECT attrVal from APP_SubClientProp with (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Git App Repositories List' AND modified=0),'<App_RepositorySubclientInfo />')
				SET	@xmlResult = (
					SELECT
						(SELECT @cloudInstType AS '@instanceType',
							(SELECT @gitHubSubclientType as '@subclientType',
									@gitAcccountName as '@accountName',
									(SELECT
										@gitAllRepoFlag as '@allRepositories',
										@gitRepoList.query('/App_RepositorySubclientInfo/*')
									FOR XML PATH('repositoryInfo'),TYPE)
								FOR XML PATH ('gitHubSubclient'), TYPE)
						FOR XML PATH('cloudAppsSubClientProp'), TYPE)
					FOR XML PATH('DBSubClientProp'), TYPE)
		END
		ELSE IF (ISNULL(@cloudInstType,0) = 34) --CloudAppsInstanceType_AzureDevOps
		BEGIN
				DECLARE @gitAllProjectsFlag INT
				DECLARE @gitProjectList XML
				SET @gitAcccountName = ISNULL((SELECT attrVal from APP_SubClientProp with (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Git App Account Name' AND modified=0),'')
				SET @gitAllProjectsFlag = ISNULL((SELECT attrVal from APP_SubClientProp with (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Git App All Projects Flag' AND modified=0),0)
				SET @gitProjectList = ISNULL((SELECT attrVal from APP_SubClientProp with (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Git App Projects List' AND modified=0),'<App_GitAppProjectSubclientInfo />')
				SET	@xmlResult = (
					SELECT
						(SELECT @cloudInstType AS '@instanceType',
							(SELECT @gitAcccountName as '@accountName',
									(SELECT
										@gitAllProjectsFlag as '@allProjectsFlag',
										@gitProjectList.query('/App_GitAppProjectSubclientInfo/*')
									FOR XML PATH('projectInfo'),TYPE)
								FOR XML PATH ('azureDevopsSubclient'), TYPE)
						FOR XML PATH('cloudAppsSubClientProp'), TYPE)
					FOR XML PATH('DBSubClientProp'), TYPE)
		END
		ELSE IF (ISNULL(@cloudInstType,0) = 37) --CloudAppsInstanceType_GCP_SPANNER
		BEGIN
			DECLARE @cloudSpannerSubclient XML
			SET @cloudSpannerSubclient = ISNULL((SELECT attrVal from App_SubClientProp with (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Google Cloud Spanner Subclient Info' AND cs_attrName = CHECKSUM(N'Google Cloud Spanner Subclient Info') AND modified=0), '<App_CloudSpannerSubclient />')
			SET @xmlResult = (
				SELECT
					(SELECT @cloudInstType AS '@instanceType',
					(SELECT
						(SELECT @cloudSpannerSubclient.value('(/App_CloudSpannerSubclient/@cloudStagingPath)[1]', 'nvarchar(max)')) as '@cloudStagingPath',
						@cloudSpannerSubclient.query('/App_CloudSpannerSubclient/*')
						FOR XML PATH ('cloudSpannerSubclient'), TYPE)
					FOR XML PATH('cloudAppsSubClientProp'), TYPE)
				FOR XML PATH('DBSubClientProp'), TYPE)
		END
		ELSE
		BEGIN
			SET	@xmlResult = (
				SELECT
					(SELECT @cloudInstType AS '@instanceType'
					FOR XML PATH('cloudAppsSubClientProp'), TYPE)
				FOR XML PATH('DBSubClientProp'), TYPE
			)
		END
	END
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDBSubClientProperties')
	delete from GxQscripts where name = 'AppGetDBSubClientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDBSubClientProperties')
	delete from GXDBVersions where aliasname = 'AppGetDBSubClientProperties'
GO

insert into GXDBVersions values(2, 'AppGetDBSubClientProperties',  '00000000000000000000', 'AppGetDBSubClientProperties', '00000000000000000000')
GO

