

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDBSCContentMap.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetDBSCContentMap.sp,v $ $Id: AppGetDBSCContentMap.sp,v 1.1.2.2 2019/12/12 19:07:14 stelagamsetti Exp $";
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetDBSCContentMap')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDBSCContentMap <<<'
	drop procedure AppGetDBSCContentMap
END
IF EXISTS (select * from GxQscripts where name='AppGetDBSCContentMap')
	delete from GxQscripts where name = 'AppGetDBSCContentMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDBSCContentMap')
	delete from GXDBVersions where aliasname = 'AppGetDBSCContentMap'
GO
print '... Creating Procedure: AppGetDBSCContentMap'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppGetDBSCContentMap
-- Input arguments
  @instanceId INT,
  @appTypeId INT
AS
--Output Arguments
declare @contentType	integer
BEGIN TRY
IF @appTypeId = 104
    SET @contentType = 120 -- PROPERTY_MYSQL
ELSE IF @appTypeId = 125
    SET @contentType = 122 -- PROPERTY_POSTGRESQL
ELSE IF @apptypeId = 5
	SET @contentType = 116 -- PROPERTY_SYBASE
SELECT app.id as subClientId,
	   app.subclientName as subClientName,
	   prop.attrName as dbName
FROM
App_Application app
JOIN APP_SubClientProp prop ON prop.componentNameId = app.id
WHERE app.instance = @instanceId AND prop.attrType = @contentType AND prop.modified = 0 AND (app.subclientStatus & 0x00004) = 0
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDBSCContentMap')
	delete from GxQscripts where name = 'AppGetDBSCContentMap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDBSCContentMap')
	delete from GXDBVersions where aliasname = 'AppGetDBSCContentMap'
GO

insert into GXDBVersions values(2, 'AppGetDBSCContentMap',  '00010001000200020000', 'AppGetDBSCContentMap', '00010001000200020000')
GO

