

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDBPointSolutionInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetDBPointSolutionInfo.sp,v $ $Id: AppGetDBPointSolutionInfo.sp,v 1.1.2.23 2018/10/13 14:33:36 rgunda Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetDBPointSolutionInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDBPointSolutionInfo <<<'
	drop procedure AppGetDBPointSolutionInfo
END
IF EXISTS (select * from GxQscripts where name='AppGetDBPointSolutionInfo')
	delete from GxQscripts where name = 'AppGetDBPointSolutionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDBPointSolutionInfo')
	delete from GXDBVersions where aliasname = 'AppGetDBPointSolutionInfo'
GO
print '... Creating Procedure: AppGetDBPointSolutionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetDBPointSolutionInfo
  @userId INTEGER,
  @o_xml XML OUTPUT
AS
  DECLARE @o_responseXML XML;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
    DROP TABLE #getIdaObjects
CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
exec dbo.sec_getIdaObjectsForUser @userid,5,0,1, '#getIdaObjects' -- 5 = Instance_Entity from Cventities.x
-- Create index on subclientId column on the temp table.
CREATE INDEX getIdaObjects_subclientID_Idx ON #getIdaObjects(subclientID)
IF OBJECT_ID('tempdb.dbo.#ClientInstanceDetails') IS NOT NULL
	DROP TABLE #ClientInstanceDetails
CREATE TABLE #ClientInstanceDetails
(	[OsName] NVARCHAR(255),
	[OsType] NVARCHAR(255),
	[InstanceId] INT,
	[InstanceName] NVARCHAR(255),
	[ClientId] INT,
	[ClientName] NVARCHAR(255),
	[IdaType] INT,
	[IdaName] NVARCHAR(255),
	[IsSnapEnabled] INT,
	[InstanceType] NVARCHAR(255),
	-- Plan Association Details Start
    planId                  INT NULL,
    planType                INT NULL,
    planSubType             INT NULL,
    planName                NVARCHAR(1024) NULL,
    -- Plan Association Details END
		PRIMARY KEY([InstanceId],[ClientId]))
INSERT INTO #ClientInstanceDetails
		SELECT		 OS.name                AS [OsName],
                         OS.[Type]              AS [OsType],
                         I.id                   AS [InstanceId],
                         I.name                 AS [InstanceName],
                         CL.id                  AS [ClientId],
                         CL.name                AS [ClientName],
                         IDA.[type]             AS [IdaType],
                         IDA.name               AS [IdaName],
                         Max(ISNULL(SCP.attrVal, 0)) AS [IsSnapEnabled],
                         ISNULL(IP.AttrVal, '') AS [InstanceType],
						 ISNULL(AP.id,0)		AS [planId],
						 ISNULL(AP.type,0)		AS [planType],
						 ISNULL(AP.subType,0)	AS [planSubType],
						 ISNULL(AP.name, NULL)	AS [planName]
        FROM    APP_InstanceName I WITH(NOLOCK) INNER JOIN APP_Application        SC  WITH(NOLOCK) ON I.id = SC.instance
                                                INNER JOIN APP_Client             CL  WITH(NOLOCK) ON SC.clientId = CL.id
                                                INNER JOIN APP_iDAType            IDA WITH(NOLOCK) ON SC.appTypeId = IDA.[type]
	                                            INNER JOIN simOperatingSystem     OS  WITH(NOLOCK) ON OS.id = CL.simOperatingSystemId
                                                INNER JOIN #getIdaObjects SEC     ON  (SC.instance  = SEC.instanceID)
                                                LEFT OUTER JOIN APP_SubClientProp SCP WITH(NOLOCK) ON     SCP.componentNameId = SC.id
                                                                                                      AND SCP.cs_attrName = CHECKSUM(N'Enable Snap backups') AND SCP.attrName = 'Enable Snap backups'
                                                                                                      AND SCP.modified = 0
                                                LEFT OUTER JOIN APP_InstanceProp IP WITH(NOLOCK) ON       IP.componentNameId = I.id
AND ((IP.attrName = 'MSSQL Server Type' AND IDA.[type] = 81)
OR (IP.attrName = 'DB Container Mode' AND IDA.[type] = 135))
                                                                                                      AND IP.modified = 0
												LEFT OUTER JOIN APP_InstanceProp AIP WITH(NOLOCK)
ON AIP.componentNameId=I.id  AND AIP.attrName = 'Associated Plan' AND AIP.modified=0
												LEFT OUTER JOIN App_Plan AP WITH(NOLOCK)
ON CAST(AP.id AS NVARCHAR(32))=AIP.attrVal AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
        WHERE     (I.status&16) = 0 AND (I.status&2) = 0 AND (I.status&4) = 0 AND (I.status & 2048) = 0 AND (I.status & 32) = 0
				--#define CV_STATUS_UNINSTALLED       0x00002
				--#define CV_STATUS_DELETED           0x00004
				--#define CV_STATUS_DEFAULT           0x00008
				--#define CV_STATUS_DUMMY             0x00010
				--#define CV_STATUS_HIDDEN            0x00020
				--#define CV_STATUS_ONDEMAND          0x0800
              AND I.name NOT LIKE '+ASM%'
	          AND I.name NOT LIKE '-ASM%'
			  AND I.name <> '-MGMTDB'
			  AND I.name <> 'LISTENER'
AND IDA.[type] IN (22, 135, 125, 80)
	          -- We are sending analysis server instances for DB Point solution now since support is added now.
			-- Adding group by below since if there are multiple subclients for an instance and one of them have snap enabled and other doesnt, two rows are returned for same instance (one with snap enabled as true and one with snap enabled as false).
		GROUP BY OS.name, OS.[Type] , I.id , I.name , CL.id  , CL.name , IDA.[type] , IDA.name, ISNULL(IP.AttrVal, ''), ISNULL(AP.id, 0), ISNULL(AP.type, 0), ISNULL(AP.subType, 0),ISNULL(AP.name, NULL)
-- Update DB Thin client property if it is supported apptype for DB Thin clients
-- This is needed for hiding regular instance options for DB Thin clients in admin console
UPDATE  cid SET cid.InstanceType = 'DB_THIN_CLIENT' FROM  #ClientInstanceDetails cid  INNER JOIN App_ClientProp acp
WITH(NOLOCK) ON cid.ClientId = acp.componentNameId AND cid.IdaType IN (22, 80 )
	WHERE acp.attrName = 'DB Thin Client' AND acp.attrVal = 1 AND acp.modified = 0
-- Update OS details for AG instances.
IF(EXISTS(SELECT 1 FROM #ClientInstanceDetails cid JOIN APP_Client ac WITH(NOLOCK) ON
	cid.ClientId = ac.id AND cid.IdaType = 81 /*CV_APPTYPE_MSSQL*/
		WHERE ((ac.status & 0x20000000 /* CV_STATUS_MSSQLAG */) = 0x20000000)))
BEGIN
	UPDATE cid SET
		cid.InstanceType = 'Database Engine'
	FROM #ClientInstanceDetails cid JOIN APP_Client ac WITH(NOLOCK)
		ON cid.ClientId = ac.id AND cid.IdaType = 81 /*CV_APPTYPE_MSSQL*/
	WHERE ((ac.status & 0x20000000 /* CV_STATUS_MSSQLAG */) = 0x20000000)
	IF OBJECT_ID('tempdb.dbo.#tt_Replicas') IS NOT NULL
		DROP TABLE #tt_Replicas
	CREATE TABLE #tt_Replicas (instanceId INT, availableReplicas XML)
	INSERT #tt_Replicas
		SELECT DISTINCT instance.componentNameId, instance.attrVal
		FROM APP_Application subclient WITH(NOLOCK)
			INNER JOIN APP_InstanceProp instance WITH(NOLOCK) ON instance.componentNameId = subclient.instance
		WHERE subclient.appTypeId = 81 /*CV_APPTYPE_MSSQL*/
			AND instance.attrName = N'Availability Replicas' and instance.modified = 0
	IF OBJECT_ID('tempdb.dbo.#tt_InstanceOsInfo') IS NOT NULL
		DROP TABLE #tt_InstanceOsInfo
	CREATE TABLE #tt_InstanceOsInfo (instanceId INT, OsName NVARCHAR(255), OsType NVARCHAR(255))
	-- Store AG instance OS information.
	INSERT INTO #tt_InstanceOsInfo
		SELECT  DISTINCT ReplicaTable.InstanceId, cid.OsName, cid.OsType
				FROM ((SELECT S.instanceId, M.C.value('@clientId', 'INT') AS ReplicaId
							FROM #tt_Replicas AS S
						OUTER APPLY S.availableReplicas.nodes('App_SQLAvailabilityReplicas/SQLAvailabilityReplicasList/replicaClient') as M(C)) ReplicaTable
					JOIN #ClientInstanceDetails cid ON ReplicaTable.ReplicaId = cid.ClientId)
				ORDER BY ReplicaTable.InstanceId
	UPDATE cid SET
		cid.OsName = CASE WHEN T.NumOs = 1 THEN ios.OsName ELSE 'Any' END,
		cid.OsType = CASE WHEN  T.NumOs = 1 THEN ios.OsType ELSE 'Any' END
	FROM #ClientInstanceDetails cid
		-- Filter on AG instances
		JOIN #tt_InstanceOsInfo ios ON ios.instanceId = cid.InstanceId
		-- Get # of OS found on for the AG instance.
		JOIN (SELECT instanceId, count(instanceId) NumOs FROM #tt_InstanceOsInfo GROUP BY instanceId) T
			ON ios.instanceId = T.instanceId
END
SET @o_responseXML =
(
   SELECT A.OsName          AS '@osName',
          A.OsType          AS '@osType',
          A.IsSnapEnabled   AS '@isSnapEnabled',
          A.InstanceType    AS '@instanceType',
          (
            SELECT  A.InstanceId    AS '@instanceId',
                    A.InstanceName  AS '@instanceName',
                    A.ClientId      AS '@clientId',
                    A.ClientName    AS '@clientName',
                    A.IdaName       AS '@appName' ,
                    A.IdaType       AS '@applicationId'
                    FOR XML PATH('entityInfo'), TYPE
          ),
		(
			SELECT planId AS '@planId',
					planType AS '@planType',
					planSubType AS '@planSubtype',
					planName AS '@planName'
				FOR XML PATH('planEntity'),TYPE
          )
	FROM #ClientInstanceDetails A
	FOR XML PATH('dbSolutionInfo'), ROOT('Api_DBPointSolutionInfoResp')
)
-- make sure that tere is always valid Api::DBPointSolutionInfoResp object to be returned
IF @o_responseXML IS NULL
	SET @o_responseXML = '<Api_DBPointSolutionInfoResp/>'
-- drop security table
IF OBJECT_ID('tempdb.dbo.#entitiesWithViewInstCapability') IS NOT NULL
    DROP TABLE #entitiesWithViewInstCapability
--SELECT @o_responseXML AS o_responseXML
SET @o_xml = @o_responseXML
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDBPointSolutionInfo')
	delete from GxQscripts where name = 'AppGetDBPointSolutionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDBPointSolutionInfo')
	delete from GXDBVersions where aliasname = 'AppGetDBPointSolutionInfo'
GO

insert into GXDBVersions values(2, 'AppGetDBPointSolutionInfo',  '00010001000200230000', 'AppGetDBPointSolutionInfo', '00010001000200230000')
GO

