

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDBInstanceVersions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +===================================================================+
--  |               AppGetDBInstanceVersions                      |
--  |        Procedure to get replication information                   |
--  +===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetDBInstanceVersions')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDBInstanceVersions <<<'
	drop procedure AppGetDBInstanceVersions
END
IF EXISTS (select * from GxQscripts where name='AppGetDBInstanceVersions')
	delete from GxQscripts where name = 'AppGetDBInstanceVersions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDBInstanceVersions')
	delete from GXDBVersions where aliasname = 'AppGetDBInstanceVersions'
GO
print '... Creating Procedure: AppGetDBInstanceVersions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetDBInstanceVersions
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS                         ---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @o_xmlString	XML
	DECLARE @userId			INT
	DECLARE @instanceId		INT
	DECLARE @errorString	NVARCHAR(MAX)
	DECLARE @errorCode		INT
	SELECT @userId=ISNULL(r.n.value('processinginstructioninfo[1]/user[1]/@userId', 'INT'), 0), @instanceId=ISNULL(r.n.value('instance[1]/@instanceId', 'INT'), 0) FROM @i_xmlString.nodes('Api_GetDBInstanceVersionsReq') r(n)
	IF @userId <> 0
	BEGIN
		DECLARE @isUserAdmin INT = 0
		EXECUTE sec_isUserAdmin @i_userid = @userId ,@o_isUserAdmin = @isUserAdmin OUTPUT
		IF OBJECT_ID('tempdb.dbo.#idaListTemp') IS NOT NULL DROP TABLE #idaListTemp
			CREATE TABLE #idaListTemp
			(
                 t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
			)
		IF ( @isUserAdmin <> 1 )
		BEGIN
EXEC sec_getIdaObjectsForUser @userId, 5 /*INSTANCE_ENTITY */ , 0, 0, '#idaListTemp'
			IF (SELECT TOP 1 1 FROM #idaListTemp WHERE t_instanceId = @instanceId) <> 1
			BEGIN
				SET @errorCode = -1
				SET @errorString = 'Provided user doesn''t have required privileges.'
				GOTO ERROR_EXIT
			END
		END
		DECLARE @attrName NVARCHAR(256) = ''
		DECLARE @appTypeId INT
		SELECT DISTINCT @appTypeId=appTypeId FROM APP_Application WITH (NOLOCK) WHERE instance = @instanceId
IF @appTypeId = 62 OR @appTypeId = 37 OR @appTypeId = 103
			SET @attrName = 'DB2 Version'
ELSE IF @appTypeId = 22
			SET @attrName = 'Oracle Version'
		SET @o_xmlString =
			(
				SELECT attrVal '@version', created '@createdTime', modified '@modifiedTime' FROM APP_InstanceProp WITH (NOLOCK)
				WHERE attrName = @attrName AND componentNameId = @instanceId ORDER BY created DESC FOR XML PATH('versionInfo'), ROOT('Api_GetDBInstanceVersionsResp')
			)
	END
ERROR_EXIT:
	IF @errorCode <> 0
		SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH('Api_GenericResp'), TYPE)
	IF @o_xmlString IS NULL
		SET @o_xmlString = '<Api_GetDBInstanceVersionsResp/>'
	SELECT @o_xmlString AS o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDBInstanceVersions')
	delete from GxQscripts where name = 'AppGetDBInstanceVersions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDBInstanceVersions')
	delete from GXDBVersions where aliasname = 'AppGetDBInstanceVersions'
GO

insert into GXDBVersions values(2, 'AppGetDBInstanceVersions',  '00000000000000000000', 'AppGetDBInstanceVersions', '00000000000000000000')
GO

