

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDBInstanceList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetDBInstanceList.sp,v $ $Id: AppGetDBInstanceList.sp,v 1.1.2.61 2020/12/23 20:27:07 bsenthilkumar Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetDBInstanceList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDBInstanceList <<<'
	drop procedure AppGetDBInstanceList
END
IF EXISTS (select * from GxQscripts where name='AppGetDBInstanceList')
	delete from GxQscripts where name = 'AppGetDBInstanceList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDBInstanceList')
	delete from GXDBVersions where aliasname = 'AppGetDBInstanceList'
GO
print '... Creating Procedure: AppGetDBInstanceList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetDBInstanceList
  @i_xmlString XML
AS
  DECLARE @o_xmlString XML;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
		DROP TABLE #getIdaObjects
	CREATE TABLE #getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
	CREATE INDEX getIdaObjects_instanceID_Idx ON #getIdaObjects(instanceID)
	-- Table: to store authentication details
	IF OBJECT_ID('tempdb..#SQLAuthDetails') IS NOT NULL DROP TABLE #SQLAuthDetails
	CREATE TABLE #SQLAuthDetails (instanceId int, authType int,
			userName nvarchar(1024), userPassword nvarchar(1024), level int)
	IF OBJECT_ID('tempdb.dbo.#ClientInstanceDetails') IS NOT NULL
		DROP TABLE #ClientInstanceDetails
	CREATE TABLE #ClientInstanceDetails
	(
		[InstanceId] INT,
		[InstanceName] NVARCHAR(255),
		[ClientId] INT,
		[ClientName] NVARCHAR(255),
		[ClientDisplayName] NVARCHAR(255),
		[IdaType] INT,
		[IdaName] NVARCHAR(255),
		[Version] NVARCHAR(255) DEFAULT N'',
		[IsSnapEnabled] INT DEFAULT 0,
		[ClientType] INT DEFAULT 0,
		[ClientAppType] INT DEFAULT 0,
		[LastBackupTime] INT DEFAULT 0,
		[Size] BIGINT DEFAULT 0,
		[SLA] VARCHAR(16) DEFAULT 'Met',
		[SLAStatus] INT DEFAULT(1), /*MET_SLA*/
		[SLADescription] NVARCHAR(MAX) DEFAULT '',
		[slaMissReasonList] XML,
		[Status] VARCHAR(16) DEFAULT 'Ready',
		[NotReadyReason] VARCHAR(256) DEFAULT '',
		[PlanId] INT DEFAULT '0',
		[PlanName] NVARCHAR(256) DEFAULT 'Not Assigned',
		[InstFlags] INT DEFAULT 0,
		[IsCloudDB] NVARCHAR(16) DEFAULT 'false',
		[noDBs] INT DEFAULT 0,
		[applicationSize] BIGINT DEFAULT 0,
		[cloudVendorType] NVARCHAR(16) DEFAULT '0',
		[lastBackupJobInfo] XML,
		[SLACategory]	INT DEFAULT(0),
		PRIMARY KEY([InstanceId],[ClientId])
	)
	-- instance application size table
	IF OBJECT_ID('tempdb.dbo.#InstanceApplicationSize') IS NOT NULL
		DROP TABLE #InstanceApplicationSize
	CREATE TABLE #InstanceApplicationSize (instanceId INT PRIMARY KEY,applicationSize BIGINT DEFAULT 0)
	DECLARE @userId INT = ISNULL((SELECT @i_xmlString.value('(/Api_GetDBInstancesRequest/@userId)[1]','INT')), 0)
	DECLARE @InstanceId INT = ISNULL((SELECT @i_xmlString.value('(/Api_GetDBInstancesRequest/@instanceId)[1]','INT')), 0)
	DECLARE @appTypeId INT = ISNULL((SELECT @i_xmlString.value('(/Api_GetDBInstancesRequest/@appTypeId)[1]','INT')), 0)
	DECLARE @propertyLevel INT = ISNULL((SELECT @i_xmlString.value('(/Api_GetDBInstancesRequest/@propertyLevel)[1]','INT')), 10)
	DECLARE @i_localeId	INT	= ISNULL(@i_xmlString.value('(Api_GetDBInstancesRequest/locale/@localeId)[1]', 'int'), 0)
	--Get list of instances user has visibility to
	EXEC dbo.sec_getIdaObjectsForUser @userid, 7, 0, 1, '#getIdaObjects' -- 7 = SUBCLIENT_ENTITY from CvEntities.x
	IF @apptypeId <> 0
		DELETE	#getIdaObjects
		WHERE	apptypeId != @appTypeId
	-- filter by InstanceId
	IF (@InstanceId <> 0)
	BEGIN
		INSERT	INTO #ClientInstanceDetails (InstanceId, InstanceName, ClientId, ClientName, ClientDisplayName, IdaType, IdaName, InstFlags)
		SELECT	DISTINCT I.id, I.name, SC.clientId, CL.name, CL.displayName, SC.appTypeId, Ida.displayName, I.status
		FROM    APP_InstanceName I
			INNER JOIN APP_Application SC
				ON I.id = SC.instance AND (I.id = @InstanceId)
			INNER JOIN APP_Client CL
				ON SC.clientId = CL.id
			INNER JOIN APP_iDAType IDA
				ON SC.appTypeId = IDA.[type]
			INNER JOIN #getIdaObjects SEC
				ON  (SC.instance  = SEC.instanceID)
WHERE	(I.status & 0x00004) = 0
AND (I.status & 0x00010) = 0
AND (I.status & 0x00020) = 0
AND (I.status & 0x0800) = 0
				AND I.name NOT LIKE '+ASM%'
				AND I.name NOT LIKE '-ASM%'
				AND I.name <> '-MGMTDB'
				AND I.name <> 'LISTENER'
AND IDA.[type] IN (22, 135, 125, 80, 104,
62,37,103, 5, 81, 61, 3)
	END
	ELSE
	BEGIN
		INSERT	INTO #ClientInstanceDetails (InstanceId, InstanceName, ClientId, ClientName, ClientDisplayName, IdaType, IdaName, InstFlags)
		SELECT	DISTINCT I.id, I.name, SC.clientId, CL.name, CL.displayName, SC.appTypeId, Ida.displayName, I.status
		FROM    APP_InstanceName I
			INNER JOIN APP_Application SC
				ON I.id = SC.instance
			INNER JOIN APP_Client CL
				ON SC.clientId = CL.id
			INNER JOIN APP_iDAType IDA
				ON SC.appTypeId = IDA.[type]
			INNER JOIN #getIdaObjects SEC
				ON  (SC.instance  = SEC.instanceID)
WHERE	(I.status & 0x00004) = 0
AND (I.status & 0x00010) = 0
AND (I.status & 0x00020) = 0
AND (I.status & 0x0800) = 0
				AND I.name NOT LIKE '+ASM%'
				AND I.name NOT LIKE '-ASM%'
				AND I.name <> '-MGMTDB'
				AND I.name <> 'LISTENER'
AND IDA.[type] IN (22, 135, 125, 80, 104,
62,37,103, 5, 81, 61, 3)
	END
	--This additional name check is required as the defaultInstance of DB2 is not marked hidden or dummy
DELETE #ClientInstanceDetails WHERE InstanceName = 'defaultInstanceName' AND IdaType = 103 -- Exclude default instances of DB2 Multinode
	-- filter by InstanceId
	IF (@InstanceId <> 0)
	BEGIN
		INSERT	INTO #ClientInstanceDetails (InstanceId, InstanceName, ClientId, ClientName, ClientDisplayName, IdaType, IdaName, InstFlags)
		SELECT	DISTINCT I.id, I.name, A.clientId, C.name, C.displayName, A.appTypeId,
				(CASE	WHEN IP.attrVal = '22' THEN 'DynamoDB'
						WHEN IP.attrVal = '4' THEN 'RDS'
						WHEN IP.attrVal = '23' THEN 'Cosmos DB (SQL API)'
						WHEN IP.attrVal = '26' THEN 'Redshift'
						WHEN IP.attrVal = '27' THEN 'DocumentDB'
						WHEN IP.attrVal = '28' THEN 'Neptune'
						WHEN IP.attrVal = '29' THEN 'ElastiCache'
						WHEN IP.attrVal = '32' THEN 'Table storage'
						WHEN IP.attrVal = '37' THEN 'Spanner'
				ELSE	IDA.displayName END),
				I.status
		FROM	APP_InstanceName I
			INNER JOIN APP_Application A
ON I.id = A.instance AND A.appTypeId = 134  AND (I.id = @InstanceId)
			INNER JOIN APP_Client C
				ON A.clientID = C.id
			INNER JOIN APP_InstanceProp IP
				ON I.id = IP.componentNameId AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0
			INNER JOIN APP_iDAType IDA
				ON A.appTypeId = IDA.[type]
			INNER JOIN #getIdaObjects SEC
				ON  (I.id = SEC.instanceID)
		WHERE	IP.attrVal IN ('4', '22', '23', '26', '27', '28', '29', '32', '37')
AND (I.status & 0x00004) = 0
AND (I.status & 0x00010) = 0
AND (I.status & 0x00020) = 0
	END
	ELSE
	BEGIN
		INSERT	INTO #ClientInstanceDetails (InstanceId, InstanceName, ClientId, ClientName, ClientDisplayName, IdaType, IdaName, InstFlags)
		SELECT	DISTINCT I.id, I.name, A.clientId, C.name, C.displayName, A.appTypeId,
				(CASE	WHEN IP.attrVal = '22' THEN 'DynamoDB'
						WHEN IP.attrVal = '4' THEN 'RDS'
						WHEN IP.attrVal = '23' THEN 'Cosmos DB (SQL API)'
						WHEN IP.attrVal = '26' THEN 'Redshift'
						WHEN IP.attrVal = '27' THEN 'DocumentDB'
						WHEN IP.attrVal = '28' THEN 'Neptune'
						WHEN IP.attrVal = '29' THEN 'ElastiCache'
						WHEN IP.attrVal = '32' THEN 'Table storage'
						WHEN IP.attrVal = '37' THEN 'Spanner'
				ELSE	IDA.displayName END),
				I.status
		FROM	APP_InstanceName I
			INNER JOIN APP_Application A
ON I.id = A.instance AND A.appTypeId = 134
			INNER JOIN APP_Client C
				ON A.clientID = C.id
			INNER JOIN APP_InstanceProp IP
				ON I.id = IP.componentNameId AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0
			INNER JOIN APP_iDAType IDA
				ON A.appTypeId = IDA.[type]
			INNER JOIN #getIdaObjects SEC
				ON  (I.id = SEC.instanceID)
		WHERE	IP.attrVal IN ('4', '22', '23', '26', '27', '28', '29', '32', '37')
AND (I.status & 0x00004) = 0
AND (I.status & 0x00010) = 0
AND (I.status & 0x00020) = 0
	END
	--Update plan info
IF @appTypeId = 81 OR @appTypeId = 0
	BEGIN
		-- Update the plan information.
		UPDATE #ClientInstanceDetails
		SET PlanId = ISNULL(AP.id, 0),
			PlanName = ISNULL(AP.name, N'Not Assigned')
		FROM #ClientInstanceDetails I
			INNER JOIN APP_InstanceProp IP
				ON IP.componentNameId = I.InstanceId
AND IP.attrName = 'Associated Plan'
					AND IP.modified = 0
			LEFT OUTER JOIN App_Plan AP
				ON CAST(AP.id AS NVARCHAR(32)) = IP.attrVal
AND ((AP.flag & 0x00004) = 0)
AND ((AP.flag & 0x40000000) = 0)
		WHERE PlanId = 0
	END
	UPDATE #ClientInstanceDetails
	SET PlanId = ISNULL(AP.id, 0),
		PlanName = ISNULL(AP.name, N'Not Assigned')
	FROM #ClientInstanceDetails I
		INNER JOIN APP_InstanceProp IP
			ON IP.componentNameId = I.InstanceId
AND IP.attrName = 'Associated Plan'
				AND IP.modified=0
		LEFT OUTER JOIN App_Plan AP
			ON CAST(AP.id AS NVARCHAR(32)) = IP.attrVal
AND ((AP.flag & 0x00004) = 0)
AND ((AP.flag & 0x40000000) = 0)
		WHERE PlanId = 0
	--Update SLA status
	IF object_id('tempdb..#SLA_EntityInfo') IS NOT NULL DROP TABLE #SLA_EntityInfo
	CREATE TABLE #SLA_EntityInfo (
	clientId INT, appTypeId INT, instanceId INT, backupsetId INT, appId INT, -- entity IDs to set
	status INT, category INT, slaDays INT)
	insert into #SLA_EntityInfo(clientId, appTypeId, instanceId, backupsetId, appId)
	SELECT  clientId, IdaType, InstanceId, 0, 0
	FROM #ClientInstanceDetails
	exec RptGetSLAOfEntities 3
	UPDATE I
	SET SLAStatus = SLA.status,
		SLACategory = SLA.Category,
		SLADescription = dbo.WR_GetSLACategoryString(@i_localeId,SLA.Category)
	FROM #ClientInstanceDetails I
		INNER JOIN #SLA_EntityInfo SLA
			ON I.clientId = SLA.clientId AND I.IdaType = SLA.appTypeId AND I.instanceId = SLA.instanceId
	UPDATE I
	SET I.SLAStatus =  5, /*MIGHT_MISS_SLA*/
		I.SLADescription = '',
		I.slaMissReasonList = CAST(stringval AS XML)
	FROM #ClientInstanceDetails I
INNER JOIN APP_ComponentProp Prop ON Prop.componentId = I.InstanceId AND Prop.componentType =  21 AND Prop.propertyTypeId = 3625 AND Prop.modified = 0
	--Update instance readiness
	-- 1. Instance is not configured properly. Credentials are missing.
	-- 2. Plan/storage policy is not associated
	-- 3. Most recent backup job failed
	UPDATE	I
	SET		I.Status = 'Not Ready',
			I.NotReadyReason = 'Instance not configured with authentication information'
	FROM	#ClientInstanceDetails I
		LEFT OUTER JOIN APP_InstanceProp IP
			ON I.InstanceId = IP.componentNameID
AND ((IP.attrName = 'PostgreSQL SA password' AND IP.modified = 0 AND I.IdaType = 125)
OR (IP.attrName = 'MySQL SA password' AND IP.modified = 0 AND I.IdaType = 104))
	WHERE	ISNULL(IP.attrVal, '') = ''
AND I.IdaType IN (125, 104)
	UPDATE	I
	SET		I.Status = 'Not Ready',
			I.NotReadyReason = 'Instance not configured with authentication information'
	FROM	#ClientInstanceDetails I
		LEFT OUTER JOIN APP_InstanceProp IP1
			ON I.InstanceId = IP1.componentNameID AND IP1.attrName = 'DB User Password' AND IP1.modified = 0
		LEFT OUTER JOIN APP_InstanceProp IP2
			ON I.InstanceId = IP2.componentNameID AND IP2.attrName = 'HDB User Store Key' AND IP2.modified = 0
	WHERE	ISNULL(IP1.attrVal, '') = '' AND ISNULL(IP2.attrVal, '') = ''
AND I.IdaType = 135
	-- Update statement is ordered here to
	--  prioritize the reasons for instance's not ready.
	UPDATE I SET
		I.[Status] = 'Not Ready',
		I.NotReadyReason = 'Client is retired. Only restoring from the existing jobs is possible'
	FROM #ClientInstanceDetails I
		INNER JOIN APP_Client C
			ON I.ClientId= C.id
AND C.status & 0x00002 = 0x00002
		WHERE I.NotReadyReason = ''
	UPDATE I SET
		I.[Status] = 'Not Ready',
		I.NotReadyReason = 'Instance is retired. Only restoring from the existing jobs is possible'
	FROM #ClientInstanceDetails I
		INNER JOIN APP_InstanceName II
			ON II.id = I.InstanceId
AND II.status & 0x00002 = 0x00002
		WHERE I.NotReadyReason = ''
	UPDATE I SET
		I.[Status] = 'Not Ready',
		I.NotReadyReason = 'Instance is not associated to a valid plan or storage policy'
	FROM #ClientInstanceDetails I
		INNER JOIN APP_Application A
			ON I.instanceId = A.instance
				AND A.subclientStatus & 8 <> 0
		LEFT OUTER JOIN APP_InstanceProp IP
			ON IP.componentNameId = I.InstanceId
AND IP.attrName = 'Associated Plan'
				AND IP.modified=0
		LEFT OUTER JOIN App_Plan AP WITH(NOLOCK)
			ON CAST(AP.id AS NVARCHAR(32)) = IP.attrVal
		WHERE I.NotReadyReason = ''
				AND	(A.dataArchGrpId <= 1
AND	(AP.id IS NULL OR ((AP.flag & 0x00004) = 0x00004)
OR ((AP.flag & 0x40000000) = 0x40000000)))
	-- Update type for SQL instances
	-- Moved here to get the type of the database engine and make some decision for JPRs.
	UPDATE I
       SET  clientType = (CASE   WHEN IP.attrVal = 'DataBase Engine' THEN 1
                WHEN IP.attrVal = 'Azure DataBase Engine' THEN 2
                WHEN IP.attrVal = 'Analysis Services' THEN 3
                WHEN IP.attrVal = 'Aws DataBase Engine' THEN 4
               END)
       FROM   #ClientInstanceDetails I
              INNER JOIN APP_InstanceProp IP
              ON     IP.componentNameId = I.InstanceId
                     AND IP.attrName = 'MSSQL Server Type'
AND I.IdaType = 81
                     AND IP.modified = 0
IF @appTypeId = 81 OR @appTypeId = 0
	BEGIN
		-- Update the readiness for instances based on the status flag.
		DECLARE @EnableInstanceStatusCheck INT = 1
		SELECT @EnableInstanceStatusCheck = CAST(value AS INT) FROM GXGlobalParam WHERE name = 'EnableInstanceStatusCheck' AND modified = 0
		IF @EnableInstanceStatusCheck = 1
		BEGIN
			UPDATE SI SET
				SI.Status = 'Not Ready',
				SI.NotReadyReason = CASE SI.clientType
										WHEN  2 THEN 'Configuration failed: Invalid cloud access details.  Verify that all the required information (application ID, subscription ID, application password, storage connection string, and SQL  server admin password) is provided and accurate.'
										WHEN  4 THEN 'Configuration failed: Invalid cloud access details.  Verify that all the required information (access key, secrete key and SQL  server admin password) is provided and accurate.'
										ELSE 'Instance validation failed: Insufficient SQL Server role. To configure the instance, the user must be a member of the SYSADMIN SQL server role.' END
			FROM #ClientInstanceDetails SI
				LEFT JOIN APP_InstanceProp AIP
					ON SI.InstanceId = AIP.componentNameId
						AND AIP.modified = 0
						AND AIP.attrName = N'Instance Status'
						AND AIP.attrVal <> N'0'
			WHERE SI.IdaType = 81
				AND AIP.attrVal IS NOT NULL
				AND SI.NotReadyReason = ''
		END
		-- For SQLiDA
		--	Instance will be marked ready based on two conditions.
		--		1) When credentials are set
		--		2) When no credentials set and backups found for the instance.
		--	MR#258328
		IF OBJECT_ID('tempdb..#temp_instances') IS NOT NULL DROP TABLE #temp_instances
		CREATE TABLE #temp_instances (instance int)
		INSERT INTO #temp_instances
			SELECT DISTINCT
				InstanceId
			FROM #ClientInstanceDetails
WHERE IdaType = 81
		EXEC AppGetSqlAuth 0, 0, 0, 0
		-- IF AuthType = 1 (LS Account), no backup ran, status is 'not ready'
		UPDATE SI SET
			SI.Status = 'Not Ready',
			SI.NotReadyReason = 'Instance not configured with authentication information'
		FROM #ClientInstanceDetails SI
			LEFT JOIN APP_Client AC
				ON AC.id = SI.ClientId
					AND AC.specialClientFlags IS NOT NULL
					AND AC.specialClientFlags = 2
			JOIN #SQLAuthDetails SD
				ON SD.instanceId = SI.InstanceId
		WHERE (AC.specialClientFlags IS NULL AND ISNULL(SD.authType, 0) = 1
					AND SI.InstanceId NOT IN (SELECT DISTINCT instanceId FROM sqlDbBackupInfo))
AND SI.IdaType = 81
				AND SI.NotReadyReason = ''
	END
	-- SQL DB count
	IF OBJECT_ID('tempdb.dbo.#ValidBackups') IS NOT NULL DROP TABLE #ValidBackups
	CREATE TABLE #ValidBackups (instanceId int, dbId INT, lastBkpId INT, lastBkpTime INT primary key (instanceId, dbId))
IF @appTypeId = 81 OR @appTypeId = 0
	BEGIN
		INSERT INTO #ValidBackups
			SELECT
				SBD.instanceId,
				SBD.sqlNameId,
				SBD.id,
				CASE WHEN SD.LastOkBackupTime IS NOT NULL
							AND SD.LastOkBackupTime > SBD.backup_finish_Date
					THEN SD.LastOkBackupTime ELSE SBD.backup_finish_Date END BkpTime
			FROM sqlDbBackupInfo SBD
				JOIN (SELECT
						SD.instanceId,
						SD.sqlNameId,
						MAX(SD.id) bkpID
					FROM sqlDbBackupInfo SD
					GROUP BY SD.instanceId, SD.sqlNameId) TX
				ON TX.bkpID = SBD.id
				LEFT JOIN SqlDatabaseInfo SD
					ON SD.instanceId = TX.instanceId
						AND SD.databaseId = TX.sqlNameId
			UNION
			SELECT
				SAB.instanceId,
				SAB.dbId,
				SAB.id,
				SAB.backup_finish_Date
			FROM sqlAnalysisDbBackupInfo SAB
				JOIN (SELECT
							SA.instanceId,
							SA.dbId,
							MAX(SA.id) bkpId
						FROM sqlAnalysisDbBackupInfo SA
						GROUP BY SA.instanceId, SA.dbId) TX
					ON TX.bkpId = SAB.id
	END
	-- Update the count for SQL databases.
	UPDATE I SET
		I.noDBs = D.cnt,
		I.LastBackupTime = D.bkpTime
	FROM	#ClientInstanceDetails I
		JOIN (SELECT
					VB.instanceId,
					COUNT(distinct VB.dbId) AS cnt,
					MAX(VB.lastBkpTime) as bkpTime
				FROM #ValidBackups VB
				GROUP BY VB.instanceId) D
		ON I.InstanceId = D.instanceId
WHERE I.IdaType = 81
	IF OBJECT_ID('tempdb.dbo.#lastBackupJob') IS NOT NULL DROP TABLE dbo.#lastBackupJob
	CREATE TABLE #lastBackupJob (instanceId INT, backupJobId INT, commCellId INT, status INT)
	IF OBJECT_ID('tempdb.dbo.#SubclientLastBkpDetails') IS NOT NULL DROP TABLE dbo.#SubclientLastBkpDetails
	CREATE TABLE #SubclientLastBkpDetails (instanceId INT, appId INT, lastBkpDetails XML, PRIMARY KEY(instanceId, appId))
	-- There was an instance where multiple 'Last Backup Job Info' found for a sub-client.
	-- So get the distinct values for each subclient.
	INSERT INTO #SubclientLastBkpDetails
		SELECT
			AP.instance,
			AP.id,
			CAST(MAX(ASP.attrVal) AS XML) as lastBkpInfo
		FROM APP_SubClientProp ASP
			JOIN APP_Application AP
				ON AP.id = ASP.componentNameId
					AND AP.subclientStatus & (2|4) = 0
			JOIN #ClientInstanceDetails I
				ON I.InstanceId = AP.instance
					AND I.ClientId = AP.clientId
		WHERE ASP.attrName = N'Last Backup Job Info'
			AND ASP.modified = 0
			AND ASP.cs_attrName = CHECKSUM(N'Last Backup Job Info')
			AND I.NotReadyReason = ''
		GROUP BY AP.instance, AP.id
	INSERT INTO #lastBackupJob
	SELECT
		Y.instanceId,
		Y.jobId,
		Y.commCellID,
		Y.status
	FROM
		-- Multiple subclients with last backup information will be found for SQL agents.
		-- So added the row number here to select the top MAX one.
		(SELECT
			ROW_NUMBER() OVER (PARTITION BY X.instanceId ORDER BY ISNULL(X.lastBkpDetails.value('(/lastBackupJobInfo/@jobID)[1]', 'INT'), 0) DESC) rn,
			X.instanceId,
			ISNULL(X.lastBkpDetails.value('(/lastBackupJobInfo/@jobID)[1]', 'INT'), 0) AS jobId,
			ISNULL(X.lastBkpDetails.value('(/lastBackupJobInfo/@commCellID)[1]', 'INT'), 0) AS commCellID,
			ISNULL(X.lastBkpDetails.value('(/lastBackupJobInfo/@status)[1]', 'INT'), 0) AS status
		FROM #SubclientLastBkpDetails X) Y
	WHERE Y.rn = 1
	UPDATE	I
	SET		I.Status = 'Not Ready',
			I.NotReadyReason = 'Last backup failed. Please review the failure and take corrective action as needed.'
	FROM	#ClientInstanceDetails I
		INNER JOIN APP_IdaType IDA
			ON I.IdaType = IDA.type
		INNER JOIN #lastBackupJob J
			ON I.InstanceId = J.instanceId
	WHERE	J.status NOT IN (1, 14) AND (J.status <> 3 OR IDA.isCWEjobValid = 0)
		AND I.NotReadyReason = ''
	IF OBJECT_ID('tempdb.dbo.#lastBackupJob') IS NOT NULL DROP TABLE dbo.#lastBackupJob
	IF OBJECT_ID('tempdb.dbo.#lastSuccBackupJob') IS NOT NULL DROP TABLE dbo.#lastSuccBackupJob
	CREATE TABLE #lastSuccBackupJob (instanceId INT, backupJobId INT, commCellId INT, servStartDate INT, size BIGINT)
	INSERT INTO #lastSuccBackupJob
		SELECT InstanceId, JB.jobId, JB.commCellID, JB.servStartDate, JB.totalUnCompBytes
		FROM
		(
			SELECT	MAX(B.jobId) jobId,
					I.InstanceId,
					B.commCellID
			FROM	#ClientInstanceDetails I
				INNER JOIN APP_IdaType IDA
					ON I.IdaType = IDA.type
				INNER JOIN APP_Application A
					ON I.instanceId = A.instance
				INNER JOIN JMBkpStats B
					-- For SQLiDA, CWE flag is not set, but CWE is still valid.
					ON A.id = B.appId
						AND B.status IN (1, 3, 14)
			GROUP BY I.InstanceId, B.commCellID
		) S
		JOIN JMBkpStats JB
			ON JB.jobId = S.jobId
				AND JB.commCellId = S.commCellId
	--Oracle and Oracle RAC
	UPDATE	I
	SET		I.Size = IP1.attrVal,
			I.LastBackupTime = IP2.attrVal
	FROM	#ClientInstanceDetails I
		LEFT OUTER JOIN APP_InstanceProp IP1
			ON I.instanceId = IP1.componentNameId AND IP1.attrName = 'Last Data Backup Size'
		LEFT OUTER JOIN APP_InstanceProp IP2
			ON I.instanceId = IP2.componentNameId AND IP2.attrName = 'Last Backup Completion Time'
	WHERE	ISNULL(IP1.attrVal, '0') <> '0'
		AND	ISNULL(IP2.attrVal, '0') <> '0'
AND I.IdaType IN (22, 80, 61, 3)
	--If we don't have size info at instance level, populate from oracleDataFiles table
	UPDATE	I
	SET		I.Size = OU.DBSIZE
	FROM	#ClientInstanceDetails I
		INNER JOIN
			(SELECT O.instId, SUM(O.maxDBDataSize) as DBSIZE FROM oracleDataFiles O WHERE O.deleteFlag = 0 GROUP BY O.instId) OU
		ON I.instanceId = OU.instId AND OU.DBSIZE IS NOT NULL
WHERE	I.IdaType IN (22, 80, 62,37,103)
		AND	I.Size = 0
	--SAP HANA
	UPDATE	I
	SET		I.Size = SH.DBSIZE
	FROM	#ClientInstanceDetails I
		INNER JOIN
			(SELECT	SEC.instanceId, SUM(ISNULL(CAST(B.attrVal AS BIGINT), 0)) as DBSIZE
			 FROM	#getIdaObjects SEC
				INNER JOIN APP_BackupSetProp B
					ON SEC.backupsetId = B.componentNameId AND B.attrName = 'Last Data Backup Size' AND B.modified = 0
AND SEC.appTypeId = 135
				GROUP BY SEC.instanceId
			) SH
		ON I.InstanceId = SH.instanceId
WHERE	I.IdaType = 135
		AND I.Size = 0
	--Postgres and MySQL
	UPDATE	I
	SET		I.size = DB.DBSIZE
	FROM	#ClientInstanceDetails I
		INNER JOIN
			(SELECT SEC.instanceId, SUM(D.databaseSize) AS DBSIZE
			 FROM	#getIdaObjects SEC
				INNER JOIN IdaDBExtendedProp D
					ON SEC.instanceId = D.instanceID
				GROUP BY SEC.instanceId
			) DB
		ON I.instanceId = DB.instanceId AND DB.DBSIZE IS NOT NULL
WHERE	I.IdaType IN (104, 125, 5)
		AND	I.Size = 0
	-- Update the backup size for SQL Server
	IF OBJECT_ID('tempdb.dbo.#SqlFullData') IS NOT NULL DROP TABLE dbo.#SqlFullData
	CREATE TABLE #SqlFullData(backup_size bigint, instanceid INT, rn INT)
	INSERT INTO #SqlFullData
		SELECT
			SUM(SF.pageSize) backup_size,
			I.instanceId,
			I.rn
		FROM
		(
			SELECT
				SDB.id,
				SDB.backup_size,
				SDB.instanceId,
				ROW_NUMBER() OVER (PARTITION BY  SDB.sqlNameId, SDB.instanceId
                                   ORDER BY SDB.backup_finish_date DESC) rn
			FROM  sqlDbBackupInfo SDB
			WHERE SDB.type = 'D'
		) I
		JOIN sqlFileBackupInfo SF
			ON SF.sqlDbBackupInfoId = I.id
		WHERE I.rn = 1
		GROUP BY I.instanceId, I.rn
		-- SQL Analysis Services
		UNION ALL
		SELECT
			I.backup_size,
			I.instanceId,
			I.rn
		FROM
			(SELECT
				SABI.backup_size,
				SABI.instanceId,
				ROW_NUMBER() OVER (PARTITION BY  SABI.dbId, SABI.instanceId ORDER BY SABI.backup_finish_date DESC) rn
			FROM  sqlAnalysisDbBackupInfo SABI
			WHERE SABI.type = 'D') I
		WHERE I.rn = 1
	UPDATE	I
	SET		I.Size = SqlSum.ISize
	FROM	#ClientInstanceDetails I
		JOIN (SELECT
					instanceId,
					SUM(backup_size) as ISize
				FROM #SqlFullData SqlData
				GROUP BY instanceId) SqlSum
		ON I.instanceId = SqlSum.instanceId
			AND SqlSum.ISize IS NOT NULL
WHERE	I.IdaType = 81
		AND	I.Size = 0
	IF OBJECT_ID('tempdb.dbo.#SqlFullData') IS NOT NULL DROP TABLE dbo.#SqlFullData
	--All agents
	--If we don't have size and backup time already populated, get it from job history
	UPDATE	I
	-- For SQL, job's size, job time should not be considered as the size and time is calculated from SqlDbBackupInfo.
	SET		I.LastBackupTime = (CASE
WHEN I.IdaType = 81 THEN I.LastBackupTime
									WHEN I.LastBackupTime > 0 THEN I.LastBackupTime
									ELSE J.servStartDate END),
			I.Size = (CASE
WHEN I.IdaType = 81 THEN  I.Size
						WHEN I.Size > 0 THEN I.Size
						ELSE J.size END)
	FROM	#ClientInstanceDetails I
		INNER JOIN #lastSuccBackupJob J
			ON I.InstanceId = J.instanceId
	WHERE	(I.LastBackupTime = 0 OR I.Size = 0)
	IF OBJECT_ID('tempdb.dbo.#lastSuccBackupJob') IS NOT NULL DROP TABLE dbo.#lastSuccBackupJob
	-- Update type for SAP HANA instances
	UPDATE	I
	SET		clientType = IP.attrVal
	FROM	#ClientInstanceDetails I
		INNER JOIN APP_InstanceProp IP
		ON	IP.componentNameId = I.InstanceId
			AND IP.attrName = 'DB Container Mode'
AND I.IdaType = 135
			AND IP.modified = 0
	-- Update DB Thin client property if it is supported apptype for DB Thin clients
	-- This is needed for hiding regular instance options for DB Thin clients in admin console
	UPDATE	cid
	SET		cid.clientType = 2
	FROM	#ClientInstanceDetails cid
	INNER JOIN App_ClientProp acp
		ON	cid.ClientId = acp.componentNameId
AND cid.IdaType IN (22, 80)
	WHERE	acp.attrName = 'DB Thin Client' AND acp.attrVal = 1 AND acp.modified = 0
	--Set CloudDB info
	UPDATE I
    SET I.IsCloudDB = 'true' , I.cloudVendorType = ISNULL(acp2.attrVal, I.cloudVendorType),
		I.IdaName = ( CASE WHEN I.IdaType IN (125, 104) AND I.InstanceName like 'aurora%' THEN 'Aurora ' + I.IdaName
WHEN I.IdaType IN (104, 125) AND I.InstanceName like 'mariadb%' THEN 'MariaDB'
					  ELSE I.IdaName END)
    FROM #ClientInstanceDetails I
        INNER JOIN APP_ClientProp acp
            on I.ClientId = acp.componentNameId AND acp.attrName = 'Client App Type' AND acp.attrVal = '1' AND acp.modified = 0
		LEFT OUTER JOIN APP_ClientProp acp2
			on I.ClientId = acp2.componentNameId AND acp2.attrName = 'Cloud Hypervisor Type' AND acp2.modified = 0
	Update I
	SET I.IsCloudDB = 'true'
	FROM #ClientInstanceDetails I
		INNER JOIN APP_ClientProp acp
			on I.ClientId = acp.componentNameId
				AND acp.attrName = 'Cloud Hypervisor Type'
				AND acp.attrVal <> '0'
				AND acp.modified = 0
	-- For SQL, set cloud DB flag.
	UPDATE I
		SET I.IsCloudDB = 'true'
	FROM #ClientInstanceDetails I
		INNER JOIN APP_InstanceProp AI
			ON I.InstanceId = AI.componentNameId
				AND AI.attrName = 'MSSQL Server Type'
AND I.IdaType = 81
				AND AI.modified = 0
	WHERE AI.attrVal IN ('Azure DataBase Engine',
							'Aws DataBase Engine',
							'Azure Managed DataBase Engine')
	INSERT INTO #InstanceApplicationSize
	SELECT InstanceId, SUM(AppSizeMB)*1024*1024 -- to bytes
	FROM (
			SELECT InstanceId, AppsizeMB,
			ROW_NUMBER() OVER(PARTITION BY SubclientId ORDER BY rankOrder ASC) AS rownum
			FROM(
					SELECT
						LC.InstanceId,
						LC.AppsizeMB,
						LC.SubclientId,
						(CASE LC.UsageType WHEN 1 THEN 1 WHEN 2 THEN 2 WHEN 4 THEN 3 WHEN 3 THEN 4 END) as rankOrder
					FROM   #ClientInstanceDetails CLI
						INNER JOIN  Lic_CurrentUsage LC WITH(NOLOCK)
							ON LC.InstanceId = CLI.InstanceId
					WHERE LC.UsageType in (1,2,3,4)
			) TMP
		)LIC
	WHERE LIC.rownum=1
	GROUP BY InstanceId
	Update I
		SET I.applicationSize = IA.applicationSize
	FROM #ClientInstanceDetails I
		INNER JOIN #InstanceApplicationSize IA
			ON I.InstanceId = IA.instanceId
	-- update isSnapEnabled flag
	-- IsSnapEnabled flag is being used by GUI to decide if some backup options should be visible.
	-- For eg., MSSQL DIFF backup option to be hidden for block level subclient.
	-- So using the same field to denote the block level subclient.
	-- Without chnages, this flag should not be used for restore options.
	Update I
	SET I.IsSnapEnabled = 1
	FROM #ClientInstanceDetails I
	INNER JOIN (
		SELECT DISTINCT app.clientId FROM APP_Application app WITH (NOLOCK)
		INNER JOIN #ClientInstanceDetails CI ON CI.InstanceId = app.instance
		INNER JOIN APP_SubClientProp sc WITH (NOLOCK) ON app.id = sc.componentNameId
		WHERE sc.attrName = 'Enable Snap Backups'
			AND sc.cs_attrName = CHECKSUM(N'Enable Snap Backups')
			AND sc.modified = 0 AND sc.attrVal = '1'
	) T ON T.clientId = I.ClientId
	Update I
	SET I.IsSnapEnabled = 1
	FROM #ClientInstanceDetails I
	INNER JOIN (
		SELECT DISTINCT app.clientId FROM APP_Application app WITH (NOLOCK)
			INNER JOIN #ClientInstanceDetails CI ON CI.InstanceId = app.instance
			INNER JOIN APP_SubClientProp sc WITH (NOLOCK) ON app.id = sc.componentNameId
		WHERE sc.attrName = 'Use block-level backup with optimize recovery'
			AND sc.cs_attrName = CHECKSUM(N'Use block-level backup with optimize recovery')
			AND sc.modified = 0 AND sc.attrVal = '1'
	) T ON T.clientId = I.ClientId
	-- Update lastbackupJobInfo
	UPDATE I
	SET I.lastBackupJobInfo = AP.attrval
	FROM   #ClientInstanceDetails I
		INNER JOIN App_InstanceProp AP WITH (NOLOCK) ON AP.componentNameId = I.InstanceId
											  AND AP.attrname = N'Last Backup Job Info'
											  AND AP.modified = 0
	SET @o_xmlString =
	(
		SELECT
		(	SELECT	0 AS '@errorCode',
					N'' AS '@errorMessage'
			FOR XML PATH('error'), TYPE),
		(	SELECT	D.Version AS '@version',
					D.Status AS '@status',
					D.IsCloudDB AS '@isCloudDB',
					D.cloudVendorType as '@cloudVendorType',
					D.NotReadyReason AS '@notReadyReason',
					D.LastBackupTime AS '@backupTime',
					D.Size AS '@backupSize',
					D.applicationSize as '@applicationSize',
					D.SLA AS '@sla',
					D.slaStatus AS '@slaStatus',
					D.slaDescription AS '@slaCategoryDescription',
					D.IsSnapEnabled AS '@isSnapEnabled',
					D.InstFlags AS '@flags',
					D.clientType AS '@clientType',
					D.noDBs AS '@noDBs',
					D.InstanceId AS 'instance/@instanceId',
					D.InstanceName AS 'instance/@instanceName',
					D.IdaType AS 'instance/@applicationId',
					D.IdaName AS 'instance/@appName',
					D.ClientId AS 'instance/@clientId',
					D.ClientName AS 'instance/@clientName',
					D.ClientDisplayName AS 'instance/@displayName',
					D.PlanId AS 'plan/@planId',
					D.PlanName AS 'plan/@planName',
					D.slaMissReasonList.query('App_MightMissSLAList/reasonList') AS slaMissReasonList,
					(SELECT D.lastBackupJobInfo.query('.'))
			FROM #ClientInstanceDetails AS D for XML PATH('dbInstance'), TYPE)
		FOR XML PATH(''), ROOT('Api_GetDBInstancesResponse')
	)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET  @o_xmlString = (SELECT @@ERROR AS '@errorCode', 'Failed to get database details.' AS '@errorMessage'
			FOR XML PATH ('response'), root(N'Api_GetDBInstancesResponse'))
END CATCH
-- make sure that tere is always valid Api::DBPointSolutionInfoResp object to be returned
IF @o_xmlString IS NULL
	SET @o_xmlString = '<Api_GetDBInstancesResponse/>'
IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL
    DROP TABLE #getIdaObjects
IF OBJECT_ID('tempdb.dbo.#ClientInstanceDetails') IS NOT NULL
	DROP TABLE #ClientInstanceDetails
SELECT @o_xmlString AS o_xmlString
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDBInstanceList')
	delete from GxQscripts where name = 'AppGetDBInstanceList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDBInstanceList')
	delete from GXDBVersions where aliasname = 'AppGetDBInstanceList'
GO

insert into GXDBVersions values(2, 'AppGetDBInstanceList',  '00010001000200610000', 'AppGetDBInstanceList', '00010001000200610000')
GO

