

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDBClonesList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppGetDBClonesList')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDBClonesList <<<'
	drop procedure AppGetDBClonesList
END
IF EXISTS (select * from GxQscripts where name='AppGetDBClonesList')
	delete from GxQscripts where name = 'AppGetDBClonesList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDBClonesList')
	delete from GXDBVersions where aliasname = 'AppGetDBClonesList'
GO
print '... Creating Procedure: AppGetDBClonesList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppGetDBClonesList
  @i_xmlString XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @o_xmlString XML
	DECLARE		@i_userId   		INT = 0
    declare		@i_errorCode		INT = 0
	declare		@s_errorString		NVARCHAR(1024) = N''
	SET @i_userId = ISNULL((select ref.value('@userId','INT')
					FROM @i_xmlString.nodes('/Api_GetVolumesOfSnapCloneRequest/processinginstructioninfo/user')  R(ref)),0)
	IF (@i_userId = 0)
	BEGIN
		SET @i_userId = ISNULL(( SELECT ref.value('@userId', 'int')
							FROM @i_xmlString.nodes('Api_GetVolumesOfSnapCloneRequest/userId') R ( ref ) ),
						0)
	END
	declare		@cloneJobId INT = 0
	SET @cloneJobId = ISNULL((SELECT @i_xmlString.value('(/Api_GetVolumesOfSnapCloneRequest/@cloneJobId)[1]','INT')), 0)
	DECLARE @nowTime  INT
	SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
	IF OBJECT_ID('tempdb.dbo.#tblSMVolume') IS NOT NULL
		DROP TABLE #tblSMVolume
	CREATE TABLE #tblSMVolume
	(
		SMVolumeId int,
		AppId int,
		CopyId int,
		ControlHostId int
	)
	IF OBJECT_ID('tempdb.dbo.#instanceInfo') IS NOT NULL
		DROP TABLE #instanceInfo
	CREATE TABLE #instanceInfo
	(
		srcInstId	int,
		srcDbSize	bigint default 0,
		version		nvarchar(1024) default ''
	)
	IF OBJECT_ID('tempdb.dbo.#tblCloneVolume') IS NOT NULL
		DROP TABLE #tblCloneVolume
	CREATE TABLE #tblCloneVolume
	(
		cloneJobId				int,
		sourceInstanceId		int,
		sourceInstanceName		nvarchar(1024),
		targetInstanceName		nvarchar(1024),
		sourceClientId			int,
		targetClientId			int,
		sourceDatabaseName		nvarchar(1024),
		targetDatabaseName		nvarchar(1024),
		appTypeId				int,
		commCellId				int,
		databaseAsOfTime		int,
		creationTimeStamp		int,
		expiryTimeStamp			int,
		cloneStatusId			int,
		snapJobId				int,
		rpId					int
	)
	--
	-- Get SMVolumeIds
	--
	INSERT INTO #tblSMVolume
	SELECT	DISTINCT VOL.SMVolumeId, VOL.AppId, VOL.CopyId, SNAP.ControlHostId
		FROM	SMMountVolume MVOL
				INNER JOIN SMVolume VOL ON MVOL.SMVolumeId = VOL.SMVolumeId
				INNER JOIN SMVolSnapMap MAP ON MAP.SMVolumeId = VOL.SMVolumeId
				INNER JOIN SMSnap SNAP ON SNAP.SMSnapId = MAP.SMSnapId
				INNER JOIN APP_Application APP ON VOL.AppId = APP.id
	-- MR: 221133 - Currently when the snap is aged, the corresponding clone is not listed and hence
	-- customer couldn't manage them - like changing the expiry time.
-- WHERE	VOL.pruneFlags = 1
	--
	-- Security - remove those where the subclients are not visible for this user.
	--
	IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
        DROP TABLE #tblSecCheck
	CREATE TABLE #tblSecCheck (
		EntityType int,
		EntityId int,
		EntityVisible int
	)
	INSERT INTO #tblSecCheck
SELECT DISTINCT 1, CopyId, 0  FROM #tblSMVolume
	INSERT INTO #tblSecCheck
SELECT DISTINCT 2, ControlHostId, 0  FROM #tblSMVolume
	INSERT INTO #tblSecCheck
SELECT DISTINCT 3, AppId, 0  FROM #tblSMVolume
	EXEC sec_isSnapshotVisible @i_userId
	DELETE	A
	FROM	#tblSMVolume A
INNER JOIN #tblSecCheck B_Copy ON A.CopyId = B_Copy.EntityId AND B_Copy.EntityType = 1
INNER JOIN #tblSecCheck B_CHost ON A.ControlHostId = B_CHost.EntityId AND B_CHost.EntityType = 2
INNER JOIN #tblSecCheck B_App ON A.AppId = B_App.EntityId AND B_App.EntityType = 3
	WHERE	B_Copy.EntityVisible <=0
			AND B_CHost.EntityVisible <=0
			AND B_App.EntityVisible <=0
	IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
		DROP TABLE #tblSecCheck
	-- User Permission Check Code Starts
		IF OBJECT_ID('tempdb.dbo.#tt_getAllIdaObjects') IS NOT NULL DROP TABLE #tt_getAllIdaObjects
		CREATE TABLE #tt_getAllIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
		-- Param ref: @userId, 3 (CLIENT_ENTITY), 0 (Any Permission), 1 (Inherit from child), N'#tt_getAllIdaObjects'
EXEC sec_getIdaObjectsForUser @i_userId,  3 , 0, 1, N'#tt_getAllIdaObjects'
	--Lookup in the metadata for the database
	BEGIN
		-- filter by cloneJobId
		IF @cloneJobId <> 0
		BEGIN
			--Get Volumes For Clones
			INSERT	INTO #tblCloneVolume
			SELECT	DISTINCT
				B.MountJobId,
				MAX(APP.instance),
				MAX(INST.name),
				ISNULL(MAX(STC.TargetEntityName), ''),
				CASE
WHEN MAX(APP.apptypeId) IN (80, 135) THEN MAX(APP.clientId)
					ELSE MAX(VOL.SourceClientId)
				END,
				MAX(B.MountHostId),
				'',
				'',
				MAX(VOL.AppTypeId),
				MAX(VOL.CommCellId),
				CASE
WHEN MAX(APP.apptypeId) = 81 THEN MAX(VOL.CreationTime) -- From AppgetLiveBrowseRecoveryPoint.sp
					WHEN ISNULL(MAX(STC.ReserveFieldStr), '') <> '' THEN CAST(MAX(STC.ReserveFieldStr) AS INT)
					ELSE 0 END,
				MAX(B.CreationTime),
				MAX(B.ExpireTime),
				MAX(B.MountStatus),
				MAX(VOL.JobId) AS BackupJobId,
				0
			FROM	#tblSMVolume A INNER JOIN SMMountVolume B ON A.SMVolumeId = B.SMVolumeId AND B.MountJobId = @cloneJobId
					INNER JOIN SMVolume VOL ON A.SMVolumeId = VOL.SMVolumeId
INNER JOIN APP_Application APP ON VOL.AppId = APP.id AND APP.apptypeId IN (22, 80, 135,
125, 104, 81, 62,37)
					INNER JOIN APP_InstanceName INST ON INST.id = APP.instance
					--INNER JOIN archGroupCopy AGC ON AGC.id = VOL.CopyId
					LEFT OUTER JOIN SMTestCloneDetails STC ON B.MountJobId = STC.OpJobId
					-- Added to remove the clones created via RP as it will be listed in live browse query.
					LEFT JOIN APP_LiveBrowseRecoveryPoints LB
					  ON LB.appType = 81 /* SQL AppType*/
						 AND LB.rpJobId = B.MountJobId
WHERE	B.MountStatus < 79 /*SM_VS_UMT_UNMOUNTED*/
AND B.MountStatus >= 59 /*SM_VS_MNT_MOUNTED*/
AND B.MountFlags & 2048 = 2048 /*CVSM_VOLUMEFLAGS_TEST_CLONE_ENV_DB*/
					-- Only the entries with no appdata should be considered.
			-- That means, the clone entries not created by RP model.
					AND LB.appData IS NULL
			GROUP BY B.MountJobId
		END
		ELSE
		BEGIN
			INSERT	INTO #tblCloneVolume
			SELECT	DISTINCT
				B.MountJobId,
				MAX(APP.instance),
				MAX(INST.name),
				ISNULL(MAX(STC.TargetEntityName), ''),
				CASE
WHEN MAX(APP.apptypeId) IN (80, 135) THEN MAX(APP.clientId)
					ELSE MAX(VOL.SourceClientId)
				END,
				MAX(B.MountHostId),
				'',
				'',
				MAX(VOL.AppTypeId),
				MAX(VOL.CommCellId),
				CASE
WHEN MAX(APP.apptypeId) = 81 THEN MAX(VOL.CreationTime) -- From AppgetLiveBrowseRecoveryPoint.sp
					WHEN ISNULL(MAX(STC.ReserveFieldStr), '') <> '' THEN CAST(MAX(STC.ReserveFieldStr) AS INT)
					ELSE 0 END,
				MAX(B.CreationTime),
				MAX(B.ExpireTime),
				MAX(B.MountStatus),
				MAX(VOL.JobId) AS BackupJobId,
				0
			FROM	#tblSMVolume A INNER JOIN SMMountVolume B ON A.SMVolumeId = B.SMVolumeId
					INNER JOIN SMVolume VOL ON A.SMVolumeId = VOL.SMVolumeId
INNER JOIN APP_Application APP ON VOL.AppId = APP.id AND APP.apptypeId IN (22, 80, 135,
125, 104, 81, 62,37)
					INNER JOIN APP_InstanceName INST ON INST.id = APP.instance
					--INNER JOIN archGroupCopy AGC ON AGC.id = VOL.CopyId
					LEFT OUTER JOIN SMTestCloneDetails STC ON B.MountJobId = STC.OpJobId
					-- Added to remove the clones created via RP as it will be listed in live browse query.
					LEFT JOIN APP_LiveBrowseRecoveryPoints LB
					  ON LB.appType = 81 /* SQL AppType*/
						 AND LB.rpJobId = B.MountJobId
WHERE	B.MountStatus < 79 /*SM_VS_UMT_UNMOUNTED*/
AND B.MountStatus >= 59 /*SM_VS_MNT_MOUNTED*/
AND B.MountFlags & 2048 = 2048 /*CVSM_VOLUMEFLAGS_TEST_CLONE_ENV_DB*/
					-- Only the entries with no appdata should be considered.
			-- That means, the clone entries not created by RP model.
					AND LB.appData IS NULL
			GROUP BY B.MountJobId
		END
		-- Set correct target instance for CV_APPTYPE_MSSQL
		UPDATE ClV
		SET ClV.targetInstanceName = Dest.tgtInstanceName
		FROM #tblCloneVolume ClV
		INNER JOIN (
                SELECT  SQLiDA.databaseList.value('./@sourceDatabaseName','nvarchar(max)') sourceDB, Z.CloneJobId,
                        SQLiDA.databaseList.value('(/SQLiDA_AttachDBMsg/@instanceName)[1]','nvarchar(max)') tgtInstanceName
                FROM    (
                            SELECT  MVOL.MountJobId AS CloneJobId, CONVERT(xml,REPLACE(MD.Metadata, 'UTF-8', 'UTF-16')) as cloneMetaData
                            FROM    #tblSMVolume X INNER JOIN SMMountVolume MVOL  (NOLOCK) ON X.SMVolumeId = MVOL.SMVolumeId
                                    INNER JOIN SMMetaData MD (NOLOCK) ON MVOL.Id=MD.RefId
                            WHERE   MD.MetaDataType= 38 /*SM_MDT_TEST_ENV_APP_INFO*/
                                    AND MD.RefType= 10 /*SM_MRT_MOUNT_VOLUME*/
                        ) Z
                CROSS APPLY Z.cloneMetaData.nodes('/SQLiDA_AttachDBMsg/databaseList') SQLiDA(databaseList)
            ) Dest ON Dest.CloneJobId = ClV.cloneJobId
WHERE ClV.appTypeId = 81
		IF @cloneJobId <> 0
		BEGIN
			-- Get Recovery points for MSSQL
			INSERT	INTO #tblCloneVolume
				SELECT	DISTINCT
					appRp.rpJobId,
					INST.id,
					INST.name,
					appRp.appdata.value('(/Ida_RPAppData/sqlAppData/mountInstance/@instanceName)[1]', 'VARCHAR(1024)'),
					appRp.srcClientId,
					appRp.MountHostId,
					'',
					'',
					appRp.appType,
					2,
					appRp.recoveryTime,
					appRp.createTime,
					appRp.expireTime,
					CASE
WHEN appRp.phase = 3 THEN 59
							/* Mapping BROWSEREADY=3 to SM_VS_MNT_MOUNTED*/
ELSE  60
							/* Mapping DELETING=4 and ERROR=5 to SM_VS_UMT_STARTED  because anything other than SM_VS_MNT_MOUNTED is considered as deleting in the XML generation*/
						END,
					appRp.bkpJobId,
					appRp.id
				FROM APP_LiveBrowseRecoveryPoints appRp
					JOIN APP_InstanceName INST
						ON INST.id = appRp.srcInstanceId AND appRp.rpJobId = @cloneJobId
					JOIN #tt_getAllIdaObjects sObj
						ON sObj.clientID = appRp.srcClientId
				WHERE appRp.phase IN (3, 4, 5) /*select only BROWSEREADY, DELETING, ERROR recovery points*/
		END
		ELSE
		BEGIN
			INSERT	INTO #tblCloneVolume
			SELECT	DISTINCT
				appRp.rpJobId,
				INST.id,
				INST.name,
				appRp.appdata.value('(/Ida_RPAppData/sqlAppData/mountInstance/@instanceName)[1]', 'VARCHAR(1024)'),
				appRp.srcClientId,
				appRp.MountHostId,
				'',
				'',
				appRp.appType,
				2,
				appRp.recoveryTime,
				appRp.createTime,
				appRp.expireTime,
				CASE
WHEN appRp.phase = 3 THEN 59
						/* Mapping BROWSEREADY=3 to SM_VS_MNT_MOUNTED*/
ELSE  60
						/* Mapping DELETING=4 and ERROR=5 to SM_VS_UMT_STARTED  because anything other than SM_VS_MNT_MOUNTED is considered as deleting in the XML generation*/
					END,
				appRp.bkpJobId,
				appRp.id
			FROM APP_LiveBrowseRecoveryPoints appRp
				JOIN APP_InstanceName INST
					ON INST.id = appRp.srcInstanceId
				JOIN #tt_getAllIdaObjects sObj
					ON sObj.clientID = appRp.srcClientId
			WHERE appRp.phase IN (3, 4, 5) /*select only BROWSEREADY, DELETING, ERROR recovery points*/
		END
		INSERT INTO #instanceInfo(srcInstId)
			SELECT DISTINCT
				sourceInstanceId
			FROM #tblCloneVolume
		UPDATE	I
		SET		I.srcDbSize = IP1.attrVal,
				I.version = IP2.attrVal
		FROM	#instanceInfo I
			LEFT OUTER JOIN APP_InstanceProp IP1
				ON I.srcInstId = IP1.componentNameId
					AND IP1.attrName = 'Last Data Backup Size'
			LEFT OUTER JOIN APP_InstanceProp IP2
				ON I.srcInstId = IP2.componentNameId
					AND IP2.attrName = 'Oracle Version'
		UPDATE	I
		SET		I.srcDbSize = OU.DBSIZE
		FROM	#instanceInfo I
		INNER JOIN
			(SELECT
					O.instId,
					SUM(O.maxDBDataSize) as DBSIZE
				FROM oracleDataFiles O
				WHERE O.deleteFlag = 0 GROUP BY O.instId) OU
			ON I.srcInstId = OU.instId
				AND OU.DBSIZE IS NOT NULL
		WHERE I.srcDbSize = 0
		UPDATE	CL
		SET		CL.targetInstanceName = I.name
		FROM	#tblCloneVolume CL
			INNER JOIN JMRestoreStats J
				ON J.jobId = CL.cloneJobId
			INNER JOIN APP_InstanceName I
				ON J.destInstanceId = I.id
		WHERE	CL.targetInstanceName = ''
	END
proc_exit:
IF EXISTS (SELECT 1 FROM #tblCloneVolume)
BEGIN
DECLARE @listOfClones             XML
SET @listOfClones = (
					SELECT	CL.cloneJobId AS '@cloneJobId',
							CL.creationTimeStamp AS '@cloneCreationTime',
							CL.expiryTimeStamp AS '@cloneExpiryTime',
							CL.databaseAsOfTime AS '@databaseAsOfTime',
							I.srcDbSize AS '@sourceDBSize',
							I.version AS '@sourceInstVersion',
							I.version AS '@destInstVersion',
							CL.snapJobId AS '@snapJobId',
							CL.rpId AS '@sqlRecoveryId',
							CL.sourceInstanceId AS 'sourceInstance/@instanceId',
							CL.sourceInstanceName AS 'sourceInstance/@instanceName',
							CL.appTypeId AS 'sourceInstance/@applicationId',
							CL.sourceClientId AS 'sourceInstance/@clientId',
							-- Display name should be shown for the UI.
							SRC_CLNT.displayName AS 'sourceInstance/@clientName',
							CL.targetClientId AS 'targetInstance/@clientId',
							-- Display name should be shown for the UI.
							TGT_CLNT.displayName AS'targetInstance/@clientName',
							CL.targetInstanceName AS 'targetInstance/@instanceName',
							CL.cloneStatusId AS 'cloneStatus/@id',
							(CASE WHEN CL.cloneStatusId = 59 AND @nowTime>=expiryTimeStamp  THEN 'Expired'
								WHEN CL.cloneStatusId = 59  THEN 'Created'
								WHEN CL.cloneStatusId > 59 THEN 'Deleting'
								END) AS 'cloneStatus/@name'
					FROM #tblCloneVolume CL
					INNER JOIN APP_Client SRC_CLNT (NOLOCK) ON SRC_CLNT.id = CL.sourceClientId
					INNER JOIN APP_Client TGT_CLNT (NOLOCK) ON TGT_CLNT.id = CL.targetClientId
					INNER JOIN #instanceInfo I ON CL.sourceInstanceId = I.srcInstId
					FOR XML PATH ('clones'))
    SET @o_xmlString = (SELECT  @i_errorCode 'errorCode', @s_errorString 'errorMsg', @listOfClones
					FOR XML PATH ( 'Api_GetClonesResponse' ), ELEMENTS)
END
ELSE
BEGIN
    SET @o_xmlString = '<Api_GetClonesResponse />'
END
SELECT @o_xmlString AS 'o_xmlString'
IF OBJECT_ID('tempdb.dbo.#tblSMVolume') IS NOT NULL
		DROP TABLE #tblSMVolume
IF OBJECT_ID('tempdb.dbo.#tblCloneVolume') IS NOT NULL
		DROP TABLE #tblCloneVolume
IF OBJECT_ID('tempdb.dbo.#tblSecCheck') IS NOT NULL
		DROP TABLE #tblSecCheck
IF OBJECT_ID('tempdb.dbo.#tt_getAllIdaObjects') IS NOT NULL
		DROP TABLE #tt_getAllIdaObjects
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDBClonesList')
	delete from GxQscripts where name = 'AppGetDBClonesList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDBClonesList')
	delete from GXDBVersions where aliasname = 'AppGetDBClonesList'
GO

insert into GXDBVersions values(2, 'AppGetDBClonesList',  '00000000000000000000', 'AppGetDBClonesList', '00000000000000000000')
GO

