

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppGetDAExcludeClients.sp] ---------- 

-- This will generate the revision for the stored procedure. Don't remove this line!!!
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetDAExcludeClients.sp,v $ $Id: AppGetDAExcludeClients.sp,v 1.1.2.2 2019/12/03 21:48:33 pankajkumar Exp $";
-- Name of the stored procedure
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetDAExcludeClients')
BEGIN
	print '>>> Drop Stored Procedure: AppGetDAExcludeClients <<<'
	drop procedure AppGetDAExcludeClients
END
IF EXISTS (select * from GxQscripts where name='AppGetDAExcludeClients')
	delete from GxQscripts where name = 'AppGetDAExcludeClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDAExcludeClients')
	delete from GXDBVersions where aliasname = 'AppGetDAExcludeClients'
GO
print '... Creating Procedure: AppGetDAExcludeClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetDAExcludeClients
-- Tell the AWK processor that body of query starts here
AS
--
--Find out invalid pseudoclients and mark status as deconfigured
	IF OBJECT_ID('tempdb.dbo.#deconfigPseudoClients') IS NOT NULL DROP TABLE #deconfigPseudoClients
	CREATE TABLE #deconfigPseudoClients
	(
		t_pseduclientId INT,  t_cloudType INT, t_clientId INT, t_status INT, t_isPackagePresent INT
	)
	--get all eligiable pseudoclients, node clients
	insert into #deconfigPseudoClients
	SELECT DC.pseudoClientId,  DC.CloudType, S.ClientId, C.status, 0
	FROM DM2Cloud DC (NOLOCK)
	JOIN DM2SearchServerCoreInfo S (NOLOCK) ON DC.cloudId = S.CloudId
	JOIN APP_Client C (NOLOCK) ON S.ClientId = C.id
WHERE DC.CloudType IN (1,
5,
6,
9,
2)
	--check if content anallyzer package is installed on phsycial nodes
	UPDATE #deconfigPseudoClients
	SET t_isPackagePresent = 1
	FROM #deconfigPseudoClients T
	JOIN simInstalledPackages P (NOLOCK) ON T.t_clientId = P.ClientId
WHERE P.simPackageID IN (729, 1108)
AND T.t_cloudType = 2
	--check if HAC package is installed on phsycial nodes
	UPDATE #deconfigPseudoClients
	SET t_isPackagePresent = 1
	FROM #deconfigPseudoClients T
	JOIN simInstalledPackages P (NOLOCK) ON T.t_clientId = P.ClientId
WHERE P.simPackageID IN (725, 1157)
AND T.t_cloudType = 6
	--check if index store package is installed on phsycial nodes
	UPDATE #deconfigPseudoClients
	SET t_isPackagePresent = 1
	FROM #deconfigPseudoClients T
	JOIN simInstalledPackages P (NOLOCK) ON T.t_clientId = P.ClientId
WHERE P.simPackageID IN (55, 1306)
AND T.t_cloudType IN (1,
5,
9)
	--distributed clients which does not have any valid clients
	--in multinode case, all nodes must have all packages uninstalled AND client is in uninstalled status
	DELETE T1
	FROM #deconfigPseudoClients T1, #deconfigPseudoClients T2
	WHERE  T1.t_pseduclientId = T2.t_pseduclientId
			AND T1.t_cloudType = T2.t_cloudType
			AND (T1.t_status != T2.t_status
				OR T1.t_isPackagePresent != T2.t_isPackagePresent
OR (T1.t_isPackagePresent=1 OR T1.t_status & 0x00002 =0))
	--mark psuedoclients as deconfigured
	 UPDATE APP_Client
SET status = status | 0x00002
	 FROM  APP_Client JOIN #deconfigPseudoClients ON id =t_pseduclientId
	 IF OBJECT_ID('tempdb.dbo.#deconfigPseudoClients') IS NOT NULL DROP TABLE #deconfigPseudoClients
--Set PlatformDeleted flag for deconfigured clients (in case if it's not set)
UPDATE APP_ClientProp
SET attrVal ='1'
WHERE attrName IN ('PlatformDeleted 4', 'PlatformDeleted 2')
AND attrVal ='0'
AND componentNameId IN (select id from APP_Client (NOLOCK) where status & 0x00002 > 0)
--get the valid distributed servers
	IF OBJECT_ID('tempdb.dbo.#excludeValidClients') IS NOT NULL DROP TABLE #excludeValidClients
	CREATE TABLE #excludeValidClients
	(
		t_cloudId INT
	)
	--found at least one nodes client which are not deconfigured
	INSERT INTO  #excludeValidClients
	SELECT DISTINCT S.cloudId
	FROM DM2SearchServerCoreInfo S (NOLOCK)
JOIN APP_Client C (NOLOCK) ON S.ClientId = C.id AND C.status & 0x00002 =0
WHERE S.CloudType IN (	1,
5,
6,
2,
9)
	UNION ALL --get cloudId where whose nodes client have any packages installed
	SELECT DISTINCT S.cloudId
	FROM DM2SearchServerCoreInfo S (NOLOCK)
	JOIN simInstalledPackages P (NOLOCK) ON S.clientId = P.clientId
WHERE S.CloudType IN (	1,
5,
6,
2,
9)
	--return valid clients which needs to be excluded by DA job
	SELECT DISTINCT clientId FROM DM2SearchServerCoreInfo (NOLOCK)  JOIN #excludeValidClients ON t_cloudId = cloudId
	UNION ALL
	SELECT DISTINCT pseudoclientId FROM  DM2Cloud  (NOLOCK) JOIN  #excludeValidClients ON t_cloudId = cloudId
	IF OBJECT_ID('tempdb.dbo.#excludeValidClients') IS NOT NULL DROP TABLE #excludeValidClients
--
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'AppGetDAExcludeClients')
	delete from GxQscripts where name = 'AppGetDAExcludeClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetDAExcludeClients')
	delete from GXDBVersions where aliasname = 'AppGetDAExcludeClients'
GO

insert into GXDBVersions values(2, 'AppGetDAExcludeClients',  '00010001000200020000', 'AppGetDAExcludeClients', '00010001000200020000')
GO

